#!python


# set PATH=h:\trunk\bin;%PATH%

class _Options(object):
    def __init__(self):
        self.verbose = False

_opts = _Options()

def ensure_dir(path):
    import os
    import os.path
    if not os.path.isdir(path):
       os.mkdir(path)

def run(command, check_returncode=True, returncode_fun=lambda ret: ret!=0 ):
    import subprocess
    if _opts.verbose:
        print "Running " + command
    p = subprocess.Popen(command.split(), stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    (stdoutdata, stderrdata) = p.communicate()
    
    if check_returncode and returncode_fun(p.returncode):
        print stdoutdata
        print stderrdata
        raise ValueError("Command '" + command + "' exited with non-zero status " + str(p.returncode))
    
    if _opts.verbose:
        print stdoutdata
        print stderrdata

if __name__ == "__main__":
    import os
    import os.path
    os.chdir(os.path.dirname(__file__))
    ensure_dir("SL_CodeGen")
    ensure_dir("SF_CodeGen")
    ensure_dir("C_CodeGen")
    ensure_dir("stage1")
    ensure_dir("stage2")
    ensure_dir("target_truetime")
    # mdl2mga closed_loop.mdl closed_loop.mga then set reference Component Definitions/Component Types/Controller/Controller
    run(r"C_CodeGen.exe  -p C_CodeGen -f closed_loop.mga")
    run(r"SF_CodeGen.exe -t SF_CodeGen closed_loop.mga")
    run(r"SL_CodeGen.exe -p SL_CodeGen closed_loop.mga", returncode_fun=lambda ret: ret!=0 and ret!=5)
    run(r"Stage1 -f closed_loop.mga -o stage1\closed_loop.xml")
    run(r"Stage2 -f stage1\closed_loop.xml -o stage2\sched.scs -t Sched -r 1ms")
    run(r"SchedTool -f stage2\sched.scs -o results.rslt")
    run(r"SchedResults -r results.rslt -e closed_loop.mga -a stage1\closed_loop.xml")
    run(r"Stage2 -t TrueTime -f stage1\closed_loop.xml -p target_truetime -o closed_loop")
    import shutil
    import itertools
    from glob import glob
    for file in itertools.chain(glob("SF_CodeGen/*"), glob("SL_CodeGen/*"), glob("C_CodeGen/*")):
        shutil.copy(file, "target_truetime/")
