function hbg_capacitor(ssName, sys, pos, value, initial, ismod)

global bg;

% C-Element
add_block('built-in/SubSystem',[sys,'/',ssName]);
set_param([sys,'/',ssName],'orientation','left','position',pos, ...
    'Mask', 'on', ...
    'ForegroundColor', 'blue',...
    'BackgroundColor', 'white', ...
    'DropShadow', 'on');

% Input Port
add_block('built-in/Inport',[sys,'/',ssName,'/','F'],...
    'Port','1', 'position',[40, 30, 60, 50]);

% Initial Condition
add_block('built-in/Constant',[sys,'/',ssName,'/','InitialCondition'],...
    'position',[40, 70, 60, 90], 'value','IC');

% Capacitance	
if ismod
	add_block('built-in/Inport',[sys,'/',ssName,'/','Capacitance'],...
		'position',[40, 110, 65, 135], 'Port','2');
	set_param([sys, '/',ssName],...
		'MaskPromptString', 'Initial Condition:', ...
		'MaskVariables', 'IC=@1',...
		'MaskStyleString', 'edit', ...
		'MaskDisplay','image(imread(''MC.png'',''BackgroundColor'',[1 1 1]))',...
		'MaskValueString', [num2str(initial)]);
else
	set_param([sys, '/',ssName],...
		'MaskPromptString', 'Value of C:|Initial Condition:', ...
		'MaskVariables', 'C=@1;IC=@2',...
		'MaskStyleString', 'edit,edit', ...
		'MaskDisplay','image(imread(''C.png'',''BackgroundColor'',[1 1 1]))',...
		'MaskValueString', [num2str(value), '|', num2str(initial)]);
	
	add_block('built-in/Constant',[sys,'/',ssName,'/','Capacitance'],...
		'position',[40, 110, 60, 130], 'value','C');
end


% Product1
add_block('built-in/Product',[sys,'/',ssName,'/','Product1'],...
    'position',[340, 110, 360, 130]);

% Math Function (Reciprocal)
add_block('built-in/Math',[sys,'/',ssName,'/','Reciprocal'],...
    'Function','Reciprocal', 'position',[340, 150, 360, 180]);

% Integrator
add_block('built-in/Integrator',[sys,'/',ssName,'/','Integrator'],...
    'InitialConditionSource','External',...
    'position',[490, 30, 530, 100]);

% Product2
add_block('built-in/Product',[sys,'/',ssName,'/','Product2'],...
    'position',[590, 110, 610, 130]);

% Output Port
add_block('built-in/Outport',[sys,'/',ssName,'/','E'],...
    'Port','1','position',[690, 110, 710, 130]);

% Output Port for State
add_block('built-in/Outport',[sys,'/',ssName,'/','q'],...
    'Port','2','position',[750, 110, 770, 130]);
	
% Initial value
add_block('simulink/Signal Attributes/IC', [sys,'/',ssName,'/','Initialization'], 'position', [125,85,165,130], 'Value', 'IC')

% Connections
add_line([sys '/' ssName], 'F/1','Integrator/1','autorouting','on');
add_line([sys '/' ssName], 'InitialCondition/1','Initialization/1','autorouting','on');
add_line([sys '/' ssName], 'Initialization/1','Product1/1','autorouting','on');
add_line([sys '/' ssName], 'Capacitance/1','Reciprocal/1','autorouting','on');
add_line([sys '/' ssName], 'Capacitance/1','Product1/2','autorouting','on');
add_line([sys '/' ssName], 'Product1/1','Integrator/2','autorouting','on');
add_line([sys '/' ssName], 'Integrator/1','Product2/1','autorouting','on');
add_line([sys '/' ssName], 'Reciprocal/1','Product2/2','autorouting','on');
add_line([sys,'/',ssName], 'Product2/1','E/1','autorouting','on');
add_line([sys,'/',ssName], 'Integrator/1','q/1','autorouting','on');
