% Constant element
function hbg_const_element(ssName, sys, pos, value)

global bg;
f.type = 'Constant';
f.path = [sys '/' ssName];

% Source of Flow
add_block('built-in/SubSystem',[sys,'/',ssName])
set_param([sys,'/',ssName],...
    'orientation','right',...
	'position',pos, ... 
    'Mask', 'on', ...
    'MaskPromptString', 'Value of Constant:', ...
    'MaskVariables', 'Constant=@1',...
    'MaskStyleString', 'edit',...
    'MaskValueString', num2str(value),...
    'BackgroundColor', 'white',...
    'MaskDisplay','image(imread(''Constant.png'',''BackgroundColor'',[1 1 1]))',...
    'DropShadow', 'on');

% Flow
add_block('built-in/Constant',[sys,'/',ssName,'/','Constant'],...
    'position',[30, 110, 50, 130], 'value','Constant');

% Output Port
add_block('built-in/Outport',[sys,'/',ssName,'/','C'],... 
    'Port','1','position',[230, 170, 250, 190])


% Connections
add_line([sys,'/',ssName], 'Constant/1','C/1','autorouting','on')