function hbg_determineState_element(sys, pos, initState)

ssName = 'determineState';

add_block('built-in/SubSystem', [sys '/' ssName] );
set_param([sys '/' ssName],'orientation','right',...
	'position', pos,...
    'ForegroundColor', 'black',...
    'BackgroundColor', 'white');
    
add_block('built-in/Inport',[sys '/' ssName '/' 'In1'],'Port','1', 'position', [20 123 50 137]);

add_block('built-in/Inport',[sys '/' ssName '/' 'In2'],'Port','2', 'position', [20 153 50 167]);

add_block('built-in/Memory',[sys '/' ssName '/' 'Memory'],'X0',num2str(initState),'position',[60 85 90 115]);

add_block('built-in/Mux', [sys '/' ssName '/Mux'],...
    'orientation', 'right', 'position', [265 105 275 155], ...
    'Inputs', '3', 'DisplayOption', 'bar')

add_block('built-in/Fcn',[sys '/' ssName '/Fcn'],...
    'Expr','(!u(1)&&u(2)) || (u(1)&&(!u(3)))',...
    'position',[300 114 320 146]);

add_block('built-in/Outport',[sys,'/',ssName,'/','Out1'],...
    'Port','1', ...
    'position', [350 123 380 137]);

add_line([sys,'/',ssName], 'Memory/1', 'Mux/1','autorouting','on');
add_line([sys,'/',ssName], 'In1/1', 'Mux/2','autorouting','on');
add_line([sys,'/',ssName], 'In2/1', 'Mux/3','autorouting','on');
add_line([sys,'/',ssName], 'Mux/1', 'Fcn/1','autorouting','on');
add_line([sys,'/',ssName], 'Fcn/1', 'Memory/1','autorouting','on');
add_line([sys,'/',ssName], 'Fcn/1', 'Out1/1','autorouting','on');