% Inports
% 1: Input
% 2: R
% 3: Neighbouring junction's DB
% 4: Neighbouring junction's bondindex, on which R is connected
% 5: Type of neighbouring junction [0|1]
%
% Outports
% 1: Output
%

function hbg_generateComputeR(sys, pos)

ssName = 'Computing R';

add_block('built-in/SubSystem', [sys '/' ssName] );
set_param([sys '/' ssName],'orientation','right','position',pos, ...
    'ForegroundColor', 'black',...
    'BackgroundColor', 'white',...
    'ShowPortLabels', 'off');
    
add_block('built-in/Inport',[sys '/' ssName '/' 'In1'],'Port','1', 'position', [80   108   110   122]);

add_block('built-in/Inport',[sys '/' ssName '/' 'R'],'Port','2', 'position', [80 198 110 212]);

add_block('built-in/Inport',[sys '/' ssName '/' 'JuncDB'],'Port','3', 'position', [80 328 110 342]);

add_block('built-in/Inport',[sys '/' ssName '/' 'Bond'],'Port','4', 'position', [80 368 110 382]);

add_block('built-in/Inport',[sys '/' ssName '/' 'Junction Type'],'Port','5', 'position', [80 408 110 422]);

add_block('built-in/Outport',[sys,'/',ssName,'/','Out1'],'Port','1','position',[565   288   595   302]);

add_block('built-in/Constant',[sys,'/',ssName,'/','One'],...
    'position',[255   410   275   430], 'value','1');

add_block('built-in/Constant',[sys,'/',ssName,'/','MinusOne'],...
    'position',[255   450   275   470], 'value','-1');

add_block('built-in/Mux', [sys '/' ssName '/Mux1'],...
    'orientation', 'right', 'position', [205   315   210   435], ...
    'Inputs', '3', 'DisplayOption', 'bar');

add_block('built-in/Mux', [sys '/' ssName '/Mux2'],...
    'orientation', 'right', 'position', [425   234   430   356], ...
    'Inputs', '3', 'DisplayOption', 'bar');

add_block('built-in/Fcn',[sys '/' ssName '/CalcCausality'],...
    'Expr','(u(1) == u(2) && u(3) ==1) || (u(1) !=u(2) && u(3) == 0)',...
    'position',[240   360   300   390]);

add_block('built-in/Fcn',[sys '/' ssName '/CalcOutput'],...
    'Expr','(u(1)*u(2)^u(3))',...
    'position',[450   280   510   310]);

add_block('built-in/MultiPortSwitch',[sys '/' ssName '/Switch1'],...
    'zeroidx','on',...
    'Inputs','2','position',[335   367   365   413]);

	
	
% Inports' connections
add_line([sys,'/',ssName], 'In1/1', 'Mux2/1','autorouting','on');
add_line([sys,'/',ssName], 'R/1', 'Mux2/2','autorouting','on');
add_line([sys,'/',ssName], 'JuncDB/1', 'Mux1/1', 'autorouting', 'on');
add_line([sys,'/',ssName], 'Bond/1', 'Mux1/2', 'autorouting', 'on');
add_line([sys,'/',ssName], 'Junction Type/1', 'Mux1/3', 'autorouting', 'on');

add_line([sys,'/',ssName], 'Mux1/1', 'CalcCausality/1', 'autorouting', 'on');

% Inputs of Switch1
add_line([sys,'/',ssName], 'CalcCausality/1', 'Switch1/1', 'autorouting', 'on');
add_line([sys,'/',ssName], 'One/1', 'Switch1/2', 'autorouting', 'on');
add_line([sys,'/',ssName], 'MinusOne/1', 'Switch1/3', 'autorouting', 'on');

% Finishing Mux2
add_line([sys,'/',ssName], 'Switch1/1', 'Mux2/3', 'autorouting', 'on');

% Calculate and connect Output (Out1 port)
add_line([sys,'/',ssName], 'Mux2/1', 'CalcOutput/1', 'autorouting', 'on');
add_line([sys,'/',ssName], 'CalcOutput/1', 'Out1/1', 'autorouting', 'on');










