function hbg_hybridjunction(ssName, sys, pos, numBonds, index, signArray, decVars, onExp, offExp, initState)
% Hybrid Junction

global bg;

% Check if fixed
juncNum = bg.juncMap(index);
if bg.fixedJuncList(index) == 1
    hbg_hybridjunction_fixed(ssName, sys, pos, numBonds, index, signArray, decVars, onExp, offExp, initState);
    return;
end
    
bg.junctionList(index)=1;

signsArray = str2num(signArray);
bondSigns = [];
for i=1:length(signsArray)
    if signsArray(i)==1
        bondSigns(i)='+';
    else
        bondSigns(i)='-';
    end
end

% Find out junction type and use the suitable image-mask
juncType = bg.node(bg.juncMap(index)).type;
if strcmp(juncType,'ZeroJunction')
    displayString = 'image(imread(''0.png'',''BackgroundColor'',[1 1 1]))';
else
	displayString = 'image(imread(''1.png'',''BackgroundColor'',[1 1 1]))';
end

% Add block to system
add_block('built-in/SubSystem', [sys '/' ssName] )
set_param([sys '/' ssName],'position',pos, ...
    'ForegroundColor', 'gray',...
    'BackgroundColor', 'white',...
    'DropShadow', 'on',...
    'ShowPortLabels', 'off',...
    'Mask','on',...
    'MaskDisplay',displayString);

% Add the mux
add_block('built-in/Mux', [sys '/' ssName '/Mux'],...
    'orientation', 'right', 'position', [80, 110, 90, 160], ...
    'Inputs', num2str(numBonds + decVars), 'DisplayOption', 'bar');

% Add constant of zero
add_block('built-in/Constant',[sys '/' ssName '/Zero'],'Value','0',...
    'position',[250, 20, 270, 40]);

% Add db stuff
add_block('built-in/DataStoreRead',[sys,'/',ssName,'/','JuncDB'],...
    'position',[100, 20, 120, 40],'DataStoreName',['junc',num2str(index),'db'],...
    'SampleTime','0');
add_block('built-in/Constant',[sys '/' ssName '/One'],'Value','1',...
    'position',[100, 40, 120, 60]);
add_block('built-in/Sum',[sys '/' ssName '/OffsetDB'],'Inputs','++',...
    'position',[190, 20, 210, 40]);
add_line([sys '/' ssName],'JuncDB/1','OffsetDB/1','autorouting','on');
add_line([sys '/' ssName],'One/1','OffsetDB/2','autorouting','on');


signsString = '';
for i=1:numBonds-1
    signsString = [signsString '+'];
end

for i = 1:numBonds
    % Add Input Ports
    inPortName = ['u(', num2str(i), ')'];
    inPortPos = ['[10, 10 + ' num2str(i) '*50, 30, 10 + ' num2str(i) '*50 + 20]'];
    add_block('built-in/Inport',[sys '/' ssName '/' inPortName],...
        'Port',num2str(i), ...
        'position', str2num(inPortPos));
    
    % Add Output Ports
    outPortName = ['y(', num2str(i), ')'];
    outPortPos = ['[400, 10 + ' num2str(i) '*50, 420, 10 + ' num2str(i) '*50 + 20]'];
    add_block('built-in/Outport',[sys '/' ssName '/' outPortName],...
        'Port',num2str(i), ...
        'position', str2num(outPortPos))
    
    % Add the multiport switch
    switchName = ['Switch' num2str(i)];
    add_block('built-in/MultiPortSwitch',[sys '/' ssName '/' switchName],...
        'Inputs',num2str(numBonds+1),...
        'position',[300 50+(20*numBonds)*(i-1) 320 50+(20*numBonds)*(i-1)+10+10*numBonds]);
      
    set_param([sys '/' ssName '/' switchName], 'DiagnosticForDefault', 'Warning');  
    
    add_line([sys '/' ssName],[switchName '/1'],[outPortName '/1'],'autorouting','on');
    add_line([sys '/' ssName],'OffsetDB/1',[switchName '/1'],'autorouting','on');
    add_line([sys '/' ssName],'Zero/1',[switchName '/2'],'autorouting','on');
    
    % Add the adder
    adderName = ['Adder' num2str(i)];
    add_block('built-in/Sum',[sys '/' ssName '/' adderName],...
        'position',[200 50+(20*numBonds)*(i-1) 220 50+(20*numBonds)*(i-1)+10+10*numBonds],...
        'Inputs',signsString);
    add_block('built-in/Gain',[sys '/' ssName '/Gain' num2str(i)],'Gain',num2str(-1*signsArray(i)),...
        'position',[250 50+(20*numBonds)*(i-1) 270 50+(20*numBonds)*(i-1)+10+10*numBonds]);
    add_line([sys '/' ssName],[adderName '/1'],['Gain' num2str(i) '/1']);
    
    add_line([sys,'/',ssName], ['u(', num2str(i),')/1'], ['Mux/', num2str(i)],'autorouting','on');
    
end

add_block('built-in/MultiPortSwitch',[sys '/' ssName '/Switch' num2str(numBonds+1)],...
        'Inputs',num2str(numBonds+1),...
        'position',[300 50+(20*numBonds)*(i-1)+100 320 50+(20*numBonds)*(i-1)+10+10*numBonds+100]);
    
set_param([sys '/' ssName '/Switch' num2str(numBonds+1)], 'DiagnosticForDefault', 'Warning');  
		
% Add extra output
add_block('built-in/Outport',[sys,'/',ssName,'/','O'],...
        'Port',num2str(numBonds + 1), ...
        'position', [400, 10+numBonds*50+100, 420, 10+numBonds*50+100+20]);
add_line([sys '/' ssName],['Switch' num2str(numBonds+1) '/1'],'O/1','autorouting','on');
add_line([sys '/' ssName],'OffsetDB/1',['Switch' num2str(numBonds+1) '/1'],'autorouting','on');
add_line([sys '/' ssName],'Zero/1',['Switch' num2str(numBonds+1) '/2'],'autorouting','on');

% Add block to compute state (if db > 0 junction is on)
add_block('built-in/Fcn',[sys,'/',ssName,'/','ComputeState'],...
    'position',[350, 10+numBonds*50+150, 370, 10+numBonds*50+150+20], 'Expression','u(1)>0');

% Add state output
add_block('built-in/Outport',[sys,'/',ssName,'/','State'],...
        'Port',num2str(numBonds + 2), ...
        'position', [400, 10+numBonds*50+150, 420, 10+numBonds*50+150+20]);
		
% Attach to ComputeState
add_line([sys '/' ssName],'ComputeState/1','State/1','autorouting','on');
add_line([sys '/' ssName],'JuncDB/1','ComputeState/1','autorouting','on');


for i=1:numBonds
	% Add compuation for db==i
    for j=1:numBonds
        if i~=j
            %add the pass-through line
            add_line([sys '/' ssName],['u(' num2str(i) ')/1'],['Switch' num2str(j) '/' num2str(i+1+1)],'autorouting','on');
            %add line to adder and fix its param
            adderName = ['Adder' num2str(j) '/'];
            signsString = get_param([sys '/' ssName '/Adder' num2str(j)],'Inputs');
            if i<j
                adderName = [adderName num2str(i)];
                signsString(i) = bondSigns(i);
            else
                adderName = [adderName num2str(i-1)];
                signsString(i-1) = bondSigns(i);
            end
            set_param([sys '/' ssName '/Adder' num2str(j)],'Inputs',signsString);
            add_line([sys '/' ssName],['u(' num2str(i) ')/1'],adderName,'autorouting','on');
        else
            % Attach gain to correct switch input
            add_line([sys '/' ssName],['Gain' num2str(i) '/1'],['Switch' num2str(i) '/' num2str(j+1+1)],'autorouting','on');
        end
    end
	% Attach to output switch
    %if isempty(find(bg.node(juncNum).cannotBeDBList == i, 1))
        add_line([sys '/' ssName],['u(' num2str(i) ')/1'],['Switch' num2str(numBonds+1) '/' num2str(i+1+1)],'autorouting','on');
    %end
end

newSignArray = signArray(1:length(signArray)-1);
for i = 1:decVars
    newSignArray = [newSignArray ', 0'];
end
newSignArray = [newSignArray ']'];

% Add guards
add_block('built-in/Fcn',[sys,'/',ssName,'/','OnGuard'],...
    'position',[120, 600, 140, 620], 'Expression',onExp);
add_block('built-in/Fcn',[sys,'/',ssName,'/','OffGuard'],...
    'position',[120, 650, 140, 670], 'Expression',offExp);
add_block('built-in/DataStoreWrite',[sys,'/',ssName,'/','StoreOnGuard'],...
    'position',[160, 600, 180, 620],'DataStoreName',['junc',num2str(index),'onguard']);
add_block('built-in/DataStoreWrite',[sys,'/',ssName,'/','StoreOffGuard'],...
    'position',[160, 650, 180, 670],'DataStoreName',['junc',num2str(index),'offguard']);

for i = numBonds+1:numBonds+decVars
    % Add Input Ports
    decPortPos = ['[10, 10 + ' num2str(i) '*50, 30, 10 + ' num2str(i) '*50 + 20]'];
    add_block('built-in/Inport',[sys,'/',ssName,'/','u(', num2str(i), ')'],...
        'Port',num2str(i), ...
        'position', str2num(decPortPos))
    
    add_line([sys,'/',ssName], ['u(', num2str(i),')/1'], ['Mux/', num2str(i)],'autorouting','on');
end

add_line([sys, '/', ssName], 'Mux/1', 'OnGuard/1', 'autorouting', 'on');
add_line([sys, '/', ssName], 'Mux/1', 'OffGuard/1', 'autorouting', 'on');
add_line([sys, '/', ssName], 'OnGuard/1', 'StoreOnGuard/1', 'autorouting', 'on');
add_line([sys, '/', ssName], 'OffGuard/1', 'StoreOffGuard/1', 'autorouting', 'on');
