function hbg_hybridjunction_fixed(ssName, sys, pos, numBonds, index, signArray, decVars, onExp, offExp, initState)

% Hybrid junctions with static determiningBonds when they are on

global bg junctionList determiningBonds;
junctionList(index)=0;
bg.junctionList(index) = 0;

signsArray = str2num(signArray);

% Find out junction type and use the suitable image-mask
juncType = bg.node(bg.juncMap(index)).type;
if strcmp(juncType,'ZeroJunction')
    displayString = 'image(imread(''0.png'',''BackgroundColor'',[1 1 1]))';
else
	displayString = 'image(imread(''1.png'',''BackgroundColor'',[1 1 1]))';
end

%add subsystem
add_block('built-in/SubSystem', [sys '/' ssName] )
set_param([sys '/' ssName],'position',pos, ...
    'ForegroundColor', 'gray',...    
    'BackgroundColor', 'white',...
    'DropShadow', 'on',...
    'ShowPortLabels', 'off',...
    'Mask','on',...
    'MaskDisplay',displayString);


% Set up signs string
signsString = '';
for i=1:numBonds
    if i~=bg.hybridJuncFixedDBList(index)
        if signsArray(i)==1
            signsString = [signsString '+'];
        else
            signsString = [signsString '-'];
        end
    end
end

% Add the adder and sign gain
adderName = 'Adder';
add_block('built-in/Sum',[sys '/' ssName '/' adderName],...
    'position',[200 50+(20*numBonds) 220 50+(20*numBonds)+10+10*numBonds],...
    'Inputs',signsString);
add_block('built-in/Gain',[sys '/' ssName '/Gain'],'Gain',num2str(-1*signsArray(bg.hybridJuncFixedDBList(index))),...
    'position',[250 50+(20*numBonds) 270 50+(20*numBonds)+10+10*numBonds]);
add_line([sys '/' ssName],[adderName '/1'],['Gain/1']);

for i = 1:numBonds
    % Add Input Ports
    inPortName = ['u(', num2str(i), ')'];
    inPortPos = ['[10, 10 + ' num2str(i) '*50, 30, 10 + ' num2str(i) '*50 + 20]'];
    add_block('built-in/Inport',[sys '/' ssName '/' inPortName],...
        'Port',num2str(i), ...
        'position', str2num(inPortPos));
    
    % Add Output Ports
    outPortName = ['y(', num2str(i), ')'];
    outPortPos = ['[400, 10 + ' num2str(i) '*50, 420, 10 + ' num2str(i) '*50 + 20]'];
    add_block('built-in/Outport',[sys '/' ssName '/' outPortName],...
        'Port',num2str(i), ...
        'position', str2num(outPortPos));
end

% Add a mux for correctly evaluating the on and off guards
add_block('built-in/Mux', [sys '/' ssName '/Mux'],...
    'orientation', 'right', 'position', [80, 110, 90, 160], ...
    'Inputs', num2str(numBonds + decVars), 'DisplayOption', 'bar');


for i = numBonds+1:numBonds+decVars
    % Add decision Ports
    decPortPos = ['[10, 10 + ' num2str(i) '*50, 30, 10 + ' num2str(i) '*50 + 20]'];
    add_block('built-in/Inport',[sys,'/',ssName,'/','u(', num2str(i), ')'],...
        'Port',num2str(i), ...
        'position', str2num(decPortPos));
    
    add_line([sys,'/',ssName], ['u(', num2str(i),')/1'], ['Mux/', num2str(i)],'autorouting','on');
    
end

% Add function blocks for evaluating on guards and off guards
add_block('built-in/Fcn',[sys,'/',ssName,'/','OnGuard'],...
    'position',[145   325   165   345], 'Expression',onExp);
add_line([sys,'/',ssName], 'Mux/1', 'OnGuard/1','autorouting','on');
add_block('built-in/Fcn',[sys,'/',ssName,'/','OffGuard'],...
    'position',[145   395   165   415], 'Expression',offExp);
add_line([sys,'/',ssName], 'Mux/1', 'OffGuard/1','autorouting','on');


if determiningBonds(index) == 0
    initialState = 0;
else
    initialState = 1;
end
hbg_determinestate_element([sys, '/',ssName], [195 360 215 380], initialState);

add_line([sys,'/',ssName], 'OnGuard/1', 'determineState/1', 'autorouting','on');
add_line([sys,'/',ssName], 'OffGuard/1', 'determineState/2', 'autorouting','on');

% Add multiplier blocks
add_block('built-in/Product', [sys '/' ssName '/Product1'],...
    'Inputs', '2',...
    'position',  [320 67 340 98]);

add_block('built-in/Product', [sys '/' ssName '/Product2'],...
    'Inputs', '2',...
    'position',  [320 167 340 198]);


% Add extra output
add_block('built-in/Outport',[sys,'/',ssName,'/','O'],...
        'Port',num2str(numBonds + 1), ...
        'position', [400, 10+numBonds*50+100, 420, 10+numBonds*50+100+20]);


% Add state output
add_block('built-in/Outport',[sys,'/',ssName,'/','State'],...
        'Port',num2str(numBonds + 2), ...
        'position', [400, 10+numBonds*50+150, 420, 10+numBonds*50+150+20]);


i = bg.hybridJuncFixedDBList(index);
add_line([sys '/' ssName],['u(' num2str(i) ')/1'],'Product1/1','autorouting','on');
add_line([sys '/' ssName],'determineState/1','Product1/2','autorouting','on');
add_line([sys '/' ssName],'determineState/1','Product2/2','autorouting','on');

% Attach to state output
add_line([sys '/' ssName],'determineState/1','State/1','autorouting','on');

% Attach to extra output
add_line([sys '/' ssName],'Product1/1','O/1','autorouting','on');

add_line([sys '/' ssName],'Gain/1','Product2/1','autorouting','on');

% Add compuation for determiningBonds
for j=1:numBonds
    i=bg.hybridJuncFixedDBList(index);
    if i~=j
        % Add the pass-through line
        add_line([sys '/' ssName],'Product1/1',['y(' num2str(j) ')/1'],'autorouting','on');
        % Add line to adder
        if j<i
            portNum = j;
        else
            portNum = j-1;
        end
        add_line([sys '/' ssName],['u(' num2str(j) ')/1'],['Adder/' num2str(portNum)],'autorouting','on');
    else
        % Attach gain to determiningBonds output        
        add_line([sys '/' ssName],['Product2/1'],['y(' num2str(i) ')/1'],'autorouting','on');
    end
end


 


