% hbg_inertia with initial value port
function hbg_inertia_w_iv_port(ssName, sys, pos, value, initial, ismod)

global bg;

% I-Element
add_block('built-in/SubSystem',[sys,'/',ssName])
set_param([sys,'/',ssName],'orientation','left','position',pos, ...
    'Mask', 'on', ...
    'ForegroundColor', 'green',...
    'BackgroundColor', 'white', ...
    'DropShadow', 'on');

% Input Port
add_block('built-in/Inport',[sys,'/',ssName,'/','E'],...
    'Port','1', 'position',[40, 30, 60, 50])

% Initial Condition
add_block('built-in/Inport',[sys,'/',ssName,'/','InitialCondition'],...
    'Port','2','position',[40, 70, 60, 90]);

% Inductance
if ismod
	add_block('built-in/Inport',[sys,'/',ssName,'/','Inductance'],...
		'position',[40, 110, 65, 135], 'Port','3');
	set_param([sys,'/',ssName],...
		'MaskPromptString', 'Initial Condition:', ...
		'MaskVariables', 'IC=@1',...
		'MaskStyleString', 'edit', ...
		'MaskDisplay','image(imread(''MI.png'',''BackgroundColor'',[1 1 1]))',...
		'MaskValueString', [num2str(initial)]);
else
	set_param([sys,'/',ssName],...
		'MaskPromptString', 'Value of I:|Initial Condition:', ...
		'MaskVariables', 'I=@1;IC=@2',...
		'MaskStyleString', 'edit,edit', ...
		'MaskDisplay','image(imread(''I.png'',''BackgroundColor'',[1 1 1]))',...
		'MaskValueString', [num2str(value), '|', num2str(initial)]);

	add_block('built-in/Constant',[sys,'/',ssName,'/','Inductance'],...
		'position',[40, 110, 60, 130], 'value','I');
end


% Product1
add_block('built-in/Product',[sys,'/',ssName,'/','Product1'],...
    'position',[340, 110, 360, 130]);

% Math Function (Reciprocal)
add_block('built-in/Math',[sys,'/',ssName,'/','Reciprocal'],...
    'Function','Reciprocal', 'position',[340, 150, 360, 180]);

% Integrator
add_block('built-in/Integrator',[sys,'/',ssName,'/','Integrator'],...
    'InitialConditionSource','External',...
    'position',[490, 30, 530, 100]);
   
% Product2
add_block('built-in/Product',[sys,'/',ssName,'/','Product2'],...
    'position',[590, 110, 610, 130]);

% Output Port
add_block('built-in/Outport',[sys,'/',ssName,'/','F'],...
    'Port','1','position',[690, 110, 710, 130]);

% Output Port for State
add_block('built-in/Outport',[sys,'/',ssName,'/','p'],...
    'Port','2','position',[750, 110, 770, 130]);
	
% Initial value
%add_block('simulink/Signal Attributes/IC', [sys,'/',ssName,'/','Initialization'], 'position', [125,85,165,130], 'Value', 'IC')
 
% Connections
add_line([sys '/' ssName], 'E/1','Integrator/1','autorouting','on');
%add_line([sys '/' ssName], 'InitialCondition/1','Initialization/1','autorouting','on');
%add_line([sys '/' ssName], 'Initialization/1','Product1/1','autorouting','on');
add_line([sys '/' ssName], 'InitialCondition/1','Product1/1','autorouting','on');
add_line([sys '/' ssName], 'Inductance/1','Reciprocal/1','autorouting','on');
add_line([sys '/' ssName], 'Inductance/1','Product1/2','autorouting','on');
add_line([sys '/' ssName], 'Product1/1','Integrator/2','autorouting','on');
add_line([sys '/' ssName], 'Integrator/1','Product2/1','autorouting','on');
add_line([sys '/' ssName], 'Reciprocal/1','Product2/2','autorouting','on');
add_line([sys,'/',ssName], 'Product2/1','F/1','autorouting','on');
add_line([sys,'/',ssName], 'Integrator/1','p/1','autorouting','on');
