function hbg_junction(ssName, sys, pos, numBonds, index, signArray)

global bg fixedJuncList;
bg.junctionList(index)=0;

% Is junction fixed?
if fixedJuncList(index) == 1
    hbg_junction_fixed(ssName, sys, pos, numBonds, index, signArray);
    return
end

juncNum = bg.juncMap(index);

% Convert signArray to bondSigns > from ones to signs [1 1 -1 -1] to [+ + - -]
% signArray(i) shows the direction of bond no i. 1: pointing towards the junction, -1: pointing away from junction
signsArray = str2num(signArray);
bondSigns = [];
for i=1:length(signsArray)
    if signsArray(i)==1
        bondSigns(i)='+';
    else
        bondSigns(i)='-';
    end
end

% Find out junction type, and use the suitable image-mask
juncType = bg.node(bg.juncMap(index)).type;
if strcmp(juncType,'ZeroJunction')
    displayString = 'image(imread(''0.png'',''BackgroundColor'',[1 1 1]))';
else
	displayString = 'image(imread(''1.png'',''BackgroundColor'',[1 1 1]))';
end


% Add subsystem
add_block('built-in/SubSystem', [sys '/' ssName] )
set_param([sys '/' ssName],'position',pos, ...
    'ForegroundColor', 'gray',...
    'BackgroundColor', 'white',...
    'DropShadow', 'on',...
    'ShowPortLabels', 'off',...
    'Mask','on',...
    'MaskDisplay', displayString);

% Add constant of zero
add_block('built-in/Constant',[sys '/' ssName '/Zero'],'Value','0',...
    'position',[250, 20, 270, 40]);

% Add db stuff
add_block('built-in/DataStoreRead',[sys,'/',ssName,'/','JuncDB'],...
    'position',[100, 20, 120, 40],...
	'DataStoreName',['junc',num2str(index),'db'],...
    'SampleTime','0');
	
add_block('built-in/Constant',[sys '/' ssName '/One'],'Value','1',...
    'position',[100, 40, 120, 60]);
add_block('built-in/Sum',[sys '/' ssName '/OffsetDB'],'Inputs','++',...
    'position',[190, 20, 210, 40]);
add_line([sys '/' ssName],'JuncDB/1','OffsetDB/1','autorouting','on');
add_line([sys '/' ssName],'One/1','OffsetDB/2','autorouting','on');

% Initialize signsString with pluses, fix it later
signsString = '';
for i=1:numBonds-1
    signsString = [signsString '+'];
end

for i = 1:numBonds
    % Add Input Ports
    inPortName = ['u(', num2str(i), ')'];
    inPortPos = ['[10, 10 + ' num2str(i) '*50, 30, 10 + ' num2str(i) '*50 + 20]'];
    add_block('built-in/Inport',[sys '/' ssName '/' inPortName],...
        'Port',num2str(i), ...
        'position', str2num(inPortPos))
    
    % Add Output Ports
    outPortName = ['y(', num2str(i), ')'];
    outPortPos = ['[400, 10 + ' num2str(i) '*50, 420, 10 + ' num2str(i) '*50 + 20]'];
    add_block('built-in/Outport',[sys '/' ssName '/' outPortName],...
        'Port',num2str(i), ...
        'position', str2num(outPortPos))
    
    % Add the multiport switch
    switchName = ['Switch' num2str(i)];
    add_block('built-in/MultiPortSwitch',[sys '/' ssName '/' switchName],...
        'Inputs',num2str(numBonds+1),...
        'position',[300 50+(20*numBonds)*(i-1) 320 50+(20*numBonds)*(i-1)+10+10*numBonds]);
      
    set_param([sys '/' ssName '/' switchName], 'DiagnosticForDefault', 'Warning');      
      
    add_line([sys '/' ssName],[switchName '/1'],[outPortName '/1'],'autorouting','on');
    add_line([sys '/' ssName],'OffsetDB/1',[switchName '/1'],'autorouting','on');
    add_line([sys '/' ssName],'Zero/1',[switchName '/2'],'autorouting','on');
    
    % Add the adder and gain
    adderName = ['Adder' num2str(i)];
	gainName = ['Gain' num2str(i)];
    add_block('built-in/Sum',[sys '/' ssName '/' adderName],...
        'position',[200 50+(20*numBonds)*(i-1) 220 50+(20*numBonds)*(i-1)+10+10*numBonds],...
        'Inputs',signsString);
    add_block('built-in/Gain',[sys '/' ssName '/' gainName],...
			'Gain',num2str(-1*signsArray(i)),...
			'position',[250 50+(20*numBonds)*(i-1) 270 50+(20*numBonds)*(i-1)+10+10*numBonds]);
			
    add_line([sys '/' ssName],[adderName '/1'],['Gain' num2str(i) '/1']);
    
end

% Additional output port
add_block('built-in/MultiPortSwitch',[sys '/' ssName '/Switch' num2str(numBonds+1)],...
        'Inputs',num2str(numBonds+1),...
        'position',[300 50+(20*numBonds)*(i-1)+100 320 50+(20*numBonds)*(i-1)+10+10*numBonds+100]);
    
set_param([sys '/' ssName '/Switch' num2str(numBonds+1)], 'DiagnosticForDefault', 'Warning');    
    
add_block('built-in/Outport',[sys,'/',ssName,'/','O'],...
        'Port',num2str(numBonds + 1), ...
        'position', [400, 10+numBonds*50+100, 420, 10+numBonds*50+100+20]);
add_line([sys '/' ssName],['Switch' num2str(numBonds+1) '/1'],'O/1','autorouting','on');
add_line([sys '/' ssName],'OffsetDB/1',['Switch' num2str(numBonds+1) '/1'],'autorouting','on');
add_line([sys '/' ssName],'Zero/1',['Switch' num2str(numBonds+1) '/2'],'autorouting','on');

for i=1:numBonds
    % Add compuation for db==i
    for j=1:numBonds
        if i~=j
            
			% Connects u(i) directly to every switch where i~=j, on port i+2 (port-1: control; port-2: constant-zero)
            add_line([sys '/' ssName],['u(' num2str(i) ')/1'],['Switch' num2str(j) '/' num2str(i+1+1)],'autorouting','on');
            
			% Fix param of adder
            adderName = ['Adder' num2str(j) '/'];
            signsString = get_param([sys '/' ssName '/Adder' num2str(j)],'Inputs');

			if i<j  % Compute addername and fix the signs of inputs
                adderName = [adderName num2str(i)];
                signsString(i) = bondSigns(i);
            else
                adderName = [adderName num2str(i-1)];
                signsString(i-1) = bondSigns(i);
            end
            set_param([sys '/' ssName '/Adder' num2str(j)],'Inputs',signsString);
            add_line([sys '/' ssName],['u(' num2str(i) ')/1'],adderName,'autorouting','on');
        else
            % Attach gain to correct switch input
            add_line([sys '/' ssName],['Gain' num2str(i) '/1'],['Switch' num2str(i) '/' num2str(j+1+1)],'autorouting','on');
        end
    end
    
	% Attach to output switch (only if can be DB)
    if isempty(find(bg.node(juncNum).cannotBeDBList == i, 1))
        add_line([sys '/' ssName],['u(' num2str(i) ')/1'],['Switch' num2str(numBonds+1) '/' num2str(i+1+1)],'autorouting','on');
    end
end
