function hbg_junction_Fixed(ssName, sys, pos, numBonds, index, signArray)
% Junction with static determiningBonds

global bg determiningBonds junctionList;
junctionList(index)=0;

signsArray = str2num(signArray);

% Find out junction type, and use the suitable image-mask
juncType = bg.node(bg.juncMap(index)).type;
if strcmp(juncType,'ZeroJunction')
    displayString = 'image(imread(''0.png'',''BackgroundColor'',[1 1 1]))';
else
	displayString = 'image(imread(''1.png'',''BackgroundColor'',[1 1 1]))';
end

% Add subsystem
add_block('built-in/SubSystem', [sys '/' ssName] )
set_param([sys '/' ssName],'position',pos, ...
    'ForegroundColor', 'gray',...    
    'BackgroundColor', 'white',...
    'DropShadow', 'on',...
    'ShowPortLabels', 'off',...
    'Mask','on',...
    'MaskDisplay',displayString);


% Set up signs string (going to be one index shorter than numBonds)
signsString = '';
for i=1:numBonds
    if i~=determiningBonds(index)
        if signsArray(i)==1
            signsString = [signsString '+'];
        else
            signsString = [signsString '-'];
        end
    end
end

% Add the adder and sign gain
adderName = 'Adder';
add_block('built-in/Sum',[sys '/' ssName '/' adderName],...
    'position',[200 50+(20*numBonds) 220 50+(20*numBonds)+10+10*numBonds],...
    'Inputs',signsString);
add_block('built-in/Gain',[sys '/' ssName '/Gain'],'Gain',num2str(-1*signsArray(determiningBonds(index))),...
    'position',[250 50+(20*numBonds) 270 50+(20*numBonds)+10+10*numBonds]);
add_line([sys '/' ssName],[adderName '/1'],['Gain/1']);

for i = 1:numBonds
    % Add Input Ports
    inPortName = ['u(', num2str(i), ')'];
    inPortPos = ['[10, 10 + ' num2str(i) '*50, 30, 10 + ' num2str(i) '*50 + 20]'];
    add_block('built-in/Inport',[sys '/' ssName '/' inPortName],...
        'Port',num2str(i), ...
        'position', str2num(inPortPos))
    
    % Add Output Ports
    outPortName = ['y(', num2str(i), ')'];
    outPortPos = ['[400, 10 + ' num2str(i) '*50, 420, 10 + ' num2str(i) '*50 + 20]'];
    add_block('built-in/Outport',[sys '/' ssName '/' outPortName],...
        'Port',num2str(i), ...
        'position', str2num(outPortPos))
end


% Add extra output
add_block('built-in/Outport',[sys,'/',ssName,'/','O'],...
        'Port',num2str(numBonds + 1), ...
        'position', [400, 10+numBonds*50+100, 420, 10+numBonds*50+100+20]);

% Add compuation for determiningBonds
for j=1:numBonds
    i=determiningBonds(index);
    if i~=j
        % Add the pass-through line (from db input to all other outputs)
        add_line([sys '/' ssName],['u(' num2str(i) ')/1'],['y(' num2str(j) ')/1'],'autorouting','on');
        % Add line to adder
        if j<i
            portNum = j;
        else
            portNum = j-1;
        end
        add_line([sys '/' ssName],['u(' num2str(j) ')/1'],['Adder/' num2str(portNum)],'autorouting','on');
    else
        % Attach gain to determiningBond's output        
        add_line([sys '/' ssName],['Gain/1'],['y(' num2str(i) ')/1'],'autorouting','on');
    end
end

% Attach to extra output
add_line([sys '/' ssName],['u(' num2str(determiningBonds(index)) ')/1'],['O/1'],'autorouting','on');


