function hbg_reset_element(ssName, sys, pos, funcSpec, numPorts, resetFunction, storagePaths, triggerType)

add_block('built-in/SubSystem', [sys '/' ssName] )
set_param([sys '/' ssName],'orientation','right','position',pos, ...
    'ForegroundColor', 'black',...
    'BackgroundColor', 'white',...
    'DropShadow', 'on',...
    'ShowPortLabels', 'off',...
    'Mask','on',...
    'MaskDisplay','image(imread(''fx.png'',''BackgroundColor'',[1 1 1]))')

% Add the mux
add_block('built-in/Mux', [sys '/' ssName '/Mux'],...
    'orientation', 'right', 'position', [100, 100, 105, 150], ...
    'Inputs', num2str(numPorts), 'DisplayOption', 'bar')

% Add the switching function block
add_block('built-in/Fcn', [sys '/' ssName '/SwFunction'],...
    'orientation', 'right', 'position',[210, 72, 280, 123], 'Expression', funcSpec)
	
% Add the ResetFunction block
add_block('built-in/Fcn', [sys '/' ssName '/ResetFunction'],...
    'orientation', 'right', 'position',[210, 272, 280, 323], 'Expression', resetFunction)

% Add the switch 
add_block('built-in/Switch', [sys '/' ssName '/Switch'],...
    'Criteria', 'u2 ~= 0', 'position',[390, 87 ,430, 127] );

% OneConstant
add_block('built-in/Constant',[sys,'/',ssName,'/','One'],...
	'position',[210, 30, 230, 50], 'value','1');

% ZeroConstant
add_block('built-in/Constant',[sys,'/',ssName,'/','Zero'], 'position',[210, 150, 230, 170], 'value', '0');

for i = 1:numPorts
    % Add Input Ports
    portPos = ['[10, 10 + ' num2str(i) '*50, 30, 10 + ' num2str(i) '*50 + 20]'];
    add_block('built-in/Inport',[sys,'/',ssName,'/','u(', num2str(i), ')'],...
        'Port', num2str(i), ...
        'position', str2num(portPos))
    
    add_line([sys,'/',ssName], ['u(', num2str(i),')/1'], ['Mux/', num2str(i)], 'autorouting', 'on');
end


add_block('built-in/Outport',[sys,'/',ssName,'/','TriggerPort'],...
    'Port', '1', 'position', [480, 100, 500, 120])

add_block('built-in/Outport',[sys,'/',ssName,'/','ResetFunctionPort'],...
    'Port', '2', 'position', [480, 300, 500, 320])
	

add_line([sys,'/',ssName], 'Mux/1', 'SwFunction/1', 'autorouting','on');
add_line([sys,'/',ssName], 'Mux/1', 'ResetFunction/1', 'autorouting', 'on')
add_line([sys,'/',ssName], 'SwFunction/1','Switch/2','autorouting','on');
add_line([sys,'/',ssName], 'ResetFunction/1', 'ResetFunctionPort/1', 'autorouting', 'on')
add_line([sys,'/',ssName], 'One/1','Switch/1','autorouting','on');
add_line([sys,'/',ssName], 'Zero/1','Switch/3','autorouting','on');
add_line([sys,'/',ssName], 'Switch/1','TriggerPort/1','autorouting','on');

% Make changes to affected storages
for i = 1:length(storagePaths)
    add_block('built-in/InPort', [storagePaths{i}, '/Trigger'], 'position', [40, 200, 60, 220], 'Port', '2');
    delete_line(storagePaths{i}, 'InitialCondition/1', 'Initialization/1');
    delete_block([storagePaths{i}, '/InitialCondition']);
    add_block('built-in/InPort', [storagePaths{i}, '/ResetFunction'], 'position', [40, 70, 60, 90], 'Port', '3');
    if strcmp(triggerType, 'Rising')
        set_param([storagePaths{i}, '/Integrator'], 'ExternalReset', 'rising');
    elseif strcmp(triggerType, 'Falling')
        set_param([storagePaths{i}, '/Integrator'], 'ExternalReset', 'falling');
    elseif strcmp(triggerType, 'Either')
        set_param([storagePaths{i}, '/Integrator'], 'ExternalReset', 'either');
    end
    add_line(storagePaths{i}, 'Trigger/1', 'Integrator/2', 'autorouting', 'on');
    add_line(storagePaths{i}, 'ResetFunction/1', 'Initialization/1', 'autorouting', 'on');
end
