function hbg_resistor_w_memory(ssName, sys, pos, j, b, juncType, value, ismod)

global bg determiningBonds fixedJuncList;

% Returns the unique nodeID of the junction, indexed by i
juncNum = bg.juncMap(j);

% R-Element-subsystem
add_block('built-in/SubSystem',[sys,'/',ssName]);
set_param([sys,'/',ssName],'orientation','left','position',pos, ...
    'Mask', 'on', ...
	'MaskPromptString', 'Value of R:', ...
	'MaskVariables', 'R=@1',...
	'MaskStyleString', 'edit', ...
	'MaskValueString', num2str(value),...
    'ForegroundColor', 'red',...
    'BackgroundColor', 'white',...
    'DropShadow', 'on');

% Input Port
add_block('built-in/Inport',[sys,'/',ssName,'/','In'],...
    'Port','1', 'position',[30,75,50,90]);
  
add_block('built-in/Memory', [sys, '/', ssName, '/', 'Memory'], ...
  'position', [195,68,225,98], 'X0', '1');
  
% Resistor Value
if ismod
	set_param([sys,'/',ssName],'MaskDisplay','image(imread(''MR.png'',''BackgroundColor'',[1 1 1]))');
	

	
	add_block('built-in/Inport',[sys,'/',ssName,'/','Resistor Value'],...
		'position',[30, 115, 50, 135], 'Port','2');

	add_block('built-in/Constant',[sys,'/',ssName,'/','Resistor Default Value'],...
		'position',[30, 210, 50, 230], 'value','R');
		
	add_block('built-in/Switch', [sys, '/', ssName, '/', 'SafetySwitch'],...
		'position',[195, 175, 225, 205], 'Criteria', 'u2 ~= 0');
		
	add_block('simulink/Logic and Bit Operations/Compare To Zero', [sys, '/', ssName, '/', 'CompareToZero'],...
		'position', [110, 150, 140, 180], 'relop', '~=');
		
	add_line([sys,'/',ssName], 'Resistor Value/1', 'SafetySwitch/1', 'autorouting','on');
	add_line([sys,'/',ssName], 'Resistor Value/1', 'CompareToZero/1', 'autorouting','on');
	add_line([sys,'/',ssName], 'CompareToZero/1', 'SafetySwitch/2', 'autorouting','on');
	add_line([sys,'/',ssName], 'Resistor Default Value/1', 'SafetySwitch/3', 'autorouting','on');
else
	set_param([sys,'/',ssName], 'MaskDisplay', 'image(imread(''R.png'',''BackgroundColor'',[1 1 1]))');
		
	add_block('built-in/Constant',[sys,'/',ssName,'/','Resistor Value'],...
		'position',[30, 110, 50, 130], 'value','R');
end



% Determine neighbouring junction's DB
if fixedJuncList(j) == 1 
   % neighboring controlled junc fixed, so use constant
   if bg.node(juncNum).hybrid == 1
       add_block('built-in/Constant',[sys,'/',ssName,'/','JuncDB'],...
    'position',[30, 270, 50, 290], 'value',num2str(bg.hybridJuncFixedDBList(j)));
   else
       add_block('built-in/Constant',[sys,'/',ssName,'/','JuncDB'],...
    'position',[30, 270, 50, 290], 'value',num2str(determiningBonds(j)));
   end
else
    % neighboring junc NOT fixed, so use data store
    add_block('built-in/DataStoreRead',[sys,'/',ssName,'/','JuncDB'],...
        'position',[30, 270, 50, 290], 'DataStoreName',['junc',num2str(j),'db'],...
        'SampleTime','0');
end

% Add bond number
add_block('built-in/Constant',[sys,'/',ssName,'/','Bond'],...
    'position',[30, 310, 50, 330], 'value',num2str(b));

% Add neighboring junction type
add_block('built-in/Constant',[sys,'/',ssName,'/','Junction Type'],...
    'position',[30, 350, 50, 370], 'value',num2str(juncType));

% Output Port
add_block('built-in/Outport',[sys,'/',ssName,'/','Out']);
set_param([sys,'/',ssName,'/','Out'],'Port','1','position',[435, 142, 455, 158]);

% External buildscript creates "Computing R", which computes the
% output based on the actual causality
hbg_generateComputeR([sys, '/', ssName], [290 150 350 190]);

% Connections
%  Input

add_line([sys,'/',ssName], 'In/1', 'Memory/1','autorouting', 'on')
add_line([sys,'/',ssName], 'Memory/1', 'Computing R/1', 'autorouting', 'on')
add_line([sys,'/',ssName], 'Resistor Value/1', 'Computing R/2', 'autorouting', 'on')

add_line([sys,'/',ssName], 'JuncDB/1','Computing R/3','autorouting','on')
add_line([sys,'/',ssName], 'Bond/1','Computing R/4','autorouting','on')
add_line([sys,'/',ssName], 'Junction Type/1','Computing R/5','autorouting','on')
%  Output
add_line([sys,'/',ssName], 'Computing R/1','Out/1','autorouting','on')

