function hbg_sf_element(ssName, sys, pos, value, ismod)

global bg;

% Source of Flow
add_block('built-in/SubSystem',[sys,'/',ssName])
set_param([sys,'/',ssName],...
    'orientation','right',...
	'position',pos, ... 
    'Mask', 'on', ...
    'ForegroundColor', 'yellow',...
    'BackgroundColor', 'white',...
    'DropShadow', 'on');

% Input Port
add_block('built-in/Inport',[sys,'/',ssName,'/','E'],...
    'Port','1', 'position',[30,75,50,95]);

% Output Port
add_block('built-in/Outport',[sys,'/',ssName,'/','F'],...
    'Port','1','position',[230, 170, 250, 190]);
	
% IF modulated insert port, ELSE insert contant
if ismod
	add_block('built-in/Inport',[sys,'/',ssName,'/','Sf Value'],...
		'position',[30, 115, 50, 135], 'Port','2');
	set_param([sys,'/',ssName],'MaskDisplay','image(imread(''Sf.png'',''BackgroundColor'',[1 1 1]))');
else
	set_param([sys,'/',ssName],...
		'MaskPromptString', 'Value of Sf:', ...
		'MaskVariables', 'Sf=@1',...
		'MaskStyleString', 'edit', ...
		'MaskDisplay','image(imread(''Sf.png'',''BackgroundColor'',[1 1 1]))',...
		'MaskValueString', num2str(value));
	
	add_block('built-in/Constant',[sys,'/',ssName,'/','Sf Value'],...
		'position',[30, 110, 50, 130], 'value','Sf');
end

% Connections
add_line([sys,'/',ssName], 'Sf Value/1','F/1','autorouting','on');