% Build causality update block
function hbg_switchhandler_element(sys)

global bg fixedJuncList;

% If no hybrid junctions or everything fixed, we don't need the switchhandler
if bg.numHybridJunctions == 0 || sum(fixedJuncList)==length(fixedJuncList)
    return
end

ssName = 'SwitchHandler';

% layout stuff
dbmem_y = 10;
grdmem_y = 52;
dbmem_w = 50;
grdmem_w = 90;
dbmem_h = 18;
grdmem_h = 18;
dbmem_indent = 120;
grdmem_indent = 120;
spacing_x = 20;

add_block('built-in/Note', [sys '/Causality data'], 'position', [10,0,100,10]);

% Add subsystem block for switchhandler
add_block('built-in/SubSystem', [sys '/' ssName] )
set_param([sys '/' ssName],'position',[35 30 75 70], ...
    'ForegroundColor', 'black',...
    'BackgroundColor', 'gray',...
    'DropShadow', 'on',...
    'ShowPortLabels', 'off');

% Place the init db block
add_block('built-in/Constant',[sys,'/',ssName,'/','InitDB'],...
    'position',[20, 20, 140, 40], 'value','determiningBonds');

% During junction_element and hybridJunction_element constructed a junction list
% bg.junctionList(i) = 0 if junction i is normal, 1 if hybrid

% Make the two muxes to multiplex the on/off guards
add_block('built-in/Mux', [sys '/' ssName '/MuxOn'],...
    'orientation', 'right', 'position', [150, 80, 155, 80+40*length(bg.junctionList)], ...
    'Inputs', num2str(length(bg.junctionList)), 'DisplayOption', 'bar');
add_block('built-in/Mux', [sys '/' ssName '/MuxOff'],...
    'orientation', 'right', 'position', [200, 120, 205, 120+40*length(bg.junctionList)], ...
    'Inputs', num2str(length(bg.junctionList)), 'DisplayOption', 'bar');

% Add the demux to demultiplex the output of the causalityupdate
add_block('built-in/Demux', [sys '/' ssName '/Demux'],...
    'orientation', 'right', 'position', [400, 80, 405, 80+35*length(bg.junctionList)], ...
    'Outputs', num2str(length(bg.junctionList)), 'DisplayOption', 'bar');

for i=1:length(bg.junctionList)
    if (bg.junctionList(i)==0) % NOT hybrid (add zeros that are never true)
        % Add onguard
        add_block('built-in/Constant',[sys,'/',ssName,'/','OnGuard',num2str(i)],...
            'position',[20, 20+45*i, 40, 20+45*i+20], 'value','0');
        % Add offguard
        add_block('built-in/Constant',[sys,'/',ssName,'/','OffGuard',num2str(i)],...
            'position',[20+40, 20+45*i+20, 40+40, 20+45*i+20+20], 'value','0');
    else % hybrid (add datastorereaders)
        % Add onguard
        add_block('built-in/DataStoreRead',[sys,'/',ssName,'/','OnGuard',num2str(i)],...
            'position',[20, 20+45*i, 40, 20+45*i+20],'DataStoreName',['junc',num2str(i),'onguard'],...
            'SampleTime','0');
        % Add offguard
        add_block('built-in/DataStoreRead',[sys,'/',ssName,'/','OffGuard',num2str(i)],...
            'position',[20+40, 20+45*i+20, 40+40, 20+45*i+20+20],'DataStoreName',['junc',num2str(i),'offguard'],...
            'SampleTime','0');
        % Add data stores to parent sys
        pos = [grdmem_indent, grdmem_y, grdmem_indent + grdmem_w, grdmem_y + grdmem_h];
        add_block('built-in/DataStoreMemory',[sys,'/','OnGuardMemory',num2str(i)],...
            'position', pos, 'DataStoreName',['junc',num2str(i),'onguard'],...
            'InitialValue','0');
        grdmem_indent = grdmem_indent + grdmem_w + spacing_x;
        pos = [grdmem_indent, grdmem_y, grdmem_indent + grdmem_w, grdmem_y + grdmem_h];
		add_block('built-in/DataStoreMemory',[sys,'/','OffGuardMemory',num2str(i)],...
            'position', pos, 'DataStoreName',['junc',num2str(i),'offguard'],...
            'InitialValue','0');
		grdmem_indent = grdmem_indent + grdmem_w + spacing_x;
    end
    % Add lines
    add_line([sys, '/', ssName], ['OnGuard',num2str(i),'/1'], ['MuxOn/',num2str(i)], 'autorouting', 'on');
    add_line([sys, '/', ssName], ['OffGuard',num2str(i),'/1'], ['MuxOff/',num2str(i)], 'autorouting', 'on');
    % Add db write
    add_block('built-in/DataStoreWrite',[sys,'/',ssName,'/','DBWrite',num2str(i)],...
            'position',[450, 20+40*i, 550, 20+40*i+20], 'DataStoreName',['junc',num2str(i),'db']);
    % Connect to demux
    add_line([sys, '/', ssName], ['Demux/',num2str(i)], ['DBWrite',num2str(i),'/1'], 'autorouting', 'on');
    % Add db memory to sys
    pos = [dbmem_indent, dbmem_y, dbmem_indent + dbmem_w, dbmem_y + dbmem_h];
    add_block('built-in/DataStoreMemory',[sys,'/','DBMemory',num2str(i)],...
            'position', pos, 'DataStoreName',['junc',num2str(i),'db'],...
            'InitialValue',['determiningBonds(',num2str(i),')']);
    dbmem_indent = dbmem_indent + dbmem_w + spacing_x;
end

% Add the s-function
add_block('built-in/S-Function', [sys, '/', ssName, '/', 'CausalityUpdate'], ...
	'FunctionName', 'callCausalityUpdate',...
	'position', [250,100,350,150],...
    'Parameters',num2str(length(bg.junctionList)));

% Connect to s-function
add_line([sys, '/', ssName], 'InitDB/1', 'CausalityUpdate/1', 'autorouting', 'on');
add_line([sys, '/', ssName], 'MuxOn/1', 'CausalityUpdate/2', 'autorouting', 'on');
add_line([sys, '/', ssName], 'MuxOff/1', 'CausalityUpdate/3', 'autorouting', 'on');
add_line([sys, '/', ssName], 'CausalityUpdate/1', 'Demux/1', 'autorouting', 'on');
