function hbg_switching_element(ssName, sys, pos, funcSpec, numPorts)

add_block('built-in/SubSystem', [sys '/' ssName] )
set_param([sys '/' ssName],'orientation','right','position',pos, ...
    'ForegroundColor', 'black',...
    'BackgroundColor', 'white',...
    'DropShadow', 'on',...
    'ShowPortLabels', 'off',...
    'Mask','on',...
    'MaskDisplay','image(imread(''fx.png'',''BackgroundColor'',[1 1 1]))')

% Add the mux
add_block('built-in/Mux', [sys '/' ssName '/Mux'],...
    'orientation', 'right', 'position', [100, 100, 105, 150], ...
    'Inputs', num2str(numPorts), 'DisplayOption', 'bar')

% Add the function block
add_block('built-in/Fcn', [sys '/' ssName '/Function'],...
    'orientation', 'right', 'position',[210, 72, 280, 123], 'Expression', funcSpec)

% Add the switch 
add_block('built-in/Switch', [sys '/' ssName '/Switch'],...
    'Criteria', 'u2 ~= 0',...
    'position',[390, 87 ,430, 127] );

% OneConstant
add_block('built-in/Constant',[sys,'/',ssName,'/','One'],...
    'position',[210, 30, 230, 50], 'value','1');

% ZeroConstant
add_block('built-in/Constant',[sys,'/',ssName,'/','Zero'],...
    'position',[210, 150, 230, 170], 'value','0');

for i = 1:numPorts
    % Add Input Ports
    portPos = ['[10, 10 + ' num2str(i) '*50, 30, 10 + ' num2str(i) '*50 + 20]'];
    add_block('built-in/Inport',[sys,'/',ssName,'/','u(', num2str(i), ')'],...
        'Port',num2str(i), ...
        'position', str2num(portPos))
    
    add_line([sys,'/',ssName], ['u(', num2str(i),')/1'], ['Mux/', num2str(i)],'autorouting','on')
end



add_block('built-in/Outport',[sys,'/',ssName,'/','y(1)'],...
    'Port','1',...
    'position', [480,100, 500, 120])

add_line([sys,'/',ssName], 'Mux/1','Function/1','autorouting','on')
add_line([sys,'/',ssName], 'Function/1','Switch/2','autorouting','on')
add_line([sys,'/',ssName], 'One/1','Switch/1','autorouting','on')
add_line([sys,'/',ssName], 'Zero/1','Switch/3','autorouting','on')
add_line([sys,'/',ssName], 'Switch/1','y(1)/1','autorouting','on')

