function hbg_transformer(ssName, sys, pos, TFnode, junc, value, ismod)

global bg determiningBonds fixedJuncList;

% Get the adjacent juncs of the TF
juncs = bg.node(TFnode).bond;
% Juncs contains global node IDs, but need junctionindex for fixedJuncList
juncNum1 = bg.node(juncs(1)).index;
juncNum2 = bg.node(juncs(2)).index;

globaljuncNum = bg.juncMap(junc);

if fixedJuncList(juncNum1) == 1 || fixedJuncList(juncNum2) == 1
    hbg_transformer_fixed(ssName, sys, pos, TFnode, junc, value, ismod);
    return
end

% TF-element shell
add_block('built-in/SubSystem',[sys,'/',ssName]);
set_param([sys,'/',ssName], 'orientation','right','position',pos, ...
    'Mask', 'on', ...
    'ForegroundColor', 'darkgreen',...
    'BackgroundColor', 'white', ...
    'DropShadow', 'on');

% Input Port 1
add_block('built-in/Inport',[sys,'/',ssName,'/','I1'],...
    'Port','1', 'position',[30,30,50,45]);

% Input Port 2
add_block('built-in/Inport',[sys,'/',ssName,'/','I2'],...
    'Port','2', 'position',[30,60,50,75]);

% TF value and param setting based on modulation
if ismod
	set_param([sys,'/',ssName], ...
		'MaskDisplay','image(imread(''MTF.png'',''BackgroundColor'',[1 1 1]))');

	add_block('built-in/Inport',[sys,'/',ssName,'/','TF Value'],...
		'Port','3', 'position', [30,110,55,135]);
else
	set_param([sys,'/',ssName], ...
		'MaskDisplay','image(imread(''TF.png'',''BackgroundColor'',[1 1 1]))',...
		'MaskPromptString', 'Value of TF:', ...
		'MaskVariables', 'TF=@1',...
		'MaskStyleString', 'edit', ...
		'MaskValueString', num2str(value));
	
	add_block('built-in/Constant',[sys,'/',ssName,'/','TF Value'],...
		'position',[30, 110, 50, 130], 'value', 'TF');
end


% Neighboring junc not fixed, so use data store
add_block('built-in/DataStoreRead',[sys,'/',ssName,'/','JuncDB'],...
    'position',[10, 200, 70, 220],'DataStoreName',['junc',num2str(junc),'db']);

% Add bond number
juncbonds = bg.node(globaljuncNum).bond;
bondOnTF = 0; % this will be the bond-index of that particular bond, on which the junction identified by 'junc' is adjacent to this transformer
for i=1:length(juncbonds)
    if juncbonds(i) == TFnode
        bondOnTF = i;
    end
end
add_block('built-in/Constant',[sys,'/',ssName,'/','Bond'],...
    'position',[30, 250, 50, 270], 'value',num2str(bondOnTF));

% Add neighboring junction type
if strcmp(bg.node(globaljuncNum).type, 'OneJunction')
	juncType = 1;
else
	juncType = 0;
end
add_block('built-in/Constant',[sys,'/',ssName,'/','Junction Type'],...
    'position',[30, 300, 50, 320], 'value',num2str(juncType));


% Add the three multiplexers
add_block('built-in/Mux', [sys '/' ssName '/Mux1'],...
    'orientation', 'right', 'position', [405, 25, 410, 75], ...
    'Inputs', '3', 'DisplayOption', 'bar');

add_block('built-in/Mux', [sys '/' ssName '/Mux2'],...
    'orientation', 'right', 'position', [405, 85, 410, 135], ...
    'Inputs', '3', 'DisplayOption', 'bar');
	
add_block('built-in/Mux', [sys '/' ssName '/Mux3'],...
    'orientation', 'right', 'position', [205, 210, 210, 260], ...
    'Inputs', '3', 'DisplayOption', 'bar');

	
% Add multiport switch
add_block('built-in/MultiPortSwitch',[sys '/' ssName '/Switch'],...
    'DataPortOrder','Zero-based contiguous',...
    'Inputs','2',...
	'position',[350, 250, 370, 320]);
	
% Add two contants
add_block('built-in/Constant',[sys,'/',ssName,'/','One'],...
    'position',[255, 270, 275, 290], 'value','1');

add_block('built-in/Constant',[sys,'/',ssName,'/','MinusOne'],...
    'position',[255, 330, 275, 350], 'value','-1');

% Add functions to calc output
add_block('built-in/Fcn',[sys '/' ssName '/CalcOutput1'],...
    'Expr','(u(2)*(u(1)^u(3)))',...
    'position',[450, 35, 510, 65]);

add_block('built-in/Fcn',[sys '/' ssName '/CalcOutput2'],...
    'Expr','(u(2)*(u(1)^u(3)))',...
    'position',[450, 95, 510, 125]);

% Function to calc causality
add_block('built-in/Fcn',[sys '/' ssName '/CalcCausality'],...
    'Expr','(u(1)==u(2) && u(3)==1) || (u(1)!=u(2) && u(3)==0)',...
    'position',[250, 220, 310, 250]);
	
% Output Port 1
add_block('built-in/Outport',[sys,'/',ssName,'/','O1'], ...
    'Port','1','position',[555, 042, 575, 058])

% Output Port 2
add_block('built-in/Outport',[sys,'/',ssName,'/','O2'], ...
    'Port','2','position',[555, 102, 575, 118])

	
	
% Connections
add_line([sys,'/',ssName], 'I1/1','Mux1/2','autorouting','on');
add_line([sys,'/',ssName], 'I2/1','Mux2/2','autorouting','on');
add_line([sys,'/',ssName], 'TF Value/1','Mux1/1','autorouting','on');
add_line([sys,'/',ssName], 'TF Value/1','Mux2/1','autorouting','on');
add_line([sys,'/',ssName], 'Switch/1','Mux1/3','autorouting','on');
add_line([sys,'/',ssName], 'Switch/1','Mux2/3','autorouting','on');

add_line([sys,'/',ssName], 'JuncDB/1','Mux3/1','autorouting','on');
add_line([sys,'/',ssName], 'Bond/1','Mux3/2','autorouting','on');
add_line([sys,'/',ssName], 'Junction Type/1','Mux3/3','autorouting','on');

add_line([sys,'/',ssName], 'Mux1/1','CalcOutput2/1','autorouting','on');
add_line([sys,'/',ssName], 'Mux2/1','CalcOutput1/1','autorouting','on');
add_line([sys,'/',ssName], 'Mux3/1','CalcCausality/1','autorouting','on');

add_line([sys,'/',ssName], 'CalcCausality/1','Switch/1','autorouting','on');
add_line([sys,'/',ssName], 'One/1','Switch/2','autorouting','on');
add_line([sys,'/',ssName], 'MinusOne/1','Switch/3','autorouting','on');

add_line([sys,'/',ssName], 'CalcOutput1/1','O1/1','autorouting','on');
add_line([sys,'/',ssName], 'CalcOutput2/1','O2/1','autorouting','on');