function hbg_transformerFixed(ssName, sys, pos, TFnode, junc, value, ismod)

global bg determiningBonds fixedJuncList;

% TF-Element-Shell
add_block('built-in/SubSystem',[sys,'/',ssName]);
set_param([sys,'/',ssName],'orientation','right','position',pos, ...
    'Mask', 'on', ...
    'ForegroundColor', 'darkgreen',...
    'BackgroundColor', 'white', ...
    'DropShadow', 'on');
	
% Input Port 1
add_block('built-in/Inport',[sys,'/',ssName,'/','I1'],...
    'Port','1', 'position',[30,30,50,45]);

% Input Port 2
add_block('built-in/Inport',[sys,'/',ssName,'/','I2'],...
    'Port','2', 'position',[30,60,50,75]);

% TF value and param setting based on modulation
if(ismod)
	set_param([sys,'/',ssName], ...
		'MaskDisplay','image(imread(''MTF.png'',''BackgroundColor'',[1 1 1]))');

	add_block('built-in/Inport',[sys,'/',ssName,'/','TF Value'],...
		'Port','3', 'position', [30,110,55,135]);		
else
	set_param([sys,'/',ssName], ...
		'MaskDisplay','image(imread(''TF.png'',''BackgroundColor'',[1 1 1]))',...
		'MaskPromptString', 'Value of TF:', ...
		'MaskVariables', 'TF=@1',...
		'MaskStyleString', 'edit',...
		'MaskValueString', num2str(value));
	
	add_block('built-in/Constant',[sys,'/',ssName,'/','TF Value'],...
    'position',[30, 110, 50, 130], 'value', 'TF');
end


% Output Port 1
add_block('built-in/Outport',[sys,'/',ssName,'/','O1'], ...
    'Port','1','position',[335 117 355 133])

% Output Port 2
add_block('built-in/Outport',[sys,'/',ssName,'/','O2'], ...
    'Port','2','position',[335 157 355 173])


% Get the adjacent juncs of the TF
juncs = bg.node(TFnode).bond;
globaljuncNum = bg.juncMap(junc);

juncbonds = bg.node(globaljuncNum).bond;
bondOnTF = 0; % this will be the bond-index of that particular bond, on which the junction identified by 'junc' is adjacent to this transformer
for i=1:length(juncbonds)
    if juncbonds(i) == TFnode
        bondOnTF = i;
    end
end

% Determine causality to build correct implementation
if bg.node(globaljuncNum).hybrid == 0
    if ((strcmp(bg.node(globaljuncNum).type, 'ZeroJunction') && determiningBonds(junc) == bondOnTF)) ...
            || ((strcmp(bg.node(globaljuncNum).type, 'OneJunction') && determiningBonds(junc) ~= bondOnTF))
        % |--- TF |---
        add_block('built-in/Product',[sys '/' ssName '/Gain1'],'position',[255 115 275 135]);
        add_block('built-in/Product',[sys '/' ssName '/Gain2'],'position',[255 155 275 175]);
    else
        % ---| TF ---|
        add_block('built-in/Product',[sys '/' ssName '/Gain1'],'Inputs','*/','position',[255 115 275 135]);
        add_block('built-in/Product',[sys '/' ssName '/Gain2'],'Inputs','*/','position',[255 155 275 175]);
    end
else
    if ((strcmp(bg.node(globaljuncNum).type, 'ZeroJunction') && bg.hybridJuncFixedDBList(junc) == bondOnTF)) ...
            || ((strcmp(bg.node(globaljuncNum).type, 'OneJunction') && bg.hybridJuncFixedDBList(junc) ~= bondOnTF))
        % |--- TF |---
        add_block('built-in/Product',[sys '/' ssName '/Gain1'],'position',[255 115 275 135]);
        add_block('built-in/Product',[sys '/' ssName '/Gain2'],'position',[255 155 275 175]);
    else
        % ---| TF ---| 
        add_block('built-in/Product',[sys '/' ssName '/Gain1'],'Inputs','*/','position',[255 115 275 135]);
        add_block('built-in/Product',[sys '/' ssName '/Gain2'],'Inputs','*/','position',[255 155 275 175]);
    end
end

% Connections
add_line([sys,'/',ssName], 'I1/1','Gain1/1','autorouting','on');
add_line([sys,'/',ssName], 'I2/1','Gain2/1','autorouting','on');
add_line([sys,'/',ssName], 'TF Value/1','Gain1/2','autorouting','on');
add_line([sys,'/',ssName], 'TF Value/1','Gain2/2','autorouting','on');
add_line([sys,'/',ssName], 'Gain1/1','O2/1','autorouting','on');
add_line([sys,'/',ssName], 'Gain2/1','O1/1','autorouting','on');