function causalityUpdate(detBondList, determineFixedJunc)
global bg juncStatus determiningBonds;
global visited;
global fixedJuncList;
global HBGSimulinkDebug;
global hybridJuncFixedDBList;

if nargin<2
    determineFixedJunc=0;
end


bg.fixedJuncList = [];
bg.hybridJuncFixedDBList = [];
bg.determiningBonds = [];

%bg.juncMap(index) gives the unique node id of the junction
for i = 1:bg.numNodes
    if isequal(getType(i), 'OneJunction') || isequal(getType(i), 'ZeroJunction')
        bg.juncMap(bg.node(i).index)=i;
    end
end

%bg.junc(index).ele(uniqueID) = gives the bond number that connects element
%uniqueID to the junction with bg.node(junction).index = index
for i = 1:bg.numNodes
    if isequal(getType(i), 'OneJunction') || isequal(getType(i), 'ZeroJunction')
        for j = 1:bg.node(i).numBonds
            bg.junc(bg.node(i).index).ele(bg.node(i).bond(j)) = j;
        end
    end
end

visited = [];
queue = [];
unforcedQueue = [];
%result = [];
% Initialize unassigned junctions'queue
for i = 1:length(determiningBonds)
    if detBondList(i) == -2
        bg.node(bg.juncMap(i)).state = 1;
        determiningBonds(i) = -1;
        queue = listPush(queue, bg.juncMap(i));
    elseif detBondList(i) == -3
        bg.node(bg.juncMap(i)).state = 0;
        determiningBonds(i) = -1;
        queue = listPush(queue, bg.juncMap(i));
    else
        determiningBonds(i) = -1;
        queue = listPush(queue, bg.juncMap(i));
    end
end


%display(queue);
% While unassigned junctions' queue is not empty
while ~isempty(queue)
    % Pop a junction off the list
    [junc queue] = listPop(queue);
    [isForced status assignedDB] = isDBForced(junc);
    % If determining bond is forced on this junction
    if  length(assignedDB) == 1 && status ~= -1
        % Update its determining bond
        setDB(junc, assignedDB, status);
        visited = listPush(visited, junc);
        % result += junctionUpdate(j)
        %display(determiningBonds);
        result = propEffect(junc);
        % push this junction in the queue
        for i = 1:length(result)
            unforcedQueue = listPush(unforcedQueue, result(i));
        end
    elseif length(assignedDB) > 1 && status ~=-1
        unforcedQueue = listPush(unforcedQueue, junc);
    elseif status == -1
        juncStatus(bg.node(junc).index) = -1;
        fprintf('Cannot assign determining bond to junction %d!\n',junc);
        disp('Model is Wrong!, forcedQueue')
        break;
    end
end
% juncStatus
% unforcedQueue
% visited
% While unassigned junctions' queue is not empty
while ~isempty(unforcedQueue)
    % Pop a junction off the list
    [junc unforcedQueue] = listPop(unforcedQueue);

    [isForced status assignedDB] = isDBForced(junc);
    % If determining bond is forced on this junction
    if  length(assignedDB) >= 1 && status ~= -1
        % Update its determining bond
        setDB(junc, assignedDB(1), status);
        visited = listPush(visited, junc);
        % result += junctionUpdate(j)
        result = propEffect(junc);
        % push this junction in the queue
        for i = 1:length(result)
            unforcedQueue = listPush(unforcedQueue, result(i));
        end
    elseif status == -1
        juncStatus(bg.node(junc).index) = -1;
        fprintf('Cannot assign determining bond to junction %d!\n',junc);
        disp('Model is Wrong!, UnforcedQueue')
        break;
    end
end

%fixedJuncList
if determineFixedJunc
    getFixedJuncList;
    detIfFixedDespiteSwitching;
end

bg.fixedJuncList = fixedJuncList;
bg.hybridJuncFixedDBList = hybridJuncFixedDBList;
bg.determiningBonds = determiningBonds;

if determineFixedJunc
    getBondsWhichCannotBeDB;
end
    
%fixedJuncList


%displayDB
if HBGSimulinkDebug
    display(determiningBonds);
    display(juncStatus);
    display(fixedJuncList);
    displayDB;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function getFixedJuncList()
global bg juncStatus determiningBonds;
global madeFixed;
global fixedJuncList;
global HBGSimulinkDebug;


%fixedJuncList

madeFixed = [];
%fixedForSureQueue = [];
notYetFixedForSureQueue = [];
notYetFixedForSureQueueSecondPass = [];
%result = [];
% Initialize unassigned junctions'queue
for i = 1:length(determiningBonds)
    if fixedJuncList(i)== 0
        notYetFixedForSureQueue = listPush(notYetFixedForSureQueue, bg.juncMap(i));
    elseif fixedJuncList(i) == 1 && isempty(find(madeFixed == bg.juncMap(i),1))
        madeFixed = listPush(madeFixed, bg.juncMap(i));
    end
    %     else
    %         notYetFixedForSureQueue = listPush(notYetFixedForSureQueue, bg.juncMap(i));
    %     end
end

%notYetFixedForSureQueue

%display(queue);
% While unassigned junctions' queue is not empty
while ~isempty(notYetFixedForSureQueue)
    % Pop a junction off the list
    
    [junc notYetFixedForSureQueue] = listPop(notYetFixedForSureQueue);
    isFixed = isDBFixed(junc);
    if isFixed
        if isempty(find(madeFixed == junc,1))
            madeFixed = listPush(madeFixed, junc);
            result = propFixedEffect(junc);

            % push this junction in the queue
            for i = 1:length(result)
                notYetFixedForSureQueueSecondPass = listPush(notYetFixedForSureQueueSecondPass, result(i));
            end
        end
    else
        notYetFixedForSureQueueSecondPass = listPush(notYetFixedForSureQueueSecondPass, junc);
    end
end

%notYetFixedForSureQueueSecondPass

while ~isempty(notYetFixedForSureQueueSecondPass)
    % Pop a junction off the list
    [junc notYetFixedForSureQueueSecondPass] = listPop(notYetFixedForSureQueueSecondPass);
    isFixed = isDBFixed(junc);
    if isFixed
        if isempty(find(madeFixed == junc,1))
            madeFixed = listPush(madeFixed, junc);
            result = propFixedEffect(junc);

            % push this junction in the queue
            for i = 1:length(result)
                notYetFixedForSureQueueSecondPass = listPush(notYetFixedForSureQueueSecondPass, result(i));
            end
        end
    end
end

%disp(notYetFixedForSureQueueSecondPass);
if HBGSimulinkDebug
    display(determiningBonds);
    display(juncStatus);
    display(fixedJuncList);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function newQueue = listPush(queue, ele)

if find(queue == ele)
    newQueue = queue;
else
    newQueue = [queue ele];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [head, newQueue] = listPop(queue)

head = -97;
newQueue = [];
if length(queue) > 1
    head = queue(1);
    newQueue = queue(2:end);
elseif length(queue) == 1
    head = queue(1);
    newQueue = [];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [result, status, assignedDB]= isDBForced(juncNum)
global bg; % determiningBonds juncStatus;
global visited;
global fixedJuncList;
global HBGSimulinkDebug;

% Returns if the DB on this junction is forced.
% Otherwise returns false
% Also returns status of the junction, i.e., forced/unforced/invalid
% Three cases :
% Case 1: Se/C ---> 0 and Sf/I ---> 1
% Case 2: F ---| 0 ---|F/U/I
% Case 3: F |--- 0 |---
%                |
%                |
%                -
%                F

% 1 = forced, 2 = unforced, -1 = inconsistent, -2 = unvisited
status = -99;
%assignedDB = -99;
assignedDB = [];
forcedDB = [];
unforcedDB = [];
%fixedDB = [];
notForcedDB = [];
notUnforcedDB = [];
%notFixedDB = [];
juncType = getJuncType(juncNum);
numForcedDB = 0;
numUnforcedDB = 0;
numUnforcedNotDB = 0;
numForcedNotDB = 0;
numFixedDB = 0;
numFixedNotDB = 0;


for i = 1:bg.node(juncNum).numBonds
    connEle = bg.node(juncNum).bond(i);
    % If one junction
    if juncType == 1
        if isequal(getType(connEle),'Sf') || isequal(getType(connEle),'I')
            numForcedDB = numForcedDB + 1;
            numFixedDB = numFixedDB + 1;
            forcedDB = listPush(forcedDB, connEle);
            %fixedJuncList(bg.node(juncNum).index) = 1;
        elseif isequal(getType(connEle),'Se') || isequal(getType(connEle),'C')
            numForcedNotDB = numForcedNotDB + 1;
            numFixedNotDB = numFixedNotDB + 1;
            notForcedDB = listPush(notForcedDB, connEle);
            %fixedJuncList(bg.node(juncNum).index) = 1;
        end
        if isequal(getType(connEle), 'ZeroJunction')
            if  ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 1 && getDB(connEle) ~= -1 && getDBEle(connEle) == juncNum
                numForcedDB = numForcedDB + 1;
                forcedDB = listPush(forcedDB, connEle);
            elseif ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 1 && getDB(connEle) ~= -1  && getDBEle(connEle) ~= juncNum
                numForcedNotDB = numForcedNotDB + 1;
                notForcedDB = listPush(notForcedDB, connEle);
            end
            if  ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && fixedJuncList(bg.node(connEle).index) == 1 && getDB(connEle) ~= -1 && getDBEle(connEle) == juncNum
                numFixedDB = numFixedDB + 1;
                %                 fixedDB = [fixedDB connEle];
            elseif ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && fixedJuncList(bg.node(connEle).index) == 1 && getDB(connEle) ~= -1  && getDBEle(connEle) ~= juncNum
                numFixedNotDB = numFixedNotDB + 1;
                %                 notFixedDB = [notFixedDB connEle];
            end
            if  ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 2 && getDB(connEle) ~= -1 && getDBEle(connEle) == juncNum
                numUnforcedDB = numUnforcedDB + 1;
                unforcedDB = listPush(unforcedDB, connEle);
            elseif ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 2 && getDB(connEle) ~= -1 && getDBEle(connEle) ~= juncNum
                numUnforcedNotDB = numUnforcedNotDB + 1;
                notUnforcedDB = listPush(notUnforcedDB, connEle);
            end
        end
        if isequal(getType(connEle), 'OneJunction')
            if  ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 1 && getDB(connEle) ~= -1  && getDBEle(connEle) ~= juncNum
                numForcedDB = numForcedDB + 1;
                forcedDB = listPush(forcedDB, connEle);
            elseif ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 1 && getDB(connEle) ~= -1  && getDBEle(connEle) == juncNum
                numForcedNotDB = numForcedNotDB + 1;
                notForcedDB = listPush(notForcedDB, connEle);
            end
            if  ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && fixedJuncList(bg.node(connEle).index) == 1 && getDB(connEle) ~= -1  && getDBEle(connEle) ~= juncNum
                numFixedDB = numFixedDB + 1;
                %                 fixedDB = [fixedDB connEle];
            elseif ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && fixedJuncList(bg.node(connEle).index) == 1 && getDB(connEle) ~= -1  && getDBEle(connEle) == juncNum
                numFixedNotDB = numFixedNotDB + 1;
                %                 notFixedDB = [notFixedDB connEle];
            end
            if  ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 2 && getDB(connEle) ~= -1 && getDBEle(connEle) ~= juncNum
                numUnforcedDB = numUnforcedDB + 1;
                unforcedDB = listPush(unforcedDB, connEle);
            elseif ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 2 && getDB(connEle) ~= -1 && getDBEle(connEle) == juncNum
                numUnforcedNotDB = numUnforcedNotDB + 1;
                notUnforcedDB = listPush(notUnforcedDB, connEle);
            end
        end
        if isequal(getType(connEle), 'TF')
            connConnEle = getConnConnElement(connEle, juncNum);
            if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) == connEle)
                numForcedNotDB = numForcedNotDB + 1;
                notForcedDB = listPush(notForcedDB, connEle);
            elseif (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numForcedDB = numForcedDB + 1;
                forcedDB = listPush(forcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) == connEle)
                numForcedDB = numForcedDB + 1;
                forcedDB = listPush(forcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numForcedNotDB = numForcedNotDB + 1;
                notForcedDB = listPush(notForcedDB, connEle);
            end
            if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1 && getDBEle(connConnEle) == connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notFixedDB = [notFixedDB connEle];
            elseif (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedDB = numFixedDB + 1;
                %                 fixedDB = [fixedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1 && getDBEle(connConnEle) == connEle)
                numFixedDB = numFixedDB + 1;
                %                 fixedDB = [fixedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notFixedDB = [notFixedDB connEle];
            end
            if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDBEle(connConnEle) == connEle)
                numUnforcedNotDB = numUnforcedNotDB + 1;
                notUnforcedDB = listPush(notUnforcedDB, connEle);
            elseif (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDBEle(connConnEle) ~= connEle)
                numUnforcedDB = numUnforcedDB + 1;
                unforcedDB = listPush(unforcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')  && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDBEle(connConnEle) == connEle)
                numUnforcedDB = numUnforcedDB + 1;
                unforcedDB = listPush(unforcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDBEle(connConnEle) ~= connEle)
                numUnforcedNotDB = numUnforcedNotDB + 1;
                notUnforcedDB = listPush(notUnforcedDB, connEle);
            end
        end
        if isequal(getType(connEle), 'GY')
            connConnEle = getConnConnElement(connEle, juncNum);
            if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) == connEle)
                numForcedDB = numForcedDB + 1;
                forcedDB = listPush(forcedDB, connEle);
            elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numForcedNotDB = numForcedNotDB + 1;
                notForcedDB = listPush(notForcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) == connEle)
                numForcedNotDB = numForcedNotDB + 1;
                notForcedDB = listPush(notForcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numForcedDB = numForcedDB + 1;
                forcedDB = listPush(forcedDB, connEle);
            end
            if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1 && getDBEle(connConnEle) == connEle)
                numFixedDB = numFixedDB + 1;
                %                 fixedDB = [fixedDB connEle];
            elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notFixedDB = [notFixedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1 && getDBEle(connConnEle) == connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notFixedDB = [notFixedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedDB = numFixedDB + 1;
                %                 fixedDB = [fixedDB connEle];
            end
            if (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDBEle(connConnEle) == connEle)
                numUnforcedDB = numUnforcedDB + 1;
                unforcedDB = listPush(unforcedDB, connEle);
            elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDBEle(connConnEle) ~= connEle)
                numUnforcedNotDB = numUnforcedNotDB + 1;
                notUnforcedDB = listPush(notUnforcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDBEle(connConnEle) == connEle)
                numUnforcedNotDB = numUnforcedNotDB + 1;
                notUnforcedDB = listPush(notUnforcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDBEle(connConnEle) ~= connEle)
                numUnforcedDB = numUnforcedDB + 1;
                unforcedDB = listPush(unforcedDB, connEle);
            end
        end
        % If zero junction
    elseif juncType == 0
        if isequal(getType(connEle),'Se') || isequal(getType(connEle),'C')
            numForcedDB = numForcedDB + 1;
            forcedDB = listPush(forcedDB, connEle);
            numFixedDB = numFixedDB + 1;
            %             fixedDB = [fixedDB connEle];
        elseif isequal(getType(connEle),'Sf') || isequal(getType(connEle),'I')
            numForcedNotDB = numForcedNotDB + 1;
            notForcedDB = listPush(notForcedDB, connEle);
            numFixedNotDB = numFixedNotDB + 1;
            %             notFixedDB = [notFixedDB connEle];
        end
        if isequal(getType(connEle), 'ZeroJunction')
            if  ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 1  && getDB(connEle) ~= -1 && getDBEle(connEle) == juncNum
                numForcedNotDB = numForcedNotDB + 1;
                notForcedDB = listPush(notForcedDB, connEle);
            elseif ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 1  && getDB(connEle) ~= -1 && getDBEle(connEle) ~= juncNum
                numForcedDB = numForcedDB + 1;
                forcedDB = listPush(forcedDB, connEle);
            end
        end
        if isequal(getType(connEle), 'ZeroJunction')
            if  ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && fixedJuncList(bg.node(connEle).index) == 1  && getDB(connEle) ~= -1 && getDBEle(connEle) == juncNum
                numFixedNotDB = numFixedNotDB + 1;
                %                 notFixedDB = [notFixedDB connEle];
            elseif ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && fixedJuncList(bg.node(connEle).index) == 1  && getDB(connEle) ~= -1 && getDBEle(connEle) ~= juncNum
                numFixedDB = numFixedDB + 1;
                %                 fixedDB = [fixedDB connEle];
            end
        end
        if isequal(getType(connEle), 'ZeroJunction')
            if  ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 2 && getDB(connEle) ~= -1 && getDBEle(connEle) == juncNum
                numUnforcedNotDB = numUnforcedNotDB + 1;
                notUnforcedDB = listPush(notUnforcedDB, connEle);
            elseif ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 2 && getDB(connEle) ~= -1 && getDBEle(connEle) ~= juncNum
                numUnforcedDB = numUnforcedDB + 1;
                unforcedDB = listPush(unforcedDB, connEle);
            end
        end
        if isequal(getType(connEle), 'OneJunction')
            if  ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 1  && getDB(connEle) ~= -1 && getDBEle(connEle) ~= juncNum
                numForcedNotDB = numForcedNotDB + 1;
                notForcedDB = listPush(notForcedDB, connEle);
            elseif ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 1  && getDB(connEle) ~= -1 && getDBEle(connEle) == juncNum
                numForcedDB = numForcedDB + 1;
                forcedDB = listPush(forcedDB, connEle);
            end
        end
        if isequal(getType(connEle), 'OneJunction')
            if  ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && fixedJuncList(bg.node(connEle).index) == 1  && getDB(connEle) ~= -1 && getDBEle(connEle) ~= juncNum
                numFixedNotDB = numFixedNotDB + 1;
                %                 notFixedDB = [notFixedDB connEle];
            elseif ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && fixedJuncList(bg.node(connEle).index) == 1  && getDB(connEle) ~= -1 && getDBEle(connEle) == juncNum
                numFixedDB = numFixedDB + 1;
                %                 fixedDB = [fixedDB connEle];
            end
        end
        if isequal(getType(connEle), 'OneJunction')
            if  ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 2 && getDB(connEle) ~= -1 && getDBEle(connEle) ~= juncNum
                numUnforcedNotDB = numUnforcedNotDB + 1;
                notUnforcedDB = listPush(notUnforcedDB, connEle);
            elseif ~isempty(find(visited == connEle,1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 2 && getDB(connEle) ~= -1 && getDBEle(connEle) == juncNum
                numUnforcedDB = numUnforcedDB + 1;
                unforcedDB = listPush(unforcedDB, connEle);
            end
        end
        if isequal(getType(connEle), 'TF')
            connConnEle = getConnConnElement(connEle, juncNum);
            if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) == connEle)
                numForcedDB = numForcedDB + 1;
                forcedDB = listPush(forcedDB, connEle);
            elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numForcedNotDB = numForcedNotDB + 1;
                notForcedDB = listPush(notForcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1  && getDBEle(connConnEle) == connEle)
                numForcedNotDB = numForcedNotDB + 1;
                notForcedDB = listPush(notForcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numForcedDB = numForcedDB + 1;
                forcedDB = listPush(forcedDB, connEle);
            end
            if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1 && getDBEle(connConnEle) == connEle)
                numFixedDB = numFixedDB + 1;
                %                 fixedDB = [fixedDB connEle];
            elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notFixedDB = [notFixedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1  && getDBEle(connConnEle) == connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notFixedDB = [notFixedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedDB = numFixedDB + 1;
                %                 fixedDB = [fixedDB connEle];
            end
            if (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDB(connConnEle)~= -1 ...
                    && getDBEle(connConnEle) == connEle)
                numUnforcedDB = numUnforcedDB + 1;
                unforcedDB = listPush(unforcedDB, connEle);
            elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDB(connConnEle)~= -1 ...
                    && getDBEle(connConnEle) ~= connEle)
                numUnforcedNotDB = numUnforcedNotDB + 1;
                notUnforcedDB = listPush(notUnforcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDB(connConnEle)~= -1 ...
                    && getDBEle(connConnEle) == connEle)
                numUnforcedNotDB = numUnforcedNotDB + 1;
                notUnforcedDB = listPush(notUnforcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDB(connConnEle)~= -1 ...
                    && getDBEle(connConnEle) ~= connEle)
                numUnforcedDB = numUnforcedDB + 1;
                unforcedDB = listPush(unforcedDB, connEle);
            end
        end
        if isequal(getType(connEle), 'GY')
            connConnEle = getConnConnElement(connEle, juncNum);
            if (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) == connEle)
                numForcedNotDB = numForcedNotDB + 1;
                notForcedDB = listPush(notForcedDB, connEle);
            elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numForcedDB = numForcedDB + 1;
                forcedDB = listPush(forcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) == connEle)
                numForcedDB = numForcedDB + 1;
                forcedDB = listPush(forcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numForcedNotDB = numForcedNotDB + 1;
                notForcedDB = listPush(notForcedDB, connEle);
            end
            if (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1 && getDBEle(connConnEle) == connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notFixedDB = [notFixedDB connEle];
            elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedDB = numFixedDB + 1;
                %                 fixedDB = [fixedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1 && getDBEle(connConnEle) == connEle)
                numFixedDB = numFixedDB + 1;
                %                 fixedDB = [fixedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && fixedJuncList(bg.node(connConnEle).index) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notFixedDB = [notFixedDB connEle];
            end
            if (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDBEle(connConnEle) == connEle)
                numUnforcedNotDB = numUnforcedNotDB + 1;
                notUnforcedDB = listPush(notUnforcedDB, connEle);
            elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDBEle(connConnEle) ~= connEle)
                numUnforcedDB = numUnforcedDB + 1;
                unforcedDB = listPush(unforcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDBEle(connConnEle) == connEle)
                numUnforcedDB = numUnforcedDB + 1;
                unforcedDB = listPush(unforcedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(visited == connConnEle,1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 2 && getDBEle(connConnEle) ~= connEle)
                numUnforcedNotDB = numUnforcedNotDB + 1;
                notUnforcedDB = listPush(notUnforcedDB, connEle);
            end
        end

    else
        disp('Error')
    end
end

numInactiveBonds = 0;
for i = 1:bg.node(juncNum).numBonds
    connEle = bg.node(juncNum).bond(i);
    if isequal(getType(connEle), 'OneJunction') || isequal(getType(connEle), 'ZeroJunction')
        if getJuncState(connEle) == 0
            numInactiveBonds = numInactiveBonds + 1;
        end
    end
    if isequal(getType(connEle), 'TF')||isequal(getType(connEle), 'GY')
        connConnEle = getConnConnElement(connEle, juncNum);
        if getJuncState(connConnEle) == 0
            numInactiveBonds = numInactiveBonds + 1;
        end
    end
end
numActiveBonds = bg.node(juncNum).numBonds - numInactiveBonds;

% bg.node(juncNum).numForcedDB = numForcedDB;
% bg.node(juncNum).numForcedNotDB = numForcedNotDB;
% bg.node(juncNum).numUnforcedDB = numUnforcedDB;
% bg.node(juncNum).numUnforcedNotDB = numUnforcedNotDB;
% bg.node(juncNum).forcedDB = forcedDB;
% bg.node(juncNum).notForcedDB = notForcedDB;
% bg.node(juncNum).unforcedDB = unforcedDB;
% bg.node(juncNum).notUnforcedDB = notUnforcedDB;

% 1 = forced, 2 = unforced, -1 = inconsistent, -2 = unvisited
if getJuncState(juncNum) == 0
    result = true;
    status = 1;
    assignedDB = 0;
elseif (numForcedDB + numUnforcedDB) == 1
    if numForcedDB == 1
        result = true;
        status = 1;
        assignedDB = forcedDB(1);
    elseif numUnforcedDB == 1
        result = false;
        status = 2;
        assignedDB = unforcedDB(1);
    end
elseif (numForcedNotDB + numUnforcedNotDB) == numActiveBonds - 1
    if numForcedNotDB == numActiveBonds - 1
        result = true;
        status = 1;
    else
        result = false;
        status = 2;
    end
    for i = 1:bg.node(juncNum).numBonds
        connEle = bg.node(juncNum).bond(i);
        getJuncState(connEle);
        if ~isempty(find(notForcedDB == connEle,1)) ...
                || ~isempty(find(notUnforcedDB == connEle,1))
            continue;
        else
            if (isequal(getType(connEle),'OneJunction')||isequal(getType(connEle),'ZeroJunction')) && getJuncState(connEle)==0
                continue;
            else
                assignedDB = bg.node(juncNum).bond(i);
            end
        end
    end
elseif numForcedDB + numUnforcedDB > 1 % Junction is inconsistent
    result = false;
    status = -1;
elseif numForcedNotDB + numUnforcedNotDB  == numActiveBonds
    result = false;
    status = -1;
else % find other things
    result = false;
    status = 2;
    tempAssignedDB_R = [];
    tempAssignedDB_Unforced = [];
    tempAssignedDB_Forced = [];
    for i = 1:bg.node(juncNum).numBonds
        connEle = bg.node(juncNum).bond(i);
        if isequal(getType(connEle),'R')
            tempAssignedDB_R = listPush(tempAssignedDB_R, connEle);
            %assignedDB = listPush(assignedDB, connEle);
        elseif (isequal(getType(connEle),'OneJunction')...
                || isequal(getType(connEle), 'ZeroJunction')) && getJuncState(connEle) ~= 0
            if ~isempty(find(notForcedDB == connEle, 1)) ...
                    || ~isempty(find(notUnforcedDB == connEle, 1))
%             if length(find(notForcedDB == connEle))~=0 ...
%                     || length(find(notUnforcedDB == connEle))~=0
                continue;
            else
                if getStatus(connEle) == 1
                    tempAssignedDB_Forced = listPush(tempAssignedDB_Forced, connEle);
                else
                    tempAssignedDB_Unforced = listPush(tempAssignedDB_Unforced, connEle);
                end

            end

        elseif (isequal(getType(connEle),'TF') || isequal(getType(connEle), 'GY'))
            connConnEle = getConnConnElement(connEle, juncNum);
            if getJuncState(connConnEle) == 0
                continue;
            end
            if ~isempty(find(notForcedDB == connConnEle, 1)) ...
                    || ~isempty(find(notUnforcedDB == connConnEle,1))
                continue;
            else
                if getStatus(connEle) == 1
                    tempAssignedDB_Forced = listPush(tempAssignedDB_Forced, connEle);
                else
                    tempAssignedDB_Unforced = listPush(tempAssignedDB_Unforced, connEle);
                end
            end
        end
    end
    assignedDB = [assignedDB tempAssignedDB_R];
    assignedDB = [assignedDB tempAssignedDB_Unforced];
    assignedDB = [assignedDB tempAssignedDB_Forced];
    % Choose unforced unvisited junction.. so in this else part put in the fact
    % that any junction which is forced is not included

end

if bg.node(juncNum).hybrid == 1
    fixedJuncList(bg.node(juncNum).index) = 0;
elseif numFixedDB == 1
    fixedJuncList(bg.node(juncNum).index) = 1;
%elseif (numFixedNotDB == numActiveBonds - 1) && (numActiveBonds > 1)
elseif (numFixedNotDB == bg.node(juncNum).numBonds - 1) && (numActiveBonds > 1)
    fixedJuncList(bg.node(juncNum).index) = 1;
end


if fixedJuncList(bg.node(juncNum).index)==1
    if HBGSimulinkDebug
        fprintf(1,'numFixedDB %d, numFixedNotDB %d, numActiveBonds %d Name %s\n', ...
            numFixedDB, numFixedNotDB, numActiveBonds, bg.node(juncNum).name);
        %     display('*************** fixed junction *****************');
        %     display(numFixedDB);
        %     display(numFixedNotDB);
        %     display(numActiveBonds);
        %     display(bg.node(juncNum).name);
        %     display('*************** fixed junction *****************');
    end
end
%display(fixedJuncList);
% make sure that the unvisited junctions are sent first

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function result= isDBFixed(juncNum)
global bg; % determiningBonds juncStatus;
global madeFixed; %visited;
global fixedJuncList;
global HBGSimulinkDebug;

% Returns if the Junc is fixed and if it is, sets the fixedJuncList array
% appropriately

if ~isempty(find(madeFixed == juncNum, 1))
    result = true;
    return;
end
% 1 = forced, 2 = unforced, -1 = inconsistent, -2 = unvisited
%status = -99;
%assignedDB = -99;
% assignedDB = [];
% forcedDB = [];
% unforcedDB = [];
% fixedDB = [];
% notForcedDB = [];
% notUnforcedDB = [];
% notFixedDB = [];
juncType = getJuncType(juncNum);
% numForcedDB = 0;
% numUnforcedDB = 0;
% numUnforcedNotDB = 0;
% numForcedNotDB = 0;
numFixedDB = 0;
numFixedNotDB = 0;



for i = 1:bg.node(juncNum).numBonds
    connEle = bg.node(juncNum).bond(i);
    % If one junction
    if juncType == 1
        if isequal(getType(connEle),'Sf') || isequal(getType(connEle),'I')
            %numForcedDB = numForcedDB + 1;
            numFixedDB = numFixedDB + 1;
            %forcedDB = [forcedDB connEle];
            %fixedJuncList(bg.node(juncNum).index) = 1;
        elseif isequal(getType(connEle),'Se') || isequal(getType(connEle),'C')
            %numForcedNotDB = numForcedNotDB + 1;
            numFixedNotDB = numFixedNotDB + 1;
            %notForcedDB = [notForcedDB connEle];
            %fixedJuncList(bg.node(juncNum).index) = 1;
        end
        if isequal(getType(connEle), 'ZeroJunction')
            if  ~isempty(find(madeFixed == connEle, 1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 1 && getDB(connEle) ~= -1 && getDBEle(connEle) == juncNum
                numFixedDB = numFixedDB + 1;
                %forcedDB = [forcedDB connEle];
            elseif ~isempty(find(madeFixed == connEle, 1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 1 && getDB(connEle) ~= -1  && getDBEle(connEle) ~= juncNum
                numFixedNotDB = numFixedNotDB + 1;
                %notForcedDB = [notForcedDB connEle];
            end
        end
        if isequal(getType(connEle), 'OneJunction')
            if  ~isempty(find(madeFixed == connEle, 1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 1 && getDB(connEle) ~= -1  && getDBEle(connEle) ~= juncNum
                numFixedDB = numFixedDB + 1;
                %forcedDB = [forcedDB connEle];
            elseif ~isempty(find(madeFixed == connEle, 1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 1 && getDB(connEle) ~= -1  && getDBEle(connEle) == juncNum
                numFixedNotDB = numFixedNotDB + 1;
                %notForcedDB = [notForcedDB connEle];
            end

        end
        if isequal(getType(connEle), 'TF')
            connConnEle = getConnConnElement(connEle, juncNum);
            if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) == connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notForcedDB = [notForcedDB connEle];
            elseif (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedDB = numFixedDB + 1;
                %                 forcedDB = [forcedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) == connEle)
                numFixedDB = numFixedDB + 1;
                %                 forcedDB = [forcedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notForcedDB = [notForcedDB connEle];
            end
        end
        if isequal(getType(connEle), 'GY')
            connConnEle = getConnConnElement(connEle, juncNum);
            if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) == connEle)
                numFixedDB = numFixedDB + 1;
                %                 forcedDB = [forcedDB connEle];
            elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notForcedDB = [notForcedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) == connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notForcedDB = [notForcedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedDB = numFixedDB + 1;
                %                 forcedDB = [forcedDB connEle];
            end

        end
        % If zero junction
    elseif juncType == 0
        if isequal(getType(connEle),'Se') || isequal(getType(connEle),'C')
            numFixedDB = numFixedDB + 1;
        elseif isequal(getType(connEle),'Sf') || isequal(getType(connEle),'I')

            numFixedNotDB = numFixedNotDB + 1;

        end
        if isequal(getType(connEle), 'ZeroJunction')
            if  ~isempty(find(madeFixed == connEle, 1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 1  && getDB(connEle) ~= -1 && getDBEle(connEle) == juncNum
                numFixedNotDB = numFixedNotDB + 1;
                %                 notForcedDB = [notForcedDB connEle];
            elseif ~isempty(find(madeFixed == connEle, 1)) && getJuncState(connEle) == 1 && getStatus(connEle) == 1  && getDB(connEle) ~= -1 && getDBEle(connEle) ~= juncNum
                numFixedDB = numFixedDB + 1;
                %                 forcedDB = [forcedDB connEle];
            end
        end

        if isequal(getType(connEle), 'OneJunction')
            if  ~isempty(find(madeFixed == connEle, 1)) && getJuncState(connEle) == 1 && fixedJuncList(bg.node(connEle).index) == 1  && getDB(connEle) ~= -1 && getDBEle(connEle) ~= juncNum
                numFixedNotDB = numFixedNotDB + 1;
                %                 notFixedDB = [notFixedDB connEle];
            elseif ~isempty(find(madeFixed == connEle, 1)) && getJuncState(connEle) == 1 && fixedJuncList(bg.node(connEle).index) == 1  && getDB(connEle) ~= -1 && getDBEle(connEle) == juncNum
                numFixedDB = numFixedDB + 1;
                %                 fixedDB = [fixedDB connEle];
            end
        end

        if isequal(getType(connEle), 'TF')
            connConnEle = getConnConnElement(connEle, juncNum);
            if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) == connEle)
                numFixedDB = numFixedDB + 1;
                %                 forcedDB = [forcedDB connEle];
            elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notForcedDB = [notForcedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1  && getDBEle(connConnEle) == connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notForcedDB = [notForcedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedDB = numFixedDB + 1;
                %                 forcedDB = [forcedDB connEle];
            end

        end
        if isequal(getType(connEle), 'GY')
            connConnEle = getConnConnElement(connEle, juncNum);
            if (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) == connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notForcedDB = [notForcedDB connEle];
            elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedDB = numFixedDB + 1;
                %                 forcedDB = [forcedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) == connEle)
                numFixedDB = numFixedDB + 1;
                %                 forcedDB = [forcedDB connEle];
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(madeFixed == connConnEle, 1)) && getJuncState(connConnEle)==1 && getDB(connConnEle) ~=-1 && getStatus(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                numFixedNotDB = numFixedNotDB + 1;
                %                 notForcedDB = [notForcedDB connEle];
            end

        end

    else
        disp('Error')
    end
end

numInactiveBonds = 0;
% for i = 1:bg.node(juncNum).numBonds
%     connEle = bg.node(juncNum).bond(i);
%     if isequal(getType(connEle), 'OneJunction') || isequal(getType(connEle), 'ZeroJunction')
%         if getJuncState(connEle) == 0
%             numInactiveBonds = numInactiveBonds + 1;
%         end
%     end
%     if isequal(getType(connEle), 'TF')||isequal(getType(connEle), 'GY')
%         connConnEle = getConnConnElement(connEle, juncNum);
%         if getJuncState(connConnEle) == 0
%             numInactiveBonds = numInactiveBonds + 1;
%         end
%     end
% end
numActiveBonds = bg.node(juncNum).numBonds - numInactiveBonds;



% 1 = forced, 2 = unforced, -1 = inconsistent, -2 = unvisited
result = false;
if getJuncState(juncNum) == 0 || bg.node(juncNum).hybrid == 1
    result = false;
else
    if (numFixedDB) == 1
        result = true;
        fixedJuncList(bg.node(juncNum).index) = 1;
        madeFixed = listPush(madeFixed, juncNum);
    elseif numFixedNotDB  == bg.node(juncNum).numBonds - 1
        result = true;
        fixedJuncList(bg.node(juncNum).index) = 1;
        madeFixed = listPush(madeFixed, juncNum);

    end
end

% if bg.node(juncNum).hybrid == 1
%     result =false;
%     fixedJuncList(bg.node(juncNum).index) = 0;
% end


if fixedJuncList(bg.node(juncNum).index)==1
    if HBGSimulinkDebug
        fprintf(1,'numFixedDB %d, numFixedNotDB %d, numActiveBonds %d Name %s\n', ...
            numFixedDB, numFixedNotDB, numActiveBonds, bg.node(juncNum).name);
        %     display('*************** fixed junction *****************');
        %     display(numFixedDB);
        %     display(numFixedNotDB);
        %     display(numActiveBonds);
        %     display(bg.node(juncNum).name);
        %     display('*************** fixed junction *****************');
    end
end
%display(fixedJuncList);
% make sure that the unvisited junctions are sent first

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function [result, adjJunc] = JuncOffAffectsEle(juncNum, BGEle)
% Returns true if the junc turning off affects the element
% Else returns false
% global bg juncStatus determiningBonds;

result = false;
adjJunc = -98;
% Is this element BGEle an on junction and juncNum is determiningBonds of BGEle, return true
% else return false
if ((isequal(getType(BGEle), 'OneJunction')...
        || isequal(getType(BGEle), 'ZeroJunction'))...
        && getJuncState(BGEle) == 1)
    if getDBEle(BGEle) == juncNum || getDB(BGEle) == -1
        result = true;
        adjJunc = BGEle;
    end
end

% Is this element BGEle a TF/GY and juncNum is determiningBonds of the other junction
% connected to BGEle, return true; else return false
if (isequal(getType(BGEle), 'TF')|| isequal(getType(BGEle), 'GY'))
    connConnElement = getConnConnElement(BGEle, juncNum);
    if (getJuncState(connConnElement) == 1 && getDBEle(connConnElement) == BGEle)
        result = true;
        adjJunc = connConnElement;
    elseif (getJuncState(connConnElement) == 1 && getDB(connConnElement) == -1)
        result = true;
        adjJunc = connConnElement;
    end
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [result, adjJunc] = JuncOnAffectsEle(juncNum, connEle)
% Returns true if the junc turning on and having assigned a determiningBonds affects
% the element else returns false
%global bg juncStatus determiningBonds;
global visited;

result = false;
adjJunc = -98;


if find(visited == connEle)
    return;
end
%In case this new determining bond for this junction causes the
%determining bonds of the other junctions to change, call junction
%update on those junctions with this current junction as the
%determining bond imposing component
if getDB(juncNum)~= -1 && getDBEle(juncNum) == connEle
    if isequal(getType(juncNum),'OneJunction')
        if (isequal(getType(connEle),'OneJunction') && getJuncState(connEle) == 1 && getDBEle(connEle)==juncNum)
            result = true;
            adjJunc = connEle;
		% [MD 2011-01-06] added case below for situation where db of
		% connEle has not yet been assigned
		elseif (isequal(getType(connEle),'OneJunction') && getJuncState(connEle) == 1 && getDBEle(connEle)==-99)
            result = true;
            adjJunc = connEle;
        elseif (isequal(getType(connEle),'ZeroJunction') && getJuncState(connEle) == 1 && getDBEle(connEle)~=juncNum)
            result = true;
            adjJunc = connEle;
        elseif isequal(getType(connEle), 'TF')
            connConnEle = getConnConnElement(connEle, juncNum);
            %            if (isequal(getType(connConnEle), 'OneJunction')&& getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==juncNum)
            if (isequal(getType(connConnEle), 'OneJunction')&& getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==connEle)
                result = true;
                adjJunc = connConnEle;
                %            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle) ~=juncNum)
            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle) ~=connEle)
                result = true;
                adjJunc = connConnEle;
            % [ZL 2011-02-11] added case below for situation where db of
            % connConnEle has not yet been assigned       
            elseif (isequal(getType(connConnEle),'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==-99)
                result = true;
                adjJunc = connConnEle;                
            end
        elseif isequal(getType(connEle), 'GY')
            connConnEle = getConnConnElement(connEle, juncNum);
            %            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle) ~= juncNum)
            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle) ~= connEle)
                result = true;
                adjJunc = connEle;
                %            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle) == juncNum)
            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle) == connEle)
                result = true;
                adjJunc = connConnEle;
            % [ZL 2011-02-11] added case below for situation where db of
            % connConnEle has not yet been assigned       
            elseif (isequal(getType(connConnEle),'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==-99)
                result = true;
                adjJunc = connConnEle;                               
            end
        end
    elseif isequal(getType(juncNum), 'ZeroJunction')
        if (isequal(getType(connEle), 'OneJunction') && getJuncState(connEle) == 1 && getDBEle(connEle)~=juncNum)
            result = true;
            adjJunc = connEle;
        elseif (isequal(getType(connEle), 'ZeroJunction') && getJuncState(connEle) == 1 && getDBEle(connEle)==juncNum)
            result = true;
            adjJunc = connEle;
		% [MD 2011-01-06] added case below for situation where db of
		% connEle has not yet been assigned
		elseif (isequal(getType(connEle), 'ZeroJunction') && getJuncState(connEle) == 1 && getDBEle(connEle)==-99)
            result = true;
            adjJunc = connEle;
        elseif isequal(getType(connEle), 'TF')
            connConnEle = getConnConnElement(connEle, juncNum);
            %            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)~=juncNum)
            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)~=connEle)
                result = true;
                adjJunc = connConnEle;
                %            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==juncNum)
            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==connEle)
                result = true;
                adjJunc = connConnEle;
            % [ZL 2011-02-11] added case below for situation where db of
            % connConnEle has not yet been assigned                
            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==-99)
                result = true;
                adjJunc = connConnEle;
            end            
        elseif isequal(getType(connEle), 'GY')
            connConnEle = getConnConnElement(connEle, juncNum);
            %            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==juncNum)
            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==connEle)
                result = true;
                adjJunc = connEle;
                %            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)~=juncNum)
            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)~=connEle)
                result = true;
                adjJunc = connConnEle;
            % [ZL 2011-02-11] added case below for situation where db of
            % connConnEle has not yet been assigned       
            elseif (isequal(getType(connConnEle),'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==-99)
                result = true;
                adjJunc = connConnEle;                       
            end
        end
    end
elseif getDB(juncNum) == -1
    display('Something Wrong in JuncOnAffectsEle');
elseif getDB(juncNum)~= -1 && getDBEle(juncNum) ~= connEle
    if isequal(getType(juncNum), 'OneJunction')
        if (isequal(getType(connEle), 'OneJunction') && getJuncState(connEle) == 1 && getDBEle(connEle)~=juncNum)
            result = true;
            adjJunc = connEle;
        elseif (isequal(getType(connEle), 'ZeroJunction') && getJuncState(connEle) == 1 && getDBEle(connEle)==juncNum)
            result = true;
            adjJunc = connEle;
        elseif isequal(getType(connEle), 'TF')
            connConnEle = getConnConnElement(connEle, juncNum);
            %            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1  && getDBEle(connConnEle)~=juncNum)
            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1  && getDBEle(connConnEle)~=connEle)
                result = true;
                adjJunc = connConnEle;
                %            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==juncNum)
            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==connEle)
                result = true;
                adjJunc = connConnEle;
            end
        elseif isequal(getType(connEle), 'GY')
            connConnEle = getConnConnElement(connEle, juncNum);
            %            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==juncNum)
            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==connEle)
                result = true;
                adjJunc = connEle;
                %            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)~=juncNum)
            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)~=connEle)
                result = true;
                adjJunc = connConnEle;
            end
        end
    elseif isequal(getType(juncNum), 'ZeroJunction')
        if (isequal(getType(connEle), 'OneJunction') && getJuncState(connEle) == 1 && getDBEle(connEle)==juncNum)
            result = true;
            adjJunc = connEle;
        elseif (isequal(getType(connEle), 'ZeroJunction') && getJuncState(connEle) == 1 && getDBEle(connEle)~=juncNum)
            result = true;
            adjJunc = connEle;
        elseif isequal(getType(connEle), 'TF')
            connConnEle = getConnConnElement(connEle, juncNum);
            %            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==juncNum)
            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==connEle)
                result = true;
                adjJunc = connConnEle;
                %            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)~=juncNum)
            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)~=connEle)
                result = true;
                adjJunc = connConnEle;
            end
        elseif isequal(getType(connEle), 'GY')
            connConnEle = getConnConnElement(connEle, juncNum);
            %            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)~=juncNum)
            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)~=connEle)
                result = true;
                adjJunc = connEle;
                %            elseif (isequal(getType(connConnEle), 'ZeroJunction')&& getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==juncNum)
            elseif (isequal(getType(connConnEle), 'ZeroJunction')&& getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==connEle)
                result = true;
                adjJunc = connConnEle;
            end
        end
    end

    if (isequal(getType(connEle), 'OneJunction')|| isequal(getType(connEle), 'ZeroJunction'))&& getDB(connEle) == -1
        result = true;
        adjJunc = connEle;
    elseif (isequal(getType(connEle), 'TF')|| isequal(getType(connEle), 'GY'))
        connConnEle = getConnConnElement(connEle, juncNum);
        if getDB(connConnEle) == -1
            result = true;
            adjJunc = connConnEle;
        end
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function status = getStatus(juncNum)
% Get the status of the junction juncNum
global bg juncStatus;
%global determiningBonds;

%juncStatus
status = juncStatus(bg.node(juncNum).index);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function jType = getJuncType(juncNum)
%global bg juncStatus determiningBonds;

jType = isequal(getType(juncNum), 'OneJunction');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function state = getJuncState(juncNum)
%global juncStatus determiningBonds;
global bg;

%if bg.node(juncNum).state == []
%    state = -99;
%else
state =  bg.node(juncNum).state;
%end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function detEle = getDBEle(juncNum)
global bg determiningBonds;

% Gets the determining bond Element of a junction
if determiningBonds(bg.node(juncNum).index) == -1
    detEle = -99;
elseif determiningBonds(bg.node(juncNum).index) == 0
    detEle = 0;
else
    detEle = bg.node(juncNum).bond(determiningBonds(bg.node(juncNum).index));
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function detBond = getDB(juncNum)
global bg determiningBonds;
% global juncStatus;

% Gets the determining bond of a junction
detBond = determiningBonds(bg.node(juncNum).index);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function connConnElement = getConnConnElement (TForGY, juncNum)
global bg;
%global juncStatus determiningBonds;



if bg.node(TForGY).bond(1) == juncNum
    connConnElement = bg.node(TForGY).bond(2);
elseif bg.node(TForGY).bond(2) == juncNum
    connConnElement = bg.node(TForGY).bond(1);
else
    connConnElement = -99;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function affJuncQueue = getAffectedJunc(juncNum, onOff)
global bg;
% global determiningBonds juncStatus;
% global visited;

affJuncQueue = [];
if onOff == 1
    for i = 1:bg.node(juncNum).numBonds
        connEle = bg.node(juncNum).bond(i);

        [result adjJunc] = JuncOnAffectsEle(juncNum, connEle);
        if result == true
            affJuncQueue = listPush(affJuncQueue, adjJunc);
        end
    end
else
    for i = 1:bg.node(juncNum).numBonds
        connEle = bg.node(juncNum).bond(i);

        [result adjJunc] = JuncOffAffectsEle(juncNum, connEle);
        if result == true
            affJuncQueue = listPush(affJuncQueue, adjJunc);
        end
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function result = propEffect(juncNum)
global bg determiningBonds juncStatus;
global visited;

% Initialize the queue of unassigned junctions
result = [];
%success = true;

% decide if the junction switched off or on based on the state
onOff = getJuncState(juncNum);

% identify junctions affected by the junction switching
affJuncList = getAffectedJunc(juncNum, onOff);

for i = 1:length(affJuncList)
    determiningBonds(bg.node(affJuncList(i)).index) = -1;
    %[isForced status assignedDB] = isDBForced(affJuncList(i));
    %juncStatus(bg.node(affJuncList(i)).index) = status;
end
% Update the status here. But you have to figure how to do it!!

for i = 1:length(affJuncList)
    affJunc = affJuncList(i);
    [isForced status assignedDB] = isDBForced(affJunc);
    % If determining bond is forced on this junction
    if  length(assignedDB) == 1 && status ~=-1
        % Update its determining bond
        setDB(affJunc, assignedDB(1), status);
        visited = listPush(visited, affJunc);
        % result += junctionUpdate(j)
        newRes = propEffect(affJunc);
        for j = 1:length(newRes)
            result = listPush(result, newRes(j));
        end
        % Elseif exists unforced adjacent element as determining bond
    elseif  length(assignedDB) > 1  && status ~=1
        result = listPush(result, affJunc);
    elseif status == -1
        juncStatus(bg.node(affJunc).index) = -1;
        fprintf('Cannot assign determining bond to junction %d!\n',affJunc);
        fprintf('Called propEffect on %d\n',juncNum);
        display(affJuncList);
        disp('Model is Wrong!, propEffect');
        return;
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function result = propFixedEffect(juncNum)
% global bg determiningBonds juncStatus;
% global visited madeFixed;
global madeFixed;

% Initialize the queue of unassigned junctions
result = [];
%success = true;

% decide if the junction switched off or on based on the state
onOff = getJuncState(juncNum);

% identify junctions affected by the junction switching
affJuncList = getAffectedJunc(juncNum, onOff);


for i = 1:length(affJuncList)
    affJunc = affJuncList(i);
    isFixed = isDBFixed(affJunc);
    % If determining bond is forced on this junction
    if  isFixed 
        madeFixed = listPush(madeFixed, affJunc);
        newRes = propFixedEffect(affJunc);
        for j = 1:length(newRes)
            result = listPush(result, newRes(j));
        end
        % Elseif exists unforced adjacent element as determining bond
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function type = getType(BGEle)
global bg;
% global determiningBonds juncStatus;

if strcmp(bg.node(BGEle).type, 'ZeroJunction');
    type = 'ZeroJunction';
elseif strcmp(bg.node(BGEle).type, 'OneJunction');
    type = 'OneJunction';
elseif strcmp(bg.node(BGEle).type, 'TF') || strcmp(bg.node(BGEle).type, 'MTF');
    type = 'TF';
elseif strcmp(bg.node(BGEle).type, 'GY') || strcmp(bg.node(BGEle).type, 'MGY');
    type = 'GY';
elseif strcmp(bg.node(BGEle).type, 'R') || strcmp(bg.node(BGEle).type, 'MR');
    type = 'R';
elseif strcmp(bg.node(BGEle).type, 'C') || strcmp(bg.node(BGEle).type, 'MC');
    type = 'C';
elseif strcmp(bg.node(BGEle).type, 'I') || strcmp(bg.node(BGEle).type, 'MI');
    type = 'I';
elseif strcmp(bg.node(BGEle).type, 'Se') || strcmp(bg.node(BGEle).type, 'MSe');
    type = 'Se';
elseif strcmp(bg.node(BGEle).type, 'Sf') || strcmp(bg.node(BGEle).type, 'MSf');
    type = 'Sf';
else
	disp('ERROR: type not found');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%function success = setDB(juncNum, detElmnt, status)
function setDB(juncNum, detElmnt, status)
global bg determiningBonds juncStatus;
%% [ZL 2011-07-04] Sometimes the juncNum is not a junction type element
% Why? needs some more debugging.
if (~strcmp(getType(juncNum), 'OneJunction') && ~strcmp(getType(juncNum), 'ZeroJunction'))
  return;
end
% [ZL end]
%% Sets the determiningBonds of juncNum to the bond it is connected to detElmnt by
if detElmnt ~= 0
    determiningBonds(bg.node(juncNum).index) = bg.junc(bg.node(juncNum).index).ele(detElmnt);
else
    determiningBonds(bg.node(juncNum).index) = 0;
end
juncStatus(bg.node(juncNum).index) = status;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function displayDB()
global determiningBonds bg HBGSimulinkDebug;

if HBGSimulinkDebug
    %newArray = [];
    fprintf('JunctionName ---> DeterminingBond\n')
    for i = 1:length(determiningBonds)
        if determiningBonds(i) > 0
            fprintf('%s ---> %s\n', bg.node(bg.juncMap(i)).name, bg.node(bg.node(bg.juncMap(i)).bond(determiningBonds(i))).name);
        elseif determiningBonds(i) == 0
            fprintf('%s ---> %s\n', bg.node(bg.juncMap(i)).name, '0');
        else
            fprintf('%s ---> Could not assign Det Bond\n', bg.node(bg.juncMap(i)).name);
        end
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function detIfFixedDespiteSwitching()

global bg juncStatus determiningBonds;
global madeFixed canBeReachedFromHybrid;
global fixedJuncList;
global HBGSimulinkDebug;
global hybridJuncFixedDBList;


%madeFixed = [];
hybridJuncList = [];
%hybridFixed = [];
unfixedQueueSecondPass = [];
hybridJuncFixedDBList = -1*ones(1, length(determiningBonds));

% display(hybridJuncFixedDBList);
% Create a queue of hybrid junctions
for i = 1:bg.numJunctions
    if bg.node(bg.juncMap(i)).hybrid == 1
        hybridJuncList = listPush(hybridJuncList, bg.juncMap(i));
    end
end


openQueue = [];
canBeReachedFromHybrid=[];

for i = 1:length(hybridJuncList)
    openQueue = listPush(openQueue, hybridJuncList(i));    
end

while ~isempty(openQueue)
    [activeElement openQueue]= listPop(openQueue);
    % Look at all the neighbors
    canBeReachedFromHybrid = listPush(canBeReachedFromHybrid, activeElement);
    for j = 1:bg.node(activeElement).numBonds
        if isempty(find(canBeReachedFromHybrid == bg.node(activeElement).bond(j),1))
            openQueue = listPush(openQueue, bg.node(activeElement).bond(j));
        end
    end
end

% display(canBeReachedFromHybrid);

% display(hybridJuncList);
% Propagate from hybrid junctions. If some unfixed junction cannot be
% reached from a hybrid junction, it needs to be fixed or the model is
% wrong!

% Also, a "fixed hybrid" junction is defined as a junction whose turning on
% or off does not affect the db of other junctions (except those hybrid
% junctions which turn on or off with this junction).

while ~isempty(hybridJuncList)
    % Pop a junction off the list
    [junc hybridJuncList] = listPop(hybridJuncList);
    %canBeReachedFromHybrid = [canBeReachedFromHybrid junc];
    [isFixed possibleDB]= isDBFixedDespiteSwitching(junc);
%     junc
%     bg.node(junc).index
    if isFixed
        madeFixed = listPush(madeFixed,junc);
        %hybridFixed = listPush(hybridFixed, junc);
        hybridJuncFixedDBList(bg.node(junc).index) = possibleDB; %bg.junc(bg.node(junc).index).ele(possibleDB);
        propFixedEffectDespiteSwitching(junc);
    else
        unfixedQueueSecondPass = listPush(unfixedQueueSecondPass, junc);
    end
end

%display(unfixedQueueSecondPass);
%display(hybridJuncFixedDBList);
while ~isempty(unfixedQueueSecondPass)
    % Pop a junction off the list
    [junc unfixedQueueSecondPass] = listPop(unfixedQueueSecondPass);
    %canBeReachedFromHybrid = [canBeReachedFromHybrid junc];
    [isFixed possibleDB] = isDBFixedDespiteSwitching(junc);
    if isFixed
        %hybridFixed = listPush(hybridFixed, junc);
        madeFixed = listPush(madeFixed, junc);
        hybridJuncFixedDBList(i) = possibleDB;
        propFixedEffectDespiteSwitching(junc);
    end
end

%if some unfixed junctions are not reachable from hybrid junctions, it
%implies a disconnected system. Hence, these
%unfixed-junctions-which-are-not-reachable-from-a-hybrid-junction should be
%made fixed
for i = 1:length(determiningBonds)
    if fixedJuncList(i) ==0 && isempty(find(canBeReachedFromHybrid == bg.juncMap(i),1))
        fixedJuncList(i) = 1;
    end       
end

% display(hybridJuncFixedDBList);

%disp(notYetFixedForSureQueueSecondPass);
if HBGSimulinkDebug
    display(determiningBonds);
    display(juncStatus);
    display(fixedJuncList);
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function propFixedEffectDespiteSwitching(juncNum)
global bg; % canBeReachedFromHybrid; % determiningBonds juncStatus;
global madeFixed;
global hybridJuncFixedDBList;


% Initialize the queue of unassigned junctions
%result = [];
%success = true;
affJuncList = [];

% If a junction can be reached from a hybrid junction, marked that junction
% as "canBeReachedFromHybrid"
for i = 1:bg.node(juncNum).numBonds
    %canBeReachedFromHybrid = [canBeReachedFromHybrid bg.node(juncNum).bond(i)];
    if isequal(getType(bg.node(juncNum).bond(i)), 'ZeroJunction') || isequal(getType(bg.node(juncNum).bond(i)), 'OneJunction')
        affJuncList = listPush(affJuncList, bg.node(juncNum).bond(i));
    elseif isequal(getType(bg.node(juncNum).bond(i)), 'TF') || isequal(getType(bg.node(juncNum).bond(i)), 'GY')
        connConnEle = getConnConnElement(bg.node(juncNum).bond(i), juncNum);
        affJuncList = listPush(affJuncList, connConnEle);
    end
        
end


for i = 1:length(affJuncList)
    affJunc = affJuncList(i);
    if ~isempty(find(madeFixed == affJunc,1))
        continue;
    end
    %canBeReachedFromHybrid = [canBeReachedFromHybrid affJunc];
    [isFixed possibleDB]= isDBFixedDespiteSwitching(affJunc);
    % If determining bond is forced on this junction
    if  isFixed 
        %hybridFixed = listPush(hybridFixed, junc);
        madeFixed = listPush(madeFixed, affJunc);
        hybridJuncFixedDBList(bg.node(affJunc).index) = possibleDB;
        propFixedEffectDespiteSwitching(affJunc);
    end
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [result hybridFixedDB] = isDBFixedDespiteSwitching(juncNum)

% If the juncNum is not a hybrid, then return -1 as DB, otherwise return the 
% db for the hybridFixed junction when it is open.

global bg  determiningBonds; %juncStatus
global madeFixed;% canBeReachedFromHybrid;
global fixedJuncList;% hybridFixed;
global HBGSimulinkDebug;
global hybridJuncFixedDBList;

result = false;

% Returns if the Junc is fixed and if it is, sets the fixedJuncList array
% appropriately

% if current junc already fixed, then continue
if ~isempty(find(madeFixed == juncNum, 1))
    result = true;
    if bg.node(juncNum).hybrid == 1
        hybridFixedDB = hybridJuncFixedDBList(bg.node(juncNum).index);
    else
        hybridFixedDB = -1;
    end
    return;
end
%Think about the above if loop

% 1 = forced, 2 = unforced, -1 = inconsistent, -2 = unvisited
juncType = getJuncType(juncNum);
numFixedDB = 0;
numFixedNotDB = 0;
fixedDB = [];
fixedNotDB = [];
hybridFixedDB = -1;

if bg.node(juncNum).hybrid == 1
    onOffHybridJunc = getJuncState(juncNum);
    %Flip the state of the Hybrid junction
    onOffHybridJunc = ~onOffHybridJunc;
    [affJuncList, DBAfterSwitching] = getAffectedJuncDespiteSwitching(juncNum, onOffHybridJunc);
    % if the current junction is on, then after flipping, the state is off.

    if DBAfterSwitching == -1
        result = false;
        hybridFixedDB = -1;
        return;
    end
    
    %if onOffHybridJunc == 0
    % On switching off, since the junction turning off does not affect
    % any other junctions, this can be fixed
    if isempty(affJuncList)
        result = true;
        fixedJuncList(bg.node(juncNum).index) = 1;
        madeFixed = listPush(madeFixed, juncNum);
        if onOffHybridJunc == 0
            hybridFixedDB = determiningBonds(bg.node(juncNum).index);
        elseif onOffHybridJunc == 1
            hybridFixedDB = bg.junc(bg.node(juncNum).index).ele(DBAfterSwitching);
        end
        %hybridFixedDB = determiningBonds(bg.node(juncNum).index);
        % However, if there are some junctions affected, check if these are
        % all hybrid junctions with the same C-spec. If so, then again fix this
        % junction.
    else 
        notFixedHybridFlag = 0;
        %numNotHybridAffNeighbors = 0;
        %numHybridAffNeighbors = 0;
        for jj = 1:length(affJuncList)
            newJunc = affJuncList(jj);
            if bg.node(newJunc).hybrid ==1
                %numHybridAffNeighbors = numHybridAffNeighbors + 1;
                if ~isequal(bg.node(newJunc).onGuard, bg.node(juncNum).onGuard) ...
                        || ~isequal(bg.node(newJunc).offGuard, bg.node(juncNum).offGuard)
                    notFixedHybridFlag = 1;
                end
            elseif bg.node(newJunc).hybrid == 0
                notFixedHybridFlag = 1;
            end
        end
        % numNotHybridAffNeighbors = length(affJuncList) - numHybridAffNeighbors;

        % if the affected hybrid neighbors all have the same CSPEC then
        % make this junction hybrid fixed!
        if notFixedHybridFlag == 0 %&& numNotHybridAffNeighbors == 0
            result = true;
            fixedJuncList(bg.node(juncNum).index) = 1;
            madeFixed = listPush(madeFixed, juncNum);
            if onOffHybridJunc == 0
                hybridFixedDB = determiningBonds(bg.node(juncNum).index);
            elseif onOffHybridJunc == 1
                hybridFixedDB = bg.junc(bg.node(juncNum).index).ele(DBAfterSwitching);
            end
        end
    end
else
    for i = 1:bg.node(juncNum).numBonds
        connEle = bg.node(juncNum).bond(i);

        % If one junction
        if juncType == 1
            if isequal(getType(connEle),'Sf') || isequal(getType(connEle),'I')
                %numForcedDB = numForcedDB + 1;
                numFixedDB = numFixedDB + 1;
                fixedDB = listPush(fixedDB, connEle);
                %forcedDB = [forcedDB connEle];
                %fixedJuncList(bg.node(juncNum).index) = 1;
            elseif isequal(getType(connEle),'Se') || isequal(getType(connEle),'C')
                %numForcedNotDB = numForcedNotDB + 1;
                numFixedNotDB = numFixedNotDB + 1;
                %notForcedDB = [notForcedDB connEle];
                %fixedJuncList(bg.node(juncNum).index) = 1;
            end

            
            if isequal(getType(connEle), 'ZeroJunction')
                if ~isempty(find(madeFixed == connEle, 1)) && bg.node(connEle).hybrid == 1 && getJuncState(connEle) == 0
                    connEleDB = bg.node(connEle).bond(hybridJuncFixedDBList(bg.node(connEle).index));
                else
                    connEleDB = getDBEle(connEle);
                end
                if  ~isempty(find(madeFixed == connEle, 1))  && getDB(connEle) ~= -1 && connEleDB == juncNum %%%%&& getJuncState(connEle) == 1 !!!
                    numFixedDB = numFixedDB + 1;
                    fixedDB = listPush(fixedDB, connEle);
                    %forcedDB = [forcedDB connEle];
                elseif ~isempty(find(madeFixed == connEle, 1))  && getDB(connEle) ~= -1  && connEleDB ~= juncNum
                    numFixedNotDB = numFixedNotDB + 1;
                    fixedNotDB = listPush(fixedNotDB, connEle);
                    %notForcedDB = [notForcedDB connEle];
                end
            end
            if isequal(getType(connEle), 'OneJunction')
                if ~isempty(find(madeFixed == connEle, 1)) && bg.node(connEle).hybrid == 1 && getJuncState(connEle) == 0
                    connEleDB = bg.node(connEle).bond(hybridJuncFixedDBList(bg.node(connEle).index));
                else
                    connEleDB = getDBEle(connEle);
                end
                if  ~isempty(find(madeFixed == connEle, 1))   && getDB(connEle) ~= -1  && connEleDB ~= juncNum
                    numFixedDB = numFixedDB + 1;
                    fixedDB = listPush(fixedDB, connEle);
                    %forcedDB = [forcedDB connEle];
                elseif ~isempty(find(madeFixed == connEle, 1))   && getDB(connEle) ~= -1  && connEleDB == juncNum
                    numFixedNotDB = numFixedNotDB + 1;
                    fixedNotDB = listPush(fixedNotDB, connEle);
                    %notForcedDB = [notForcedDB connEle];
                end

            end
            if isequal(getType(connEle), 'TF')
                connConnEle = getConnConnElement(connEle, juncNum);
                if ~isempty(find(madeFixed == connConnEle, 1)) && bg.node(connConnEle).hybrid == 1 && getJuncState(connConnEle) == 0
                    connConnEleDB = bg.node(connConnEle).bond(hybridJuncFixedDBList(bg.node(connConnEle).index));
                else
                    connConnEleDB = getDBEle(connConnEle);
                end
                if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(madeFixed == connConnEle, 1)) &&  getDB(connConnEle) ~=-1  && connConnEleDB == connEle)
                    numFixedNotDB = numFixedNotDB + 1;
                    fixedNotDB = listPush(fixedNotDB, connEle);
                    %                 notForcedDB = [notForcedDB connEle];
                elseif (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1  && connConnEleDB ~= connEle)
                    numFixedDB = numFixedDB + 1;
                    fixedDB = listPush(fixedDB, connEle);
                    %                 forcedDB = [forcedDB connEle];
                elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1  && connConnEleDB == connEle)
                    numFixedDB = numFixedDB + 1;
                    fixedDB = listPush(fixedDB, connEle);
                    %                 forcedDB = [forcedDB connEle];
                elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(madeFixed == connConnEle, 1)) && getDB(connConnEle) ~=-1  && connConnEleDB ~= connEle)
                    numFixedNotDB = numFixedNotDB + 1;
                    fixedNotDB = listPush(fixedNotDB, connEle);
                    %                 notForcedDB = [notForcedDB connEle];
                end
            end
            if isequal(getType(connEle), 'GY')
                connConnEle = getConnConnElement(connEle, juncNum);
                if ~isempty(find(madeFixed == connConnEle, 1)) && bg.node(connConnEle).hybrid == 1 && getJuncState(connConnEle) == 0
                    connConnEleDB = bg.node(connConnEle).bond(hybridJuncFixedDBList(bg.node(connConnEle).index));
                else
                    connConnEleDB = getDBEle(connConnEle);
                end
                if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(madeFixed == connConnEle, 1)) && getDB(connConnEle) ~=-1  && connConnEleDB == connEle)
                    numFixedDB = numFixedDB + 1;
                    fixedDB = listPush(fixedDB, connEle);
                    %                 forcedDB = [forcedDB connEle];
                elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1  && connConnEleDB ~= connEle)
                    numFixedNotDB = numFixedNotDB + 1;
                    fixedNotDB = listPush(fixedNotDB, connEle);
                    %                 notForcedDB = [notForcedDB connEle];
                elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(madeFixed == connConnEle, 1)) && getDB(connConnEle) ~=-1  && connConnEleDB == connEle)
                    numFixedNotDB = numFixedNotDB + 1;
                    fixedNotDB = listPush(fixedNotDB, connEle);
                    %                 notForcedDB = [notForcedDB connEle];
                elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1  && connConnEleDB ~= connEle)
                    numFixedDB = numFixedDB + 1;
                    fixedDB = listPush(fixedDB, connEle);
                    %                 forcedDB = [forcedDB connEle];
                end

            end
            % If zero junction
        elseif juncType == 0
            if isequal(getType(connEle),'Se') || isequal(getType(connEle),'C')
                numFixedDB = numFixedDB + 1;
                fixedDB = listPush(fixedDB, connEle);
            elseif isequal(getType(connEle),'Sf') || isequal(getType(connEle),'I')
                numFixedNotDB = numFixedNotDB + 1;
                fixedNotDB = listPush(fixedNotDB, connEle);
            end
            if isequal(getType(connEle), 'ZeroJunction')
                if ~isempty(find(madeFixed == connEle, 1)) && bg.node(connEle).hybrid == 1 && getJuncState(connEle) == 0
                    connEleDB = bg.node(connEle).bond(hybridJuncFixedDBList(bg.node(connEle).index));
                else
                    connEleDB = getDBEle(connEle);
                end
                if  ~isempty(find(madeFixed == connEle, 1))   && getDB(connEle) ~= -1 && connEleDB == juncNum
                    numFixedNotDB = numFixedNotDB + 1;
                    fixedNotDB = listPush(fixedNotDB, connEle);
                    %                 notForcedDB = [notForcedDB connEle];
                elseif ~isempty(find(madeFixed == connEle, 1))   && getDB(connEle) ~= -1 && connEleDB ~= juncNum
                    numFixedDB = numFixedDB + 1;
                    fixedDB = listPush(fixedDB, connEle);
                    %                 forcedDB = [forcedDB connEle];
                end
            end

            if isequal(getType(connEle), 'OneJunction')
                if ~isempty(find(madeFixed == connEle, 1)) && bg.node(connEle).hybrid == 1 && getJuncState(connEle) == 0
                    connEleDB = bg.node(connEle).bond(hybridJuncFixedDBList(bg.node(connEle).index));
                else
                    connEleDB = getDBEle(connEle);
                end
                if  ~isempty(find(madeFixed == connEle, 1))  && fixedJuncList(bg.node(connEle).index) == 1  && getDB(connEle) ~= -1 && connEleDB ~= juncNum
                    numFixedNotDB = numFixedNotDB + 1;
                    fixedNotDB = listPush(fixedNotDB, connEle);
                    %                 notFixedDB = [notFixedDB connEle];
                elseif ~isempty(find(madeFixed == connEle, 1))  && fixedJuncList(bg.node(connEle).index) == 1  && getDB(connEle) ~= -1 && connEleDB == juncNum
                    numFixedDB = numFixedDB + 1;
                    fixedDB = listPush(fixedDB, connEle);
                    %                 fixedDB = [fixedDB connEle];
                end
            end

            if isequal(getType(connEle), 'TF')
                connConnEle = getConnConnElement(connEle, juncNum);
                if ~isempty(find(madeFixed == connConnEle, 1)) && bg.node(connConnEle).hybrid == 1 && getJuncState(connConnEle) == 0
                    connConnEleDB = bg.node(connConnEle).bond(hybridJuncFixedDBList(bg.node(connConnEle).index));
                else
                    connConnEleDB = getDBEle(connConnEle);
                end
                if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1 && connConnEleDB == connEle)
                    numFixedDB = numFixedDB + 1;
                    fixedDB = listPush(fixedDB, connEle);
                    %                 forcedDB = [forcedDB connEle];
                elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1 && connConnEleDB ~= connEle)
                    numFixedNotDB = numFixedNotDB + 1;
                    fixedNotDB = listPush(fixedNotDB, connEle);
                    %                 notForcedDB = [notForcedDB connEle];
                elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1   && connConnEleDB == connEle)
                    numFixedNotDB = numFixedNotDB + 1;
                    fixedNotDB = listPush(fixedNotDB, connEle);
                    %                 notForcedDB = [notForcedDB connEle];
                elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1 && connConnEleDB ~= connEle)
                    numFixedDB = numFixedDB + 1;
                    fixedDB = listPush(fixedDB, connEle);
                    %                 forcedDB = [forcedDB connEle];
                end

            end
            if isequal(getType(connEle), 'GY')
                connConnEle = getConnConnElement(connEle, juncNum);
                if ~isempty(find(madeFixed == connConnEle, 1)) && bg.node(connConnEle).hybrid == 1 && getJuncState(connConnEle) == 0
                    connConnEleDB = bg.node(connConnEle).bond(hybridJuncFixedDBList(bg.node(connConnEle).index));
                else
                    connConnEleDB = getDBEle(connConnEle);
                end
                if (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(madeFixed == connConnEle, 1)) && getDB(connConnEle) ~=-1 && connConnEleDB == connEle)
                    numFixedNotDB = numFixedNotDB + 1;
                    fixedNotDB = listPush(fixedNotDB, connEle);
                    %                 notForcedDB = [notForcedDB connEle];
                elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(madeFixed == connConnEle, 1)) && getDB(connConnEle) ~=-1 && connConnEleDB ~= connEle)
                    numFixedDB = numFixedDB + 1;
                    fixedDB = listPush(fixedDB, connEle);
                    %                 forcedDB = [forcedDB connEle];
                elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1 && connConnEleDB == connEle)
                    numFixedDB = numFixedDB + 1;
                    fixedDB = listPush(fixedDB, connEle);
                    %                 forcedDB = [forcedDB connEle];
                elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1 && connConnEleDB ~= connEle)
                    numFixedNotDB = numFixedNotDB + 1;
                    fixedNotDB = listPush(fixedNotDB, connEle);
                    %                 notForcedDB = [notForcedDB connEle];
                end

            end

        else
            disp('Error')
        end
    end

    numInactiveBonds = 0;
    numActiveBonds = bg.node(juncNum).numBonds - numInactiveBonds;



    % 1 = forced, 2 = unforced, -1 = inconsistent, -2 = unvisited
    %result = false;
    %
    % if getJuncState(juncNum) == 0 || bg.node(juncNum).hybrid == 1
    %     result = false;
    % else
    if (numFixedDB) == 1
        result = true;
        fixedJuncList(bg.node(juncNum).index) = 1;
        madeFixed = listPush(madeFixed, juncNum); % This might need to be checked.
        hybridFixedDB = bg.junc(bg.node(juncNum).index).ele(fixedDB(1));
    elseif numFixedNotDB  == bg.node(juncNum).numBonds - 1
        result = true;
        fixedJuncList(bg.node(juncNum).index) = 1;
        madeFixed = listPush(madeFixed, juncNum);
        for j = 1:bg.node(juncNum).numBonds
            if isempty(find(fixedNotDB == bg.node(juncNum).bond(j), 1))
                hybridFixedDB = bg.junc(bg.node(juncNum).index).ele(bg.node(juncNum).bond(j));
            end
        end
    else
        result = false;
        hybridFixedDB(bg.node(juncNum).index) = -1;
    end

end

if fixedJuncList(bg.node(juncNum).index)==1
    if HBGSimulinkDebug
        fprintf(1,'numFixedDB %d, numFixedNotDB %d, numActiveBonds %d Name %s\n', ...
            numFixedDB, numFixedNotDB, numActiveBonds, bg.node(juncNum).name);
        %     display('*************** fixed junction *****************');
        %     display(numFixedDB);
        %     display(numFixedNotDB);
        %     display(numActiveBonds);
        %     display(bg.node(juncNum).name);
        %     display('*************** fixed junction *****************');
    end
end
%display(fixedJuncList);
% make sure that the unvisited junctions are sent first

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [affJuncQueue, DBAfterSwitching] = getAffectedJuncDespiteSwitching(juncNum, onOff)
global bg;

% global determiningBonds juncStatus;
% global visited;

affJuncQueue = [];
if onOff == 1
    % Determine the db of the junction when it switches on, based on
    % the fixed junctions and hybrid junctions (with the same CSPEC)
    DBWhenHybridJuncSwitchesOn = detDBWhenHybridJuncSwitchesOn(juncNum);
    
    if DBWhenHybridJuncSwitchesOn == -1
        DBAfterSwitching = -1;
        affJuncQueue = [];
        return;
    end
    
    DBAfterSwitching = DBWhenHybridJuncSwitchesOn;
    % get the list of junctions that are affected when the hybrid
    % junction above is assigned that db
    % If this junction switches on, then try and figure it's decision
    % based on the fixed junctions (with the same CSPEC) and other stuff...
    % and
    for i = 1:bg.node(juncNum).numBonds
        connEle = bg.node(juncNum).bond(i);
        [result adjJunc] = JuncOnAffectsEleDespiteSwitching(juncNum, connEle, DBAfterSwitching);
        if result == true
            affJuncQueue = listPush(affJuncQueue, adjJunc);
        end
    end
else
    % IMPORTANT: Although the function below is named
    % detDBWhenHybridJuncSwitchesOn, it actually also performs a check if
    % the currently on hybrid junction is fixed or not. 
    DBWhenHybridJuncSwitchesOn = detDBWhenHybridJuncSwitchesOn(juncNum);
    
    if DBWhenHybridJuncSwitchesOn == -1
        DBAfterSwitching = -1;
        affJuncQueue = [];
        return;
    end
    
    DBAfterSwitching = 0;
    for i = 1:bg.node(juncNum).numBonds
        connEle = bg.node(juncNum).bond(i);

        [result adjJunc] = JuncOffAffectsEleDespiteSwitching(juncNum, connEle);
        if result == true
            affJuncQueue = listPush(affJuncQueue, adjJunc);
        end
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function [result, adjJunc] = JuncOffAffectsEleDespiteSwitching(juncNum, BGEle)
% Returns true if the junc turning off affects the element
% Else returns false
%global bg juncStatus determiningBonds;

result = false;
adjJunc = -98;
% Is this element BGEle an on junction and juncNum is determiningBonds of BGEle, return true
% else return false
if ((isequal(getType(BGEle), 'OneJunction') || isequal(getType(BGEle), 'ZeroJunction')))
    if getDBEle(BGEle) == juncNum %|| getDB(BGEle) == -1
        result = true;
        adjJunc = BGEle;
    end
end

% Is this element BGEle a TF/GY and juncNum is determiningBonds of the other junction
% connected to BGEle, return true; else return false
if (isequal(getType(BGEle), 'TF')|| isequal(getType(BGEle), 'GY'))
    connConnElement = getConnConnElement(BGEle, juncNum);
    if getDBEle(connConnElement) == BGEle
        result = true;
        adjJunc = connConnElement;
        %     elseif (getJuncState(connConnElement) == 1 && getDB(connConnElement) == -1)
        %         result = true;
        %         adjJunc = connConnElement;
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [result, adjJunc] = JuncOnAffectsEleDespiteSwitching(juncNum, connEle, DBAfterSwitching)
% Returns true if the junc turning on and having assigned a determiningBonds affects
% the element else returns false
global bg; %  determiningBonds; %juncStatus
global madeFixed;% canBeReachedFromHybrid;


result = false;
adjJunc = -98;


if ~isempty(find(madeFixed == connEle,1))
    return;
end


%In case this new determining bond for this junction causes the
%determining bonds of the other junctions to change, call junction
%update on those junctions with this current junction as the
%determining bond imposing component
%if getDBEle(juncNum) == connEle
if  DBAfterSwitching == connEle
    if isequal(getType(juncNum), 'OneJunction')
        if (isequal(getType(connEle), 'OneJunction')&& getDBEle(connEle)==juncNum) %&& bg.node(connEle).hybrid == 0)
            result = true;
            adjJunc = connEle;
        elseif (isequal(getType(connEle), 'OneJunction')&& getDBEle(connEle)== 0 && isequal(bg.node(connEle).onGuard, ...
                bg.node(juncNum).onGuard) && isequal(bg.node(connEle).offGuard, bg.node(juncNum).offGuard) )
            result = true;
            adjJunc = connEle;
        elseif (isequal(getType(connEle), 'ZeroJunction')&& getDBEle(connEle)~=juncNum) %&& bg.node(connEle).hybrid == 0)
            result = true;
            adjJunc = connEle;
        elseif (isequal(getType(connEle), 'ZeroJunction')&& getDBEle(connEle)== 0 && isequal(bg.node(connEle).onGuard, ...
                bg.node(juncNum).onGuard) && isequal(bg.node(connEle).offGuard, bg.node(juncNum).offGuard))
            result = true;
            adjJunc = connEle;
        elseif isequal(getType(connEle), 'TF')
            connConnEle = getConnConnElement(connEle, juncNum);
            if (isequal(getType(connConnEle), 'OneJunction')&& getDBEle(connConnEle)==connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'OneJunction')&& getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getDBEle(connConnEle) ~=connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'ZeroJunction')&& getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;
            end
        elseif isequal(getType(connEle), 'GY')
            connConnEle = getConnConnElement(connEle, juncNum);
            if (isequal(getType(connConnEle), 'OneJunction') && getDBEle(connConnEle) ~= connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connEle;
                %            elseif (isequal(getType(connConnEle),
                %            'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle) == juncNum)
            elseif (isequal(getType(connConnEle), 'OneJunction')&& getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getDBEle(connConnEle) == connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'ZeroJunction')&& getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;
            end
        end
    elseif isequal(getType(juncNum), 'ZeroJunction')
        if (isequal(getType(connEle), 'OneJunction') && getDBEle(connEle)~=juncNum)% && bg.node(connEle).hybrid == 0)
            result = true;
            adjJunc = connEle;
        elseif (isequal(getType(connEle), 'OneJunction')&&  getDBEle(connEle)== 0 && isequal(bg.node(connEle).onGuard, ...
                bg.node(juncNum).onGuard) && isequal(bg.node(connEle).offGuard, bg.node(juncNum).offGuard))
            result = true;
            adjJunc = connEle;
        elseif (isequal(getType(connEle), 'ZeroJunction') && getDBEle(connEle)==juncNum)% && bg.node(connEle).hybrid == 0)
            result = true;
            adjJunc = connEle;
        elseif (isequal(getType(connEle), 'ZeroJunction') && getDBEle(connEle)== 0 && isequal(bg.node(connEle).onGuard, ...
                bg.node(juncNum).onGuard) && isequal(bg.node(connEle).offGuard, bg.node(juncNum).offGuard))
            result = true;
            adjJunc = connEle;
            
        elseif isequal(getType(connEle), 'TF')
            connConnEle = getConnConnElement(connEle, juncNum);
            if (isequal(getType(connConnEle), 'OneJunction') && getDBEle(connConnEle)~=connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connConnEle;
                %            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==juncNum)
            elseif (isequal(getType(connConnEle), 'OneJunction') && getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;

            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getDBEle(connConnEle)==connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'ZeroJunction')&& getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;

            end
        elseif isequal(getType(connEle), 'GY')
            connConnEle = getConnConnElement(connEle, juncNum);
            %            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==juncNum)
            if (isequal(getType(connConnEle), 'OneJunction') && getDBEle(connConnEle)==connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connEle;
                %            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)~=juncNum)
            elseif (isequal(getType(connConnEle), 'OneJunction')&& getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getDBEle(connConnEle)~=connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'ZeroJunction')&& getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;
            end
        end
    end
elseif getDB(juncNum) == -1
    display('Something Wrong in JuncOnAffectsEle');
elseif DBAfterSwitching ~= connEle
    if isequal(getType(juncNum), 'OneJunction')
        if (isequal(getType(connEle), 'OneJunction') && getDBEle(connEle)~=juncNum)% && bg.node(connEle).hybrid == 0)
            result = true;
            adjJunc = connEle;
        elseif (isequal(getType(connEle), 'ZeroJunction') && getDBEle(connEle)==juncNum)% && bg.node(connEle).hybrid == 0)
            result = true;
            adjJunc = connEle;
        elseif isequal(getType(connEle), 'TF')
            connConnEle = getConnConnElement(connEle, juncNum);
            %            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1  && getDBEle(connConnEle)~=juncNum)
            if (isequal(getType(connConnEle), 'OneJunction') && getDBEle(connConnEle)~=connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connConnEle;
                %            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==juncNum)
            elseif (isequal(getType(connConnEle), 'ZeroJunction')  && getDBEle(connConnEle)==connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'OneJunction')&& getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'ZeroJunction')&& getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;

            end
        elseif isequal(getType(connEle), 'GY')
            connConnEle = getConnConnElement(connEle, juncNum);
            %            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==juncNum)
            if (isequal(getType(connConnEle), 'OneJunction')  && getDBEle(connConnEle)==connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connEle;
                %            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)~=juncNum)
            elseif (isequal(getType(connConnEle), 'ZeroJunction')  && getDBEle(connConnEle)~=connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'OneJunction')&& getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'ZeroJunction')&& getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;

            end
        end
    elseif isequal(getType(juncNum), 'ZeroJunction')
        if (isequal(getType(connEle), 'OneJunction') && getDBEle(connEle)==juncNum)% && bg.node(connEle).hybrid == 0)
            result = true;
            adjJunc = connEle;
        elseif (isequal(getType(connEle), 'ZeroJunction') && getDBEle(connEle)~=juncNum)% && bg.node(connEle).hybrid == 0)
            result = true;
            adjJunc = connEle;
        elseif isequal(getType(connEle), 'TF')
            connConnEle = getConnConnElement(connEle, juncNum);
            %            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==juncNum)
            if (isequal(getType(connConnEle), 'OneJunction')  && getDBEle(connConnEle)==connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connConnEle;
                %            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)~=juncNum)
            elseif (isequal(getType(connConnEle), 'ZeroJunction')  && getDBEle(connConnEle)~=connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'OneJunction')&& getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'ZeroJunction')&& getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;

            end
        elseif isequal(getType(connEle), 'GY')
            connConnEle = getConnConnElement(connEle, juncNum);
            %            if (isequal(getType(connConnEle), 'OneJunction') && getJuncState(connConnEle) == 1 && getDBEle(connConnEle)~=juncNum)
            if (isequal(getType(connConnEle), 'OneJunction')  && getDBEle(connConnEle)~=connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connEle;
                %            elseif (isequal(getType(connConnEle), 'ZeroJunction')&& getJuncState(connConnEle) == 1 && getDBEle(connConnEle)==juncNum)
            elseif (isequal(getType(connConnEle), 'ZeroJunction') && getDBEle(connConnEle)==connEle)% && bg.node(connConnEle).hybrid == 0)
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'OneJunction')&& getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;
            elseif (isequal(getType(connConnEle), 'ZeroJunction')&& getDBEle(connConnEle)== 0 && isequal(bg.node(connConnEle).onGuard, ...
                    bg.node(juncNum).onGuard) && isequal(bg.node(connConnEle).offGuard, bg.node(juncNum).offGuard))
                result = true;
                adjJunc = connConnEle;
            end
        end
    end
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function DBWhenHybridJuncSwitchesOn = detDBWhenHybridJuncSwitchesOn(juncNum)

% return -1 if the db for this on junction cannot be determined without any
% ambiguity

global bg; %  determiningBonds; %juncStatus
global madeFixed;% canBeReachedFromHybrid;
global fixedJuncList;% hybridFixed;
% global HBGSimulinkDebug;
global hybridJuncFixedDBList;

juncType = getJuncType(juncNum);
numFixedDB = 0;
numFixedNotDB = 0;
fixedDB = [];
fixedNotDB = [];
%hybridFixedDB = -1;

DBWhenHybridJuncSwitchesOn = -1;

for i = 1:bg.node(juncNum).numBonds
    connEle = bg.node(juncNum).bond(i);
    

    % If one junction
    if juncType == 1
        if isequal(getType(connEle),'Sf') || isequal(getType(connEle),'I')
            numFixedDB = numFixedDB + 1;
            fixedDB = listPush(fixedDB, connEle);
        elseif isequal(getType(connEle),'Se') || isequal(getType(connEle),'C')
            numFixedNotDB = numFixedNotDB + 1;
        end
        if isequal(getType(connEle), 'ZeroJunction')
            if ~isempty(find(madeFixed == connEle, 1)) && bg.node(connEle).hybrid == 1 && getJuncState(connEle) == 0
                connEleDB = bg.node(connEle).bond(hybridJuncFixedDBList(bg.node(connEle).index));
            else
                connEleDB = getDBEle(connEle);
            end
            if  ~isempty(find(madeFixed == connEle, 1)) && getDB(connEle) ~= -1 && connEleDB == juncNum %%%%&& getJuncState(connEle) == 1 !!!
                numFixedDB = numFixedDB + 1;
                fixedDB = listPush(fixedDB, connEle);
            elseif ~isempty(find(madeFixed == connEle, 1))  && getDB(connEle) ~= -1  && connEleDB ~= juncNum
                numFixedNotDB = numFixedNotDB + 1;
                fixedNotDB = listPush(fixedNotDB, connEle);
            end
        end
        if isequal(getType(connEle), 'OneJunction')
            if ~isempty(find(madeFixed == connEle, 1)) && bg.node(connEle).hybrid == 1 && getJuncState(connEle) == 0
                connEleDB = bg.node(connEle).bond(hybridJuncFixedDBList(bg.node(connEle).index));
            else
                connEleDB = getDBEle(connEle);
            end
            if  ~isempty(find(madeFixed == connEle, 1))   && getDB(connEle) ~= -1  && connEleDB ~= juncNum
                numFixedDB = numFixedDB + 1;
                fixedDB = listPush(fixedDB, connEle);
            elseif ~isempty(find(madeFixed == connEle, 1))   && getDB(connEle) ~= -1  && connEleDB == juncNum
                numFixedNotDB = numFixedNotDB + 1;
                fixedNotDB = listPush(fixedNotDB, connEle);
            end

        end
        if isequal(getType(connEle), 'TF')
            connConnEle = getConnConnElement(connEle, juncNum);
            if ~isempty(find(madeFixed == connConnEle, 1)) && bg.node(connConnEle).hybrid == 1 && getStatus(connConnEle) == 0
                connConnEleDB = bg.node(connConnEle).bond(hybridJuncFixedDBList(bg.node(connConnEle).index));
            else
                connConnEleDB = getDBEle(connConnEle);
            end
            if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(madeFixed == connConnEle, 1)) &&  getDB(connConnEle) ~=-1 && connConnEleDB == connEle)
                numFixedNotDB = numFixedNotDB + 1;
                fixedNotDB = listPush(fixedNotDB, connEle);
            elseif (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1 && connConnEleDB ~= connEle)
                numFixedDB = numFixedDB + 1;
                fixedDB = listPush(fixedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1 && connConnEleDB == connEle)
                numFixedDB = numFixedDB + 1;
                fixedDB = listPush(fixedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(madeFixed == connConnEle, 1)) && getDB(connConnEle) ~=-1 && connConnEleDB ~= connEle)
                numFixedNotDB = numFixedNotDB + 1;
                fixedNotDB = listPush(fixedNotDB, connEle);
            end
        end
        if isequal(getType(connEle), 'GY')
            connConnEle = getConnConnElement(connEle, juncNum);
            if ~isempty(find(madeFixed == connConnEle, 1)) && bg.node(connConnEle).hybrid == 1 && getStatus(connConnEle) == 0
                connConnEleDB = bg.node(connConnEle).bond(hybridJuncFixedDBList(bg.node(connConnEle).index));
            else
                connConnEleDB = getDBEle(connConnEle);
            end
            if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(madeFixed == connConnEle, 1)) && getDB(connConnEle) ~=-1 && connConnEleDB == connEle)
                numFixedDB = numFixedDB + 1;
                fixedDB = listPush(fixedDB, connEle);
            elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1 && connConnEleDB ~= connEle)
                numFixedNotDB = numFixedNotDB + 1;
                fixedNotDB = listPush(fixedNotDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(madeFixed == connConnEle, 1)) && getDB(connConnEle) ~=-1 && connConnEleDB == connEle)
                numFixedNotDB = numFixedNotDB + 1;
                fixedNotDB = listPush(fixedNotDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1 && connConnEleDB ~= connEle)
                numFixedDB = numFixedDB + 1;
                fixedDB = listPush(fixedDB, connEle);
            end

        end
        % If zero junction
    elseif juncType == 0
        if isequal(getType(connEle),'Se') || isequal(getType(connEle),'C')
            numFixedDB = numFixedDB + 1;
            fixedDB = listPush(fixedDB, connEle);
        elseif isequal(getType(connEle),'Sf') || isequal(getType(connEle),'I')
            numFixedNotDB = numFixedNotDB + 1;
            fixedNotDB = listPush(fixedNotDB, connEle);
        end
        if isequal(getType(connEle), 'ZeroJunction')
            if ~isempty(find(madeFixed == connEle, 1)) && bg.node(connEle).hybrid == 1 && getJuncState(connEle) == 0
                connEleDB = bg.node(connEle).bond(hybridJuncFixedDBList(bg.node(connEle).index));
            else
                connEleDB = getDBEle(connEle);
            end
            if  ~isempty(find(madeFixed == connEle, 1))   && getDB(connEle) ~= -1 && connEleDB == juncNum
                numFixedNotDB = numFixedNotDB + 1;
                fixedNotDB = listPush(fixedNotDB, connEle);
            elseif ~isempty(find(madeFixed == connEle, 1))    && getDB(connEle) ~= -1 && connEleDB ~= juncNum
                numFixedDB = numFixedDB + 1;
                fixedDB = listPush(fixedDB, connEle);
            end
        end

        if isequal(getType(connEle), 'OneJunction')
            if ~isempty(find(madeFixed == connEle, 1)) && bg.node(connEle).hybrid == 1 && getJuncState(connEle) == 0
                connEleDB = bg.node(connEle).bond(hybridJuncFixedDBList(bg.node(connEle).index));
            else
                connEleDB = getDBEle(connEle);
            end
            if  ~isempty(find(madeFixed == connEle, 1))  && fixedJuncList(bg.node(connEle).index) == 1  && getDB(connEle) ~= -1 && connEleDB ~= juncNum
                numFixedNotDB = numFixedNotDB + 1;
                fixedNotDB = listPush(fixedNotDB, connEle);
            elseif ~isempty(find(madeFixed == connEle, 1))  && fixedJuncList(bg.node(connEle).index) == 1  && getDB(connEle) ~= -1 && connEleDB == juncNum
                numFixedDB = numFixedDB + 1;
                fixedDB = listPush(fixedDB, connEle);
            end
        end

        if isequal(getType(connEle), 'TF')
            connConnEle = getConnConnElement(connEle, juncNum);
            if ~isempty(find(madeFixed == connConnEle, 1)) && bg.node(connConnEle).hybrid == 1 && getStatus(connConnEle) == 0
                connConnEleDB = bg.node(connConnEle).bond(hybridJuncFixedDBList(bg.node(connConnEle).index));
            else
                connConnEleDB = getDBEle(connConnEle);
            end
            if (isequal(getType(connConnEle),'OneJunction') && ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1 && connConnEleDB == connEle)
                numFixedDB = numFixedDB + 1;
                fixedDB = listPush(fixedDB, connEle);
            elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1 && connConnEleDB ~= connEle)
                numFixedNotDB = numFixedNotDB + 1;
                fixedNotDB = listPush(fixedNotDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1  && connConnEleDB == connEle)
                numFixedNotDB = numFixedNotDB + 1;
                fixedNotDB = listPush(fixedNotDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1 && connConnEleDB ~= connEle)
                numFixedDB = numFixedDB + 1;
                fixedDB = listPush(fixedDB, connEle);
            end

        end
        if isequal(getType(connEle), 'GY')
            connConnEle = getConnConnElement(connEle, juncNum);
            if ~isempty(find(madeFixed == connConnEle, 1)) && bg.node(connConnEle).hybrid == 1 && getStatus(connConnEle) == 0
                connConnEleDB = bg.node(connConnEle).bond(hybridJuncFixedDBList(bg.node(connConnEle).index));
            else
                connConnEleDB = getDBEle(connConnEle);
            end
            if (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(madeFixed == connConnEle, 1)) && getDB(connConnEle) ~=-1 && connConnEleDB == connEle)
                numFixedNotDB = numFixedNotDB + 1;
                fixedNotDB = listPush(fixedNotDB, connEle);
            elseif (isequal(getType(connConnEle),'OneJunction')&& ~isempty(find(madeFixed == connConnEle, 1)) && getDB(connConnEle) ~=-1 && connConnEleDB ~= connEle)
                numFixedDB = numFixedDB + 1;
                fixedDB = listPush(fixedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction') && ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1 && connConnEleDB == connEle)
                numFixedDB = numFixedDB + 1;
                fixedDB = listPush(fixedDB, connEle);
            elseif (isequal(getType(connConnEle),'ZeroJunction')&& ~isempty(find(madeFixed == connConnEle, 1))  && getDB(connConnEle) ~=-1 && connConnEleDB ~= connEle)
                numFixedNotDB = numFixedNotDB + 1;
                fixedNotDB = listPush(fixedNotDB, connEle);
            end

        end

    else
        disp('Error')
    end
end

numInactiveBonds = 0;
numActiveBonds = bg.node(juncNum).numBonds - numInactiveBonds;



% 1 = forced, 2 = unforced, -1 = inconsistent, -2 = unvisited
if (numFixedDB) == 1
    DBWhenHybridJuncSwitchesOn = fixedDB(1);
elseif numFixedNotDB  == numActiveBonds - 1
    for j = 1:bg.node(juncNum).numBonds
        if isempty(find(fixedNotDB == bg.node(juncNum).bond(j), 1))
            DBWhenHybridJuncSwitchesOn = bg.node(juncNum).bond(j);
        end
    end
else
    DBWhenHybridJuncSwitchesOn = -1;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function getBondsWhichCannotBeDB()
global bg;

% This function identifies bonds that can never be the determining bond for
% a junction

% Generate a list of junctions that are not fixed
listOfJuncs = [];
for i = 1:bg.numNodes
    if isequal(getType(i), 'ZeroJunction') ...
            || isequal(getType(i), 'OneJunction')
        if bg.fixedJuncList(bg.node(i).index) ~=1
            listOfJuncs = listPush(listOfJuncs, i);
        end
    end
end

% For each unfixed junction in the list, figure out the bonds that cannot
% be their dbs: Make sure that this list contains the bond number for each
% junction
while ~isempty(listOfJuncs)
    [juncNum listOfJuncs] = listPop(listOfJuncs);
    cannotBeDBListEle = [];
    bg.node(juncNum).cannotBeDBList = [];
    juncType = getJuncType(juncNum);
    for i = 1:bg.node(juncNum).numBonds
        connEle = bg.node(juncNum).bond(i);
        if juncType == 1
            if isequal(getType(connEle),'Se') || isequal(getType(connEle),'C')
                cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(bg.node(juncNum).index).ele(connEle));
            end
            if isequal(getType(connEle), 'ZeroJunction') && bg.fixedJuncList(bg.node(connEle).index) == 1
                if  bg.node(connEle).hybrid == 1
                    DBConnEle = bg.hybridJuncFixedDBList(bg.node(connEle).index) ;
                else
                    DBConnEle = bg.determiningBonds(bg.node(connEle).index);
                end
                if DBConnEle ~= bg.junc(bg.node(connEle).index).ele(juncNum)
                    cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(bg.node(juncNum).index).ele(connEle));
                end
            end
            if isequal(getType(connEle), 'OneJunction') && bg.fixedJuncList(bg.node(connEle).index) == 1
                if  bg.node(connEle).hybrid == 1
                    DBConnEle = bg.hybridJuncFixedDBList(bg.node(connEle).index) ;
                else
                    DBConnEle = bg.determiningBonds(bg.node(connEle).index);
                end
                if DBConnEle == bg.junc(bg.node(connEle).index).ele(juncNum)
                    cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(bg.node(juncNum).index).ele(connEle));
                end
            end
            if isequal(getType(connEle),'TF')
                connConnEle = getConnConnElement(connEle, juncNum);
                if isequal(getType(connConnEle), 'ZeroJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle ~= bg.junc(bg.node(connConnEle).index).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(bg.node(connConnEle).index).ele(connEle));
                    end
                end
                if isequal(getType(connConnEle), 'OneJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle == bg.junc(bg.node(connConnEle).index).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(bg.node(connConnEle).index).ele(connEle));
                    end
                end
            end
            if isequal(getType(connEle),'GY')
                connConnEle = getConnConnElement(connEle, juncNum);
                if isequal(getType(connConnEle), 'ZeroJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle == bg.junc(bg.node(connConnEle).index).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(bg.node(connConnEle).index).ele(connEle));
                    end
                end
                if isequal(getType(connConnEle), 'OneJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle ~= bg.junc(bg.node(connConnEle).index).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(bg.node(connConnEle).index).ele(connEle));
                    end
                end
            end
        elseif juncType == 0
            if isequal(getType(connEle),'Sf') || isequal(getType(connEle),'I')
                cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(bg.node(juncNum).index).ele(connEle));
            end
            if isequal(getType(connEle), 'ZeroJunction') && bg.fixedJuncList(bg.node(connEle).index) == 1
                if  bg.node(connEle).hybrid == 1
                    DBConnEle = bg.hybridJuncFixedDBList(bg.node(connEle).index) ;
                else
                    DBConnEle = bg.determiningBonds(bg.node(connEle).index);
                end
                if DBConnEle == bg.junc(bg.node(connEle).index).ele(juncNum)
                    cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(bg.node(juncNum).index).ele(connEle));
                end
            end
            if isequal(getType(connEle), 'OneJunction') && bg.fixedJuncList(bg.node(connEle).index) == 1
                if  bg.node(connEle).hybrid == 1
                    DBConnEle = bg.hybridJuncFixedDBList(bg.node(connEle).index) ;
                else
                    DBConnEle = bg.determiningBonds(bg.node(connEle).index);
                end
                if DBConnEle ~= bg.junc(bg.node(connEle).index).ele(juncNum)
                    cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(bg.node(juncNum).index).ele(connEle));
                end
            end
            if isequal(getType(connEle),'TF')
                connConnEle = getConnConnElement(connEle, juncNum);
                if isequal(getType(connConnEle), 'ZeroJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle == bg.junc(bg.node(connConnEle).index).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(bg.node(connConnEle).index).ele(connEle));
                    end
                end
                if isequal(getType(connConnEle), 'OneJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle ~= bg.junc(bg.node(connConnEle).index).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(bg.node(connConnEle).index).ele(connEle));
                    end
                end
            end
            if isequal(getType(connEle),'GY')
                connConnEle = getConnConnElement(connEle, juncNum);
                if isequal(getType(connConnEle), 'ZeroJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle ~= bg.junc(bg.node(connConnEle).index).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(bg.node(connConnEle).index).ele(connEle));
                    end
                end
                if isequal(getType(connConnEle), 'OneJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle == bg.junc(bg.node(connConnEle).index).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(bg.node(connConnEle).index).ele(connEle));
                    end
                end
            end
        end
    end
    bg.node(juncNum).cannotBeDBList = cannotBeDBListEle;
end












