function getBondsWhichCannotBeDB()
global bg;

% This function identifies bonds that can never be the determining bond of a junction

% bg.fixedJuncList = [];
% bg.hybridJuncFixedDBList = [];

% Generate a list of junctions that are not fixed
listOfJuncs = [];
for i = 1:bg.numNodes
    if isequal(bg.node(i).type, 'ZeroJunction') || isequal(bg.node(i).type, 'OneJunction')
        if bg.fixedJuncList(bg.node(i).index) ~=1
            listOfJuncs = listPush(listOfJuncs, i);
        end
    end
end

% For each unfixed junction in the list, figure out the bonds that cannot
% be their dbs: Make sure that this list contains the bond number for each
% junction
while ~isempty(listOfJuncs)
    [juncNum listOfJuncs] = listPop(listOfJuncs);
    cannotBeDBListEle = [];
    bg.node(juncNum).cannotBeDBList = [];
    juncType = getJuncType(juncNum);
    for i = 1:bg.node(juncNum).numBonds
        connEle = bg.node(juncNum).bond(i);
        if juncType == 1
            if isequal(getType(connEle),'Se') || isequal(getType(connEle),'C')
                cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(juncNum).ele(connEle));
            end
            if isequal(getType(connEle), 'ZeroJunction') && bg.fixedJuncList(bg.node(connEle).index) == 1
                if  bg.node(connEle).hybrid == 1
                    DBConnEle = bg.hybridJuncFixedDBList(bg.node(connEle).index) ;
                else
                    DBConnEle = bg.determiningBonds(bg.node(connEle).index);
                end
                if DBConnEle ~= bg.junc(connEle).ele(juncNum)
                    cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(juncNum).ele(connEle));
                end
            end
            if isequal(getType(connEle), 'OneJunction') && bg.fixedJuncList(bg.node(connEle).index) == 1
                if  bg.node(connEle).hybrid == 1
                    DBConnEle = bg.hybridJuncFixedDBList(bg.node(connEle).index) ;
                else
                    DBConnEle = bg.determiningBonds(bg.node(connEle).index);
                end
                if DBConnEle == bg.junc(connEle).ele(juncNum)
                    cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(juncNum).ele(connEle));
                end
            end
            if isequal(getType(connEle),'TF')
                connConnEle = getConnConnElement(connEle, juncNum);
                if isequal(getType(connConnEle), 'ZeroJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle ~= bg.junc(connConnEle).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(connConnEle).ele(connEle));
                    end
                end
                if isequal(getType(connConnEle), 'OneJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle == bg.junc(connConnEle).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(connConnEle).ele(connEle));
                    end
                end
            end
            if isequal(getType(connEle),'GY')
                connConnEle = getConnConnElement(connEle, juncNum);
                if isequal(getType(connConnEle), 'ZeroJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle == bg.junc(connConnEle).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(connConnEle).ele(connEle));
                    end
                end
                if isequal(getType(connConnEle), 'OneJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle ~= bg.junc(connConnEle).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(connConnEle).ele(connEle));
                    end
                end
            end
        elseif juncType == 0
            if isequal(getType(connEle),'Sf') || isequal(getType(connEle),'I')
                cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(juncNum).ele(connEle));
            end
            if isequal(getType(connEle), 'ZeroJunction') && bg.fixedJuncList(bg.node(connEle).index) == 1
                if  bg.node(connEle).hybrid == 1
                    DBConnEle = bg.hybridJuncFixedDBList(bg.node(connEle).index) ;
                else
                    DBConnEle = bg.determiningBonds(bg.node(connEle).index);
                end
                if DBConnEle == bg.junc(connEle).ele(juncNum)
                    cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(juncNum).ele(connEle));
                end
            end
            if isequal(getType(connEle), 'OneJunction') && bg.fixedJuncList(bg.node(connEle).index) == 1
                if  bg.node(connEle).hybrid == 1
                    DBConnEle = bg.hybridJuncFixedDBList(bg.node(connEle).index) ;
                else
                    DBConnEle = bg.determiningBonds(bg.node(connEle).index);
                end
                if DBConnEle ~= bg.junc(connEle).ele(juncNum)
                    cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(juncNum).ele(connEle));
                end
            end
            if isequal(getType(connEle),'TF')
                connConnEle = getConnConnElement(connEle, juncNum);
                if isequal(getType(connConnEle), 'ZeroJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle == bg.junc(connConnEle).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(connConnEle).ele(connEle));
                    end
                end
                if isequal(getType(connConnEle), 'OneJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle ~= bg.junc(connConnEle).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(connConnEle).ele(connEle));
                    end
                end
            end
            if isequal(getType(connEle),'GY')
                connConnEle = getConnConnElement(connEle, juncNum);
                if isequal(getType(connConnEle), 'ZeroJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle ~= bg.junc(connConnEle).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(connConnEle).ele(connEle));
                    end
                end
                if isequal(getType(connConnEle), 'OneJunction') && bg.fixedJuncList(bg.node(connConnEle).index) == 1
                    if  bg.node(connConnEle).hybrid == 1
                        DBConnConnEle = bg.hybridJuncFixedDBList(bg.node(connConnEle).index) ;
                    else
                        DBConnConnEle = bg.determiningBonds(bg.node(connConnEle).index);
                    end
                    if DBConnConnEle == bg.junc(connConnEle).ele(connEle)
                        cannotBeDBListEle = listPush(cannotBeDBListEle, bg.junc(connConnEle).ele(connEle));
                    end
                end
            end
        end
    end
    bg.node(juncNum).cannotbeDBList = cannotBeDBListEle;
end




