#define S_FUNCTION_NAME callCausalityUpdate
#define S_FUNCTION_LEVEL 2
#include "simstruc.h"

static void mdlInitializeSizes(SimStruct *S)
{
    const real_T *numStates;    

    ssSetNumSFcnParams(S, 1);  /* Number of expected parameters */
    if (ssGetNumSFcnParams(S) != ssGetSFcnParamsCount(S)) {
        /* Return if number of expected != number of actual parameters */
        return;
    }
    
    numStates = mxGetPr(ssGetSFcnParam(S,0));

    ssSetNumContStates(S, 0);
    ssSetNumDiscStates(S, *numStates);

    if (!ssSetNumInputPorts(S, 3)) return;
    ssSetInputPortWidth(S, 0, DYNAMICALLY_SIZED);
	ssSetInputPortRequiredContiguous(S, 0, true);
	ssSetInputPortDirectFeedThrough(S, 0, 1);
	ssSetInputPortWidth(S, 1, DYNAMICALLY_SIZED);
	ssSetInputPortRequiredContiguous(S, 1, true);
	ssSetInputPortDirectFeedThrough(S, 1, 1);
	ssSetInputPortWidth(S, 2, DYNAMICALLY_SIZED);
	ssSetInputPortRequiredContiguous(S, 2, true);
	ssSetInputPortDirectFeedThrough(S, 2, 1);
	
    if (!ssSetNumOutputPorts(S, 1)) return;
    ssSetOutputPortWidth(S, 0, DYNAMICALLY_SIZED);    
    
    ssSetNumSampleTimes(S, 1);

    ssSetOptions(S, 0);
}



static void mdlInitializeSampleTimes(SimStruct *S)
{
    ssSetSampleTime(S, 0, INHERITED_SAMPLE_TIME);
    ssSetOffsetTime(S, 0, 0.0);
}



#define MDL_INITIALIZE_CONDITIONS   /* Change to #undef to remove function */
#if defined(MDL_INITIALIZE_CONDITIONS)
  static void mdlInitializeConditions(SimStruct *S)
  {
    const real_T *init = (const real_T*) ssGetInputPortSignal(S,0);
	real_T *db0 = ssGetRealDiscStates(S);
	int i;
	for (i=0; i<ssGetInputPortWidth(S,0); i++) {
	    db0[i] = init[i];
    }
  }
#endif /* MDL_INITIALIZE_CONDITIONS */



#define MDL_START  /* Change to #undef to remove function */
#if defined(MDL_START) 
  static void mdlStart(SimStruct *S)
  {
  }
#endif /*  MDL_START */



static void mdlOutputs(SimStruct *S, int_T tid)
{
    real_T *db = ssGetRealDiscStates(S);    
    real_T *dbOut = ssGetOutputPortSignal(S,0);
    int i;
    for (i=0; i<ssGetInputPortWidth(S,0); i++) {
        dbOut[i]=db[i];
    }
}



#define MDL_UPDATE  /* Change to #undef to remove function */
#if defined(MDL_UPDATE)
static void mdlUpdate(SimStruct *S, int_T tid)
{
    real_T *db = ssGetRealDiscStates(S);
    const real_T *onguard = (const real_T*) ssGetInputPortSignal(S,1);
    const real_T *offguard = (const real_T*) ssGetInputPortSignal(S,2);
    
    double *dbdata;
    const mxArray *determiningbonds;
    mxArray *rhs;
    
    int i;
    int change = 0;
    
    /* for each db */
    for (i=0; i<ssGetInputPortWidth(S,0); i++) {
        /* if junction on and offguard true, or off and onguard true, must update */
        if ( (db[i]!=0 && offguard[i]==1)){
            db[i] = -3; /* Junction switched off */
            change = 1;
        }
        else if ((db[i]==0 && onguard[i]==1) ) {
            db[i]=-2; /* Junction switched on */
            change = 1;
        }
    }
    
    /* call CausalityUpdate */
    if (change) {
        /* call causality update */
        rhs = mxCreateDoubleMatrix(ssGetInputPortWidth(S,0), 1, mxREAL);
        for (i=0; i<ssGetInputPortWidth(S,0); i++) {
            mxGetPr(rhs)[i]=db[i];
        }
        mexCallMATLAB(0,NULL,1,&rhs,"causalityUpdate");                
    
        /* get new db and update */
        determiningbonds = mexGetVariablePtr("global", "determiningBonds");    
        if (determiningbonds == NULL){
            mexErrMsgTxt("causalityUpdate could not get determiningbonds variable.");
        }
        dbdata = mxGetPr(determiningbonds);
        for (i=0; i<ssGetInputPortWidth(S,0); i++) {
            db[i]=dbdata[i];
        }
    }
    else {
        /* db remains same */
        for (i=0; i<ssGetInputPortWidth(S,0); i++) {
            db[i] = db[i];
        }
    }
    
    
}
#endif /* MDL_UPDATE */



#define MDL_DERIVATIVES  /* Change to #undef to remove function */
#if defined(MDL_DERIVATIVES)
  static void mdlDerivatives(SimStruct *S)
  {
  }
#endif /* MDL_DERIVATIVES */



static void mdlTerminate(SimStruct *S)
{
}


#ifdef  MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */
#include "simulink.c"      /* MEX-file interface mechanism */
#else
#include "cg_sfun.h"       /* Code generation registration function */
#endif
