%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Discover subsystem interface: input/output numbers and names.
% 
% Author: Zsolt Lattmann (lattmann@isis.vanderbilt.edu)
%
% Date: 2011/05/08 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fprintf('Discover subsystem interface\n');
fileName = 'Discover_Model_Interface.tmp';
OutputFileNameInputs = 'Discover_Model_Interface_Inputs.txt';
OutputFileNameOutputs = 'Discover_Model_Interface_Outputs.txt';

fprintf('Attempt to open the Discover_Model_Interface.tmp file for reading.\n');
% attempt to open the file for reading
fid = fopen(fileName, 'r');
if fid == -1
    error('Could not read inputs from %s\n', fileName);
    return
end

% read all the lines
lines = {};
line = fgetl(fid);
j = 1;
while ischar(line)
    lines{j} = line;
    j = j + 1;
    line = fgetl(fid);
end
fclose(fid);

if isempty(lines)
    error('There is no specified system in file: %s\n', fileName);
    return
end

if length(lines) > 1
    error(['The number of specified system in file: %s is more than one. ' ...
      'Please specify exactly one system in the first line.\n'], fileName);
    return
end

SubsystemPath = lines{1};
idx = strfind(SubsystemPath, '/');

ModelName     = SubsystemPath(1:min(idx) - 1);   % mdl file name
SubsystemName = SubsystemPath(max(idx) + 1:end); % current system name
SubsystemPath = SubsystemPath(1:max(idx) - 1);   % full path without name

numIn  = 0; % count number of input ports
numOut = 0; % count number of output ports

InputPortNames    = []; % input port names array
InputPortNumbers  = []; % input port numbers array
OutputPortNames   = []; % output port names array
OutputPortNumbers = []; % output port numbers array

load_system(ModelName); % load the system /mdl file/

S = sfroot;
B = S.find('-isa','Simulink.SubSystem'); % find all subsystems
for i=1 : 1 : B.size(1)
  % iterate through the subsystems
  if strcmp([B(i).Path '/' B(i).Name], [SubsystemPath '/' SubsystemName])
    % check the path and the name
    fprintf(' Found Location (%s).\n', B(i).Name);
    C = B(i).find('-isa','Simulink.Inport'); % get all inports
    for ii=1 : 1 : C.size(1)
      % iterate through the inports
      if strcmp(C(ii).Path, [SubsystemPath '/' SubsystemName])
        % select only those, which are on the 1st 'level'
        numIn = numIn + 1; % count it
        % store name and number in a string array
        InputPortNames = cellstr([InputPortNames; C(ii).Name]);        
        InputPortNumbers = cellstr([InputPortNumbers; C(ii).Port]);
      end
    end
    C = B(i).find('-isa','Simulink.Outport'); % get all Outports
    for ii=1 : 1 : C.size(1)
      % iterate through the outports
      if strcmp(C(ii).Path, [SubsystemPath '/' SubsystemName])  
        % select only those, which are on the 1st 'level'
        numOut = numOut + 1; % count it
        % store name and number in a string array
        OutputPortNames = cellstr([OutputPortNames; C(ii).Name]);
        OutputPortNumbers = cellstr([OutputPortNumbers; C(ii).Port]);
      end
    end  
  end
end

% open output file
fid = fopen(OutputFileNameInputs, 'w');
if fid == -1
    error('Could not write sample data to %s\n', OutputFileNameInputs);    
end

% write the labels %NAME%/%PORTNUMBER%
for j = 1:length(InputPortNames)
    fprintf(fid, '%s/%s\n', ...
      strrep(InputPortNames{j},sprintf('\n'),'_'), ... % replace enters
      InputPortNumbers{j});
end

fclose(fid);

% open output file
fid = fopen(OutputFileNameOutputs, 'w');
if fid == -1
    error('Could not write sample data to %s\n', OutputFileNameOutputs);    
end

% write the labels %NAME%/%PORTNUMBER%
for j = 1:length(OutputPortNames)
    fprintf(fid, '%s/%s\n', ...
      strrep(OutputPortNames{j},sprintf('\n'),'_'), ... % replace enters
      OutputPortNumbers{j});
end

fclose(fid);
exit;