%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Resize a subsystem based on the # of inputs and outputs. This script
% also use the length of the port names. The original X1 and Y1 remain the
% same (top-left corner).
% 
% Author: Zsolt Lattmann (lattmann@isis.vanderbilt.edu)
%
% Date: 2011/05/07
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [] = ResizeSubsystems( SubsystemPath )
%ResizeSubsystems Summary of this function goes here
%   Detailed explanation goes here

idx = strfind(SubsystemPath, '/');

ModelName     = SubsystemPath(1:min(idx) - 1);   % mdl file name
SubsystemName = SubsystemPath(max(idx) + 1:end); % current system name
SubsystemPath = SubsystemPath(1:max(idx) - 1);   % full path without name

load_system(ModelName); % load the system /mdl file/

% fprintf('Resize subsystem: %s/%s\n', ...
%   SubsystemPath, ...
%   SubsystemName);

maxLengthIn  = 0; % character length of the longest input name
maxLengthOut = 0; % character length of the longest output name

numIn  = 0; % count number of input ports
numOut = 0; % count number of output ports

S = sfroot;
B = S.find('-isa','Simulink.SubSystem'); % find all subsystems
for i=1 : 1 : B.size(1)
  % iterate through the subsystems
  if strcmp([B(i).Path '/' B(i).Name], [SubsystemPath '/' SubsystemName])
     % check the path and the name
%     fprintf(' Found Location (%s): %d %d %d %d\n', ...
%       B(i).Name, ...
%       B(i).Position(1), ...
%       B(i).Position(2), ...
%       B(i).Position(3), ...
%       B(i).Position(4));
    
    C = B(i).find('-isa','Simulink.Inport'); % get all inports
    for ii=1 : 1 : C.size(1)
      % iterate through the inports
      if strcmp(C(ii).Path, [SubsystemPath '/' SubsystemName])
        % select only those, which are on the 1st 'level'
        numIn = numIn + 1;  % count it
        if maxLengthIn < length(C(ii).Name)
          maxLengthIn = length(C(ii).Name);
          %fprintf(' In: %s %d\n', C(ii).Name, maxLengthIn);
        end        
      end
    end
    C = B(i).find('-isa','Simulink.Outport'); % get all Outports
    for ii=1 : 1 : C.size(1)
      % iterate through the outports
      if strcmp(C(ii).Path, [SubsystemPath '/' SubsystemName]) 
        % select only those, which are on the 1st 'level'
        numOut = numOut + 1; % count it
        if maxLengthOut < length(C(ii).Name)
          maxLengthOut = length(C(ii).Name);
          %fprintf(' Out: %s %d\n', C(ii).Name, maxLengthOut);
        end
      end
    end    
    
    % get the greater port number
    if numIn > numOut
      maxPort = numIn;
    else
      maxPort = numOut;
    end
    
    % the subsystem has a minimum size
    if maxPort < 3
      maxPort = 0;
    else
      maxPort = maxPort - 2;
    end
    
    maxLength = maxLengthIn + maxLengthOut; % get the max length
    % the subsystem has a minimum size
    if maxLength < 10
      maxLength = 0;
    else
      maxLength = maxLength - 10;
    end    
    
    % the subsystem has a minimum size Width:80 by Height:50
    B(i).Position(3) = B(i).Position(1) + 80 + maxLength*5; % 5 by each char
    B(i).Position(4) = B(i).Position(2) + 50 + maxPort*9; % 9 by each port
    
%     fprintf(' New Location (%s): %d %d %d %d\n', ...
%       B(i).Name, ...
%       B(i).Position(1), ...
%       B(i).Position(2), ...
%       B(i).Position(3), ...
%       B(i).Position(4));
  end
end

end

