% THIS COULD NOT BE A FUNCTION!
global responseNames;
global sysName;

disp('=== Saving simulation results... ===');
% variables
HtmlDirectory = 'html';
PlotsSubDirectory = 'plots';

PlotDirectory = [HtmlDirectory '/' PlotsSubDirectory];

% make output directory for the logged data
mkdir(HtmlDirectory);
mkdir(PlotDirectory);


%% Scopes
% match format: id_XXXX_XXXXXXXX where X is a hexadecimal number
data = whos('-regexp', '(id_([0-9]|[a-f]|[A-F]){4}_([0-9]|[a-f]|[A-F]){7}){1}'); % get logged scope data

scopes = [];

% get scopes from the model
S = sfroot;
B = S.find('-isa','Simulink.Scope'); % find all subsystems
for i=1 : 1 : B.size(1)
    if strncmp(B(i).Path, sysName, length(sysName))
        scopes = [scopes; containers.Map({B(i).SaveName}, {B(i).Name})];
    end
end


for i=1:1:length(data)
    % get one dataset
    expr = sprintf('%s.signals.values', data(i).name);
    eval(['tmp_values = ' expr ';']);
    expr = sprintf('%s.time', data(i).name);
    eval(['tmp_time = ' expr ';']);

    dataName = lower(regexprep(data(i).name, '_', '-'));
    
    % save the dataset into json format
    jsonFile = fopen([PlotDirectory '/' dataName '.js'], 'w');
    
    if jsonFile ~= -1
        fprintf(jsonFile, '{\r\n');
        fprintf(jsonFile, ['    "label": "' scopes(data(i).name) '",\r\n']);
        fprintf(jsonFile, ['    "id"   : "' dataName '",\r\n']);
        fprintf(jsonFile, '    "unit" : "?unit?",\r\n');
        fprintf(jsonFile, '    "data" : [');
        
        for k=1:1:length(tmp_time)
            fprintf(jsonFile, '[%d, %d]', tmp_time(k), tmp_values(k));
            if k < length(tmp_time)
                fprintf(jsonFile, ',');
            end
        end
        
        fprintf(jsonFile,']\r\n');
        fprintf(jsonFile,'}\r\n');   
        fclose(jsonFile);
        disp([PlotDirectory '/' dataName '.js' ' saved.']);
    end
end

%% Metrics
for i=1:1:length(responseNames)
    
    expr = sprintf('%s.signals.values', responseNames{i});
    eval(['tmp_values = ' expr ';']);
    expr = sprintf('%s.time', responseNames{i});
    eval(['tmp_time = ' expr ';']);
    
    % save the dataset into json format
    jsonFile = fopen([PlotDirectory '/' responseNames{i} '.js'], 'w');
    
    if jsonFile ~= -1
        fprintf(jsonFile, '{\r\n');
        fprintf(jsonFile, ['    "label": "' responseNames{i} '",\r\n']);
        fprintf(jsonFile, ['    "id"   : "' responseNames{i} '",\r\n']);
        fprintf(jsonFile, '    "unit" : "?unit?",\r\n');
        fprintf(jsonFile, '    "data" : [');
        
        for k=1:1:length(tmp_time)
            fprintf(jsonFile, '[%d, %d]', tmp_time(k), tmp_values(k));
            if k < length(tmp_time)
                fprintf(jsonFile, ',');
            end
        end
        
        fprintf(jsonFile,']\r\n');
        fprintf(jsonFile,'}\r\n');   
        fclose(jsonFile);
        disp([PlotDirectory '/' responseNames{i} '.js' ' saved.']);
    end  
end

disp('=== Simulation results were saved. ===');
