%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Summary: Builds Simulink model based on generated files.
% 
% Usage:
%  (0) Start it from MatLab
%  Go to the output directory, which contains the generated script files.
%  >> build_model
%
%
%% Author: Zsolt Lattmann (lattmann@isis.vanderbilt.edu)
%
%% Date: 2011/10/10 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
try
    
    if exist('_FAILED.txt', 'file')        
        delete('_FAILED.txt');
    end    
    
    FileExistMDAO = exist('MDAO_Init.m', 'file');    
    if FileExistMDAO ~= 0
      MDAO_Init;
      FileExistScript = exist([sysName '_buildscript.m'], 'file');      
      if FileExistMDAO ~= 0
        eval([sysName '_buildscript']);
        save_system(sysName);
        close_system(sysName);
      else
        disp([sysName '_buildscript.m  does not exist']);
      end
    else
      disp('MDAO_Init.m does not exist');
      exception = MException('FileNotFound', ...
      'MDAO_Init.m was not found.');
      throw(exception);
    end

catch ex
    fileName = '_FAILED.txt';
    fid = fopen(fileName, 'w');
    if fid == -1
        error('Could not write sample data to %s\n', fileName);    
    end
    fprintf(fid, '%s', getReport(ex, 'extended'));
    fclose(fid); 
end
