%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Summary: Builds Simulink models based on generated files.
% 
% Usage:
%  (0) Start it from MatLab
%  Go to the output directory, which contains several subdirectories w
%  >> build_models
%
%
%% Author: Zsolt Lattmann (lattmann@isis.vanderbilt.edu)
%
%% Date: 2011/08/19 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all;
clc;
starttime = tic;
disp('Starting build process.');
%matlabpool open local
dirEntries = dir;
for i=3:length(dirEntries)
  dirEntry = [dirEntries(i).name '/Dynamics interpreter'];
  disp(dirEntry);
  if isdir(dirEntry) == 1
    eval(['cd ''' dirEntry '''']);
    dir;
    save __tmp__.mat
    FileExistMDAO = exist('MDAO_Init.m', 'file');    
    if FileExistMDAO ~= 0
      MDAO_Init;
      FileExistScript = exist([sysName '_buildscript.m'], 'file');      
      if FileExistMDAO ~= 0
        eval([sysName '_buildscript']);
        run_model;
        % copy metrics
        %copyfile('Metrics.xml', ['../../Metrics_' ConfigurationID '.xml']);
      else
        disp([sysName '_buildscript.m  does not exist']);
      end
    else
      disp('MDAO_Init.m does not exist');
    end
    load __tmp__.mat
    delete __tmp__.mat
    copyfile('Metrics.xml', ['../../Metrics_' dirEntries(i).name '.xml']);
    eval('cd ..');
    eval('cd ..');
  end
end
%matlabpool close
clc;
disp('Done.');
endtime = tic;
%disp(endtime - starttime);