function [] = generateXML(result)

global ConfigurationID;
global MetricIDs;
global responseNames;


docNode = com.mathworks.xml.XMLUtils.createDocument... 
    ('RootObject');

docRootNode = docNode.getDocumentElement;
%docRootNode.setAttribute('attr_name','attr_value');
%docRootNode.appendChild(docNode.createComment('this is a comment'));
thisConfigurations = docRootNode.appendChild(docNode.createElement('Configurations'));
thisConfiguration = thisConfigurations.appendChild(docNode.createElement('Configuration'));
thisConfiguration.setAttribute('ID', ConfigurationID);
for i=MetricIDs.keys
    thisMetric = thisConfiguration.appendChild(docNode.createElement('ConfigMetric'));
    thisMetric.setAttribute('DefID', MetricIDs(i{1}));    
    eval(['value = result.find(''' i{1} ''').signals.values(end);']);
    thisMetric.setAttribute('Value', sprintf('%d', value));
end

tempname = 'Metrics';
xmlFileName = [tempname,'.xml'];
xmlwrite(xmlFileName,docNode);
%type(xmlFileName);


%% OLD VERSION
docNode = com.mathworks.xml.XMLUtils.createDocument... 
    ('Configurations');

docRootNode = docNode.getDocumentElement;
%docRootNode.setAttribute('attr_name','attr_value');
%docRootNode.appendChild(docNode.createComment('this is a comment'));

thisConfiguration = docRootNode.appendChild(docNode.createElement('Configuration'));
thisConfiguration.setAttribute('ID', ConfigurationID);
for i=MetricIDs.keys
    thisMetric = thisConfiguration.appendChild(docNode.createElement('ConfigObject'));
    thisMetric.setAttribute('ID', MetricIDs(i{1}));
    thisMetric.setAttribute('Name', i);
    eval(['value = result.find(''' i{1} ''').signals.values(end);']);
    thisMetric.setAttribute('Value', sprintf('%d', value));
end

tempname = 'outputs';
xmlFileName = [tempname,'.xml'];
xmlwrite(xmlFileName,docNode);
%type(xmlFileName);



