%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Discover MDAO input and output variable names in the specified models.
% 
% Author: Zsolt Lattmann (lattmann@isis.vanderbilt.edu)
%
% Date: 2011/05/06 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Input_System_Names = [];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fprintf('Discover_MDAO_Inputs_Outputs\n');
fileName = 'Discover_Systems.tmp';
fprintf('Attempt to open the Discover_Systems.tmp file for reading.\n');
% attempt to open the file for reading
fid = fopen(fileName, 'r');
if fid == -1
    error('Could not read inputs from %s\n', fileName);
    return
end

% read all the lines
lines = {};
line = fgetl(fid);
j = 1;
while ischar(line)
    lines{j} = line;
    j = j + 1;
    line = fgetl(fid);
end
fclose(fid);

if isempty(lines)
    error('There is no specified system in file: %s\n', fileName);
    return
end

fprintf('%d system names read successfully.\n', length(lines));
% read values
for i=1:length(lines)
    Input_System_Names = [Input_System_Names lines(i)];
end

OutputFileName = 'Discover_MDAO_Outputs_Default.txt';
OutputFileName2 = 'Discover_MDAO_Inputs_Default.txt';

Output_Names = [];
Input_Names = [];

idx_out = 1;
idx_in = 1;

% iterate through all the systems
for name_idx = 1:length(Input_System_Names)
    % load current system
    CurrentSysFullName = Input_System_Names{name_idx};
    parse_index = strfind(CurrentSysFullName, '/');
    CurrentSys = CurrentSysFullName(1:parse_index(1)-1);
    fprintf(' Load system (%d): %s\n', name_idx, CurrentSys);
    load_system(CurrentSys);

    % search for To Workspace blocks
    S = sfroot;
    A = S.find('-isa','Simulink.SubSystem');
    B = A.find('-isa','Simulink.ToWorkspace');
    for i=1 : 1 : B.size(1)
      if strncmp(B(i).Path, CurrentSysFullName, length(CurrentSysFullName))
        fprintf('  Output name detected (%d): %s\n', idx_out, B(i).VariableName);
        idx_out = idx_out +1;
        Output_Names = [Output_Names cellstr(B(i).VariableName)];        
      end
    end
    B = A.find('-isa','Simulink.Constant');
    for i=1 : 1 : B.size(1)
      if strncmp(B(i).Path, CurrentSysFullName, length(CurrentSysFullName))
        if (isempty(str2num(B(i).Value)))
          % support only 2 argument such as: arg1*2 or agr1*agr2 or 5-arg1
          [token remain] = strtok(B(i).Value, '/*+-^');
          if (isempty(str2num(token)))
            fprintf('  Input name detected (%d): %s\n', idx_in, token);
            idx_in = idx_in + 1;
            Input_Names = [Input_Names cellstr(token)];              
          end
          if length(remain) > 1
            remain = remain(2:end); % leave the first char out
            if (isempty(str2num(remain)))
                fprintf('  Input name detected (%d): %s\n', idx_in, remain);
                idx_in = idx_in + 1;
                Input_Names = [Input_Names cellstr(token)];               
         	end            
          end           
        end
      end
    end    
end
fprintf('End of automatic detection process.\n');

% open output file
fid = fopen(OutputFileName, 'w');
if fid == -1
    error('Could not write sample data to %s\n', OutputFileName);    
end

% write the labels
for j = 1:length(Output_Names)
    fprintf(fid, '%s\n', Output_Names{j});
end

fclose(fid);
fprintf('Wrote discovered (%d) outputs to %s file\n', length(Output_Names) , OutputFileName);

% open output file
fid = fopen(OutputFileName2, 'w');
if fid == -1
    error('Could not write sample data to %s\n', OutputFileName2);    
end

% write the labels
for j = 1:length(Input_Names)
    fprintf(fid, '%s\n', Input_Names{j});
end

fclose(fid);
fprintf('Wrote discovered (%d) inputs to %s file\n', length(Input_Names) , OutputFileName2);

exit;