% [Zsolt Lattmann 2011-03-21]
% Build script for generating the executable model

global sysName;
global FunctionsToCompile;
global Parameters;
global StopTime;

clc;
%clear all;

% MDAO Init contains:
% sysName : current system name
% Parameters : parameters for the MDAO: in 'p1,p2,p3' format
% StopTime : simulation stop time
MDAO_Init;

load_system(sysName);

set_param(sysName, 'StopTime', StopTime);

set_param(sysName, 'InlineParams', 'on');

TunableParams = [];
StorageClass = [];
TypeQualifier = [];
for i=1:length(Parameters)
    if i ~= 1
        TunableParams = [sprintf('%s',TunableParams) ','];
        StorageClass = [sprintf('%s',StorageClass) ','];
        TypeQualifier = [sprintf('%s',TypeQualifier) ','];
    else
        TypeQualifier = '';
    end
    TunableParams = [sprintf('%s',TunableParams) Parameters{i}];
    StorageClass = [sprintf('%s',StorageClass) 'auto'];    
    
end

set_param(sysName, 'TunableVars', TunableParams);
set_param(sysName, 'TunableVarsStorageClass', StorageClass);
set_param(sysName, 'TunableVarsTypeQualifier', TypeQualifier);

set_param(sysName, 'RTWSystemTargetFile', 'rsim.tlc');
set_param(sysName, 'RTWTemplateMakefile', 'rsim_default_tmf');

% [ZL]
% We have to refresh the RTW target settings. I do not know how.
% The rtwbulid does the refresh, but if the param_struct is saved before that
% the check sum does not the same in the compiled model. This is the
% reason we need the rtwrebulid.

% compile the model
rtwbuild(sysName)

% create tuneable param_struct based on the model's parameters
param_struct = rsimgetrtp(sysName, 'AddTunableParamInfo', 'on');
save param_struct.mat param_struct

rtwrebuild(sysName)

txtCompiling = sprintf('Compiling the program and building the %s_Wrapper.exe ...', sysName);
disp(txtCompiling)

sourceFiles = {'wrapper.m', ...
               'readInfile.m', ...
               'writeOutfile.m', ...               
               'MDAO_Init.m'};
sourceFiles = [sourceFiles FunctionsToCompile];

outputFileName = [sysName, '_Wrapper'];

% Compiles the program. "wrapper" is the entry point
mcc('-m', sourceFiles{:}, '-o',outputFileName);

txtFinished = sprintf('Finished building %s_Wrapper.exe\n', sysName);
fprintf(txtFinished);

fprintf('Create a sample/template inputfile with 2 input vectors\n');
% Create a sample/template inputfile with 2 input vectors
% attempt to open the file for writing
fileName = 'testInputSample.txt';
fid = fopen(fileName, 'w');
if fid == -1
    error('Could not write sample data to %s\n', fileName);    
end

% write the labels
for j = 1:length(Parameters)
    fprintf(fid, '%-18s', Parameters{j});
    if j < length(Parameters)
        fprintf(fid, ' ');
    else
        fprintf(fid, '\n');
    end
end

% write 2 lines of the sample data
for i = 1:2
    for j=1:length(Parameters)
        fprintf(fid, '%16.10e', j*i);
        if j < length(Parameters) 
            fprintf(fid, '  ');
        else
            fprintf(fid, '\n');
        end
    end
end

fclose(fid);
fprintf('Wrote sample data to %s\n', fileName);
fprintf('Build script has successfully finished and all files are generated/compiled.\n');
 