function [ModelParameters] = readInfile(fileName)
% [Zsolt Lattmann 2011-03-21]
% modifications have been applied to make this function more generic
global Parameters;

% attempt to open the file for reading
fid = fopen(fileName, 'r');
if fid == -1
    error('could not read inputs from %s\n', fileName);
    return
end

% read all the lines
lines = {};
line = fgetl(fid);
j = 1;
while ischar(line)
    lines{j} = line;
    j = j + 1;
    line = fgetl(fid);
end
fclose(fid);

m = length(lines);
if m < 2
    ModelParameters = [];
    return
end

% attempt to figure out which columns have the data
names = regexp(lines{1}, '\w*', 'match');
if length(names) ~= length(Parameters)
    ParaNames = [];
    for i=1:length(Parameters)
        if i ~= 1
            ParaNames = [sprintf('%s',ParaNames) ','];
        end
    ParaNames = [sprintf('%s',ParaNames) Parameters{i}];
    end
    error('expected exactly %d response types (%s); found "%s"\n', length(Parameters), ParaNames, lines{1})
end

labels = Parameters; % contains the labels of the parameters
cols = repmat(NaN, length(labels), 1);
for i = 1:length(labels)
    for j = 1:length(names)
        if strcmp(labels{i}, names{j})
            cols(i) = j;
            break
        end
    end
end

for i = 1:length(labels)
    if isnan(cols(i))
        error('could not find input for %s\n', labels{i});
    end
end

% read values
ModelParameters = repmat(NaN, m - 1, length(Parameters));
for i=2:length(lines)
    values = regexp(lines{i}, '[\d\.\w\+\-]*', 'match');
    if length(values) ~= length(labels)
        fprintf('skipping inputs on line %d: found %d values (expected %d)\n', ...
                i, length(values), length(labels));
        continue
    end
    for j = 1:length(values)
        v = str2double(values(j));
        if isnan(v)
            fprintf('line %d had errors: %s\n', i, lines{i});
        end
        ModelParameters(i - 1, cols(j)) = v;
    end
end