function [modelParameters, responseNames, responseValues] = wrapper(inFile, outFile)

% john-paul.n.sabino@boeing.com (2011 MAR 9)
%
% First, I opened Simulink and went into the Simulation -> [Configuration 
% Parameters] dialog box for the RLC model. I went to the optimization pane
% and turned on the "Inline parameters" option. I clicked the "Configure"
% button and made the RValue, LValue, and CValue parameters global.
%
% Back in Matlab, I loaded the parameter structure with the following command:
% param_struct = rsimgetrtp('RLC', 'AddTunableParamInfo', 'on')
%
% Querying param_struct.parameters.map(1:3).Identifier showed that the
% variables of interest can be set with the following command:
% param_struct.parameters.values = [C L R];
%
% I saved the structure to a file.
%
% What we're going to do is load the file, overwrite the parameters with the
% user input, and run the model. The model will load the input structure,
% run, and save the output. We'll write the ouput to a file.
%
% To be able to load the parameters from a file, I had to change the RTW
% "system target file" to rsim.tlc (Rapid Simulation Target). This option
% can be found by following [Simulation -> Configuration Parameters -> Real
% Time Workshop] and selecting the Browse button next to "System target
% file."
%
% Design Explorer input / output requirements:
% http://math.web.boeing.com/software/DesignExplorer/main/training/onlineTM/DesignExplorerTM.1.041.html

% [Zsolt Lattmann 2011-03-21]
% modifications have been applied to make this function more generic

global Parameters;
global sysName;
global responseNames; %#ok<REDEF>
global PostFunction;
global simout;

tic
MDAO_Init; % parameter definitions
modelParameters = readInfile(inFile);
n = length(modelParameters(:,1));
%responseNames = {'f_peak'};
responseValues = repmat(NaN, n, length(responseNames));
fprintf('found %d sets of inputs\n', n);
for j=1:n

    % execute the script to load in data
    %RLC_datastruct 
    eval([sysName '_datastruct']);
    % load parameter structure
    load param_struct
    
    % overwrite values
    for k=1:length(modelParameters(1,:))
        param_struct.parameters.values(k) = modelParameters(j,k);
    end
    
    if any(isnan(param_struct.parameters.values))
        fprintf('input set %d had NA values; setting responses to NA\n', j);
        responseValues(j,:) = repmat(NaN, 1, size(responseValues, 2));
        continue
    end

    % save parameter structure to a new file
    save current_params param_struct

    % run the model with the new parameters
    fprintf('Evaluating set %d: ', j);
    for k=1:length(modelParameters(1,:))
        fprintf(' %s = %f', Parameters{k}, modelParameters(j,k));
        if k < length(modelParameters(1,:))
            fprintf(',');
        else
            fprintf('\n');
        end
    end   
       
    system([sysName ' -p current_params.mat']);

    result = load([sysName '.mat']);

    % find the center frequency    
    %simout = result.rt_simout;    
    returnValues = [];
    % assumption we have ONLY ONE PostFunction
    eval(['returnValues = ' PostFunction{1} '(result);']);   
%     if (returnValues.length > responseNames.length)
%         eval(['fprintf(''' returnValues.length ' = %d\n'', ' returnValues.length ')']);
%         eval(['fprintf(''' responseNames.length ' = %d\n'', ' responseNames.length ')']);
%         error(['ReturnValues are over defined in ' PostFunction{1} ' please correct it!'])
%     elseif (returnValues.length < responseNames.length)
%         eval(['fprintf(''' returnValues.length ' = %d\n'', ' returnValues.length ')']);
%         eval(['fprintf(''' responseNames.length ' = %d\n'', ' responseNames.length ')']); 
%         error(['ReturnValues are under defined in ' PostFunction{1} ' please correct it!'])
%     end
    
%     fprintf('responseNames length: %d, returnValues length: %d', ...
%             length(responseNames), ...
%             length(returnValues));

    for k=1:length(responseNames)
        eval([responseNames{k} ' = '  sprintf('%f',returnValues(k))]);
        eval(['fprintf(''' responseNames{k} ' = %f\n'', ' responseNames{k} ')']);
        %fprintf('fpeak = %f\n', f_peak);
        eval(['responseValues(' sprintf('%d',j) ',' sprintf('%d',k) ') = ' responseNames{k} ';']);
        %responseValues(j,1) = f_peak;
    end  
end

writeOutfile(outFile, responseNames, responseValues);
toc


