function writeOutfile(fileName, responseNames, responseValues)

% attempt to open the file for writing
fid = fopen(fileName, 'w');
if fid == -1
    error('could not write responses to %s\n', fileName);
    return
end

% check that dimensions are compatible
n = length(responseNames);
if n ~= size(responseValues, 2)
    error('%d response labels but there are values for %d responses\n', ...
          n, size(responseValues, 2));
    return
end

% write the labels
for j = 1:n
    fprintf(fid, '%-18s', responseNames{j});
    if j < n
        fprintf(fid, ' ');
    else
        fprintf(fid, '\n');
    end
end

% write the responses
m = size(responseValues, 1);
for i = 1:m
    for j=1:n
        v = responseValues(i,j);
        if isnan(v)
            fprintf(fid, '%18s', 'na');
        elseif v < 0.0
            fprintf(fid, '%16.10e', v);
        else
            fprintf(fid, ' %16.10e', v);
        end
        if j < n
            fprintf(fid, ' ');
        else
            fprintf(fid, '\n');
        end
    end
end

fclose(fid);
fprintf('wrote %d values for %d response types to %s\n', m, n, fileName);



