/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// MainDialog.cpp : implementation file
//

#include "MainDialog.h"
#include "afxdialogex.h"
#include "afxdlgs.h"

// MainDialog dialog

IMPLEMENT_DYNAMIC(MainDialog, CDialog)

MainDialog::MainDialog(CWnd* pParent /*=NULL*/)
	: CDialog(MainDialog::IDD, pParent),
	m_metricsFile(_T(""))
{

}

MainDialog::~MainDialog()
{
}

void MainDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_FILE  , m_metricsFile);
}


BEGIN_MESSAGE_MAP(MainDialog, CDialog)
	ON_BN_CLICKED(IDC_OK_BUTTON, &MainDialog::OnBnClickedOkButton)
	ON_BN_CLICKED(IDC_CANCEL_BUTTON, &MainDialog::OnBnClickedCancelButton)
	ON_BN_CLICKED(IDC_FILE_BUTTON, &MainDialog::OnBnClickedFileButton)
END_MESSAGE_MAP()


// MainDialog message handlers


void MainDialog::OnBnClickedOkButton()
{
	// TODO: Add your control notification handler code here
	this->UpdateData(1);
	
	if(m_metricsFile.IsEmpty())
		AfxMessageBox("You must specify the output directory.", MB_ICONINFORMATION );
	else
		this->OnOK();
}


void MainDialog::OnBnClickedCancelButton()
{
	// TODO: Add your control notification handler code here
	this->OnCancel();
}


void MainDialog::OnBnClickedFileButton()
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CFileDialog outputLoc = CFileDialog(1);
	int dialogReturn(outputLoc.DoModal());
	if (dialogReturn == IDOK) 
	{
		this->m_metricsFile = outputLoc.GetPathName();
		UpdateData(false);
	}
}
