/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "JsonHelper.h"

#include <boost\filesystem.hpp>
#include <boost\property_tree\ptree.hpp>
#include <boost\property_tree\json_parser.hpp>
#include <boost\foreach.hpp>
#include <boost\algorithm\string.hpp>
#include <sstream>

#include <fstream>
#include <iterator>
#include <boost/regex.hpp>
#include <string>
#include <iostream>

namespace isis_CADCommon
{

	void AddStepFileMappingToManufacturingManifest(
									const std::string &in_ManifestJson_PathAndFileName,
									const std::map<std::string, std::string> &in_ComponentInstanceId_to_StepFile_map,
									std::set<std::string> &out_ComponentInstanceIds_AddedToManifest ) 
															throw (isis::application_exception)
	{
		using boost::property_tree::ptree;
		//std::list<std::string> messages;
		try
		{
			boost::filesystem::path p(in_ManifestJson_PathAndFileName);
			if (boost::filesystem::exists(p))
			{
				if (boost::filesystem::is_regular_file(p))
				{
					std::string id = "";

					ptree pt;
					boost::property_tree::read_json(p.make_preferred().string(), pt);
					BOOST_FOREACH(ptree::value_type& child, pt.get_child("ComponentManufactureList")) 
					{
						//std::cout << child.second.get<string>("id") << "\n";
						id = child.second.get<std::string>("id");			

						if (id != "")
						{
							std::map<std::string, std::string>::const_iterator ci = in_ComponentInstanceId_to_StepFile_map.find(id);
							if (ci != in_ComponentInstanceId_to_StepFile_map.end())
							{
								child.second.put("STEPModel", ci->second);
								out_ComponentInstanceIds_AddedToManifest.insert(ci->first);
							}
						}
					}
					boost::property_tree::write_json(in_ManifestJson_PathAndFileName, pt);
					
				}
			}
			else
			{
				std::stringstream errorString;
				errorString << "Input file not found: " << in_ManifestJson_PathAndFileName;
				throw isis::application_exception(errorString.str().c_str());
			}
		}
		catch(const boost::property_tree::ptree_error &exc)
		{		
			std::stringstream errorString;
			errorString << "Input file processing error: " << in_ManifestJson_PathAndFileName 
						<< "  Error: " << exc.what();
			throw isis::application_exception(errorString.str().c_str());
		}
	}
}