/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef JSONHELPER_H
#define JSONHELPER_H

#include "isis_application_exception.h"
#include <string>
#include <list>
#include <map>
#include <set>


namespace isis_CADCommon
{
	/* Parses a json file specified by path. Populates the "STEPModel" tag based on "id" using key and value of the input stepFiles parameter.
	* @param	in_ManifestJson_PathAndFileName path/name to the json file (e.g. .\manufacturing.manifest.json) 
	* @param	in_ComponentInstanceId_to_StepFile_map map of component instance ID to step file name
	* @param	out_ComponentInstanceIds_AddedToManifest component instance IDs that were updated with the STEP file name in the manifest.
	*/
	void AddStepFileMappingToManufacturingManifest(
									const std::string &in_ManifestJson_PathAndFileName,
									const std::map<std::string, std::string> &in_ComponentInstanceId_to_StepFile_map,
									std::set<std::string> &out_ComponentInstanceIds_AddedToManifest ) 
															throw (isis::application_exception);

}

#endif