/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef MISCELLANEOUS_FUNCTIONS_H
#define MISCELLANEOUS_FUNCTIONS_H

#include <string>
#include <stdio.h>
#include <vector>

namespace isis_CADCommon
{

	std::string IntegerToString( int in_Integer);
	
	inline void tokenize_strtok(std::vector<std::string> &tokens, std::string input, std::string delimiters)
	{
		int wordCount = 0;
		char *nextWordPtr = NULL;
		char *context = NULL;

		nextWordPtr = strtok_s(&input[0], delimiters.c_str(), &context);		// split using space as divider
		while (nextWordPtr != NULL) 
		{
			tokens.push_back(nextWordPtr);
			nextWordPtr = strtok_s(NULL, delimiters.c_str(), &context);
		}
	}

	inline void stringTokenize(const std::string& str,
		std::vector<std::string>& tokens,
		std::string delimiters)
	{
		// Skip delimiters at beginning.
		std::string::size_type lastPos = str.find_first_not_of(delimiters, 0);
		// Find first "non-delimiter".
		std::string::size_type pos = str.find_first_of(delimiters, lastPos);

		while (	std::string::npos != pos || 	std::string::npos != lastPos)
		{
			// Found a token, add it to the vector.
			std::string substring=str.substr(lastPos, pos - lastPos);
			//LOGGER("SUBSTRING is %s",substring.c_str());
			//std::cout<<substring;
			tokens.push_back(substring);
			// Skip delimiters.  Note the "not_of"
			lastPos = str.find_first_not_of(delimiters, pos);
			// Find next "non-delimiter"
			pos = str.find_first_of(delimiters, lastPos);
		}
	}

}  // end namespace isis
#endif