/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "WindowsFunctions.h"
#include "Windows.h"
#include <sstream>
namespace isis_CADCommon
{
	std::string isis_GetCurrentDirectoryA()
	{
		char buffer[MAX_PATH+1];

		DWORD errorCode;

		errorCode = GetCurrentDirectoryA(MAX_PATH, buffer);

		if ( errorCode == 0 )
		{
				std::stringstream errorString;
				errorString <<
					"Function - GetCurrentDirectoryA, returned a zero error code, which indicates that the function failed.";
				throw isis::application_exception(errorString.str().c_str());			
		}
		
		return std::string(buffer);
	}

} // END namespace isis_CADCommon

