/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "WindowsHDependentCommonFunctions.h"
#include <Windows.h>


namespace isis
{

	///////////////////////////////////////////////////////////////////////////////////////////////////	
	bool DirectoryExists(const std::string& in_DirectoryName)
	{
		// http://stackoverflow.com/questions/8233842/how-to-check-if-directory-exist-using-c-and-winapi

		DWORD ftyp = GetFileAttributesA(in_DirectoryName.c_str());
		if (ftyp == INVALID_FILE_ATTRIBUTES) return false;  //something is wrong with your path!
		if (ftyp & FILE_ATTRIBUTE_DIRECTORY) return true;   // this is a directory!

	  return false;    // this is not a directory!
	}
	///////////////////////////////////////////////////////////////////////////////////////////////////
	


} // End namespace isis