/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef  WINDOWS_H_DEPENDENT_COMMON_FUNCTIONS_H
#define  WINDOWS_H_DEPENDENT_COMMON_FUNCTIONS_H

#include <string>

namespace isis
{

	///////////////////////////////////////////////////////////////////////////////////////////////////
	// If in_DirectoryName is an actual directory on the system
	//		then
	//			return true
	// If in_DirectoryName points to a file or points to nothing that exists in file system
	//		then
	//			return false
	//
	// If in_DirectoryName contains spaces, do NOT enclose the string in  parentheses.
	// Passing the following string will work:
	//		C:\Users\rowens\Documents\Microsoft Research
	//		e.g string myString =  "C:\\Users\\rowens\\Documents\\Microsoft Research"
	//
	//	Passing the following string will NOT work:
	//		"C:\\Users\\rowens\\Documents\\Microsoft Research\"
	//		e.g string myString = "\"C:\\Users\\rowens\\Documents\\Microsoft Research\""
	bool DirectoryExists(const std::string& in_DirectoryName);

}


#endif