/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include <AssembleComponents.h>

namespace isis
{



ProError AddComponentToAssembly( ProAssembly asm_model, 
							     ProSolid	 comp_model,
							     ProAsmcomp	*out_p_assembled_feat_handle) 
											throw (isis::application_exception)
{
	ProError status;

	ProMatrix identity_matrix = {{ 1.0, 0.0, 0.0, 0.0 }, 
								{0.0, 1.0, 0.0, 0.0}, 
								{0.0, 0.0, 1.0, 0.0}, 
								{0.0, 0.0, 0.0, 1.0}};
	ProAsmcomp asmcomp;

	//-----------------------------------------------------------------
	//	Package the component initially
	//-----------------------------------------------------------------
	isis::isis_ProAsmcompAssemble (asm_model, comp_model, identity_matrix, &asmcomp);
	//ProTKPrintf(" \n ProAsmcompAssemble Error Code:  %d", status);

	*out_p_assembled_feat_handle = asmcomp;			

	return PRO_TK_NO_ERROR;
}


} // end namespace isis