/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef ASSEMBLE_UTILS_H
#define ASSEMBLE_UTILS_H
#include <CommonStructures.h>
#include <isis_application_exception.h>
#include <map>
#include <AssembleUtils.h>

namespace isis
{

	const std::string manufacturingManifestJson_PathAndFileName = ".\\manufacturing.manifest.json";



	void Populate_c_id_table( const list<int> &in_path_list, ProIdTable out_c_id_table, int &out_c_id_table_size );

	void RetrieveTranformationMatrix_Assembly_to_Child (  
							const std::string  &in_AssemblyComponentID,
							const std::string  &in_ChildComponentID,
							const list<int>	   &in_ChildComponentPaths,
							std::map<std::string, isis::CADComponentData>		&in_CADComponentData_map,  
							ProBoolean   in_bottom_up,
							double out_TransformationMatrix[4][4] )  throw (isis::application_exception);

	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	const std::string	CouldNotFindManufacturingManifestError =
			"\nDid not update manufacturing manifest file (" +
			isis::manufacturingManifestJson_PathAndFileName + ") with " + 
			"\nthe mapping of component-instance-ID to STEP-file-name because the manifest file " +
			"\ncould not be found.  The manufacturing manifest file would only exist if the " +
			"\nCyPhyPrepareIFab interpreter had been invoked. Typically, CyPhyPrepareIFab " +
			"\nwould not have been invoked."; 

	const std::string	NotUpdatingManufacturingManifest_SeperateSTEPFilesNotRequested =
			"\nDid not update manufacturing manifest file (" +
			isis::manufacturingManifestJson_PathAndFileName + ") for the" +
			"\nassembled parts because seperate STEP part files were not requested." +
			"\nAP203_E2_SEPERATE_PART_FILES or AP214_SEPERATE_PART_FILES must be requested" +
			"\nin order for the manufacturing manifest to be updated for assembled parts.  The " +
			"\nmanifest will be updated for any unassembled parts.";


 
	void UpdateManufacturingManifestWithSTEPFileInfo( 
									e_DataExchangeVersion in_DataExchangeVersion, // AP203_SINGLE_FILE, AP203_E2_SINGLE_FILE, AP203_E2_SEPERATE_PART_FILES...
									const std::string	&in_ComponentID,
									bool				in_OnlyUpdateManifestForParts,
									bool				in_ChangeCaseOfPartStepFileToLowerCase,
									std::map<std::string, isis::CADComponentData> &in_CADComponentData_map )
												throw (isis::application_exception);

	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// If a part name (not assembly name) appears more than once in in_out_CADComponentData_map
	//	then
	//		this function modifies in_out_CADComponentData_map to have unique name for the second
	//		and later occurrences of the particular part name.  The new and old part names are added
	//      to out_ToPartName_FromPartName. 
	void ModifyToHaveAUniqueNameForEachPart( 
							int &in_out_UniqueNameIndex,
							std::map<std::string, isis::CADComponentData> &in_out_CADComponentData_map, 
							std::map<std::string, std::string>			  &out_ToPartName_FromPartName )
																		throw (isis::application_exception);
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// If part/assem appears more than once in in_out_CADComponentData_map and is a parametric part/assembly
	//	then
	//		this function modifies in_out_CADComponentData_map to have unique name for the second
	//		and later occurrences of the particular part/assembly that is a parametric part/assembly.  
	//		The new and old part names are added to out_ToPartAssemName_FromPartAssemName. 
	void ModifyToHaveAUniqueNameForEachParametricPartOrAssembly( 
							int &in_out_UniqueNameIndex,
							std::map<std::string, isis::CADComponentData> &in_out_CADComponentData_map, 
							std::map<std::string, std::string>			  &out_ToPartAssemName_FromPartAssemName )
																		throw (isis::application_exception);

	class ComponentVistor
	{
		public:
			virtual void operator() ( const std::string  &in_ComponentID, 
									  std::map<std::string, isis::CADComponentData> &in_out_CADComponentData_map )=0;
	};

	void VisitComponents(	const std::string								&in_ComponentID, 
							std::map<std::string, isis::CADComponentData>	&in_out_CADComponentData_map,
							ComponentVistor									&in_componentVistor) 
																		throw (isis::application_exception);


	class ComponentVistorMaterialTokens: public ComponentVistor
	{
		public:
			//std::map<std::string, AnalysisTempMaterial> materialKey_MaterialDefintion_map;
			std::map<std::string, double> componentID_PoissonsRatio_map;
			std::map<std::string, std::string> materialKey_ComponentID_map;

			virtual void operator() ( const std::string  &in_ComponentID, 
									  std::map<std::string, isis::CADComponentData> &in_out_CADComponentData_map );
	};

	class ComponentVistorCountAssemblyComponents: public ComponentVistor
	{
		public:
			int numberOfComponents;

			virtual void operator() ( const std::string  &in_ComponentID, 
									  std::map<std::string, isis::CADComponentData> &in_out_CADComponentData_map );

			ComponentVistorCountAssemblyComponents();

	};

	class ComponentVistorBuildListOfComponentIDs: public ComponentVistor
	{
		public:
			std::list<std::string> listOfComponentIDs;

			virtual void operator() ( const std::string  &in_ComponentID, 
									  std::map<std::string, isis::CADComponentData> &in_out_CADComponentData_map );

	};

	std::string GetDayMonthTimeYear();

	//class ComponentVistorBuildListOfBoundingBoxComputations: public ComponentVistor
	//{
 	//	public:
	//		std::list<std::string> boundingBoxComputationsComponentIDs;

	//		virtual void operator() ( const std::string  &in_ComponentID, 
	//								  std::map<std::string, isis::CADComponentData> &in_out_CADComponentData_map );

	//		ComponentVistorBuildListOfBoundingBoxComputations();

	//};

}

#endif