/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// cpp (meta datanetwork format) source file AssemblyInterface.cpp
// generated from diagram AssemblyInterface
// generated on Thu Mar 07 16:38:21 2013

#include "AssemblyInterface.h"
#include <UmlExt.h>
#include <UdmStatic.h>

#include <UdmDom.h>
#include "AssemblyInterface_xsd.h"
using namespace std;

namespace AssemblyInterface {

	Assembly::Assembly() {}
	Assembly::Assembly(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Assembly::Assembly(const Assembly &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Assembly::Assembly(Assembly &&master) : UDM_OBJECT(master) {};

	Assembly Assembly::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Assembly& Assembly::operator=(Assembly &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Assembly Assembly::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Assembly Assembly::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Assembly Assembly::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Assembly> Assembly::Instances() { return ::Udm::InstantiatedAttr< Assembly>(impl); }
	Assembly Assembly::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Assembly> Assembly::Derived() { return ::Udm::DerivedAttr< Assembly>(impl); }
	::Udm::ArchetypeAttr< Assembly> Assembly::Archetype() const { return ::Udm::ArchetypeAttr< Assembly>(impl); }
	::Udm::StringAttr Assembly::ConfigurationID() const { return ::Udm::StringAttr(impl, meta_ConfigurationID); }
	::Udm::ChildAttr< ::AssemblyInterface::CADComponent> Assembly::CADComponent_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::CADComponent>(impl, meta_CADComponent_child); }
	::Udm::ChildAttr< ::AssemblyInterface::Analyses> Assembly::Analyses_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Analyses>(impl, meta_Analyses_child); }
	::Udm::ChildAttr< ::AssemblyInterface::Properties> Assembly::Properties_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Properties>(impl, meta_Properties_child); }
	::Udm::ChildAttr< ::AssemblyInterface::Computations> Assembly::Computations_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Computations>(impl, meta_Computations_child); }
	::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent> Assembly::CADComponent_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Properties> Assembly::Properties_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Properties>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Analyses> Assembly::Analyses_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Analyses>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Computations> Assembly::Computations_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Computations>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Assemblies> Assembly::Assemblies_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Assemblies>(impl, meta_Assemblies_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Assemblies> Assembly::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Assemblies>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Assembly::meta;
	::Uml::Attribute Assembly::meta_ConfigurationID;
	::Uml::CompositionChildRole Assembly::meta_CADComponent_child;
	::Uml::CompositionChildRole Assembly::meta_Analyses_child;
	::Uml::CompositionChildRole Assembly::meta_Properties_child;
	::Uml::CompositionChildRole Assembly::meta_Computations_child;
	::Uml::CompositionParentRole Assembly::meta_Assemblies_parent;

	CADComponent::CADComponent() {}
	CADComponent::CADComponent(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	CADComponent::CADComponent(const CADComponent &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	CADComponent::CADComponent(CADComponent &&master) : UDM_OBJECT(master) {};

	CADComponent CADComponent::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	CADComponent& CADComponent::operator=(CADComponent &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	CADComponent CADComponent::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	CADComponent CADComponent::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	CADComponent CADComponent::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< CADComponent> CADComponent::Instances() { return ::Udm::InstantiatedAttr< CADComponent>(impl); }
	CADComponent CADComponent::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< CADComponent> CADComponent::Derived() { return ::Udm::DerivedAttr< CADComponent>(impl); }
	::Udm::ArchetypeAttr< CADComponent> CADComponent::Archetype() const { return ::Udm::ArchetypeAttr< CADComponent>(impl); }
	::Udm::StringAttr CADComponent::ComponentID() const { return ::Udm::StringAttr(impl, meta_ComponentID); }
	::Udm::StringAttr CADComponent::Name() const { return ::Udm::StringAttr(impl, meta_Name); }
	::Udm::StringAttr CADComponent::Type() const { return ::Udm::StringAttr(impl, meta_Type); }
	::Udm::StringAttr CADComponent::SpecialInstruction() const { return ::Udm::StringAttr(impl, meta_SpecialInstruction); }
	::Udm::StringAttr CADComponent::MaterialID() const { return ::Udm::StringAttr(impl, meta_MaterialID); }
	::Udm::BooleanAttr CADComponent::Standalone() const { return ::Udm::BooleanAttr(impl, meta_Standalone); }
	::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent> CADComponent::CADComponent_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent>(impl, meta_CADComponent_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Constraint> CADComponent::Constraint_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Constraint>(impl, meta_Constraint_children); }
	::Udm::ChildAttr< ::AssemblyInterface::ParametricParameters> CADComponent::ParametricParameters_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::ParametricParameters>(impl, meta_ParametricParameters_child); }
	::Udm::ChildAttr< ::AssemblyInterface::KinematicConnections> CADComponent::KinematicConnections_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::KinematicConnections>(impl, meta_KinematicConnections_child); }
	::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent> CADComponent::CADComponent_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Constraint> CADComponent::Constraint_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Constraint>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::ParametricParameters> CADComponent::ParametricParameters_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ParametricParameters>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::KinematicConnections> CADComponent::KinematicConnections_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::KinematicConnections>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Assembly> CADComponent::Assembly_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Assembly>(impl, meta_Assembly_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::CADComponent> CADComponent::CADComponent_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::CADComponent>(impl, meta_CADComponent_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::UnassembledComponents> CADComponent::UnassembledComponents_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::UnassembledComponents>(impl, meta_UnassembledComponents_parent); }
	::Udm::ParentAttr< ::Udm::Object> CADComponent::parent() const { return ::Udm::ParentAttr< ::Udm::Object>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class CADComponent::meta;
	::Uml::Attribute CADComponent::meta_ComponentID;
	::Uml::Attribute CADComponent::meta_Name;
	::Uml::Attribute CADComponent::meta_Type;
	::Uml::Attribute CADComponent::meta_SpecialInstruction;
	::Uml::Attribute CADComponent::meta_MaterialID;
	::Uml::Attribute CADComponent::meta_Standalone;
	::Uml::CompositionChildRole CADComponent::meta_CADComponent_children;
	::Uml::CompositionChildRole CADComponent::meta_Constraint_children;
	::Uml::CompositionChildRole CADComponent::meta_ParametricParameters_child;
	::Uml::CompositionChildRole CADComponent::meta_KinematicConnections_child;
	::Uml::CompositionParentRole CADComponent::meta_Assembly_parent;
	::Uml::CompositionParentRole CADComponent::meta_CADComponent_parent;
	::Uml::CompositionParentRole CADComponent::meta_UnassembledComponents_parent;

	Units::Units() {}
	Units::Units(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Units::Units(const Units &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Units::Units(Units &&master) : UDM_OBJECT(master) {};

	Units Units::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Units& Units::operator=(Units &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Units Units::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Units Units::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Units Units::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Units> Units::Instances() { return ::Udm::InstantiatedAttr< Units>(impl); }
	Units Units::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Units> Units::Derived() { return ::Udm::DerivedAttr< Units>(impl); }
	::Udm::ArchetypeAttr< Units> Units::Archetype() const { return ::Udm::ArchetypeAttr< Units>(impl); }
	::Udm::StringAttr Units::Value() const { return ::Udm::StringAttr(impl, meta_Value); }
	::Udm::ParentAttr< ::AssemblyInterface::Properties> Units::Properties_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Properties>(impl, meta_Properties_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::CADParameter> Units::CADParameter_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::CADParameter>(impl, meta_CADParameter_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::ConstraintOffset> Units::ConstraintOffset_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::ConstraintOffset>(impl, meta_ConstraintOffset_parent); }
	::Udm::ParentAttr< ::Udm::Object> Units::parent() const { return ::Udm::ParentAttr< ::Udm::Object>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Units::meta;
	::Uml::Attribute Units::meta_Value;
	::Uml::CompositionParentRole Units::meta_Properties_parent;
	::Uml::CompositionParentRole Units::meta_CADParameter_parent;
	::Uml::CompositionParentRole Units::meta_ConstraintOffset_parent;

	Properties::Properties() {}
	Properties::Properties(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Properties::Properties(const Properties &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Properties::Properties(Properties &&master) : UDM_OBJECT(master) {};

	Properties Properties::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Properties& Properties::operator=(Properties &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Properties Properties::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Properties Properties::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Properties Properties::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Properties> Properties::Instances() { return ::Udm::InstantiatedAttr< Properties>(impl); }
	Properties Properties::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Properties> Properties::Derived() { return ::Udm::DerivedAttr< Properties>(impl); }
	::Udm::ArchetypeAttr< Properties> Properties::Archetype() const { return ::Udm::ArchetypeAttr< Properties>(impl); }
	::Udm::ChildAttr< ::AssemblyInterface::Units> Properties::Units_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Units>(impl, meta_Units_child); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Units> Properties::Units_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Units>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Assembly> Properties::Assembly_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Assembly>(impl, meta_Assembly_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Assembly> Properties::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Assembly>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Properties::meta;
	::Uml::CompositionChildRole Properties::meta_Units_child;
	::Uml::CompositionParentRole Properties::meta_Assembly_parent;

	Constraint::Constraint() {}
	Constraint::Constraint(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Constraint::Constraint(const Constraint &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Constraint::Constraint(Constraint &&master) : UDM_OBJECT(master) {};

	Constraint Constraint::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Constraint& Constraint::operator=(Constraint &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Constraint Constraint::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Constraint Constraint::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Constraint Constraint::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Constraint> Constraint::Instances() { return ::Udm::InstantiatedAttr< Constraint>(impl); }
	Constraint Constraint::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Constraint> Constraint::Derived() { return ::Udm::DerivedAttr< Constraint>(impl); }
	::Udm::ArchetypeAttr< Constraint> Constraint::Archetype() const { return ::Udm::ArchetypeAttr< Constraint>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Pair> Constraint::Pair_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Pair>(impl, meta_Pair_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Pair> Constraint::Pair_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Pair>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::CADComponent> Constraint::CADComponent_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::CADComponent>(impl, meta_CADComponent_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::CADComponent> Constraint::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::CADComponent>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Constraint::meta;
	::Uml::CompositionChildRole Constraint::meta_Pair_children;
	::Uml::CompositionParentRole Constraint::meta_CADComponent_parent;

	ConstraintFeature::ConstraintFeature() {}
	ConstraintFeature::ConstraintFeature(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	ConstraintFeature::ConstraintFeature(const ConstraintFeature &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	ConstraintFeature::ConstraintFeature(ConstraintFeature &&master) : UDM_OBJECT(master) {};

	ConstraintFeature ConstraintFeature::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	ConstraintFeature& ConstraintFeature::operator=(ConstraintFeature &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	ConstraintFeature ConstraintFeature::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	ConstraintFeature ConstraintFeature::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	ConstraintFeature ConstraintFeature::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< ConstraintFeature> ConstraintFeature::Instances() { return ::Udm::InstantiatedAttr< ConstraintFeature>(impl); }
	ConstraintFeature ConstraintFeature::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< ConstraintFeature> ConstraintFeature::Derived() { return ::Udm::DerivedAttr< ConstraintFeature>(impl); }
	::Udm::ArchetypeAttr< ConstraintFeature> ConstraintFeature::Archetype() const { return ::Udm::ArchetypeAttr< ConstraintFeature>(impl); }
	::Udm::StringAttr ConstraintFeature::ComponentID() const { return ::Udm::StringAttr(impl, meta_ComponentID); }
	::Udm::StringAttr ConstraintFeature::FeatureName() const { return ::Udm::StringAttr(impl, meta_FeatureName); }
	::Udm::StringAttr ConstraintFeature::FeatureOrientationType() const { return ::Udm::StringAttr(impl, meta_FeatureOrientationType); }
	::Udm::ParentAttr< ::AssemblyInterface::Pair> ConstraintFeature::Pair_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Pair>(impl, meta_Pair_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Pair> ConstraintFeature::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Pair>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class ConstraintFeature::meta;
	::Uml::Attribute ConstraintFeature::meta_ComponentID;
	::Uml::Attribute ConstraintFeature::meta_FeatureName;
	::Uml::Attribute ConstraintFeature::meta_FeatureOrientationType;
	::Uml::CompositionParentRole ConstraintFeature::meta_Pair_parent;

	Pair::Pair() {}
	Pair::Pair(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Pair::Pair(const Pair &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Pair::Pair(Pair &&master) : UDM_OBJECT(master) {};

	Pair Pair::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Pair& Pair::operator=(Pair &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Pair Pair::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Pair Pair::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Pair Pair::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Pair> Pair::Instances() { return ::Udm::InstantiatedAttr< Pair>(impl); }
	Pair Pair::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Pair> Pair::Derived() { return ::Udm::DerivedAttr< Pair>(impl); }
	::Udm::ArchetypeAttr< Pair> Pair::Archetype() const { return ::Udm::ArchetypeAttr< Pair>(impl); }
	::Udm::StringAttr Pair::FeatureInterfaceType() const { return ::Udm::StringAttr(impl, meta_FeatureInterfaceType); }
	::Udm::StringAttr Pair::FeatureGeometryType() const { return ::Udm::StringAttr(impl, meta_FeatureGeometryType); }
	::Udm::StringAttr Pair::FeatureAlignmentType() const { return ::Udm::StringAttr(impl, meta_FeatureAlignmentType); }
	::Udm::ChildAttr< ::AssemblyInterface::ConstraintOffset> Pair::ConstraintOffset_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::ConstraintOffset>(impl, meta_ConstraintOffset_child); }
	::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintFeature> Pair::ConstraintFeature_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintFeature>(impl, meta_ConstraintFeature_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintFeature> Pair::ConstraintFeature_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintFeature>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintOffset> Pair::ConstraintOffset_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintOffset>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Constraint> Pair::Constraint_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Constraint>(impl, meta_Constraint_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Constraint> Pair::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Constraint>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Pair::meta;
	::Uml::Attribute Pair::meta_FeatureInterfaceType;
	::Uml::Attribute Pair::meta_FeatureGeometryType;
	::Uml::Attribute Pair::meta_FeatureAlignmentType;
	::Uml::CompositionChildRole Pair::meta_ConstraintOffset_child;
	::Uml::CompositionChildRole Pair::meta_ConstraintFeature_children;
	::Uml::CompositionParentRole Pair::meta_Constraint_parent;

	CADParameter::CADParameter() {}
	CADParameter::CADParameter(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	CADParameter::CADParameter(const CADParameter &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	CADParameter::CADParameter(CADParameter &&master) : UDM_OBJECT(master) {};

	CADParameter CADParameter::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	CADParameter& CADParameter::operator=(CADParameter &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	CADParameter CADParameter::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	CADParameter CADParameter::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	CADParameter CADParameter::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< CADParameter> CADParameter::Instances() { return ::Udm::InstantiatedAttr< CADParameter>(impl); }
	CADParameter CADParameter::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< CADParameter> CADParameter::Derived() { return ::Udm::DerivedAttr< CADParameter>(impl); }
	::Udm::ArchetypeAttr< CADParameter> CADParameter::Archetype() const { return ::Udm::ArchetypeAttr< CADParameter>(impl); }
	::Udm::StringAttr CADParameter::Name() const { return ::Udm::StringAttr(impl, meta_Name); }
	::Udm::StringAttr CADParameter::Type() const { return ::Udm::StringAttr(impl, meta_Type); }
	::Udm::StringAttr CADParameter::Value() const { return ::Udm::StringAttr(impl, meta_Value); }
	::Udm::ChildAttr< ::AssemblyInterface::Units> CADParameter::Units_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Units>(impl, meta_Units_child); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Units> CADParameter::Units_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Units>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::ParametricParameters> CADParameter::ParametricParameters_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::ParametricParameters>(impl, meta_ParametricParameters_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::ParametricParameters> CADParameter::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::ParametricParameters>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class CADParameter::meta;
	::Uml::Attribute CADParameter::meta_Name;
	::Uml::Attribute CADParameter::meta_Type;
	::Uml::Attribute CADParameter::meta_Value;
	::Uml::CompositionChildRole CADParameter::meta_Units_child;
	::Uml::CompositionParentRole CADParameter::meta_ParametricParameters_parent;

	ConstraintOffset::ConstraintOffset() {}
	ConstraintOffset::ConstraintOffset(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	ConstraintOffset::ConstraintOffset(const ConstraintOffset &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	ConstraintOffset::ConstraintOffset(ConstraintOffset &&master) : UDM_OBJECT(master) {};

	ConstraintOffset ConstraintOffset::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	ConstraintOffset& ConstraintOffset::operator=(ConstraintOffset &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	ConstraintOffset ConstraintOffset::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	ConstraintOffset ConstraintOffset::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	ConstraintOffset ConstraintOffset::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< ConstraintOffset> ConstraintOffset::Instances() { return ::Udm::InstantiatedAttr< ConstraintOffset>(impl); }
	ConstraintOffset ConstraintOffset::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< ConstraintOffset> ConstraintOffset::Derived() { return ::Udm::DerivedAttr< ConstraintOffset>(impl); }
	::Udm::ArchetypeAttr< ConstraintOffset> ConstraintOffset::Archetype() const { return ::Udm::ArchetypeAttr< ConstraintOffset>(impl); }
	::Udm::RealAttr ConstraintOffset::Value() const { return ::Udm::RealAttr(impl, meta_Value); }
	::Udm::StringAttr ConstraintOffset::OffsetAlignmentType() const { return ::Udm::StringAttr(impl, meta_OffsetAlignmentType); }
	::Udm::ChildAttr< ::AssemblyInterface::Units> ConstraintOffset::Units_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Units>(impl, meta_Units_child); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Units> ConstraintOffset::Units_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Units>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Pair> ConstraintOffset::Pair_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Pair>(impl, meta_Pair_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Pair> ConstraintOffset::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Pair>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class ConstraintOffset::meta;
	::Uml::Attribute ConstraintOffset::meta_Value;
	::Uml::Attribute ConstraintOffset::meta_OffsetAlignmentType;
	::Uml::CompositionChildRole ConstraintOffset::meta_Units_child;
	::Uml::CompositionParentRole ConstraintOffset::meta_Pair_parent;

	ParametricParameters::ParametricParameters() {}
	ParametricParameters::ParametricParameters(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	ParametricParameters::ParametricParameters(const ParametricParameters &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	ParametricParameters::ParametricParameters(ParametricParameters &&master) : UDM_OBJECT(master) {};

	ParametricParameters ParametricParameters::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	ParametricParameters& ParametricParameters::operator=(ParametricParameters &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	ParametricParameters ParametricParameters::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	ParametricParameters ParametricParameters::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	ParametricParameters ParametricParameters::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< ParametricParameters> ParametricParameters::Instances() { return ::Udm::InstantiatedAttr< ParametricParameters>(impl); }
	ParametricParameters ParametricParameters::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< ParametricParameters> ParametricParameters::Derived() { return ::Udm::DerivedAttr< ParametricParameters>(impl); }
	::Udm::ArchetypeAttr< ParametricParameters> ParametricParameters::Archetype() const { return ::Udm::ArchetypeAttr< ParametricParameters>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::CADParameter> ParametricParameters::CADParameter_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CADParameter>(impl, meta_CADParameter_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::CADParameter> ParametricParameters::CADParameter_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CADParameter>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::CADComponent> ParametricParameters::CADComponent_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::CADComponent>(impl, meta_CADComponent_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::CADComponent> ParametricParameters::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::CADComponent>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class ParametricParameters::meta;
	::Uml::CompositionChildRole ParametricParameters::meta_CADParameter_children;
	::Uml::CompositionParentRole ParametricParameters::meta_CADComponent_parent;

	Assemblies::Assemblies() {}
	Assemblies::Assemblies(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Assemblies::Assemblies(const Assemblies &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Assemblies::Assemblies(Assemblies &&master) : UDM_OBJECT(master) {};

	Assemblies Assemblies::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Assemblies& Assemblies::operator=(Assemblies &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Assemblies Assemblies::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Assemblies Assemblies::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Assemblies Assemblies::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Assemblies> Assemblies::Instances() { return ::Udm::InstantiatedAttr< Assemblies>(impl); }
	Assemblies Assemblies::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Assemblies> Assemblies::Derived() { return ::Udm::DerivedAttr< Assemblies>(impl); }
	::Udm::ArchetypeAttr< Assemblies> Assemblies::Archetype() const { return ::Udm::ArchetypeAttr< Assemblies>(impl); }
	::Udm::StringAttr Assemblies::VersionInfo() const { return ::Udm::StringAttr(impl, meta_VersionInfo); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Assembly> Assemblies::Assembly_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Assembly>(impl, meta_Assembly_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Materials> Assemblies::Materials_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Materials>(impl, meta_Materials_children); }
	::Udm::ChildAttr< ::AssemblyInterface::DataExchange> Assemblies::DataExchange_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::DataExchange>(impl, meta_DataExchange_child); }
	::Udm::ChildAttr< ::AssemblyInterface::UnassembledComponents> Assemblies::UnassembledComponents_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::UnassembledComponents>(impl, meta_UnassembledComponents_child); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Assembly> Assemblies::Assembly_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Assembly>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Materials> Assemblies::Materials_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Materials>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::DataExchange> Assemblies::DataExchange_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::DataExchange>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::UnassembledComponents> Assemblies::UnassembledComponents_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::UnassembledComponents>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::Udm::Object> Assemblies::parent() const { return ::Udm::ParentAttr< ::Udm::Object>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Assemblies::meta;
	::Uml::Attribute Assemblies::meta_VersionInfo;
	::Uml::CompositionChildRole Assemblies::meta_Assembly_children;
	::Uml::CompositionChildRole Assemblies::meta_Materials_children;
	::Uml::CompositionChildRole Assemblies::meta_DataExchange_child;
	::Uml::CompositionChildRole Assemblies::meta_UnassembledComponents_child;

	Analyses::Analyses() {}
	Analyses::Analyses(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Analyses::Analyses(const Analyses &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Analyses::Analyses(Analyses &&master) : UDM_OBJECT(master) {};

	Analyses Analyses::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Analyses& Analyses::operator=(Analyses &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Analyses Analyses::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Analyses Analyses::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Analyses Analyses::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Analyses> Analyses::Instances() { return ::Udm::InstantiatedAttr< Analyses>(impl); }
	Analyses Analyses::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Analyses> Analyses::Derived() { return ::Udm::DerivedAttr< Analyses>(impl); }
	::Udm::ArchetypeAttr< Analyses> Analyses::Archetype() const { return ::Udm::ArchetypeAttr< Analyses>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisType> Analyses::AnalysisType_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisType>(impl, meta_AnalysisType_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::FEA> Analyses::FEA_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::FEA>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisType> Analyses::AnalysisType_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisType>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Interference> Analyses::Interference_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Interference>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Tolerance> Analyses::Tolerance_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Tolerance>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Assembly> Analyses::Assembly_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Assembly>(impl, meta_Assembly_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Assembly> Analyses::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Assembly>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Analyses::meta;
	::Uml::CompositionChildRole Analyses::meta_AnalysisType_children;
	::Uml::CompositionParentRole Analyses::meta_Assembly_parent;

	Material::Material() {}
	Material::Material(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Material::Material(const Material &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Material::Material(Material &&master) : UDM_OBJECT(master) {};

	Material Material::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Material& Material::operator=(Material &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Material Material::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Material Material::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Material Material::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Material> Material::Instances() { return ::Udm::InstantiatedAttr< Material>(impl); }
	Material Material::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Material> Material::Derived() { return ::Udm::DerivedAttr< Material>(impl); }
	::Udm::ArchetypeAttr< Material> Material::Archetype() const { return ::Udm::ArchetypeAttr< Material>(impl); }
	::Udm::StringAttr Material::MaterialName() const { return ::Udm::StringAttr(impl, meta_MaterialName); }
	::Udm::StringAttr Material::MaterialID() const { return ::Udm::StringAttr(impl, meta_MaterialID); }
	::Udm::StringAttr Material::MaterialType() const { return ::Udm::StringAttr(impl, meta_MaterialType); }
	::Udm::ChildrenAttr< ::AssemblyInterface::MaterialProperty> Material::MaterialProperty_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::MaterialProperty>(impl, meta_MaterialProperty_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::MaterialProperty> Material::MaterialProperty_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::MaterialProperty>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Materials> Material::Materials_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Materials>(impl, meta_Materials_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Materials> Material::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Materials>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Material::meta;
	::Uml::Attribute Material::meta_MaterialName;
	::Uml::Attribute Material::meta_MaterialID;
	::Uml::Attribute Material::meta_MaterialType;
	::Uml::CompositionChildRole Material::meta_MaterialProperty_children;
	::Uml::CompositionParentRole Material::meta_Materials_parent;

	MaterialProperty::MaterialProperty() {}
	MaterialProperty::MaterialProperty(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	MaterialProperty::MaterialProperty(const MaterialProperty &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	MaterialProperty::MaterialProperty(MaterialProperty &&master) : UDM_OBJECT(master) {};

	MaterialProperty MaterialProperty::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	MaterialProperty& MaterialProperty::operator=(MaterialProperty &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	MaterialProperty MaterialProperty::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	MaterialProperty MaterialProperty::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	MaterialProperty MaterialProperty::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< MaterialProperty> MaterialProperty::Instances() { return ::Udm::InstantiatedAttr< MaterialProperty>(impl); }
	MaterialProperty MaterialProperty::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< MaterialProperty> MaterialProperty::Derived() { return ::Udm::DerivedAttr< MaterialProperty>(impl); }
	::Udm::ArchetypeAttr< MaterialProperty> MaterialProperty::Archetype() const { return ::Udm::ArchetypeAttr< MaterialProperty>(impl); }
	::Udm::StringAttr MaterialProperty::PropertyName() const { return ::Udm::StringAttr(impl, meta_PropertyName); }
	::Udm::RealAttr MaterialProperty::Value() const { return ::Udm::RealAttr(impl, meta_Value); }
	::Udm::StringAttr MaterialProperty::Units() const { return ::Udm::StringAttr(impl, meta_Units); }
	::Udm::ParentAttr< ::AssemblyInterface::Material> MaterialProperty::Material_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Material>(impl, meta_Material_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Material> MaterialProperty::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Material>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class MaterialProperty::meta;
	::Uml::Attribute MaterialProperty::meta_PropertyName;
	::Uml::Attribute MaterialProperty::meta_Value;
	::Uml::Attribute MaterialProperty::meta_Units;
	::Uml::CompositionParentRole MaterialProperty::meta_Material_parent;

	Materials::Materials() {}
	Materials::Materials(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Materials::Materials(const Materials &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Materials::Materials(Materials &&master) : UDM_OBJECT(master) {};

	Materials Materials::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Materials& Materials::operator=(Materials &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Materials Materials::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Materials Materials::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Materials Materials::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Materials> Materials::Instances() { return ::Udm::InstantiatedAttr< Materials>(impl); }
	Materials Materials::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Materials> Materials::Derived() { return ::Udm::DerivedAttr< Materials>(impl); }
	::Udm::ArchetypeAttr< Materials> Materials::Archetype() const { return ::Udm::ArchetypeAttr< Materials>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Material> Materials::Material_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Material>(impl, meta_Material_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Material> Materials::Material_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Material>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Assemblies> Materials::Assemblies_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Assemblies>(impl, meta_Assemblies_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Assemblies> Materials::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Assemblies>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Materials::meta;
	::Uml::CompositionChildRole Materials::meta_Material_children;
	::Uml::CompositionParentRole Materials::meta_Assemblies_parent;

	DataExchange::DataExchange() {}
	DataExchange::DataExchange(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	DataExchange::DataExchange(const DataExchange &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	DataExchange::DataExchange(DataExchange &&master) : UDM_OBJECT(master) {};

	DataExchange DataExchange::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	DataExchange& DataExchange::operator=(DataExchange &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	DataExchange DataExchange::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	DataExchange DataExchange::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	DataExchange DataExchange::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< DataExchange> DataExchange::Instances() { return ::Udm::InstantiatedAttr< DataExchange>(impl); }
	DataExchange DataExchange::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< DataExchange> DataExchange::Derived() { return ::Udm::DerivedAttr< DataExchange>(impl); }
	::Udm::ArchetypeAttr< DataExchange> DataExchange::Archetype() const { return ::Udm::ArchetypeAttr< DataExchange>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::DataFormatBase> DataExchange::DataFormatBase_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::DataFormatBase>(impl, meta_DataFormatBase_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::DataFormatBase> DataExchange::DataFormatBase_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::DataFormatBase>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::STEPFormat> DataExchange::STEPFormat_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::STEPFormat>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Assemblies> DataExchange::Assemblies_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Assemblies>(impl, meta_Assemblies_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Assemblies> DataExchange::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Assemblies>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class DataExchange::meta;
	::Uml::CompositionChildRole DataExchange::meta_DataFormatBase_children;
	::Uml::CompositionParentRole DataExchange::meta_Assemblies_parent;

	DataFormatBase::DataFormatBase() {}
	DataFormatBase::DataFormatBase(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	DataFormatBase::DataFormatBase(const DataFormatBase &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	DataFormatBase::DataFormatBase(DataFormatBase &&master) : UDM_OBJECT(master) {};

	DataFormatBase DataFormatBase::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	DataFormatBase& DataFormatBase::operator=(DataFormatBase &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	DataFormatBase DataFormatBase::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	DataFormatBase DataFormatBase::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	DataFormatBase DataFormatBase::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< DataFormatBase> DataFormatBase::Instances() { return ::Udm::InstantiatedAttr< DataFormatBase>(impl); }
	DataFormatBase DataFormatBase::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< DataFormatBase> DataFormatBase::Derived() { return ::Udm::DerivedAttr< DataFormatBase>(impl); }
	::Udm::ArchetypeAttr< DataFormatBase> DataFormatBase::Archetype() const { return ::Udm::ArchetypeAttr< DataFormatBase>(impl); }
	::Udm::ParentAttr< ::AssemblyInterface::DataExchange> DataFormatBase::DataExchange_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::DataExchange>(impl, meta_DataExchange_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::DataExchange> DataFormatBase::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::DataExchange>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class DataFormatBase::meta;
	::Uml::CompositionParentRole DataFormatBase::meta_DataExchange_parent;

	STEPFormat::STEPFormat() {}
	STEPFormat::STEPFormat(::Udm::ObjectImpl *impl) : DataFormatBase(impl) {}
	STEPFormat::STEPFormat(const STEPFormat &master) : DataFormatBase(master) {}

#ifdef UDM_RVALUE
	STEPFormat::STEPFormat(STEPFormat &&master) : DataFormatBase(master) {};

	STEPFormat STEPFormat::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	STEPFormat& STEPFormat::operator=(STEPFormat &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	STEPFormat STEPFormat::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	STEPFormat STEPFormat::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	STEPFormat STEPFormat::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< STEPFormat> STEPFormat::Instances() { return ::Udm::InstantiatedAttr< STEPFormat>(impl); }
	STEPFormat STEPFormat::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< STEPFormat> STEPFormat::Derived() { return ::Udm::DerivedAttr< STEPFormat>(impl); }
	::Udm::ArchetypeAttr< STEPFormat> STEPFormat::Archetype() const { return ::Udm::ArchetypeAttr< STEPFormat>(impl); }
	::Udm::StringAttr STEPFormat::Name() const { return ::Udm::StringAttr(impl, meta_Name); }
	::Udm::ParentAttr< ::AssemblyInterface::DataExchange> STEPFormat::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::DataExchange>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class STEPFormat::meta;
	::Uml::Attribute STEPFormat::meta_Name;

	Computations::Computations() {}
	Computations::Computations(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Computations::Computations(const Computations &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Computations::Computations(Computations &&master) : UDM_OBJECT(master) {};

	Computations Computations::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Computations& Computations::operator=(Computations &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Computations Computations::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Computations Computations::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Computations Computations::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Computations> Computations::Instances() { return ::Udm::InstantiatedAttr< Computations>(impl); }
	Computations Computations::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Computations> Computations::Derived() { return ::Udm::DerivedAttr< Computations>(impl); }
	::Udm::ArchetypeAttr< Computations> Computations::Archetype() const { return ::Udm::ArchetypeAttr< Computations>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::ComputationType> Computations::ComputationType_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ComputationType>(impl, meta_ComputationType_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::ComputationType> Computations::ComputationType_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ComputationType>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::BoundingBox> Computations::BoundingBox_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::BoundingBox>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::CenterOfGravity> Computations::CenterOfGravity_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CenterOfGravity>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::PointCoordinates> Computations::PointCoordinates_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::PointCoordinates>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Mass> Computations::Mass_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Mass>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Assembly> Computations::Assembly_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Assembly>(impl, meta_Assembly_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Assembly> Computations::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Assembly>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Computations::meta;
	::Uml::CompositionChildRole Computations::meta_ComputationType_children;
	::Uml::CompositionParentRole Computations::meta_Assembly_parent;

	UnassembledComponents::UnassembledComponents() {}
	UnassembledComponents::UnassembledComponents(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	UnassembledComponents::UnassembledComponents(const UnassembledComponents &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	UnassembledComponents::UnassembledComponents(UnassembledComponents &&master) : UDM_OBJECT(master) {};

	UnassembledComponents UnassembledComponents::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	UnassembledComponents& UnassembledComponents::operator=(UnassembledComponents &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	UnassembledComponents UnassembledComponents::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	UnassembledComponents UnassembledComponents::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	UnassembledComponents UnassembledComponents::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< UnassembledComponents> UnassembledComponents::Instances() { return ::Udm::InstantiatedAttr< UnassembledComponents>(impl); }
	UnassembledComponents UnassembledComponents::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< UnassembledComponents> UnassembledComponents::Derived() { return ::Udm::DerivedAttr< UnassembledComponents>(impl); }
	::Udm::ArchetypeAttr< UnassembledComponents> UnassembledComponents::Archetype() const { return ::Udm::ArchetypeAttr< UnassembledComponents>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent> UnassembledComponents::CADComponent_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent>(impl, meta_CADComponent_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent> UnassembledComponents::CADComponent_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Assemblies> UnassembledComponents::Assemblies_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Assemblies>(impl, meta_Assemblies_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Assemblies> UnassembledComponents::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Assemblies>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class UnassembledComponents::meta;
	::Uml::CompositionChildRole UnassembledComponents::meta_CADComponent_children;
	::Uml::CompositionParentRole UnassembledComponents::meta_Assemblies_parent;

	AnalysisConstraints::AnalysisConstraints() {}
	AnalysisConstraints::AnalysisConstraints(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	AnalysisConstraints::AnalysisConstraints(const AnalysisConstraints &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	AnalysisConstraints::AnalysisConstraints(AnalysisConstraints &&master) : UDM_OBJECT(master) {};

	AnalysisConstraints AnalysisConstraints::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	AnalysisConstraints& AnalysisConstraints::operator=(AnalysisConstraints &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	AnalysisConstraints AnalysisConstraints::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	AnalysisConstraints AnalysisConstraints::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	AnalysisConstraints AnalysisConstraints::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< AnalysisConstraints> AnalysisConstraints::Instances() { return ::Udm::InstantiatedAttr< AnalysisConstraints>(impl); }
	AnalysisConstraints AnalysisConstraints::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< AnalysisConstraints> AnalysisConstraints::Derived() { return ::Udm::DerivedAttr< AnalysisConstraints>(impl); }
	::Udm::ArchetypeAttr< AnalysisConstraints> AnalysisConstraints::Archetype() const { return ::Udm::ArchetypeAttr< AnalysisConstraints>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisConstraint> AnalysisConstraints::AnalysisConstraint_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisConstraint>(impl, meta_AnalysisConstraint_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisConstraint> AnalysisConstraints::AnalysisConstraint_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisConstraint>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::FEA> AnalysisConstraints::FEA_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::FEA>(impl, meta_FEA_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::FEA> AnalysisConstraints::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::FEA>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class AnalysisConstraints::meta;
	::Uml::CompositionChildRole AnalysisConstraints::meta_AnalysisConstraint_children;
	::Uml::CompositionParentRole AnalysisConstraints::meta_FEA_parent;

	PartInterfaces::PartInterfaces() {}
	PartInterfaces::PartInterfaces(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	PartInterfaces::PartInterfaces(const PartInterfaces &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	PartInterfaces::PartInterfaces(PartInterfaces &&master) : UDM_OBJECT(master) {};

	PartInterfaces PartInterfaces::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	PartInterfaces& PartInterfaces::operator=(PartInterfaces &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	PartInterfaces PartInterfaces::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	PartInterfaces PartInterfaces::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	PartInterfaces PartInterfaces::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< PartInterfaces> PartInterfaces::Instances() { return ::Udm::InstantiatedAttr< PartInterfaces>(impl); }
	PartInterfaces PartInterfaces::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< PartInterfaces> PartInterfaces::Derived() { return ::Udm::DerivedAttr< PartInterfaces>(impl); }
	::Udm::ArchetypeAttr< PartInterfaces> PartInterfaces::Archetype() const { return ::Udm::ArchetypeAttr< PartInterfaces>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::PartInterface> PartInterfaces::PartInterface_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::PartInterface>(impl, meta_PartInterface_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::PartInterface> PartInterfaces::PartInterface_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::PartInterface>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::FEA> PartInterfaces::FEA_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::FEA>(impl, meta_FEA_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::FEA> PartInterfaces::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::FEA>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class PartInterfaces::meta;
	::Uml::CompositionChildRole PartInterfaces::meta_PartInterface_children;
	::Uml::CompositionParentRole PartInterfaces::meta_FEA_parent;

	FEA::FEA() {}
	FEA::FEA(::Udm::ObjectImpl *impl) : AnalysisType(impl) {}
	FEA::FEA(const FEA &master) : AnalysisType(master) {}

#ifdef UDM_RVALUE
	FEA::FEA(FEA &&master) : AnalysisType(master) {};

	FEA FEA::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	FEA& FEA::operator=(FEA &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	FEA FEA::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	FEA FEA::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	FEA FEA::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< FEA> FEA::Instances() { return ::Udm::InstantiatedAttr< FEA>(impl); }
	FEA FEA::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< FEA> FEA::Derived() { return ::Udm::DerivedAttr< FEA>(impl); }
	::Udm::ArchetypeAttr< FEA> FEA::Archetype() const { return ::Udm::ArchetypeAttr< FEA>(impl); }
	::Udm::StringAttr FEA::Type() const { return ::Udm::StringAttr(impl, meta_Type); }
	::Udm::ChildAttr< ::AssemblyInterface::AnalysisConstraints> FEA::AnalysisConstraints_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::AnalysisConstraints>(impl, meta_AnalysisConstraints_child); }
	::Udm::ChildAttr< ::AssemblyInterface::Loads> FEA::Loads_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Loads>(impl, meta_Loads_child); }
	::Udm::ChildAttr< ::AssemblyInterface::PartInterfaces> FEA::PartInterfaces_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::PartInterfaces>(impl, meta_PartInterfaces_child); }
	::Udm::ChildAttr< ::AssemblyInterface::AnalysisComponents> FEA::AnalysisComponents_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::AnalysisComponents>(impl, meta_AnalysisComponents_child); }
	::Udm::ChildAttr< ::AssemblyInterface::Solvers> FEA::Solvers_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Solvers>(impl, meta_Solvers_child); }
	::Udm::ChildAttr< ::AssemblyInterface::Conditions> FEA::Conditions_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Conditions>(impl, meta_Conditions_child); }
	::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatments> FEA::SurfaceTreatments_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatments>(impl, meta_SurfaceTreatments_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisConstraints> FEA::AnalysisConstraints_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisConstraints>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::PartInterfaces> FEA::PartInterfaces_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::PartInterfaces>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Loads> FEA::Loads_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Loads>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisComponents> FEA::AnalysisComponents_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisComponents>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Solvers> FEA::Solvers_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Solvers>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Conditions> FEA::Conditions_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Conditions>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatments> FEA::SurfaceTreatments_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatments>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Analyses> FEA::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Analyses>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class FEA::meta;
	::Uml::Attribute FEA::meta_Type;
	::Uml::CompositionChildRole FEA::meta_AnalysisConstraints_child;
	::Uml::CompositionChildRole FEA::meta_Loads_child;
	::Uml::CompositionChildRole FEA::meta_PartInterfaces_child;
	::Uml::CompositionChildRole FEA::meta_AnalysisComponents_child;
	::Uml::CompositionChildRole FEA::meta_Solvers_child;
	::Uml::CompositionChildRole FEA::meta_Conditions_child;
	::Uml::CompositionChildRole FEA::meta_SurfaceTreatments_children;

	AnalysisType::AnalysisType() {}
	AnalysisType::AnalysisType(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	AnalysisType::AnalysisType(const AnalysisType &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	AnalysisType::AnalysisType(AnalysisType &&master) : UDM_OBJECT(master) {};

	AnalysisType AnalysisType::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	AnalysisType& AnalysisType::operator=(AnalysisType &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	AnalysisType AnalysisType::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	AnalysisType AnalysisType::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	AnalysisType AnalysisType::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< AnalysisType> AnalysisType::Instances() { return ::Udm::InstantiatedAttr< AnalysisType>(impl); }
	AnalysisType AnalysisType::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< AnalysisType> AnalysisType::Derived() { return ::Udm::DerivedAttr< AnalysisType>(impl); }
	::Udm::ArchetypeAttr< AnalysisType> AnalysisType::Archetype() const { return ::Udm::ArchetypeAttr< AnalysisType>(impl); }
	::Udm::StringAttr AnalysisType::AnalysisID() const { return ::Udm::StringAttr(impl, meta_AnalysisID); }
	::Udm::ParentAttr< ::AssemblyInterface::Analyses> AnalysisType::Analyses_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Analyses>(impl, meta_Analyses_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Analyses> AnalysisType::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Analyses>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class AnalysisType::meta;
	::Uml::Attribute AnalysisType::meta_AnalysisID;
	::Uml::CompositionParentRole AnalysisType::meta_Analyses_parent;

	Solver::Solver() {}
	Solver::Solver(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Solver::Solver(const Solver &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Solver::Solver(Solver &&master) : UDM_OBJECT(master) {};

	Solver Solver::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Solver& Solver::operator=(Solver &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Solver Solver::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Solver Solver::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Solver Solver::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Solver> Solver::Instances() { return ::Udm::InstantiatedAttr< Solver>(impl); }
	Solver Solver::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Solver> Solver::Derived() { return ::Udm::DerivedAttr< Solver>(impl); }
	::Udm::ArchetypeAttr< Solver> Solver::Archetype() const { return ::Udm::ArchetypeAttr< Solver>(impl); }
	::Udm::StringAttr Solver::Type() const { return ::Udm::StringAttr(impl, meta_Type); }
	::Udm::StringAttr Solver::MeshType() const { return ::Udm::StringAttr(impl, meta_MeshType); }
	::Udm::StringAttr Solver::ShellElementType() const { return ::Udm::StringAttr(impl, meta_ShellElementType); }
	::Udm::StringAttr Solver::ElementShapeType() const { return ::Udm::StringAttr(impl, meta_ElementShapeType); }
	::Udm::ParentAttr< ::AssemblyInterface::Solvers> Solver::Solvers_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Solvers>(impl, meta_Solvers_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Solvers> Solver::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Solvers>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Solver::meta;
	::Uml::Attribute Solver::meta_Type;
	::Uml::Attribute Solver::meta_MeshType;
	::Uml::Attribute Solver::meta_ShellElementType;
	::Uml::Attribute Solver::meta_ElementShapeType;
	::Uml::CompositionParentRole Solver::meta_Solvers_parent;

	AnalysisConstraint::AnalysisConstraint() {}
	AnalysisConstraint::AnalysisConstraint(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	AnalysisConstraint::AnalysisConstraint(const AnalysisConstraint &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	AnalysisConstraint::AnalysisConstraint(AnalysisConstraint &&master) : UDM_OBJECT(master) {};

	AnalysisConstraint AnalysisConstraint::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	AnalysisConstraint& AnalysisConstraint::operator=(AnalysisConstraint &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	AnalysisConstraint AnalysisConstraint::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	AnalysisConstraint AnalysisConstraint::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	AnalysisConstraint AnalysisConstraint::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< AnalysisConstraint> AnalysisConstraint::Instances() { return ::Udm::InstantiatedAttr< AnalysisConstraint>(impl); }
	AnalysisConstraint AnalysisConstraint::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< AnalysisConstraint> AnalysisConstraint::Derived() { return ::Udm::DerivedAttr< AnalysisConstraint>(impl); }
	::Udm::ArchetypeAttr< AnalysisConstraint> AnalysisConstraint::Archetype() const { return ::Udm::ArchetypeAttr< AnalysisConstraint>(impl); }
	::Udm::ChildAttr< ::AssemblyInterface::ConstraintType> AnalysisConstraint::ConstraintType_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::ConstraintType>(impl, meta_ConstraintType_child); }
	::Udm::ChildAttr< ::AssemblyInterface::Geometry> AnalysisConstraint::Geometry_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Geometry>(impl, meta_Geometry_child); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Displacement> AnalysisConstraint::Displacement_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Displacement>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Pin> AnalysisConstraint::Pin_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Pin>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Ball> AnalysisConstraint::Ball_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Ball>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintType> AnalysisConstraint::ConstraintType_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintType>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Geometry> AnalysisConstraint::Geometry_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Geometry>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraints> AnalysisConstraint::AnalysisConstraints_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraints>(impl, meta_AnalysisConstraints_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraints> AnalysisConstraint::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraints>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class AnalysisConstraint::meta;
	::Uml::CompositionChildRole AnalysisConstraint::meta_ConstraintType_child;
	::Uml::CompositionChildRole AnalysisConstraint::meta_Geometry_child;
	::Uml::CompositionParentRole AnalysisConstraint::meta_AnalysisConstraints_parent;

	Loads::Loads() {}
	Loads::Loads(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Loads::Loads(const Loads &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Loads::Loads(Loads &&master) : UDM_OBJECT(master) {};

	Loads Loads::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Loads& Loads::operator=(Loads &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Loads Loads::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Loads Loads::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Loads Loads::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Loads> Loads::Instances() { return ::Udm::InstantiatedAttr< Loads>(impl); }
	Loads Loads::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Loads> Loads::Derived() { return ::Udm::DerivedAttr< Loads>(impl); }
	::Udm::ArchetypeAttr< Loads> Loads::Archetype() const { return ::Udm::ArchetypeAttr< Loads>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Load> Loads::Load_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Load>(impl, meta_Load_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Load> Loads::Load_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Load>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::FEA> Loads::FEA_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::FEA>(impl, meta_FEA_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::FEA> Loads::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::FEA>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Loads::meta;
	::Uml::CompositionChildRole Loads::meta_Load_children;
	::Uml::CompositionParentRole Loads::meta_FEA_parent;

	AnalysisComponents::AnalysisComponents() {}
	AnalysisComponents::AnalysisComponents(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	AnalysisComponents::AnalysisComponents(const AnalysisComponents &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	AnalysisComponents::AnalysisComponents(AnalysisComponents &&master) : UDM_OBJECT(master) {};

	AnalysisComponents AnalysisComponents::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	AnalysisComponents& AnalysisComponents::operator=(AnalysisComponents &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	AnalysisComponents AnalysisComponents::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	AnalysisComponents AnalysisComponents::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	AnalysisComponents AnalysisComponents::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< AnalysisComponents> AnalysisComponents::Instances() { return ::Udm::InstantiatedAttr< AnalysisComponents>(impl); }
	AnalysisComponents AnalysisComponents::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< AnalysisComponents> AnalysisComponents::Derived() { return ::Udm::DerivedAttr< AnalysisComponents>(impl); }
	::Udm::ArchetypeAttr< AnalysisComponents> AnalysisComponents::Archetype() const { return ::Udm::ArchetypeAttr< AnalysisComponents>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Component> AnalysisComponents::Component_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Component>(impl, meta_Component_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Component> AnalysisComponents::Component_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Component>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::FEA> AnalysisComponents::FEA_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::FEA>(impl, meta_FEA_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::FEA> AnalysisComponents::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::FEA>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class AnalysisComponents::meta;
	::Uml::CompositionChildRole AnalysisComponents::meta_Component_children;
	::Uml::CompositionParentRole AnalysisComponents::meta_FEA_parent;

	Load::Load() {}
	Load::Load(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Load::Load(const Load &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Load::Load(Load &&master) : UDM_OBJECT(master) {};

	Load Load::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Load& Load::operator=(Load &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Load Load::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Load Load::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Load Load::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Load> Load::Instances() { return ::Udm::InstantiatedAttr< Load>(impl); }
	Load Load::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Load> Load::Derived() { return ::Udm::DerivedAttr< Load>(impl); }
	::Udm::ArchetypeAttr< Load> Load::Archetype() const { return ::Udm::ArchetypeAttr< Load>(impl); }
	::Udm::ChildAttr< ::AssemblyInterface::LoadType> Load::LoadType_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::LoadType>(impl, meta_LoadType_child); }
	::Udm::ChildAttr< ::AssemblyInterface::Geometry> Load::Geometry_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Geometry>(impl, meta_Geometry_child); }
	::Udm::ChildrenAttr< ::AssemblyInterface::LoadType> Load::LoadType_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::LoadType>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::ForceMoment> Load::ForceMoment_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ForceMoment>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Pressure> Load::Pressure_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Pressure>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Acceleration> Load::Acceleration_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Acceleration>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Geometry> Load::Geometry_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Geometry>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Loads> Load::Loads_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Loads>(impl, meta_Loads_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Loads> Load::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Loads>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Load::meta;
	::Uml::CompositionChildRole Load::meta_LoadType_child;
	::Uml::CompositionChildRole Load::meta_Geometry_child;
	::Uml::CompositionParentRole Load::meta_Loads_parent;

	PartInterface::PartInterface() {}
	PartInterface::PartInterface(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	PartInterface::PartInterface(const PartInterface &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	PartInterface::PartInterface(PartInterface &&master) : UDM_OBJECT(master) {};

	PartInterface PartInterface::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	PartInterface& PartInterface::operator=(PartInterface &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	PartInterface PartInterface::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	PartInterface PartInterface::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	PartInterface PartInterface::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< PartInterface> PartInterface::Instances() { return ::Udm::InstantiatedAttr< PartInterface>(impl); }
	PartInterface PartInterface::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< PartInterface> PartInterface::Derived() { return ::Udm::DerivedAttr< PartInterface>(impl); }
	::Udm::ArchetypeAttr< PartInterface> PartInterface::Archetype() const { return ::Udm::ArchetypeAttr< PartInterface>(impl); }
	::Udm::StringAttr PartInterface::Type() const { return ::Udm::StringAttr(impl, meta_Type); }
	::Udm::StringAttr PartInterface::ComponentID_1() const { return ::Udm::StringAttr(impl, meta_ComponentID_1); }
	::Udm::StringAttr PartInterface::ComponentID_2() const { return ::Udm::StringAttr(impl, meta_ComponentID_2); }
	::Udm::ParentAttr< ::AssemblyInterface::PartInterfaces> PartInterface::PartInterfaces_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::PartInterfaces>(impl, meta_PartInterfaces_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::PartInterfaces> PartInterface::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::PartInterfaces>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class PartInterface::meta;
	::Uml::Attribute PartInterface::meta_Type;
	::Uml::Attribute PartInterface::meta_ComponentID_1;
	::Uml::Attribute PartInterface::meta_ComponentID_2;
	::Uml::CompositionParentRole PartInterface::meta_PartInterfaces_parent;

	Component::Component() {}
	Component::Component(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Component::Component(const Component &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Component::Component(Component &&master) : UDM_OBJECT(master) {};

	Component Component::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Component& Component::operator=(Component &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Component Component::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Component Component::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Component Component::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Component> Component::Instances() { return ::Udm::InstantiatedAttr< Component>(impl); }
	Component Component::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Component> Component::Derived() { return ::Udm::DerivedAttr< Component>(impl); }
	::Udm::ArchetypeAttr< Component> Component::Archetype() const { return ::Udm::ArchetypeAttr< Component>(impl); }
	::Udm::StringAttr Component::ComponentID() const { return ::Udm::StringAttr(impl, meta_ComponentID); }
	::Udm::BooleanAttr Component::InfiniteCycle() const { return ::Udm::BooleanAttr(impl, meta_InfiniteCycle); }
	::Udm::ChildAttr< ::AssemblyInterface::Metrics> Component::Metrics_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Metrics>(impl, meta_Metrics_child); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Metrics> Component::Metrics_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Metrics>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::AnalysisComponents> Component::AnalysisComponents_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::AnalysisComponents>(impl, meta_AnalysisComponents_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::AnalysisComponents> Component::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::AnalysisComponents>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Component::meta;
	::Uml::Attribute Component::meta_ComponentID;
	::Uml::Attribute Component::meta_InfiniteCycle;
	::Uml::CompositionChildRole Component::meta_Metrics_child;
	::Uml::CompositionParentRole Component::meta_AnalysisComponents_parent;

	Solvers::Solvers() {}
	Solvers::Solvers(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Solvers::Solvers(const Solvers &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Solvers::Solvers(Solvers &&master) : UDM_OBJECT(master) {};

	Solvers Solvers::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Solvers& Solvers::operator=(Solvers &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Solvers Solvers::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Solvers Solvers::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Solvers Solvers::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Solvers> Solvers::Instances() { return ::Udm::InstantiatedAttr< Solvers>(impl); }
	Solvers Solvers::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Solvers> Solvers::Derived() { return ::Udm::DerivedAttr< Solvers>(impl); }
	::Udm::ArchetypeAttr< Solvers> Solvers::Archetype() const { return ::Udm::ArchetypeAttr< Solvers>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Solver> Solvers::Solver_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Solver>(impl, meta_Solver_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Solver> Solvers::Solver_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Solver>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::FEA> Solvers::FEA_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::FEA>(impl, meta_FEA_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::FEA> Solvers::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::FEA>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Solvers::meta;
	::Uml::CompositionChildRole Solvers::meta_Solver_children;
	::Uml::CompositionParentRole Solvers::meta_FEA_parent;

	Interference::Interference() {}
	Interference::Interference(::Udm::ObjectImpl *impl) : AnalysisType(impl) {}
	Interference::Interference(const Interference &master) : AnalysisType(master) {}

#ifdef UDM_RVALUE
	Interference::Interference(Interference &&master) : AnalysisType(master) {};

	Interference Interference::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Interference& Interference::operator=(Interference &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Interference Interference::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Interference Interference::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Interference Interference::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Interference> Interference::Instances() { return ::Udm::InstantiatedAttr< Interference>(impl); }
	Interference Interference::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Interference> Interference::Derived() { return ::Udm::DerivedAttr< Interference>(impl); }
	::Udm::ArchetypeAttr< Interference> Interference::Archetype() const { return ::Udm::ArchetypeAttr< Interference>(impl); }
	::Udm::ParentAttr< ::AssemblyInterface::Analyses> Interference::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Analyses>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Interference::meta;

	Tolerance::Tolerance() {}
	Tolerance::Tolerance(::Udm::ObjectImpl *impl) : AnalysisType(impl) {}
	Tolerance::Tolerance(const Tolerance &master) : AnalysisType(master) {}

#ifdef UDM_RVALUE
	Tolerance::Tolerance(Tolerance &&master) : AnalysisType(master) {};

	Tolerance Tolerance::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Tolerance& Tolerance::operator=(Tolerance &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Tolerance Tolerance::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Tolerance Tolerance::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Tolerance Tolerance::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Tolerance> Tolerance::Instances() { return ::Udm::InstantiatedAttr< Tolerance>(impl); }
	Tolerance Tolerance::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Tolerance> Tolerance::Derived() { return ::Udm::DerivedAttr< Tolerance>(impl); }
	::Udm::ArchetypeAttr< Tolerance> Tolerance::Archetype() const { return ::Udm::ArchetypeAttr< Tolerance>(impl); }
	::Udm::ParentAttr< ::AssemblyInterface::Analyses> Tolerance::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Analyses>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Tolerance::meta;

	Metric::Metric() {}
	Metric::Metric(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Metric::Metric(const Metric &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Metric::Metric(Metric &&master) : UDM_OBJECT(master) {};

	Metric Metric::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Metric& Metric::operator=(Metric &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Metric Metric::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Metric Metric::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Metric Metric::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Metric> Metric::Instances() { return ::Udm::InstantiatedAttr< Metric>(impl); }
	Metric Metric::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Metric> Metric::Derived() { return ::Udm::DerivedAttr< Metric>(impl); }
	::Udm::ArchetypeAttr< Metric> Metric::Archetype() const { return ::Udm::ArchetypeAttr< Metric>(impl); }
	::Udm::StringAttr Metric::Type() const { return ::Udm::StringAttr(impl, meta_Type); }
	::Udm::StringAttr Metric::ID() const { return ::Udm::StringAttr(impl, meta_ID); }
	::Udm::ParentAttr< ::AssemblyInterface::Metrics> Metric::Metrics_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Metrics>(impl, meta_Metrics_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Metrics> Metric::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Metrics>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Metric::meta;
	::Uml::Attribute Metric::meta_Type;
	::Uml::Attribute Metric::meta_ID;
	::Uml::CompositionParentRole Metric::meta_Metrics_parent;

	Metrics::Metrics() {}
	Metrics::Metrics(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Metrics::Metrics(const Metrics &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Metrics::Metrics(Metrics &&master) : UDM_OBJECT(master) {};

	Metrics Metrics::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Metrics& Metrics::operator=(Metrics &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Metrics Metrics::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Metrics Metrics::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Metrics Metrics::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Metrics> Metrics::Instances() { return ::Udm::InstantiatedAttr< Metrics>(impl); }
	Metrics Metrics::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Metrics> Metrics::Derived() { return ::Udm::DerivedAttr< Metrics>(impl); }
	::Udm::ArchetypeAttr< Metrics> Metrics::Archetype() const { return ::Udm::ArchetypeAttr< Metrics>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Metric> Metrics::Metric_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Metric>(impl, meta_Metric_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Metric> Metrics::Metric_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Metric>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Component> Metrics::Component_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Component>(impl, meta_Component_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Component> Metrics::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Component>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Metrics::meta;
	::Uml::CompositionChildRole Metrics::meta_Metric_children;
	::Uml::CompositionParentRole Metrics::meta_Component_parent;

	Conditions::Conditions() {}
	Conditions::Conditions(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Conditions::Conditions(const Conditions &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Conditions::Conditions(Conditions &&master) : UDM_OBJECT(master) {};

	Conditions Conditions::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Conditions& Conditions::operator=(Conditions &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Conditions Conditions::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Conditions Conditions::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Conditions Conditions::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Conditions> Conditions::Instances() { return ::Udm::InstantiatedAttr< Conditions>(impl); }
	Conditions Conditions::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Conditions> Conditions::Derived() { return ::Udm::DerivedAttr< Conditions>(impl); }
	::Udm::ArchetypeAttr< Conditions> Conditions::Archetype() const { return ::Udm::ArchetypeAttr< Conditions>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Condition> Conditions::Condition_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Condition>(impl, meta_Condition_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Condition> Conditions::Condition_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Condition>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::FEA> Conditions::FEA_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::FEA>(impl, meta_FEA_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::FEA> Conditions::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::FEA>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Conditions::meta;
	::Uml::CompositionChildRole Conditions::meta_Condition_children;
	::Uml::CompositionParentRole Conditions::meta_FEA_parent;

	Condition::Condition() {}
	Condition::Condition(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Condition::Condition(const Condition &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Condition::Condition(Condition &&master) : UDM_OBJECT(master) {};

	Condition Condition::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Condition& Condition::operator=(Condition &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Condition Condition::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Condition Condition::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Condition Condition::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Condition> Condition::Instances() { return ::Udm::InstantiatedAttr< Condition>(impl); }
	Condition Condition::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Condition> Condition::Derived() { return ::Udm::DerivedAttr< Condition>(impl); }
	::Udm::ArchetypeAttr< Condition> Condition::Archetype() const { return ::Udm::ArchetypeAttr< Condition>(impl); }
	::Udm::StringAttr Condition::Name() const { return ::Udm::StringAttr(impl, meta_Name); }
	::Udm::RealAttr Condition::Value() const { return ::Udm::RealAttr(impl, meta_Value); }
	::Udm::StringAttr Condition::Units() const { return ::Udm::StringAttr(impl, meta_Units); }
	::Udm::ParentAttr< ::AssemblyInterface::Conditions> Condition::Conditions_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Conditions>(impl, meta_Conditions_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Conditions> Condition::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Conditions>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Condition::meta;
	::Uml::Attribute Condition::meta_Name;
	::Uml::Attribute Condition::meta_Value;
	::Uml::Attribute Condition::meta_Units;
	::Uml::CompositionParentRole Condition::meta_Conditions_parent;

	SurfaceTreatment::SurfaceTreatment() {}
	SurfaceTreatment::SurfaceTreatment(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	SurfaceTreatment::SurfaceTreatment(const SurfaceTreatment &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	SurfaceTreatment::SurfaceTreatment(SurfaceTreatment &&master) : UDM_OBJECT(master) {};

	SurfaceTreatment SurfaceTreatment::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	SurfaceTreatment& SurfaceTreatment::operator=(SurfaceTreatment &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	SurfaceTreatment SurfaceTreatment::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	SurfaceTreatment SurfaceTreatment::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	SurfaceTreatment SurfaceTreatment::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< SurfaceTreatment> SurfaceTreatment::Instances() { return ::Udm::InstantiatedAttr< SurfaceTreatment>(impl); }
	SurfaceTreatment SurfaceTreatment::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< SurfaceTreatment> SurfaceTreatment::Derived() { return ::Udm::DerivedAttr< SurfaceTreatment>(impl); }
	::Udm::ArchetypeAttr< SurfaceTreatment> SurfaceTreatment::Archetype() const { return ::Udm::ArchetypeAttr< SurfaceTreatment>(impl); }
	::Udm::StringAttrArr SurfaceTreatment::AdjoiningParts() const { return ::Udm::StringAttrArr(impl, meta_AdjoiningParts); }
	::Udm::ChildAttr< ::AssemblyInterface::Geometry> SurfaceTreatment::Geometry_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Geometry>(impl, meta_Geometry_child); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Geometry> SurfaceTreatment::Geometry_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Geometry>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::SurfaceTreatments> SurfaceTreatment::SurfaceTreatments_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::SurfaceTreatments>(impl, meta_SurfaceTreatments_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::SurfaceTreatments> SurfaceTreatment::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::SurfaceTreatments>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class SurfaceTreatment::meta;
	::Uml::Attribute SurfaceTreatment::meta_AdjoiningParts;
	::Uml::CompositionChildRole SurfaceTreatment::meta_Geometry_child;
	::Uml::CompositionParentRole SurfaceTreatment::meta_SurfaceTreatments_parent;

	SurfaceTreatments::SurfaceTreatments() {}
	SurfaceTreatments::SurfaceTreatments(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	SurfaceTreatments::SurfaceTreatments(const SurfaceTreatments &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	SurfaceTreatments::SurfaceTreatments(SurfaceTreatments &&master) : UDM_OBJECT(master) {};

	SurfaceTreatments SurfaceTreatments::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	SurfaceTreatments& SurfaceTreatments::operator=(SurfaceTreatments &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	SurfaceTreatments SurfaceTreatments::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	SurfaceTreatments SurfaceTreatments::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	SurfaceTreatments SurfaceTreatments::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< SurfaceTreatments> SurfaceTreatments::Instances() { return ::Udm::InstantiatedAttr< SurfaceTreatments>(impl); }
	SurfaceTreatments SurfaceTreatments::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< SurfaceTreatments> SurfaceTreatments::Derived() { return ::Udm::DerivedAttr< SurfaceTreatments>(impl); }
	::Udm::ArchetypeAttr< SurfaceTreatments> SurfaceTreatments::Archetype() const { return ::Udm::ArchetypeAttr< SurfaceTreatments>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatment> SurfaceTreatments::SurfaceTreatment_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatment>(impl, meta_SurfaceTreatment_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatment> SurfaceTreatments::SurfaceTreatment_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatment>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::FEA> SurfaceTreatments::FEA_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::FEA>(impl, meta_FEA_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::FEA> SurfaceTreatments::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::FEA>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class SurfaceTreatments::meta;
	::Uml::CompositionChildRole SurfaceTreatments::meta_SurfaceTreatment_children;
	::Uml::CompositionParentRole SurfaceTreatments::meta_FEA_parent;

	Features::Features() {}
	Features::Features(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Features::Features(const Features &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Features::Features(Features &&master) : UDM_OBJECT(master) {};

	Features Features::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Features& Features::operator=(Features &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Features Features::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Features Features::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Features Features::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Features> Features::Instances() { return ::Udm::InstantiatedAttr< Features>(impl); }
	Features Features::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Features> Features::Derived() { return ::Udm::DerivedAttr< Features>(impl); }
	::Udm::ArchetypeAttr< Features> Features::Archetype() const { return ::Udm::ArchetypeAttr< Features>(impl); }
	::Udm::StringAttr Features::FeatureID() const { return ::Udm::StringAttr(impl, meta_FeatureID); }
	::Udm::StringAttr Features::GeometryType() const { return ::Udm::StringAttr(impl, meta_GeometryType); }
	::Udm::StringAttr Features::FeatureInterfaceType() const { return ::Udm::StringAttr(impl, meta_FeatureInterfaceType); }
	::Udm::StringAttr Features::FeatureGeometryType() const { return ::Udm::StringAttr(impl, meta_FeatureGeometryType); }
	::Udm::StringAttr Features::PrimaryGeometryQualifier() const { return ::Udm::StringAttr(impl, meta_PrimaryGeometryQualifier); }
	::Udm::StringAttr Features::SecondaryGeometryQualifier() const { return ::Udm::StringAttr(impl, meta_SecondaryGeometryQualifier); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Feature> Features::Feature_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Feature>(impl, meta_Feature_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Feature> Features::Feature_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Feature>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Geometry> Features::Geometry_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Geometry>(impl, meta_Geometry_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Geometry> Features::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Geometry>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Features::meta;
	::Uml::Attribute Features::meta_FeatureID;
	::Uml::Attribute Features::meta_GeometryType;
	::Uml::Attribute Features::meta_FeatureInterfaceType;
	::Uml::Attribute Features::meta_FeatureGeometryType;
	::Uml::Attribute Features::meta_PrimaryGeometryQualifier;
	::Uml::Attribute Features::meta_SecondaryGeometryQualifier;
	::Uml::CompositionChildRole Features::meta_Feature_children;
	::Uml::CompositionParentRole Features::meta_Geometry_parent;

	Feature::Feature() {}
	Feature::Feature(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Feature::Feature(const Feature &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Feature::Feature(Feature &&master) : UDM_OBJECT(master) {};

	Feature Feature::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Feature& Feature::operator=(Feature &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Feature Feature::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Feature Feature::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Feature Feature::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Feature> Feature::Instances() { return ::Udm::InstantiatedAttr< Feature>(impl); }
	Feature Feature::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Feature> Feature::Derived() { return ::Udm::DerivedAttr< Feature>(impl); }
	::Udm::ArchetypeAttr< Feature> Feature::Archetype() const { return ::Udm::ArchetypeAttr< Feature>(impl); }
	::Udm::StringAttr Feature::Name() const { return ::Udm::StringAttr(impl, meta_Name); }
	::Udm::StringAttr Feature::ComponentID() const { return ::Udm::StringAttr(impl, meta_ComponentID); }
	::Udm::ParentAttr< ::AssemblyInterface::Features> Feature::Features_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Features>(impl, meta_Features_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Features> Feature::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Features>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Feature::meta;
	::Uml::Attribute Feature::meta_Name;
	::Uml::Attribute Feature::meta_ComponentID;
	::Uml::CompositionParentRole Feature::meta_Features_parent;

	Displacement::Displacement() {}
	Displacement::Displacement(::Udm::ObjectImpl *impl) : ConstraintType(impl) {}
	Displacement::Displacement(const Displacement &master) : ConstraintType(master) {}

#ifdef UDM_RVALUE
	Displacement::Displacement(Displacement &&master) : ConstraintType(master) {};

	Displacement Displacement::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Displacement& Displacement::operator=(Displacement &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Displacement Displacement::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Displacement Displacement::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Displacement Displacement::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Displacement> Displacement::Instances() { return ::Udm::InstantiatedAttr< Displacement>(impl); }
	Displacement Displacement::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Displacement> Displacement::Derived() { return ::Udm::DerivedAttr< Displacement>(impl); }
	::Udm::ArchetypeAttr< Displacement> Displacement::Archetype() const { return ::Udm::ArchetypeAttr< Displacement>(impl); }
	::Udm::ChildAttr< ::AssemblyInterface::Translation> Displacement::Translation_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Translation>(impl, meta_Translation_child); }
	::Udm::ChildAttr< ::AssemblyInterface::Rotation> Displacement::Rotation_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Rotation>(impl, meta_Rotation_child); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Translation> Displacement::Translation_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Translation>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Rotation> Displacement::Rotation_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Rotation>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint> Displacement::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Displacement::meta;
	::Uml::CompositionChildRole Displacement::meta_Translation_child;
	::Uml::CompositionChildRole Displacement::meta_Rotation_child;

	Pin::Pin() {}
	Pin::Pin(::Udm::ObjectImpl *impl) : ConstraintType(impl) {}
	Pin::Pin(const Pin &master) : ConstraintType(master) {}

#ifdef UDM_RVALUE
	Pin::Pin(Pin &&master) : ConstraintType(master) {};

	Pin Pin::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Pin& Pin::operator=(Pin &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Pin Pin::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Pin Pin::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Pin Pin::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Pin> Pin::Instances() { return ::Udm::InstantiatedAttr< Pin>(impl); }
	Pin Pin::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Pin> Pin::Derived() { return ::Udm::DerivedAttr< Pin>(impl); }
	::Udm::ArchetypeAttr< Pin> Pin::Archetype() const { return ::Udm::ArchetypeAttr< Pin>(impl); }
	::Udm::ChildAttr< ::AssemblyInterface::AxialRotation> Pin::AxialRotation_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::AxialRotation>(impl, meta_AxialRotation_child); }
	::Udm::ChildAttr< ::AssemblyInterface::AxialDisplacement> Pin::AxialDisplacement_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::AxialDisplacement>(impl, meta_AxialDisplacement_child); }
	::Udm::ChildrenAttr< ::AssemblyInterface::AxialRotation> Pin::AxialRotation_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AxialRotation>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::AxialDisplacement> Pin::AxialDisplacement_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AxialDisplacement>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint> Pin::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Pin::meta;
	::Uml::CompositionChildRole Pin::meta_AxialRotation_child;
	::Uml::CompositionChildRole Pin::meta_AxialDisplacement_child;

	Ball::Ball() {}
	Ball::Ball(::Udm::ObjectImpl *impl) : ConstraintType(impl) {}
	Ball::Ball(const Ball &master) : ConstraintType(master) {}

#ifdef UDM_RVALUE
	Ball::Ball(Ball &&master) : ConstraintType(master) {};

	Ball Ball::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Ball& Ball::operator=(Ball &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Ball Ball::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Ball Ball::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Ball Ball::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Ball> Ball::Instances() { return ::Udm::InstantiatedAttr< Ball>(impl); }
	Ball Ball::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Ball> Ball::Derived() { return ::Udm::DerivedAttr< Ball>(impl); }
	::Udm::ArchetypeAttr< Ball> Ball::Archetype() const { return ::Udm::ArchetypeAttr< Ball>(impl); }
	::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint> Ball::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Ball::meta;

	ConstraintType::ConstraintType() {}
	ConstraintType::ConstraintType(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	ConstraintType::ConstraintType(const ConstraintType &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	ConstraintType::ConstraintType(ConstraintType &&master) : UDM_OBJECT(master) {};

	ConstraintType ConstraintType::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	ConstraintType& ConstraintType::operator=(ConstraintType &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	ConstraintType ConstraintType::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	ConstraintType ConstraintType::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	ConstraintType ConstraintType::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< ConstraintType> ConstraintType::Instances() { return ::Udm::InstantiatedAttr< ConstraintType>(impl); }
	ConstraintType ConstraintType::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< ConstraintType> ConstraintType::Derived() { return ::Udm::DerivedAttr< ConstraintType>(impl); }
	::Udm::ArchetypeAttr< ConstraintType> ConstraintType::Archetype() const { return ::Udm::ArchetypeAttr< ConstraintType>(impl); }
	::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint> ConstraintType::AnalysisConstraint_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint>(impl, meta_AnalysisConstraint_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint> ConstraintType::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class ConstraintType::meta;
	::Uml::CompositionParentRole ConstraintType::meta_AnalysisConstraint_parent;

	LoadType::LoadType() {}
	LoadType::LoadType(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	LoadType::LoadType(const LoadType &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	LoadType::LoadType(LoadType &&master) : UDM_OBJECT(master) {};

	LoadType LoadType::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	LoadType& LoadType::operator=(LoadType &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	LoadType LoadType::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	LoadType LoadType::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	LoadType LoadType::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< LoadType> LoadType::Instances() { return ::Udm::InstantiatedAttr< LoadType>(impl); }
	LoadType LoadType::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< LoadType> LoadType::Derived() { return ::Udm::DerivedAttr< LoadType>(impl); }
	::Udm::ArchetypeAttr< LoadType> LoadType::Archetype() const { return ::Udm::ArchetypeAttr< LoadType>(impl); }
	::Udm::ParentAttr< ::AssemblyInterface::Load> LoadType::Load_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Load>(impl, meta_Load_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Load> LoadType::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Load>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class LoadType::meta;
	::Uml::CompositionParentRole LoadType::meta_Load_parent;

	ForceMoment::ForceMoment() {}
	ForceMoment::ForceMoment(::Udm::ObjectImpl *impl) : LoadType(impl) {}
	ForceMoment::ForceMoment(const ForceMoment &master) : LoadType(master) {}

#ifdef UDM_RVALUE
	ForceMoment::ForceMoment(ForceMoment &&master) : LoadType(master) {};

	ForceMoment ForceMoment::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	ForceMoment& ForceMoment::operator=(ForceMoment &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	ForceMoment ForceMoment::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	ForceMoment ForceMoment::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	ForceMoment ForceMoment::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< ForceMoment> ForceMoment::Instances() { return ::Udm::InstantiatedAttr< ForceMoment>(impl); }
	ForceMoment ForceMoment::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< ForceMoment> ForceMoment::Derived() { return ::Udm::DerivedAttr< ForceMoment>(impl); }
	::Udm::ArchetypeAttr< ForceMoment> ForceMoment::Archetype() const { return ::Udm::ArchetypeAttr< ForceMoment>(impl); }
	::Udm::ChildAttr< ::AssemblyInterface::Force> ForceMoment::Force_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Force>(impl, meta_Force_child); }
	::Udm::ChildAttr< ::AssemblyInterface::Moment> ForceMoment::Moment_child() const { return ::Udm::ChildAttr< ::AssemblyInterface::Moment>(impl, meta_Moment_child); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Force> ForceMoment::Force_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Force>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Moment> ForceMoment::Moment_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Moment>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::Load> ForceMoment::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Load>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class ForceMoment::meta;
	::Uml::CompositionChildRole ForceMoment::meta_Force_child;
	::Uml::CompositionChildRole ForceMoment::meta_Moment_child;

	Pressure::Pressure() {}
	Pressure::Pressure(::Udm::ObjectImpl *impl) : LoadType(impl) {}
	Pressure::Pressure(const Pressure &master) : LoadType(master) {}

#ifdef UDM_RVALUE
	Pressure::Pressure(Pressure &&master) : LoadType(master) {};

	Pressure Pressure::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Pressure& Pressure::operator=(Pressure &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Pressure Pressure::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Pressure Pressure::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Pressure Pressure::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Pressure> Pressure::Instances() { return ::Udm::InstantiatedAttr< Pressure>(impl); }
	Pressure Pressure::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Pressure> Pressure::Derived() { return ::Udm::DerivedAttr< Pressure>(impl); }
	::Udm::ArchetypeAttr< Pressure> Pressure::Archetype() const { return ::Udm::ArchetypeAttr< Pressure>(impl); }
	::Udm::RealAttr Pressure::Value() const { return ::Udm::RealAttr(impl, meta_Value); }
	::Udm::StringAttr Pressure::Units() const { return ::Udm::StringAttr(impl, meta_Units); }
	::Udm::ParentAttr< ::AssemblyInterface::Load> Pressure::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Load>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Pressure::meta;
	::Uml::Attribute Pressure::meta_Value;
	::Uml::Attribute Pressure::meta_Units;

	Acceleration::Acceleration() {}
	Acceleration::Acceleration(::Udm::ObjectImpl *impl) : LoadType(impl) {}
	Acceleration::Acceleration(const Acceleration &master) : LoadType(master) {}

#ifdef UDM_RVALUE
	Acceleration::Acceleration(Acceleration &&master) : LoadType(master) {};

	Acceleration Acceleration::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Acceleration& Acceleration::operator=(Acceleration &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Acceleration Acceleration::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Acceleration Acceleration::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Acceleration Acceleration::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Acceleration> Acceleration::Instances() { return ::Udm::InstantiatedAttr< Acceleration>(impl); }
	Acceleration Acceleration::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Acceleration> Acceleration::Derived() { return ::Udm::DerivedAttr< Acceleration>(impl); }
	::Udm::ArchetypeAttr< Acceleration> Acceleration::Archetype() const { return ::Udm::ArchetypeAttr< Acceleration>(impl); }
	::Udm::StringAttr Acceleration::Units() const { return ::Udm::StringAttr(impl, meta_Units); }
	::Udm::RealAttr Acceleration::x() const { return ::Udm::RealAttr(impl, meta_x); }
	::Udm::RealAttr Acceleration::y() const { return ::Udm::RealAttr(impl, meta_y); }
	::Udm::RealAttr Acceleration::z() const { return ::Udm::RealAttr(impl, meta_z); }
	::Udm::ParentAttr< ::AssemblyInterface::Load> Acceleration::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Load>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Acceleration::meta;
	::Uml::Attribute Acceleration::meta_Units;
	::Uml::Attribute Acceleration::meta_x;
	::Uml::Attribute Acceleration::meta_y;
	::Uml::Attribute Acceleration::meta_z;

	AxialRotation::AxialRotation() {}
	AxialRotation::AxialRotation(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	AxialRotation::AxialRotation(const AxialRotation &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	AxialRotation::AxialRotation(AxialRotation &&master) : UDM_OBJECT(master) {};

	AxialRotation AxialRotation::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	AxialRotation& AxialRotation::operator=(AxialRotation &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	AxialRotation AxialRotation::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	AxialRotation AxialRotation::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	AxialRotation AxialRotation::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< AxialRotation> AxialRotation::Instances() { return ::Udm::InstantiatedAttr< AxialRotation>(impl); }
	AxialRotation AxialRotation::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< AxialRotation> AxialRotation::Derived() { return ::Udm::DerivedAttr< AxialRotation>(impl); }
	::Udm::ArchetypeAttr< AxialRotation> AxialRotation::Archetype() const { return ::Udm::ArchetypeAttr< AxialRotation>(impl); }
	::Udm::StringAttr AxialRotation::Property() const { return ::Udm::StringAttr(impl, meta_Property); }
	::Udm::ParentAttr< ::AssemblyInterface::Pin> AxialRotation::Pin_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Pin>(impl, meta_Pin_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Pin> AxialRotation::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Pin>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class AxialRotation::meta;
	::Uml::Attribute AxialRotation::meta_Property;
	::Uml::CompositionParentRole AxialRotation::meta_Pin_parent;

	AxialDisplacement::AxialDisplacement() {}
	AxialDisplacement::AxialDisplacement(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	AxialDisplacement::AxialDisplacement(const AxialDisplacement &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	AxialDisplacement::AxialDisplacement(AxialDisplacement &&master) : UDM_OBJECT(master) {};

	AxialDisplacement AxialDisplacement::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	AxialDisplacement& AxialDisplacement::operator=(AxialDisplacement &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	AxialDisplacement AxialDisplacement::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	AxialDisplacement AxialDisplacement::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	AxialDisplacement AxialDisplacement::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< AxialDisplacement> AxialDisplacement::Instances() { return ::Udm::InstantiatedAttr< AxialDisplacement>(impl); }
	AxialDisplacement AxialDisplacement::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< AxialDisplacement> AxialDisplacement::Derived() { return ::Udm::DerivedAttr< AxialDisplacement>(impl); }
	::Udm::ArchetypeAttr< AxialDisplacement> AxialDisplacement::Archetype() const { return ::Udm::ArchetypeAttr< AxialDisplacement>(impl); }
	::Udm::StringAttr AxialDisplacement::Property() const { return ::Udm::StringAttr(impl, meta_Property); }
	::Udm::ParentAttr< ::AssemblyInterface::Pin> AxialDisplacement::Pin_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Pin>(impl, meta_Pin_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Pin> AxialDisplacement::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Pin>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class AxialDisplacement::meta;
	::Uml::Attribute AxialDisplacement::meta_Property;
	::Uml::CompositionParentRole AxialDisplacement::meta_Pin_parent;

	Translation::Translation() {}
	Translation::Translation(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Translation::Translation(const Translation &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Translation::Translation(Translation &&master) : UDM_OBJECT(master) {};

	Translation Translation::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Translation& Translation::operator=(Translation &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Translation Translation::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Translation Translation::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Translation Translation::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Translation> Translation::Instances() { return ::Udm::InstantiatedAttr< Translation>(impl); }
	Translation Translation::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Translation> Translation::Derived() { return ::Udm::DerivedAttr< Translation>(impl); }
	::Udm::ArchetypeAttr< Translation> Translation::Archetype() const { return ::Udm::ArchetypeAttr< Translation>(impl); }
	::Udm::StringAttr Translation::Units() const { return ::Udm::StringAttr(impl, meta_Units); }
	::Udm::StringAttr Translation::x() const { return ::Udm::StringAttr(impl, meta_x); }
	::Udm::StringAttr Translation::y() const { return ::Udm::StringAttr(impl, meta_y); }
	::Udm::StringAttr Translation::z() const { return ::Udm::StringAttr(impl, meta_z); }
	::Udm::ParentAttr< ::AssemblyInterface::Displacement> Translation::Displacement_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Displacement>(impl, meta_Displacement_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Displacement> Translation::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Displacement>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Translation::meta;
	::Uml::Attribute Translation::meta_Units;
	::Uml::Attribute Translation::meta_x;
	::Uml::Attribute Translation::meta_y;
	::Uml::Attribute Translation::meta_z;
	::Uml::CompositionParentRole Translation::meta_Displacement_parent;

	Rotation::Rotation() {}
	Rotation::Rotation(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Rotation::Rotation(const Rotation &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Rotation::Rotation(Rotation &&master) : UDM_OBJECT(master) {};

	Rotation Rotation::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Rotation& Rotation::operator=(Rotation &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Rotation Rotation::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Rotation Rotation::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Rotation Rotation::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Rotation> Rotation::Instances() { return ::Udm::InstantiatedAttr< Rotation>(impl); }
	Rotation Rotation::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Rotation> Rotation::Derived() { return ::Udm::DerivedAttr< Rotation>(impl); }
	::Udm::ArchetypeAttr< Rotation> Rotation::Archetype() const { return ::Udm::ArchetypeAttr< Rotation>(impl); }
	::Udm::StringAttr Rotation::Units() const { return ::Udm::StringAttr(impl, meta_Units); }
	::Udm::StringAttr Rotation::x() const { return ::Udm::StringAttr(impl, meta_x); }
	::Udm::StringAttr Rotation::y() const { return ::Udm::StringAttr(impl, meta_y); }
	::Udm::StringAttr Rotation::z() const { return ::Udm::StringAttr(impl, meta_z); }
	::Udm::ParentAttr< ::AssemblyInterface::Displacement> Rotation::Displacement_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Displacement>(impl, meta_Displacement_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Displacement> Rotation::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Displacement>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Rotation::meta;
	::Uml::Attribute Rotation::meta_Units;
	::Uml::Attribute Rotation::meta_x;
	::Uml::Attribute Rotation::meta_y;
	::Uml::Attribute Rotation::meta_z;
	::Uml::CompositionParentRole Rotation::meta_Displacement_parent;

	Force::Force() {}
	Force::Force(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Force::Force(const Force &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Force::Force(Force &&master) : UDM_OBJECT(master) {};

	Force Force::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Force& Force::operator=(Force &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Force Force::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Force Force::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Force Force::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Force> Force::Instances() { return ::Udm::InstantiatedAttr< Force>(impl); }
	Force Force::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Force> Force::Derived() { return ::Udm::DerivedAttr< Force>(impl); }
	::Udm::ArchetypeAttr< Force> Force::Archetype() const { return ::Udm::ArchetypeAttr< Force>(impl); }
	::Udm::StringAttr Force::Units() const { return ::Udm::StringAttr(impl, meta_Units); }
	::Udm::RealAttr Force::x() const { return ::Udm::RealAttr(impl, meta_x); }
	::Udm::RealAttr Force::y() const { return ::Udm::RealAttr(impl, meta_y); }
	::Udm::RealAttr Force::z() const { return ::Udm::RealAttr(impl, meta_z); }
	::Udm::ParentAttr< ::AssemblyInterface::ForceMoment> Force::ForceMoment_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::ForceMoment>(impl, meta_ForceMoment_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::ForceMoment> Force::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::ForceMoment>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Force::meta;
	::Uml::Attribute Force::meta_Units;
	::Uml::Attribute Force::meta_x;
	::Uml::Attribute Force::meta_y;
	::Uml::Attribute Force::meta_z;
	::Uml::CompositionParentRole Force::meta_ForceMoment_parent;

	Moment::Moment() {}
	Moment::Moment(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Moment::Moment(const Moment &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Moment::Moment(Moment &&master) : UDM_OBJECT(master) {};

	Moment Moment::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Moment& Moment::operator=(Moment &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Moment Moment::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Moment Moment::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Moment Moment::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Moment> Moment::Instances() { return ::Udm::InstantiatedAttr< Moment>(impl); }
	Moment Moment::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Moment> Moment::Derived() { return ::Udm::DerivedAttr< Moment>(impl); }
	::Udm::ArchetypeAttr< Moment> Moment::Archetype() const { return ::Udm::ArchetypeAttr< Moment>(impl); }
	::Udm::StringAttr Moment::Units() const { return ::Udm::StringAttr(impl, meta_Units); }
	::Udm::RealAttr Moment::x() const { return ::Udm::RealAttr(impl, meta_x); }
	::Udm::RealAttr Moment::y() const { return ::Udm::RealAttr(impl, meta_y); }
	::Udm::RealAttr Moment::z() const { return ::Udm::RealAttr(impl, meta_z); }
	::Udm::ParentAttr< ::AssemblyInterface::ForceMoment> Moment::ForceMoment_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::ForceMoment>(impl, meta_ForceMoment_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::ForceMoment> Moment::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::ForceMoment>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Moment::meta;
	::Uml::Attribute Moment::meta_Units;
	::Uml::Attribute Moment::meta_x;
	::Uml::Attribute Moment::meta_y;
	::Uml::Attribute Moment::meta_z;
	::Uml::CompositionParentRole Moment::meta_ForceMoment_parent;

	Geometry::Geometry() {}
	Geometry::Geometry(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Geometry::Geometry(const Geometry &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Geometry::Geometry(Geometry &&master) : UDM_OBJECT(master) {};

	Geometry Geometry::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Geometry& Geometry::operator=(Geometry &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Geometry Geometry::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Geometry Geometry::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Geometry Geometry::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Geometry> Geometry::Instances() { return ::Udm::InstantiatedAttr< Geometry>(impl); }
	Geometry Geometry::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Geometry> Geometry::Derived() { return ::Udm::DerivedAttr< Geometry>(impl); }
	::Udm::ArchetypeAttr< Geometry> Geometry::Archetype() const { return ::Udm::ArchetypeAttr< Geometry>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Features> Geometry::Features_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Features>(impl, meta_Features_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::SetOperation> Geometry::SetOperation_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::SetOperation>(impl, meta_SetOperation_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Features> Geometry::Features_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Features>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::SetOperation> Geometry::SetOperation_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::SetOperation>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint> Geometry::AnalysisConstraint_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint>(impl, meta_AnalysisConstraint_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Load> Geometry::Load_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Load>(impl, meta_Load_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::SurfaceTreatment> Geometry::SurfaceTreatment_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::SurfaceTreatment>(impl, meta_SurfaceTreatment_parent); }
	::Udm::ParentAttr< ::Udm::Object> Geometry::parent() const { return ::Udm::ParentAttr< ::Udm::Object>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Geometry::meta;
	::Uml::CompositionChildRole Geometry::meta_Features_children;
	::Uml::CompositionChildRole Geometry::meta_SetOperation_children;
	::Uml::CompositionParentRole Geometry::meta_AnalysisConstraint_parent;
	::Uml::CompositionParentRole Geometry::meta_Load_parent;
	::Uml::CompositionParentRole Geometry::meta_SurfaceTreatment_parent;

	SetOperation::SetOperation() {}
	SetOperation::SetOperation(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	SetOperation::SetOperation(const SetOperation &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	SetOperation::SetOperation(SetOperation &&master) : UDM_OBJECT(master) {};

	SetOperation SetOperation::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	SetOperation& SetOperation::operator=(SetOperation &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	SetOperation SetOperation::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	SetOperation SetOperation::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	SetOperation SetOperation::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< SetOperation> SetOperation::Instances() { return ::Udm::InstantiatedAttr< SetOperation>(impl); }
	SetOperation SetOperation::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< SetOperation> SetOperation::Derived() { return ::Udm::DerivedAttr< SetOperation>(impl); }
	::Udm::ArchetypeAttr< SetOperation> SetOperation::Archetype() const { return ::Udm::ArchetypeAttr< SetOperation>(impl); }
	::Udm::StringAttr SetOperation::Type() const { return ::Udm::StringAttr(impl, meta_Type); }
	::Udm::StringAttrArr SetOperation::FeatureID() const { return ::Udm::StringAttrArr(impl, meta_FeatureID); }
	::Udm::ParentAttr< ::AssemblyInterface::Geometry> SetOperation::Geometry_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Geometry>(impl, meta_Geometry_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Geometry> SetOperation::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Geometry>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class SetOperation::meta;
	::Uml::Attribute SetOperation::meta_Type;
	::Uml::Attribute SetOperation::meta_FeatureID;
	::Uml::CompositionParentRole SetOperation::meta_Geometry_parent;

	KinematicBase::KinematicBase() {}
	KinematicBase::KinematicBase(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	KinematicBase::KinematicBase(const KinematicBase &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	KinematicBase::KinematicBase(KinematicBase &&master) : UDM_OBJECT(master) {};

	KinematicBase KinematicBase::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	KinematicBase& KinematicBase::operator=(KinematicBase &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	KinematicBase KinematicBase::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	KinematicBase KinematicBase::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	KinematicBase KinematicBase::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< KinematicBase> KinematicBase::Instances() { return ::Udm::InstantiatedAttr< KinematicBase>(impl); }
	KinematicBase KinematicBase::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< KinematicBase> KinematicBase::Derived() { return ::Udm::DerivedAttr< KinematicBase>(impl); }
	::Udm::ArchetypeAttr< KinematicBase> KinematicBase::Archetype() const { return ::Udm::ArchetypeAttr< KinematicBase>(impl); }
	::Udm::StringAttr KinematicBase::ConnectionID() const { return ::Udm::StringAttr(impl, meta_ConnectionID); }
	::Udm::StringAttr KinematicBase::ConnectedComponentID() const { return ::Udm::StringAttr(impl, meta_ConnectedComponentID); }
	::Udm::StringAttr KinematicBase::FeatureInterfaceType() const { return ::Udm::StringAttr(impl, meta_FeatureInterfaceType); }
	::Udm::RealAttr KinematicBase::ERP() const { return ::Udm::RealAttr(impl, meta_ERP); }
	::Udm::RealAttr KinematicBase::CFM() const { return ::Udm::RealAttr(impl, meta_CFM); }
	::Udm::ChildrenAttr< ::AssemblyInterface::KinematicFeature> KinematicBase::KinematicFeature_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::KinematicFeature>(impl, meta_KinematicFeature_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::KinematicFeature> KinematicBase::KinematicFeature_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::KinematicFeature>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections> KinematicBase::KinematicConnections_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections>(impl, meta_KinematicConnections_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections> KinematicBase::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class KinematicBase::meta;
	::Uml::Attribute KinematicBase::meta_ConnectionID;
	::Uml::Attribute KinematicBase::meta_ConnectedComponentID;
	::Uml::Attribute KinematicBase::meta_FeatureInterfaceType;
	::Uml::Attribute KinematicBase::meta_ERP;
	::Uml::Attribute KinematicBase::meta_CFM;
	::Uml::CompositionChildRole KinematicBase::meta_KinematicFeature_children;
	::Uml::CompositionParentRole KinematicBase::meta_KinematicConnections_parent;

	KinematicConnections::KinematicConnections() {}
	KinematicConnections::KinematicConnections(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	KinematicConnections::KinematicConnections(const KinematicConnections &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	KinematicConnections::KinematicConnections(KinematicConnections &&master) : UDM_OBJECT(master) {};

	KinematicConnections KinematicConnections::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	KinematicConnections& KinematicConnections::operator=(KinematicConnections &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	KinematicConnections KinematicConnections::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	KinematicConnections KinematicConnections::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	KinematicConnections KinematicConnections::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< KinematicConnections> KinematicConnections::Instances() { return ::Udm::InstantiatedAttr< KinematicConnections>(impl); }
	KinematicConnections KinematicConnections::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< KinematicConnections> KinematicConnections::Derived() { return ::Udm::DerivedAttr< KinematicConnections>(impl); }
	::Udm::ArchetypeAttr< KinematicConnections> KinematicConnections::Archetype() const { return ::Udm::ArchetypeAttr< KinematicConnections>(impl); }
	::Udm::ChildrenAttr< ::AssemblyInterface::KinematicBase> KinematicConnections::KinematicBase_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::KinematicBase>(impl, meta_KinematicBase_children); }
	::Udm::ChildrenAttr< ::AssemblyInterface::KinematicBase> KinematicConnections::KinematicBase_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::KinematicBase>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Revolute> KinematicConnections::Revolute_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Revolute>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Spherical> KinematicConnections::Spherical_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Spherical>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Prismatic> KinematicConnections::Prismatic_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Prismatic>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::AssemblyInterface::Fixed> KinematicConnections::Fixed_kind_children() const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Fixed>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::AssemblyInterface::CADComponent> KinematicConnections::CADComponent_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::CADComponent>(impl, meta_CADComponent_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::CADComponent> KinematicConnections::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::CADComponent>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class KinematicConnections::meta;
	::Uml::CompositionChildRole KinematicConnections::meta_KinematicBase_children;
	::Uml::CompositionParentRole KinematicConnections::meta_CADComponent_parent;

	Revolute::Revolute() {}
	Revolute::Revolute(::Udm::ObjectImpl *impl) : KinematicBase(impl) {}
	Revolute::Revolute(const Revolute &master) : KinematicBase(master) {}

#ifdef UDM_RVALUE
	Revolute::Revolute(Revolute &&master) : KinematicBase(master) {};

	Revolute Revolute::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Revolute& Revolute::operator=(Revolute &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Revolute Revolute::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Revolute Revolute::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Revolute Revolute::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Revolute> Revolute::Instances() { return ::Udm::InstantiatedAttr< Revolute>(impl); }
	Revolute Revolute::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Revolute> Revolute::Derived() { return ::Udm::DerivedAttr< Revolute>(impl); }
	::Udm::ArchetypeAttr< Revolute> Revolute::Archetype() const { return ::Udm::ArchetypeAttr< Revolute>(impl); }
	::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections> Revolute::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Revolute::meta;

	Spherical::Spherical() {}
	Spherical::Spherical(::Udm::ObjectImpl *impl) : KinematicBase(impl) {}
	Spherical::Spherical(const Spherical &master) : KinematicBase(master) {}

#ifdef UDM_RVALUE
	Spherical::Spherical(Spherical &&master) : KinematicBase(master) {};

	Spherical Spherical::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Spherical& Spherical::operator=(Spherical &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Spherical Spherical::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Spherical Spherical::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Spherical Spherical::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Spherical> Spherical::Instances() { return ::Udm::InstantiatedAttr< Spherical>(impl); }
	Spherical Spherical::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Spherical> Spherical::Derived() { return ::Udm::DerivedAttr< Spherical>(impl); }
	::Udm::ArchetypeAttr< Spherical> Spherical::Archetype() const { return ::Udm::ArchetypeAttr< Spherical>(impl); }
	::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections> Spherical::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Spherical::meta;

	Prismatic::Prismatic() {}
	Prismatic::Prismatic(::Udm::ObjectImpl *impl) : KinematicBase(impl) {}
	Prismatic::Prismatic(const Prismatic &master) : KinematicBase(master) {}

#ifdef UDM_RVALUE
	Prismatic::Prismatic(Prismatic &&master) : KinematicBase(master) {};

	Prismatic Prismatic::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Prismatic& Prismatic::operator=(Prismatic &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Prismatic Prismatic::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Prismatic Prismatic::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Prismatic Prismatic::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Prismatic> Prismatic::Instances() { return ::Udm::InstantiatedAttr< Prismatic>(impl); }
	Prismatic Prismatic::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Prismatic> Prismatic::Derived() { return ::Udm::DerivedAttr< Prismatic>(impl); }
	::Udm::ArchetypeAttr< Prismatic> Prismatic::Archetype() const { return ::Udm::ArchetypeAttr< Prismatic>(impl); }
	::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections> Prismatic::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Prismatic::meta;

	KinematicFeature::KinematicFeature() {}
	KinematicFeature::KinematicFeature(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	KinematicFeature::KinematicFeature(const KinematicFeature &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	KinematicFeature::KinematicFeature(KinematicFeature &&master) : UDM_OBJECT(master) {};

	KinematicFeature KinematicFeature::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	KinematicFeature& KinematicFeature::operator=(KinematicFeature &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	KinematicFeature KinematicFeature::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	KinematicFeature KinematicFeature::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	KinematicFeature KinematicFeature::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< KinematicFeature> KinematicFeature::Instances() { return ::Udm::InstantiatedAttr< KinematicFeature>(impl); }
	KinematicFeature KinematicFeature::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< KinematicFeature> KinematicFeature::Derived() { return ::Udm::DerivedAttr< KinematicFeature>(impl); }
	::Udm::ArchetypeAttr< KinematicFeature> KinematicFeature::Archetype() const { return ::Udm::ArchetypeAttr< KinematicFeature>(impl); }
	::Udm::StringAttr KinematicFeature::DatumName() const { return ::Udm::StringAttr(impl, meta_DatumName); }
	::Udm::StringAttr KinematicFeature::ComponentID() const { return ::Udm::StringAttr(impl, meta_ComponentID); }
	::Udm::StringAttr KinematicFeature::FeatureGeometryType() const { return ::Udm::StringAttr(impl, meta_FeatureGeometryType); }
	::Udm::ParentAttr< ::AssemblyInterface::KinematicBase> KinematicFeature::KinematicBase_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::KinematicBase>(impl, meta_KinematicBase_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::KinematicBase> KinematicFeature::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::KinematicBase>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class KinematicFeature::meta;
	::Uml::Attribute KinematicFeature::meta_DatumName;
	::Uml::Attribute KinematicFeature::meta_ComponentID;
	::Uml::Attribute KinematicFeature::meta_FeatureGeometryType;
	::Uml::CompositionParentRole KinematicFeature::meta_KinematicBase_parent;

	Fixed::Fixed() {}
	Fixed::Fixed(::Udm::ObjectImpl *impl) : KinematicBase(impl) {}
	Fixed::Fixed(const Fixed &master) : KinematicBase(master) {}

#ifdef UDM_RVALUE
	Fixed::Fixed(Fixed &&master) : KinematicBase(master) {};

	Fixed Fixed::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Fixed& Fixed::operator=(Fixed &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Fixed Fixed::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Fixed Fixed::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Fixed Fixed::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Fixed> Fixed::Instances() { return ::Udm::InstantiatedAttr< Fixed>(impl); }
	Fixed Fixed::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Fixed> Fixed::Derived() { return ::Udm::DerivedAttr< Fixed>(impl); }
	::Udm::ArchetypeAttr< Fixed> Fixed::Archetype() const { return ::Udm::ArchetypeAttr< Fixed>(impl); }
	::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections> Fixed::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Fixed::meta;

	ComputationType::ComputationType() {}
	ComputationType::ComputationType(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	ComputationType::ComputationType(const ComputationType &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	ComputationType::ComputationType(ComputationType &&master) : UDM_OBJECT(master) {};

	ComputationType ComputationType::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	ComputationType& ComputationType::operator=(ComputationType &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	ComputationType ComputationType::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	ComputationType ComputationType::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	ComputationType ComputationType::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< ComputationType> ComputationType::Instances() { return ::Udm::InstantiatedAttr< ComputationType>(impl); }
	ComputationType ComputationType::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< ComputationType> ComputationType::Derived() { return ::Udm::DerivedAttr< ComputationType>(impl); }
	::Udm::ArchetypeAttr< ComputationType> ComputationType::Archetype() const { return ::Udm::ArchetypeAttr< ComputationType>(impl); }
	::Udm::StringAttr ComputationType::ComponentID() const { return ::Udm::StringAttr(impl, meta_ComponentID); }
	::Udm::StringAttr ComputationType::RequestedValueType() const { return ::Udm::StringAttr(impl, meta_RequestedValueType); }
	::Udm::StringAttr ComputationType::MetricID() const { return ::Udm::StringAttr(impl, meta_MetricID); }
	::Udm::ParentAttr< ::AssemblyInterface::Computations> ComputationType::Computations_parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Computations>(impl, meta_Computations_parent); }
	::Udm::ParentAttr< ::AssemblyInterface::Computations> ComputationType::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Computations>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class ComputationType::meta;
	::Uml::Attribute ComputationType::meta_ComponentID;
	::Uml::Attribute ComputationType::meta_RequestedValueType;
	::Uml::Attribute ComputationType::meta_MetricID;
	::Uml::CompositionParentRole ComputationType::meta_Computations_parent;

	BoundingBox::BoundingBox() {}
	BoundingBox::BoundingBox(::Udm::ObjectImpl *impl) : ComputationType(impl) {}
	BoundingBox::BoundingBox(const BoundingBox &master) : ComputationType(master) {}

#ifdef UDM_RVALUE
	BoundingBox::BoundingBox(BoundingBox &&master) : ComputationType(master) {};

	BoundingBox BoundingBox::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	BoundingBox& BoundingBox::operator=(BoundingBox &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	BoundingBox BoundingBox::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	BoundingBox BoundingBox::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	BoundingBox BoundingBox::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< BoundingBox> BoundingBox::Instances() { return ::Udm::InstantiatedAttr< BoundingBox>(impl); }
	BoundingBox BoundingBox::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< BoundingBox> BoundingBox::Derived() { return ::Udm::DerivedAttr< BoundingBox>(impl); }
	::Udm::ArchetypeAttr< BoundingBox> BoundingBox::Archetype() const { return ::Udm::ArchetypeAttr< BoundingBox>(impl); }
	::Udm::ParentAttr< ::AssemblyInterface::Computations> BoundingBox::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Computations>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class BoundingBox::meta;

	CenterOfGravity::CenterOfGravity() {}
	CenterOfGravity::CenterOfGravity(::Udm::ObjectImpl *impl) : ComputationType(impl) {}
	CenterOfGravity::CenterOfGravity(const CenterOfGravity &master) : ComputationType(master) {}

#ifdef UDM_RVALUE
	CenterOfGravity::CenterOfGravity(CenterOfGravity &&master) : ComputationType(master) {};

	CenterOfGravity CenterOfGravity::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	CenterOfGravity& CenterOfGravity::operator=(CenterOfGravity &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	CenterOfGravity CenterOfGravity::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	CenterOfGravity CenterOfGravity::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	CenterOfGravity CenterOfGravity::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< CenterOfGravity> CenterOfGravity::Instances() { return ::Udm::InstantiatedAttr< CenterOfGravity>(impl); }
	CenterOfGravity CenterOfGravity::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< CenterOfGravity> CenterOfGravity::Derived() { return ::Udm::DerivedAttr< CenterOfGravity>(impl); }
	::Udm::ArchetypeAttr< CenterOfGravity> CenterOfGravity::Archetype() const { return ::Udm::ArchetypeAttr< CenterOfGravity>(impl); }
	::Udm::ParentAttr< ::AssemblyInterface::Computations> CenterOfGravity::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Computations>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class CenterOfGravity::meta;

	PointCoordinates::PointCoordinates() {}
	PointCoordinates::PointCoordinates(::Udm::ObjectImpl *impl) : ComputationType(impl) {}
	PointCoordinates::PointCoordinates(const PointCoordinates &master) : ComputationType(master) {}

#ifdef UDM_RVALUE
	PointCoordinates::PointCoordinates(PointCoordinates &&master) : ComputationType(master) {};

	PointCoordinates PointCoordinates::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	PointCoordinates& PointCoordinates::operator=(PointCoordinates &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	PointCoordinates PointCoordinates::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	PointCoordinates PointCoordinates::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	PointCoordinates PointCoordinates::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< PointCoordinates> PointCoordinates::Instances() { return ::Udm::InstantiatedAttr< PointCoordinates>(impl); }
	PointCoordinates PointCoordinates::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< PointCoordinates> PointCoordinates::Derived() { return ::Udm::DerivedAttr< PointCoordinates>(impl); }
	::Udm::ArchetypeAttr< PointCoordinates> PointCoordinates::Archetype() const { return ::Udm::ArchetypeAttr< PointCoordinates>(impl); }
	::Udm::StringAttr PointCoordinates::FeatureDatumName() const { return ::Udm::StringAttr(impl, meta_FeatureDatumName); }
	::Udm::ParentAttr< ::AssemblyInterface::Computations> PointCoordinates::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Computations>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class PointCoordinates::meta;
	::Uml::Attribute PointCoordinates::meta_FeatureDatumName;

	Mass::Mass() {}
	Mass::Mass(::Udm::ObjectImpl *impl) : ComputationType(impl) {}
	Mass::Mass(const Mass &master) : ComputationType(master) {}

#ifdef UDM_RVALUE
	Mass::Mass(Mass &&master) : ComputationType(master) {};

	Mass Mass::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Mass& Mass::operator=(Mass &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Mass Mass::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Mass Mass::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Mass Mass::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Mass> Mass::Instances() { return ::Udm::InstantiatedAttr< Mass>(impl); }
	Mass Mass::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Mass> Mass::Derived() { return ::Udm::DerivedAttr< Mass>(impl); }
	::Udm::ArchetypeAttr< Mass> Mass::Archetype() const { return ::Udm::ArchetypeAttr< Mass>(impl); }
	::Udm::ParentAttr< ::AssemblyInterface::Computations> Mass::parent() const { return ::Udm::ParentAttr< ::AssemblyInterface::Computations>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Mass::meta;

	::Uml::Diagram meta;

	void CreateMeta() {
		// classes, with attributes, constraints and constraint definitions
		Acceleration::meta = ::Uml::Class::Create(meta);
		Acceleration::meta_Units = ::Uml::Attribute::Create(Acceleration::meta);
		Acceleration::meta_x = ::Uml::Attribute::Create(Acceleration::meta);
		Acceleration::meta_y = ::Uml::Attribute::Create(Acceleration::meta);
		Acceleration::meta_z = ::Uml::Attribute::Create(Acceleration::meta);

		Analyses::meta = ::Uml::Class::Create(meta);

		AnalysisComponents::meta = ::Uml::Class::Create(meta);

		AnalysisConstraint::meta = ::Uml::Class::Create(meta);

		AnalysisConstraints::meta = ::Uml::Class::Create(meta);

		AnalysisType::meta = ::Uml::Class::Create(meta);
		AnalysisType::meta_AnalysisID = ::Uml::Attribute::Create(AnalysisType::meta);

		Assemblies::meta = ::Uml::Class::Create(meta);
		Assemblies::meta_VersionInfo = ::Uml::Attribute::Create(Assemblies::meta);

		Assembly::meta = ::Uml::Class::Create(meta);
		Assembly::meta_ConfigurationID = ::Uml::Attribute::Create(Assembly::meta);

		AxialDisplacement::meta = ::Uml::Class::Create(meta);
		AxialDisplacement::meta_Property = ::Uml::Attribute::Create(AxialDisplacement::meta);

		AxialRotation::meta = ::Uml::Class::Create(meta);
		AxialRotation::meta_Property = ::Uml::Attribute::Create(AxialRotation::meta);

		Ball::meta = ::Uml::Class::Create(meta);

		BoundingBox::meta = ::Uml::Class::Create(meta);

		CADComponent::meta = ::Uml::Class::Create(meta);
		CADComponent::meta_ComponentID = ::Uml::Attribute::Create(CADComponent::meta);
		CADComponent::meta_Name = ::Uml::Attribute::Create(CADComponent::meta);
		CADComponent::meta_Type = ::Uml::Attribute::Create(CADComponent::meta);
		CADComponent::meta_SpecialInstruction = ::Uml::Attribute::Create(CADComponent::meta);
		CADComponent::meta_MaterialID = ::Uml::Attribute::Create(CADComponent::meta);
		CADComponent::meta_Standalone = ::Uml::Attribute::Create(CADComponent::meta);

		CADParameter::meta = ::Uml::Class::Create(meta);
		CADParameter::meta_Name = ::Uml::Attribute::Create(CADParameter::meta);
		CADParameter::meta_Type = ::Uml::Attribute::Create(CADParameter::meta);
		CADParameter::meta_Value = ::Uml::Attribute::Create(CADParameter::meta);

		CenterOfGravity::meta = ::Uml::Class::Create(meta);

		Component::meta = ::Uml::Class::Create(meta);
		Component::meta_ComponentID = ::Uml::Attribute::Create(Component::meta);
		Component::meta_InfiniteCycle = ::Uml::Attribute::Create(Component::meta);

		ComputationType::meta = ::Uml::Class::Create(meta);
		ComputationType::meta_ComponentID = ::Uml::Attribute::Create(ComputationType::meta);
		ComputationType::meta_RequestedValueType = ::Uml::Attribute::Create(ComputationType::meta);
		ComputationType::meta_MetricID = ::Uml::Attribute::Create(ComputationType::meta);

		Computations::meta = ::Uml::Class::Create(meta);

		Condition::meta = ::Uml::Class::Create(meta);
		Condition::meta_Name = ::Uml::Attribute::Create(Condition::meta);
		Condition::meta_Value = ::Uml::Attribute::Create(Condition::meta);
		Condition::meta_Units = ::Uml::Attribute::Create(Condition::meta);

		Conditions::meta = ::Uml::Class::Create(meta);

		Constraint::meta = ::Uml::Class::Create(meta);

		ConstraintFeature::meta = ::Uml::Class::Create(meta);
		ConstraintFeature::meta_ComponentID = ::Uml::Attribute::Create(ConstraintFeature::meta);
		ConstraintFeature::meta_FeatureName = ::Uml::Attribute::Create(ConstraintFeature::meta);
		ConstraintFeature::meta_FeatureOrientationType = ::Uml::Attribute::Create(ConstraintFeature::meta);

		ConstraintOffset::meta = ::Uml::Class::Create(meta);
		ConstraintOffset::meta_Value = ::Uml::Attribute::Create(ConstraintOffset::meta);
		ConstraintOffset::meta_OffsetAlignmentType = ::Uml::Attribute::Create(ConstraintOffset::meta);

		ConstraintType::meta = ::Uml::Class::Create(meta);

		DataExchange::meta = ::Uml::Class::Create(meta);

		DataFormatBase::meta = ::Uml::Class::Create(meta);

		Displacement::meta = ::Uml::Class::Create(meta);

		FEA::meta = ::Uml::Class::Create(meta);
		FEA::meta_Type = ::Uml::Attribute::Create(FEA::meta);

		Feature::meta = ::Uml::Class::Create(meta);
		Feature::meta_Name = ::Uml::Attribute::Create(Feature::meta);
		Feature::meta_ComponentID = ::Uml::Attribute::Create(Feature::meta);

		Features::meta = ::Uml::Class::Create(meta);
		Features::meta_FeatureID = ::Uml::Attribute::Create(Features::meta);
		Features::meta_GeometryType = ::Uml::Attribute::Create(Features::meta);
		Features::meta_FeatureInterfaceType = ::Uml::Attribute::Create(Features::meta);
		Features::meta_FeatureGeometryType = ::Uml::Attribute::Create(Features::meta);
		Features::meta_PrimaryGeometryQualifier = ::Uml::Attribute::Create(Features::meta);
		Features::meta_SecondaryGeometryQualifier = ::Uml::Attribute::Create(Features::meta);

		Fixed::meta = ::Uml::Class::Create(meta);

		Force::meta = ::Uml::Class::Create(meta);
		Force::meta_Units = ::Uml::Attribute::Create(Force::meta);
		Force::meta_x = ::Uml::Attribute::Create(Force::meta);
		Force::meta_y = ::Uml::Attribute::Create(Force::meta);
		Force::meta_z = ::Uml::Attribute::Create(Force::meta);

		ForceMoment::meta = ::Uml::Class::Create(meta);

		Geometry::meta = ::Uml::Class::Create(meta);

		Interference::meta = ::Uml::Class::Create(meta);

		KinematicBase::meta = ::Uml::Class::Create(meta);
		KinematicBase::meta_ConnectionID = ::Uml::Attribute::Create(KinematicBase::meta);
		KinematicBase::meta_ConnectedComponentID = ::Uml::Attribute::Create(KinematicBase::meta);
		KinematicBase::meta_FeatureInterfaceType = ::Uml::Attribute::Create(KinematicBase::meta);
		KinematicBase::meta_ERP = ::Uml::Attribute::Create(KinematicBase::meta);
		KinematicBase::meta_CFM = ::Uml::Attribute::Create(KinematicBase::meta);

		KinematicConnections::meta = ::Uml::Class::Create(meta);

		KinematicFeature::meta = ::Uml::Class::Create(meta);
		KinematicFeature::meta_DatumName = ::Uml::Attribute::Create(KinematicFeature::meta);
		KinematicFeature::meta_ComponentID = ::Uml::Attribute::Create(KinematicFeature::meta);
		KinematicFeature::meta_FeatureGeometryType = ::Uml::Attribute::Create(KinematicFeature::meta);

		Load::meta = ::Uml::Class::Create(meta);

		LoadType::meta = ::Uml::Class::Create(meta);

		Loads::meta = ::Uml::Class::Create(meta);

		Mass::meta = ::Uml::Class::Create(meta);

		Material::meta = ::Uml::Class::Create(meta);
		Material::meta_MaterialName = ::Uml::Attribute::Create(Material::meta);
		Material::meta_MaterialID = ::Uml::Attribute::Create(Material::meta);
		Material::meta_MaterialType = ::Uml::Attribute::Create(Material::meta);

		MaterialProperty::meta = ::Uml::Class::Create(meta);
		MaterialProperty::meta_PropertyName = ::Uml::Attribute::Create(MaterialProperty::meta);
		MaterialProperty::meta_Value = ::Uml::Attribute::Create(MaterialProperty::meta);
		MaterialProperty::meta_Units = ::Uml::Attribute::Create(MaterialProperty::meta);

		Materials::meta = ::Uml::Class::Create(meta);

		Metric::meta = ::Uml::Class::Create(meta);
		Metric::meta_Type = ::Uml::Attribute::Create(Metric::meta);
		Metric::meta_ID = ::Uml::Attribute::Create(Metric::meta);

		Metrics::meta = ::Uml::Class::Create(meta);

		Moment::meta = ::Uml::Class::Create(meta);
		Moment::meta_Units = ::Uml::Attribute::Create(Moment::meta);
		Moment::meta_x = ::Uml::Attribute::Create(Moment::meta);
		Moment::meta_y = ::Uml::Attribute::Create(Moment::meta);
		Moment::meta_z = ::Uml::Attribute::Create(Moment::meta);

		Pair::meta = ::Uml::Class::Create(meta);
		Pair::meta_FeatureInterfaceType = ::Uml::Attribute::Create(Pair::meta);
		Pair::meta_FeatureGeometryType = ::Uml::Attribute::Create(Pair::meta);
		Pair::meta_FeatureAlignmentType = ::Uml::Attribute::Create(Pair::meta);

		ParametricParameters::meta = ::Uml::Class::Create(meta);

		PartInterface::meta = ::Uml::Class::Create(meta);
		PartInterface::meta_Type = ::Uml::Attribute::Create(PartInterface::meta);
		PartInterface::meta_ComponentID_1 = ::Uml::Attribute::Create(PartInterface::meta);
		PartInterface::meta_ComponentID_2 = ::Uml::Attribute::Create(PartInterface::meta);

		PartInterfaces::meta = ::Uml::Class::Create(meta);

		Pin::meta = ::Uml::Class::Create(meta);

		PointCoordinates::meta = ::Uml::Class::Create(meta);
		PointCoordinates::meta_FeatureDatumName = ::Uml::Attribute::Create(PointCoordinates::meta);

		Pressure::meta = ::Uml::Class::Create(meta);
		Pressure::meta_Value = ::Uml::Attribute::Create(Pressure::meta);
		Pressure::meta_Units = ::Uml::Attribute::Create(Pressure::meta);

		Prismatic::meta = ::Uml::Class::Create(meta);

		Properties::meta = ::Uml::Class::Create(meta);

		Revolute::meta = ::Uml::Class::Create(meta);

		Rotation::meta = ::Uml::Class::Create(meta);
		Rotation::meta_Units = ::Uml::Attribute::Create(Rotation::meta);
		Rotation::meta_x = ::Uml::Attribute::Create(Rotation::meta);
		Rotation::meta_y = ::Uml::Attribute::Create(Rotation::meta);
		Rotation::meta_z = ::Uml::Attribute::Create(Rotation::meta);

		STEPFormat::meta = ::Uml::Class::Create(meta);
		STEPFormat::meta_Name = ::Uml::Attribute::Create(STEPFormat::meta);

		SetOperation::meta = ::Uml::Class::Create(meta);
		SetOperation::meta_Type = ::Uml::Attribute::Create(SetOperation::meta);
		SetOperation::meta_FeatureID = ::Uml::Attribute::Create(SetOperation::meta);

		Solver::meta = ::Uml::Class::Create(meta);
		Solver::meta_Type = ::Uml::Attribute::Create(Solver::meta);
		Solver::meta_MeshType = ::Uml::Attribute::Create(Solver::meta);
		Solver::meta_ShellElementType = ::Uml::Attribute::Create(Solver::meta);
		Solver::meta_ElementShapeType = ::Uml::Attribute::Create(Solver::meta);

		Solvers::meta = ::Uml::Class::Create(meta);

		Spherical::meta = ::Uml::Class::Create(meta);

		SurfaceTreatment::meta = ::Uml::Class::Create(meta);
		SurfaceTreatment::meta_AdjoiningParts = ::Uml::Attribute::Create(SurfaceTreatment::meta);

		SurfaceTreatments::meta = ::Uml::Class::Create(meta);

		Tolerance::meta = ::Uml::Class::Create(meta);

		Translation::meta = ::Uml::Class::Create(meta);
		Translation::meta_Units = ::Uml::Attribute::Create(Translation::meta);
		Translation::meta_x = ::Uml::Attribute::Create(Translation::meta);
		Translation::meta_y = ::Uml::Attribute::Create(Translation::meta);
		Translation::meta_z = ::Uml::Attribute::Create(Translation::meta);

		UnassembledComponents::meta = ::Uml::Class::Create(meta);

		Units::meta = ::Uml::Class::Create(meta);
		Units::meta_Value = ::Uml::Attribute::Create(Units::meta);

	}

	void InitMeta() {
		// classes, with attributes, constraints and constraint definitions
		::Uml::InitClassProps(Acceleration::meta, "Acceleration", false, NULL, NULL);
		::Uml::InitAttributeProps(Acceleration::meta_Units, "Units", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Acceleration::meta_x, "x", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Acceleration::meta_y, "y", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Acceleration::meta_z, "z", "Real", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Analyses::meta, "Analyses", false, NULL, NULL);

		::Uml::InitClassProps(AnalysisComponents::meta, "AnalysisComponents", false, NULL, NULL);

		::Uml::InitClassProps(AnalysisConstraint::meta, "AnalysisConstraint", false, NULL, NULL);

		::Uml::InitClassProps(AnalysisConstraints::meta, "AnalysisConstraints", false, NULL, NULL);

		::Uml::InitClassProps(AnalysisType::meta, "AnalysisType", true, NULL, NULL);
		::Uml::InitAttributeProps(AnalysisType::meta_AnalysisID, "AnalysisID", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Assemblies::meta, "Assemblies", false, NULL, NULL);
		::Uml::InitAttributeProps(Assemblies::meta_VersionInfo, "VersionInfo", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Assembly::meta, "Assembly", false, NULL, NULL);
		::Uml::InitAttributeProps(Assembly::meta_ConfigurationID, "ConfigurationID", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(AxialDisplacement::meta, "AxialDisplacement", false, NULL, NULL);
		::Uml::InitAttributeProps(AxialDisplacement::meta_Property, "Property", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(AxialRotation::meta, "AxialRotation", false, NULL, NULL);
		::Uml::InitAttributeProps(AxialRotation::meta_Property, "Property", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Ball::meta, "Ball", false, NULL, NULL);

		::Uml::InitClassProps(BoundingBox::meta, "BoundingBox", false, NULL, NULL);

		::Uml::InitClassProps(CADComponent::meta, "CADComponent", false, NULL, NULL);
		::Uml::InitAttributeProps(CADComponent::meta_ComponentID, "ComponentID", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(CADComponent::meta_Name, "Name", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(CADComponent::meta_Type, "Type", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(CADComponent::meta_SpecialInstruction, "SpecialInstruction", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(CADComponent::meta_MaterialID, "MaterialID", "String", false, false, 1, 1, false, "public", vector<string>());
		vector<string> CADComponent_Standalone_dva;
		CADComponent_Standalone_dva.push_back("false");
		::Uml::InitAttributeProps(CADComponent::meta_Standalone, "Standalone", "Boolean", false, false, 1, 1, false, "public", CADComponent_Standalone_dva);

		::Uml::InitClassProps(CADParameter::meta, "CADParameter", false, NULL, NULL);
		::Uml::InitAttributeProps(CADParameter::meta_Name, "Name", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(CADParameter::meta_Type, "Type", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(CADParameter::meta_Value, "Value", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(CenterOfGravity::meta, "CenterOfGravity", false, NULL, NULL);

		::Uml::InitClassProps(Component::meta, "Component", false, NULL, NULL);
		::Uml::InitAttributeProps(Component::meta_ComponentID, "ComponentID", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Component::meta_InfiniteCycle, "InfiniteCycle", "Boolean", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(ComputationType::meta, "ComputationType", true, NULL, NULL);
		::Uml::InitAttributeProps(ComputationType::meta_ComponentID, "ComponentID", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(ComputationType::meta_RequestedValueType, "RequestedValueType", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(ComputationType::meta_MetricID, "MetricID", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Computations::meta, "Computations", false, NULL, NULL);

		::Uml::InitClassProps(Condition::meta, "Condition", false, NULL, NULL);
		::Uml::InitAttributeProps(Condition::meta_Name, "Name", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Condition::meta_Value, "Value", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Condition::meta_Units, "Units", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Conditions::meta, "Conditions", false, NULL, NULL);

		::Uml::InitClassProps(Constraint::meta, "Constraint", false, NULL, NULL);

		::Uml::InitClassProps(ConstraintFeature::meta, "ConstraintFeature", false, NULL, NULL);
		::Uml::InitAttributeProps(ConstraintFeature::meta_ComponentID, "ComponentID", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(ConstraintFeature::meta_FeatureName, "FeatureName", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(ConstraintFeature::meta_FeatureOrientationType, "FeatureOrientationType", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(ConstraintOffset::meta, "ConstraintOffset", false, NULL, NULL);
		::Uml::InitAttributeProps(ConstraintOffset::meta_Value, "Value", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(ConstraintOffset::meta_OffsetAlignmentType, "OffsetAlignmentType", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(ConstraintType::meta, "ConstraintType", true, NULL, NULL);

		::Uml::InitClassProps(DataExchange::meta, "DataExchange", false, NULL, NULL);

		::Uml::InitClassProps(DataFormatBase::meta, "DataFormatBase", true, NULL, NULL);

		::Uml::InitClassProps(Displacement::meta, "Displacement", false, NULL, NULL);

		::Uml::InitClassProps(FEA::meta, "FEA", false, NULL, NULL);
		::Uml::InitAttributeProps(FEA::meta_Type, "Type", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Feature::meta, "Feature", false, NULL, NULL);
		::Uml::InitAttributeProps(Feature::meta_Name, "Name", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Feature::meta_ComponentID, "ComponentID", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Features::meta, "Features", false, NULL, NULL);
		::Uml::InitAttributeProps(Features::meta_FeatureID, "FeatureID", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Features::meta_GeometryType, "GeometryType", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Features::meta_FeatureInterfaceType, "FeatureInterfaceType", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Features::meta_FeatureGeometryType, "FeatureGeometryType", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Features::meta_PrimaryGeometryQualifier, "PrimaryGeometryQualifier", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Features::meta_SecondaryGeometryQualifier, "SecondaryGeometryQualifier", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Fixed::meta, "Fixed", false, NULL, NULL);

		::Uml::InitClassProps(Force::meta, "Force", false, NULL, NULL);
		::Uml::InitAttributeProps(Force::meta_Units, "Units", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Force::meta_x, "x", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Force::meta_y, "y", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Force::meta_z, "z", "Real", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(ForceMoment::meta, "ForceMoment", false, NULL, NULL);

		::Uml::InitClassProps(Geometry::meta, "Geometry", false, NULL, NULL);

		::Uml::InitClassProps(Interference::meta, "Interference", false, NULL, NULL);

		::Uml::InitClassProps(KinematicBase::meta, "KinematicBase", true, NULL, NULL);
		::Uml::InitAttributeProps(KinematicBase::meta_ConnectionID, "ConnectionID", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(KinematicBase::meta_ConnectedComponentID, "ConnectedComponentID", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(KinematicBase::meta_FeatureInterfaceType, "FeatureInterfaceType", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(KinematicBase::meta_ERP, "ERP", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(KinematicBase::meta_CFM, "CFM", "Real", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(KinematicConnections::meta, "KinematicConnections", false, NULL, NULL);

		::Uml::InitClassProps(KinematicFeature::meta, "KinematicFeature", false, NULL, NULL);
		::Uml::InitAttributeProps(KinematicFeature::meta_DatumName, "DatumName", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(KinematicFeature::meta_ComponentID, "ComponentID", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(KinematicFeature::meta_FeatureGeometryType, "FeatureGeometryType", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Load::meta, "Load", false, NULL, NULL);

		::Uml::InitClassProps(LoadType::meta, "LoadType", true, NULL, NULL);

		::Uml::InitClassProps(Loads::meta, "Loads", false, NULL, NULL);

		::Uml::InitClassProps(Mass::meta, "Mass", false, NULL, NULL);

		::Uml::InitClassProps(Material::meta, "Material", false, NULL, NULL);
		::Uml::InitAttributeProps(Material::meta_MaterialName, "MaterialName", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Material::meta_MaterialID, "MaterialID", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Material::meta_MaterialType, "MaterialType", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(MaterialProperty::meta, "MaterialProperty", false, NULL, NULL);
		::Uml::InitAttributeProps(MaterialProperty::meta_PropertyName, "PropertyName", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(MaterialProperty::meta_Value, "Value", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(MaterialProperty::meta_Units, "Units", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Materials::meta, "Materials", false, NULL, NULL);

		::Uml::InitClassProps(Metric::meta, "Metric", false, NULL, NULL);
		::Uml::InitAttributeProps(Metric::meta_Type, "Type", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Metric::meta_ID, "ID", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Metrics::meta, "Metrics", false, NULL, NULL);

		::Uml::InitClassProps(Moment::meta, "Moment", false, NULL, NULL);
		::Uml::InitAttributeProps(Moment::meta_Units, "Units", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Moment::meta_x, "x", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Moment::meta_y, "y", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Moment::meta_z, "z", "Real", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Pair::meta, "Pair", false, NULL, NULL);
		::Uml::InitAttributeProps(Pair::meta_FeatureInterfaceType, "FeatureInterfaceType", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Pair::meta_FeatureGeometryType, "FeatureGeometryType", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Pair::meta_FeatureAlignmentType, "FeatureAlignmentType", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(ParametricParameters::meta, "ParametricParameters", false, NULL, NULL);

		::Uml::InitClassProps(PartInterface::meta, "PartInterface", false, NULL, NULL);
		::Uml::InitAttributeProps(PartInterface::meta_Type, "Type", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(PartInterface::meta_ComponentID_1, "ComponentID_1", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(PartInterface::meta_ComponentID_2, "ComponentID_2", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(PartInterfaces::meta, "PartInterfaces", false, NULL, NULL);

		::Uml::InitClassProps(Pin::meta, "Pin", false, NULL, NULL);

		::Uml::InitClassProps(PointCoordinates::meta, "PointCoordinates", false, NULL, NULL);
		::Uml::InitAttributeProps(PointCoordinates::meta_FeatureDatumName, "FeatureDatumName", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Pressure::meta, "Pressure", false, NULL, NULL);
		::Uml::InitAttributeProps(Pressure::meta_Value, "Value", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Pressure::meta_Units, "Units", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Prismatic::meta, "Prismatic", false, NULL, NULL);

		::Uml::InitClassProps(Properties::meta, "Properties", false, NULL, NULL);

		::Uml::InitClassProps(Revolute::meta, "Revolute", false, NULL, NULL);

		::Uml::InitClassProps(Rotation::meta, "Rotation", false, NULL, NULL);
		::Uml::InitAttributeProps(Rotation::meta_Units, "Units", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Rotation::meta_x, "x", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Rotation::meta_y, "y", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Rotation::meta_z, "z", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(STEPFormat::meta, "STEPFormat", false, NULL, NULL);
		::Uml::InitAttributeProps(STEPFormat::meta_Name, "Name", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(SetOperation::meta, "SetOperation", false, NULL, NULL);
		::Uml::InitAttributeProps(SetOperation::meta_Type, "Type", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(SetOperation::meta_FeatureID, "FeatureID", "String", false, false, 2, -1, false, "public", vector<string>());

		::Uml::InitClassProps(Solver::meta, "Solver", false, NULL, NULL);
		::Uml::InitAttributeProps(Solver::meta_Type, "Type", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Solver::meta_MeshType, "MeshType", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Solver::meta_ShellElementType, "ShellElementType", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Solver::meta_ElementShapeType, "ElementShapeType", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Solvers::meta, "Solvers", false, NULL, NULL);

		::Uml::InitClassProps(Spherical::meta, "Spherical", false, NULL, NULL);

		::Uml::InitClassProps(SurfaceTreatment::meta, "SurfaceTreatment", false, NULL, NULL);
		::Uml::InitAttributeProps(SurfaceTreatment::meta_AdjoiningParts, "AdjoiningParts", "String", false, false, 0, -1, false, "public", vector<string>());

		::Uml::InitClassProps(SurfaceTreatments::meta, "SurfaceTreatments", false, NULL, NULL);

		::Uml::InitClassProps(Tolerance::meta, "Tolerance", false, NULL, NULL);

		::Uml::InitClassProps(Translation::meta, "Translation", false, NULL, NULL);
		::Uml::InitAttributeProps(Translation::meta_Units, "Units", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Translation::meta_x, "x", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Translation::meta_y, "y", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Translation::meta_z, "z", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(UnassembledComponents::meta, "UnassembledComponents", false, NULL, NULL);

		::Uml::InitClassProps(Units::meta, "Units", false, NULL, NULL);
		::Uml::InitAttributeProps(Units::meta_Value, "Value", "String", false, false, 1, 1, false, "public", vector<string>());

		// compositions
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			CADComponent::meta_Assembly_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(CADComponent::meta_Assembly_parent, "Assembly_parent", true);
			Assembly::meta_CADComponent_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Assembly::meta_CADComponent_child, "CADComponent", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Analyses::meta_Assembly_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Analyses::meta_Assembly_parent, "Assembly_parent", true);
			Assembly::meta_Analyses_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Assembly::meta_Analyses_child, "Analyses", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Properties::meta_Assembly_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Properties::meta_Assembly_parent, "Assembly_parent", true);
			Assembly::meta_Properties_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Assembly::meta_Properties_child, "Properties", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Computations::meta_Assembly_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Computations::meta_Assembly_parent, "Assembly_parent", true);
			Assembly::meta_Computations_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Assembly::meta_Computations_child, "Computations", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			CADComponent::meta_CADComponent_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(CADComponent::meta_CADComponent_parent, "CADComponent_parent", true);
			CADComponent::meta_CADComponent_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(CADComponent::meta_CADComponent_children, "CADComponent", true, 0, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Constraint::meta_CADComponent_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Constraint::meta_CADComponent_parent, "CADComponent_parent", true);
			CADComponent::meta_Constraint_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(CADComponent::meta_Constraint_children, "Constraint", true, 0, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			ParametricParameters::meta_CADComponent_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(ParametricParameters::meta_CADComponent_parent, "CADComponent_parent", true);
			CADComponent::meta_ParametricParameters_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(CADComponent::meta_ParametricParameters_child, "ParametricParameters", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			KinematicConnections::meta_CADComponent_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(KinematicConnections::meta_CADComponent_parent, "CADComponent_parent", true);
			CADComponent::meta_KinematicConnections_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(CADComponent::meta_KinematicConnections_child, "KinematicConnections", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Units::meta_Properties_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Units::meta_Properties_parent, "Properties_parent", true);
			Properties::meta_Units_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Properties::meta_Units_child, "Units", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Pair::meta_Constraint_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Pair::meta_Constraint_parent, "Constraint_parent", true);
			Constraint::meta_Pair_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Constraint::meta_Pair_children, "Pair", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			ConstraintOffset::meta_Pair_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(ConstraintOffset::meta_Pair_parent, "Pair_parent", true);
			Pair::meta_ConstraintOffset_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Pair::meta_ConstraintOffset_child, "ConstraintOffset", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			ConstraintFeature::meta_Pair_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(ConstraintFeature::meta_Pair_parent, "Pair_parent", true);
			Pair::meta_ConstraintFeature_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Pair::meta_ConstraintFeature_children, "ConstraintFeature", true, 2, 2);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Units::meta_CADParameter_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Units::meta_CADParameter_parent, "CADParameter_parent", true);
			CADParameter::meta_Units_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(CADParameter::meta_Units_child, "Units", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Units::meta_ConstraintOffset_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Units::meta_ConstraintOffset_parent, "ConstraintOffset_parent", true);
			ConstraintOffset::meta_Units_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(ConstraintOffset::meta_Units_child, "Units", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			CADParameter::meta_ParametricParameters_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(CADParameter::meta_ParametricParameters_parent, "ParametricParameters_parent", true);
			ParametricParameters::meta_CADParameter_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(ParametricParameters::meta_CADParameter_children, "CADParameter", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Assembly::meta_Assemblies_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Assembly::meta_Assemblies_parent, "Assemblies_parent", true);
			Assemblies::meta_Assembly_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Assemblies::meta_Assembly_children, "Assembly", true, 0, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Materials::meta_Assemblies_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Materials::meta_Assemblies_parent, "Assemblies_parent", true);
			Assemblies::meta_Materials_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Assemblies::meta_Materials_children, "Materials", true, 0, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			DataExchange::meta_Assemblies_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(DataExchange::meta_Assemblies_parent, "Assemblies_parent", true);
			Assemblies::meta_DataExchange_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Assemblies::meta_DataExchange_child, "DataExchange", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			UnassembledComponents::meta_Assemblies_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(UnassembledComponents::meta_Assemblies_parent, "Assemblies_parent", true);
			Assemblies::meta_UnassembledComponents_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Assemblies::meta_UnassembledComponents_child, "UnassembledComponents", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			AnalysisType::meta_Analyses_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(AnalysisType::meta_Analyses_parent, "Analyses_parent", true);
			Analyses::meta_AnalysisType_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Analyses::meta_AnalysisType_children, "AnalysisType", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			MaterialProperty::meta_Material_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(MaterialProperty::meta_Material_parent, "Material_parent", true);
			Material::meta_MaterialProperty_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Material::meta_MaterialProperty_children, "MaterialProperty", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Material::meta_Materials_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Material::meta_Materials_parent, "Materials_parent", true);
			Materials::meta_Material_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Materials::meta_Material_children, "Material", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			DataFormatBase::meta_DataExchange_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(DataFormatBase::meta_DataExchange_parent, "DataExchange_parent", true);
			DataExchange::meta_DataFormatBase_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(DataExchange::meta_DataFormatBase_children, "DataFormatBase", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			ComputationType::meta_Computations_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(ComputationType::meta_Computations_parent, "Computations_parent", true);
			Computations::meta_ComputationType_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Computations::meta_ComputationType_children, "ComputationType", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			CADComponent::meta_UnassembledComponents_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(CADComponent::meta_UnassembledComponents_parent, "UnassembledComponents_parent", true);
			UnassembledComponents::meta_CADComponent_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(UnassembledComponents::meta_CADComponent_children, "CADComponent", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			AnalysisConstraint::meta_AnalysisConstraints_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(AnalysisConstraint::meta_AnalysisConstraints_parent, "AnalysisConstraints_parent", true);
			AnalysisConstraints::meta_AnalysisConstraint_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(AnalysisConstraints::meta_AnalysisConstraint_children, "AnalysisConstraint", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			PartInterface::meta_PartInterfaces_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(PartInterface::meta_PartInterfaces_parent, "PartInterfaces_parent", true);
			PartInterfaces::meta_PartInterface_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(PartInterfaces::meta_PartInterface_children, "PartInterface", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			AnalysisConstraints::meta_FEA_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(AnalysisConstraints::meta_FEA_parent, "FEA_parent", true);
			FEA::meta_AnalysisConstraints_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(FEA::meta_AnalysisConstraints_child, "AnalysisConstraints", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Loads::meta_FEA_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Loads::meta_FEA_parent, "FEA_parent", true);
			FEA::meta_Loads_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(FEA::meta_Loads_child, "Loads", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			PartInterfaces::meta_FEA_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(PartInterfaces::meta_FEA_parent, "FEA_parent", true);
			FEA::meta_PartInterfaces_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(FEA::meta_PartInterfaces_child, "PartInterfaces", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			AnalysisComponents::meta_FEA_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(AnalysisComponents::meta_FEA_parent, "FEA_parent", true);
			FEA::meta_AnalysisComponents_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(FEA::meta_AnalysisComponents_child, "AnalysisComponents", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Solvers::meta_FEA_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Solvers::meta_FEA_parent, "FEA_parent", true);
			FEA::meta_Solvers_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(FEA::meta_Solvers_child, "Solvers", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Conditions::meta_FEA_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Conditions::meta_FEA_parent, "FEA_parent", true);
			FEA::meta_Conditions_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(FEA::meta_Conditions_child, "Conditions", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			SurfaceTreatments::meta_FEA_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(SurfaceTreatments::meta_FEA_parent, "FEA_parent", true);
			FEA::meta_SurfaceTreatments_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(FEA::meta_SurfaceTreatments_children, "SurfaceTreatments", true, 0, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			ConstraintType::meta_AnalysisConstraint_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(ConstraintType::meta_AnalysisConstraint_parent, "AnalysisConstraint_parent", true);
			AnalysisConstraint::meta_ConstraintType_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(AnalysisConstraint::meta_ConstraintType_child, "ConstraintType", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Geometry::meta_AnalysisConstraint_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Geometry::meta_AnalysisConstraint_parent, "AnalysisConstraint_parent", true);
			AnalysisConstraint::meta_Geometry_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(AnalysisConstraint::meta_Geometry_child, "Geometry", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Load::meta_Loads_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Load::meta_Loads_parent, "Loads_parent", true);
			Loads::meta_Load_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Loads::meta_Load_children, "Load", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Component::meta_AnalysisComponents_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Component::meta_AnalysisComponents_parent, "AnalysisComponents_parent", true);
			AnalysisComponents::meta_Component_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(AnalysisComponents::meta_Component_children, "Component", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			LoadType::meta_Load_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(LoadType::meta_Load_parent, "Load_parent", true);
			Load::meta_LoadType_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Load::meta_LoadType_child, "LoadType", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Geometry::meta_Load_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Geometry::meta_Load_parent, "Load_parent", true);
			Load::meta_Geometry_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Load::meta_Geometry_child, "Geometry", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Metrics::meta_Component_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Metrics::meta_Component_parent, "Component_parent", true);
			Component::meta_Metrics_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Component::meta_Metrics_child, "Metrics", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Solver::meta_Solvers_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Solver::meta_Solvers_parent, "Solvers_parent", true);
			Solvers::meta_Solver_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Solvers::meta_Solver_children, "Solver", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Metric::meta_Metrics_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Metric::meta_Metrics_parent, "Metrics_parent", true);
			Metrics::meta_Metric_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Metrics::meta_Metric_children, "Metric", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Condition::meta_Conditions_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Condition::meta_Conditions_parent, "Conditions_parent", true);
			Conditions::meta_Condition_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Conditions::meta_Condition_children, "Condition", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Geometry::meta_SurfaceTreatment_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Geometry::meta_SurfaceTreatment_parent, "SurfaceTreatment_parent", true);
			SurfaceTreatment::meta_Geometry_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(SurfaceTreatment::meta_Geometry_child, "Geometry", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			SurfaceTreatment::meta_SurfaceTreatments_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(SurfaceTreatment::meta_SurfaceTreatments_parent, "SurfaceTreatments_parent", true);
			SurfaceTreatments::meta_SurfaceTreatment_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(SurfaceTreatments::meta_SurfaceTreatment_children, "SurfaceTreatment", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Feature::meta_Features_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Feature::meta_Features_parent, "Features_parent", true);
			Features::meta_Feature_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Features::meta_Feature_children, "Feature", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Translation::meta_Displacement_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Translation::meta_Displacement_parent, "Displacement_parent", true);
			Displacement::meta_Translation_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Displacement::meta_Translation_child, "Translation", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Rotation::meta_Displacement_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Rotation::meta_Displacement_parent, "Displacement_parent", true);
			Displacement::meta_Rotation_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Displacement::meta_Rotation_child, "Rotation", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			AxialRotation::meta_Pin_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(AxialRotation::meta_Pin_parent, "Pin_parent", true);
			Pin::meta_AxialRotation_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Pin::meta_AxialRotation_child, "AxialRotation", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			AxialDisplacement::meta_Pin_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(AxialDisplacement::meta_Pin_parent, "Pin_parent", true);
			Pin::meta_AxialDisplacement_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Pin::meta_AxialDisplacement_child, "AxialDisplacement", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Force::meta_ForceMoment_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Force::meta_ForceMoment_parent, "ForceMoment_parent", true);
			ForceMoment::meta_Force_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(ForceMoment::meta_Force_child, "Force", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Moment::meta_ForceMoment_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Moment::meta_ForceMoment_parent, "ForceMoment_parent", true);
			ForceMoment::meta_Moment_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(ForceMoment::meta_Moment_child, "Moment", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Features::meta_Geometry_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Features::meta_Geometry_parent, "Geometry_parent", true);
			Geometry::meta_Features_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Geometry::meta_Features_children, "Features", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			SetOperation::meta_Geometry_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(SetOperation::meta_Geometry_parent, "Geometry_parent", true);
			Geometry::meta_SetOperation_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Geometry::meta_SetOperation_children, "SetOperation", true, 0, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			KinematicFeature::meta_KinematicBase_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(KinematicFeature::meta_KinematicBase_parent, "KinematicBase_parent", true);
			KinematicBase::meta_KinematicFeature_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(KinematicBase::meta_KinematicFeature_children, "KinematicFeature", true, 0, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			KinematicBase::meta_KinematicConnections_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(KinematicBase::meta_KinematicConnections_parent, "KinematicConnections_parent", true);
			KinematicConnections::meta_KinematicBase_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(KinematicConnections::meta_KinematicBase_children, "KinematicBase", true, 1, -1);

		}

	}

	void InitMetaLinks() {
		AnalysisType::meta_Analyses_parent.target() = Analyses::meta;
		Assembly::meta_Analyses_child.target() = Analyses::meta;

		Component::meta_AnalysisComponents_parent.target() = AnalysisComponents::meta;
		FEA::meta_AnalysisComponents_child.target() = AnalysisComponents::meta;

		ConstraintType::meta_AnalysisConstraint_parent.target() = AnalysisConstraint::meta;
		Geometry::meta_AnalysisConstraint_parent.target() = AnalysisConstraint::meta;
		AnalysisConstraints::meta_AnalysisConstraint_children.target() = AnalysisConstraint::meta;

		AnalysisConstraint::meta_AnalysisConstraints_parent.target() = AnalysisConstraints::meta;
		FEA::meta_AnalysisConstraints_child.target() = AnalysisConstraints::meta;

		Analyses::meta_AnalysisType_children.target() = AnalysisType::meta;
		AnalysisType::meta.subTypes() += FEA::meta;
		AnalysisType::meta.subTypes() += Interference::meta;
		AnalysisType::meta.subTypes() += Tolerance::meta;

		Assembly::meta_Assemblies_parent.target() = Assemblies::meta;
		Materials::meta_Assemblies_parent.target() = Assemblies::meta;
		DataExchange::meta_Assemblies_parent.target() = Assemblies::meta;
		UnassembledComponents::meta_Assemblies_parent.target() = Assemblies::meta;

		CADComponent::meta_Assembly_parent.target() = Assembly::meta;
		Analyses::meta_Assembly_parent.target() = Assembly::meta;
		Properties::meta_Assembly_parent.target() = Assembly::meta;
		Computations::meta_Assembly_parent.target() = Assembly::meta;
		Assemblies::meta_Assembly_children.target() = Assembly::meta;

		Pin::meta_AxialDisplacement_child.target() = AxialDisplacement::meta;

		Pin::meta_AxialRotation_child.target() = AxialRotation::meta;

		CADComponent::meta_CADComponent_parent.target() = CADComponent::meta;
		Constraint::meta_CADComponent_parent.target() = CADComponent::meta;
		ParametricParameters::meta_CADComponent_parent.target() = CADComponent::meta;
		KinematicConnections::meta_CADComponent_parent.target() = CADComponent::meta;
		Assembly::meta_CADComponent_child.target() = CADComponent::meta;
		CADComponent::meta_CADComponent_children.target() = CADComponent::meta;
		UnassembledComponents::meta_CADComponent_children.target() = CADComponent::meta;

		Units::meta_CADParameter_parent.target() = CADParameter::meta;
		ParametricParameters::meta_CADParameter_children.target() = CADParameter::meta;

		Metrics::meta_Component_parent.target() = Component::meta;
		AnalysisComponents::meta_Component_children.target() = Component::meta;

		Computations::meta_ComputationType_children.target() = ComputationType::meta;
		ComputationType::meta.subTypes() += BoundingBox::meta;
		ComputationType::meta.subTypes() += CenterOfGravity::meta;
		ComputationType::meta.subTypes() += PointCoordinates::meta;
		ComputationType::meta.subTypes() += Mass::meta;

		ComputationType::meta_Computations_parent.target() = Computations::meta;
		Assembly::meta_Computations_child.target() = Computations::meta;

		Conditions::meta_Condition_children.target() = Condition::meta;

		Condition::meta_Conditions_parent.target() = Conditions::meta;
		FEA::meta_Conditions_child.target() = Conditions::meta;

		Pair::meta_Constraint_parent.target() = Constraint::meta;
		CADComponent::meta_Constraint_children.target() = Constraint::meta;

		Pair::meta_ConstraintFeature_children.target() = ConstraintFeature::meta;

		Units::meta_ConstraintOffset_parent.target() = ConstraintOffset::meta;
		Pair::meta_ConstraintOffset_child.target() = ConstraintOffset::meta;

		AnalysisConstraint::meta_ConstraintType_child.target() = ConstraintType::meta;
		ConstraintType::meta.subTypes() += Displacement::meta;
		ConstraintType::meta.subTypes() += Pin::meta;
		ConstraintType::meta.subTypes() += Ball::meta;

		DataFormatBase::meta_DataExchange_parent.target() = DataExchange::meta;
		Assemblies::meta_DataExchange_child.target() = DataExchange::meta;

		DataExchange::meta_DataFormatBase_children.target() = DataFormatBase::meta;
		DataFormatBase::meta.subTypes() += STEPFormat::meta;

		Translation::meta_Displacement_parent.target() = Displacement::meta;
		Rotation::meta_Displacement_parent.target() = Displacement::meta;

		AnalysisConstraints::meta_FEA_parent.target() = FEA::meta;
		Loads::meta_FEA_parent.target() = FEA::meta;
		PartInterfaces::meta_FEA_parent.target() = FEA::meta;
		AnalysisComponents::meta_FEA_parent.target() = FEA::meta;
		Solvers::meta_FEA_parent.target() = FEA::meta;
		Conditions::meta_FEA_parent.target() = FEA::meta;
		SurfaceTreatments::meta_FEA_parent.target() = FEA::meta;

		Features::meta_Feature_children.target() = Feature::meta;

		Feature::meta_Features_parent.target() = Features::meta;
		Geometry::meta_Features_children.target() = Features::meta;

		ForceMoment::meta_Force_child.target() = Force::meta;

		Force::meta_ForceMoment_parent.target() = ForceMoment::meta;
		Moment::meta_ForceMoment_parent.target() = ForceMoment::meta;

		Features::meta_Geometry_parent.target() = Geometry::meta;
		SetOperation::meta_Geometry_parent.target() = Geometry::meta;
		AnalysisConstraint::meta_Geometry_child.target() = Geometry::meta;
		Load::meta_Geometry_child.target() = Geometry::meta;
		SurfaceTreatment::meta_Geometry_child.target() = Geometry::meta;

		KinematicFeature::meta_KinematicBase_parent.target() = KinematicBase::meta;
		KinematicConnections::meta_KinematicBase_children.target() = KinematicBase::meta;
		KinematicBase::meta.subTypes() += Revolute::meta;
		KinematicBase::meta.subTypes() += Spherical::meta;
		KinematicBase::meta.subTypes() += Prismatic::meta;
		KinematicBase::meta.subTypes() += Fixed::meta;

		KinematicBase::meta_KinematicConnections_parent.target() = KinematicConnections::meta;
		CADComponent::meta_KinematicConnections_child.target() = KinematicConnections::meta;

		KinematicBase::meta_KinematicFeature_children.target() = KinematicFeature::meta;

		LoadType::meta_Load_parent.target() = Load::meta;
		Geometry::meta_Load_parent.target() = Load::meta;
		Loads::meta_Load_children.target() = Load::meta;

		Load::meta_LoadType_child.target() = LoadType::meta;
		LoadType::meta.subTypes() += ForceMoment::meta;
		LoadType::meta.subTypes() += Pressure::meta;
		LoadType::meta.subTypes() += Acceleration::meta;

		Load::meta_Loads_parent.target() = Loads::meta;
		FEA::meta_Loads_child.target() = Loads::meta;

		MaterialProperty::meta_Material_parent.target() = Material::meta;
		Materials::meta_Material_children.target() = Material::meta;

		Material::meta_MaterialProperty_children.target() = MaterialProperty::meta;

		Material::meta_Materials_parent.target() = Materials::meta;
		Assemblies::meta_Materials_children.target() = Materials::meta;

		Metrics::meta_Metric_children.target() = Metric::meta;

		Metric::meta_Metrics_parent.target() = Metrics::meta;
		Component::meta_Metrics_child.target() = Metrics::meta;

		ForceMoment::meta_Moment_child.target() = Moment::meta;

		ConstraintOffset::meta_Pair_parent.target() = Pair::meta;
		ConstraintFeature::meta_Pair_parent.target() = Pair::meta;
		Constraint::meta_Pair_children.target() = Pair::meta;

		CADParameter::meta_ParametricParameters_parent.target() = ParametricParameters::meta;
		CADComponent::meta_ParametricParameters_child.target() = ParametricParameters::meta;

		PartInterfaces::meta_PartInterface_children.target() = PartInterface::meta;

		PartInterface::meta_PartInterfaces_parent.target() = PartInterfaces::meta;
		FEA::meta_PartInterfaces_child.target() = PartInterfaces::meta;

		AxialRotation::meta_Pin_parent.target() = Pin::meta;
		AxialDisplacement::meta_Pin_parent.target() = Pin::meta;

		Units::meta_Properties_parent.target() = Properties::meta;
		Assembly::meta_Properties_child.target() = Properties::meta;

		Displacement::meta_Rotation_child.target() = Rotation::meta;

		Geometry::meta_SetOperation_children.target() = SetOperation::meta;

		Solvers::meta_Solver_children.target() = Solver::meta;

		Solver::meta_Solvers_parent.target() = Solvers::meta;
		FEA::meta_Solvers_child.target() = Solvers::meta;

		Geometry::meta_SurfaceTreatment_parent.target() = SurfaceTreatment::meta;
		SurfaceTreatments::meta_SurfaceTreatment_children.target() = SurfaceTreatment::meta;

		SurfaceTreatment::meta_SurfaceTreatments_parent.target() = SurfaceTreatments::meta;
		FEA::meta_SurfaceTreatments_children.target() = SurfaceTreatments::meta;

		Displacement::meta_Translation_child.target() = Translation::meta;

		CADComponent::meta_UnassembledComponents_parent.target() = UnassembledComponents::meta;
		Assemblies::meta_UnassembledComponents_child.target() = UnassembledComponents::meta;

		Properties::meta_Units_child.target() = Units::meta;
		CADParameter::meta_Units_child.target() = Units::meta;
		ConstraintOffset::meta_Units_child.target() = Units::meta;

	}

	void InitMeta(const ::Uml::Diagram &parent) {
		// classes, with attributes, constraints and constraint definitions
		::Uml::SetClass(Acceleration::meta, parent, "Acceleration");
		::Uml::SetAttribute(Acceleration::meta_Units, Acceleration::meta, "Units");
		::Uml::SetAttribute(Acceleration::meta_x, Acceleration::meta, "x");
		::Uml::SetAttribute(Acceleration::meta_y, Acceleration::meta, "y");
		::Uml::SetAttribute(Acceleration::meta_z, Acceleration::meta, "z");

		::Uml::SetClass(Analyses::meta, parent, "Analyses");

		::Uml::SetClass(AnalysisComponents::meta, parent, "AnalysisComponents");

		::Uml::SetClass(AnalysisConstraint::meta, parent, "AnalysisConstraint");

		::Uml::SetClass(AnalysisConstraints::meta, parent, "AnalysisConstraints");

		::Uml::SetClass(AnalysisType::meta, parent, "AnalysisType");
		::Uml::SetAttribute(AnalysisType::meta_AnalysisID, AnalysisType::meta, "AnalysisID");

		::Uml::SetClass(Assemblies::meta, parent, "Assemblies");
		::Uml::SetAttribute(Assemblies::meta_VersionInfo, Assemblies::meta, "VersionInfo");

		::Uml::SetClass(Assembly::meta, parent, "Assembly");
		::Uml::SetAttribute(Assembly::meta_ConfigurationID, Assembly::meta, "ConfigurationID");

		::Uml::SetClass(AxialDisplacement::meta, parent, "AxialDisplacement");
		::Uml::SetAttribute(AxialDisplacement::meta_Property, AxialDisplacement::meta, "Property");

		::Uml::SetClass(AxialRotation::meta, parent, "AxialRotation");
		::Uml::SetAttribute(AxialRotation::meta_Property, AxialRotation::meta, "Property");

		::Uml::SetClass(Ball::meta, parent, "Ball");

		::Uml::SetClass(BoundingBox::meta, parent, "BoundingBox");

		::Uml::SetClass(CADComponent::meta, parent, "CADComponent");
		::Uml::SetAttribute(CADComponent::meta_ComponentID, CADComponent::meta, "ComponentID");
		::Uml::SetAttribute(CADComponent::meta_Name, CADComponent::meta, "Name");
		::Uml::SetAttribute(CADComponent::meta_Type, CADComponent::meta, "Type");
		::Uml::SetAttribute(CADComponent::meta_SpecialInstruction, CADComponent::meta, "SpecialInstruction");
		::Uml::SetAttribute(CADComponent::meta_MaterialID, CADComponent::meta, "MaterialID");
		::Uml::SetAttribute(CADComponent::meta_Standalone, CADComponent::meta, "Standalone");

		::Uml::SetClass(CADParameter::meta, parent, "CADParameter");
		::Uml::SetAttribute(CADParameter::meta_Name, CADParameter::meta, "Name");
		::Uml::SetAttribute(CADParameter::meta_Type, CADParameter::meta, "Type");
		::Uml::SetAttribute(CADParameter::meta_Value, CADParameter::meta, "Value");

		::Uml::SetClass(CenterOfGravity::meta, parent, "CenterOfGravity");

		::Uml::SetClass(Component::meta, parent, "Component");
		::Uml::SetAttribute(Component::meta_ComponentID, Component::meta, "ComponentID");
		::Uml::SetAttribute(Component::meta_InfiniteCycle, Component::meta, "InfiniteCycle");

		::Uml::SetClass(ComputationType::meta, parent, "ComputationType");
		::Uml::SetAttribute(ComputationType::meta_ComponentID, ComputationType::meta, "ComponentID");
		::Uml::SetAttribute(ComputationType::meta_RequestedValueType, ComputationType::meta, "RequestedValueType");
		::Uml::SetAttribute(ComputationType::meta_MetricID, ComputationType::meta, "MetricID");

		::Uml::SetClass(Computations::meta, parent, "Computations");

		::Uml::SetClass(Condition::meta, parent, "Condition");
		::Uml::SetAttribute(Condition::meta_Name, Condition::meta, "Name");
		::Uml::SetAttribute(Condition::meta_Value, Condition::meta, "Value");
		::Uml::SetAttribute(Condition::meta_Units, Condition::meta, "Units");

		::Uml::SetClass(Conditions::meta, parent, "Conditions");

		::Uml::SetClass(Constraint::meta, parent, "Constraint");

		::Uml::SetClass(ConstraintFeature::meta, parent, "ConstraintFeature");
		::Uml::SetAttribute(ConstraintFeature::meta_ComponentID, ConstraintFeature::meta, "ComponentID");
		::Uml::SetAttribute(ConstraintFeature::meta_FeatureName, ConstraintFeature::meta, "FeatureName");
		::Uml::SetAttribute(ConstraintFeature::meta_FeatureOrientationType, ConstraintFeature::meta, "FeatureOrientationType");

		::Uml::SetClass(ConstraintOffset::meta, parent, "ConstraintOffset");
		::Uml::SetAttribute(ConstraintOffset::meta_Value, ConstraintOffset::meta, "Value");
		::Uml::SetAttribute(ConstraintOffset::meta_OffsetAlignmentType, ConstraintOffset::meta, "OffsetAlignmentType");

		::Uml::SetClass(ConstraintType::meta, parent, "ConstraintType");

		::Uml::SetClass(DataExchange::meta, parent, "DataExchange");

		::Uml::SetClass(DataFormatBase::meta, parent, "DataFormatBase");

		::Uml::SetClass(Displacement::meta, parent, "Displacement");

		::Uml::SetClass(FEA::meta, parent, "FEA");
		::Uml::SetAttribute(FEA::meta_Type, FEA::meta, "Type");

		::Uml::SetClass(Feature::meta, parent, "Feature");
		::Uml::SetAttribute(Feature::meta_Name, Feature::meta, "Name");
		::Uml::SetAttribute(Feature::meta_ComponentID, Feature::meta, "ComponentID");

		::Uml::SetClass(Features::meta, parent, "Features");
		::Uml::SetAttribute(Features::meta_FeatureID, Features::meta, "FeatureID");
		::Uml::SetAttribute(Features::meta_GeometryType, Features::meta, "GeometryType");
		::Uml::SetAttribute(Features::meta_FeatureInterfaceType, Features::meta, "FeatureInterfaceType");
		::Uml::SetAttribute(Features::meta_FeatureGeometryType, Features::meta, "FeatureGeometryType");
		::Uml::SetAttribute(Features::meta_PrimaryGeometryQualifier, Features::meta, "PrimaryGeometryQualifier");
		::Uml::SetAttribute(Features::meta_SecondaryGeometryQualifier, Features::meta, "SecondaryGeometryQualifier");

		::Uml::SetClass(Fixed::meta, parent, "Fixed");

		::Uml::SetClass(Force::meta, parent, "Force");
		::Uml::SetAttribute(Force::meta_Units, Force::meta, "Units");
		::Uml::SetAttribute(Force::meta_x, Force::meta, "x");
		::Uml::SetAttribute(Force::meta_y, Force::meta, "y");
		::Uml::SetAttribute(Force::meta_z, Force::meta, "z");

		::Uml::SetClass(ForceMoment::meta, parent, "ForceMoment");

		::Uml::SetClass(Geometry::meta, parent, "Geometry");

		::Uml::SetClass(Interference::meta, parent, "Interference");

		::Uml::SetClass(KinematicBase::meta, parent, "KinematicBase");
		::Uml::SetAttribute(KinematicBase::meta_ConnectionID, KinematicBase::meta, "ConnectionID");
		::Uml::SetAttribute(KinematicBase::meta_ConnectedComponentID, KinematicBase::meta, "ConnectedComponentID");
		::Uml::SetAttribute(KinematicBase::meta_FeatureInterfaceType, KinematicBase::meta, "FeatureInterfaceType");
		::Uml::SetAttribute(KinematicBase::meta_ERP, KinematicBase::meta, "ERP");
		::Uml::SetAttribute(KinematicBase::meta_CFM, KinematicBase::meta, "CFM");

		::Uml::SetClass(KinematicConnections::meta, parent, "KinematicConnections");

		::Uml::SetClass(KinematicFeature::meta, parent, "KinematicFeature");
		::Uml::SetAttribute(KinematicFeature::meta_DatumName, KinematicFeature::meta, "DatumName");
		::Uml::SetAttribute(KinematicFeature::meta_ComponentID, KinematicFeature::meta, "ComponentID");
		::Uml::SetAttribute(KinematicFeature::meta_FeatureGeometryType, KinematicFeature::meta, "FeatureGeometryType");

		::Uml::SetClass(Load::meta, parent, "Load");

		::Uml::SetClass(LoadType::meta, parent, "LoadType");

		::Uml::SetClass(Loads::meta, parent, "Loads");

		::Uml::SetClass(Mass::meta, parent, "Mass");

		::Uml::SetClass(Material::meta, parent, "Material");
		::Uml::SetAttribute(Material::meta_MaterialName, Material::meta, "MaterialName");
		::Uml::SetAttribute(Material::meta_MaterialID, Material::meta, "MaterialID");
		::Uml::SetAttribute(Material::meta_MaterialType, Material::meta, "MaterialType");

		::Uml::SetClass(MaterialProperty::meta, parent, "MaterialProperty");
		::Uml::SetAttribute(MaterialProperty::meta_PropertyName, MaterialProperty::meta, "PropertyName");
		::Uml::SetAttribute(MaterialProperty::meta_Value, MaterialProperty::meta, "Value");
		::Uml::SetAttribute(MaterialProperty::meta_Units, MaterialProperty::meta, "Units");

		::Uml::SetClass(Materials::meta, parent, "Materials");

		::Uml::SetClass(Metric::meta, parent, "Metric");
		::Uml::SetAttribute(Metric::meta_Type, Metric::meta, "Type");
		::Uml::SetAttribute(Metric::meta_ID, Metric::meta, "ID");

		::Uml::SetClass(Metrics::meta, parent, "Metrics");

		::Uml::SetClass(Moment::meta, parent, "Moment");
		::Uml::SetAttribute(Moment::meta_Units, Moment::meta, "Units");
		::Uml::SetAttribute(Moment::meta_x, Moment::meta, "x");
		::Uml::SetAttribute(Moment::meta_y, Moment::meta, "y");
		::Uml::SetAttribute(Moment::meta_z, Moment::meta, "z");

		::Uml::SetClass(Pair::meta, parent, "Pair");
		::Uml::SetAttribute(Pair::meta_FeatureInterfaceType, Pair::meta, "FeatureInterfaceType");
		::Uml::SetAttribute(Pair::meta_FeatureGeometryType, Pair::meta, "FeatureGeometryType");
		::Uml::SetAttribute(Pair::meta_FeatureAlignmentType, Pair::meta, "FeatureAlignmentType");

		::Uml::SetClass(ParametricParameters::meta, parent, "ParametricParameters");

		::Uml::SetClass(PartInterface::meta, parent, "PartInterface");
		::Uml::SetAttribute(PartInterface::meta_Type, PartInterface::meta, "Type");
		::Uml::SetAttribute(PartInterface::meta_ComponentID_1, PartInterface::meta, "ComponentID_1");
		::Uml::SetAttribute(PartInterface::meta_ComponentID_2, PartInterface::meta, "ComponentID_2");

		::Uml::SetClass(PartInterfaces::meta, parent, "PartInterfaces");

		::Uml::SetClass(Pin::meta, parent, "Pin");

		::Uml::SetClass(PointCoordinates::meta, parent, "PointCoordinates");
		::Uml::SetAttribute(PointCoordinates::meta_FeatureDatumName, PointCoordinates::meta, "FeatureDatumName");

		::Uml::SetClass(Pressure::meta, parent, "Pressure");
		::Uml::SetAttribute(Pressure::meta_Value, Pressure::meta, "Value");
		::Uml::SetAttribute(Pressure::meta_Units, Pressure::meta, "Units");

		::Uml::SetClass(Prismatic::meta, parent, "Prismatic");

		::Uml::SetClass(Properties::meta, parent, "Properties");

		::Uml::SetClass(Revolute::meta, parent, "Revolute");

		::Uml::SetClass(Rotation::meta, parent, "Rotation");
		::Uml::SetAttribute(Rotation::meta_Units, Rotation::meta, "Units");
		::Uml::SetAttribute(Rotation::meta_x, Rotation::meta, "x");
		::Uml::SetAttribute(Rotation::meta_y, Rotation::meta, "y");
		::Uml::SetAttribute(Rotation::meta_z, Rotation::meta, "z");

		::Uml::SetClass(STEPFormat::meta, parent, "STEPFormat");
		::Uml::SetAttribute(STEPFormat::meta_Name, STEPFormat::meta, "Name");

		::Uml::SetClass(SetOperation::meta, parent, "SetOperation");
		::Uml::SetAttribute(SetOperation::meta_Type, SetOperation::meta, "Type");
		::Uml::SetAttribute(SetOperation::meta_FeatureID, SetOperation::meta, "FeatureID");

		::Uml::SetClass(Solver::meta, parent, "Solver");
		::Uml::SetAttribute(Solver::meta_Type, Solver::meta, "Type");
		::Uml::SetAttribute(Solver::meta_MeshType, Solver::meta, "MeshType");
		::Uml::SetAttribute(Solver::meta_ShellElementType, Solver::meta, "ShellElementType");
		::Uml::SetAttribute(Solver::meta_ElementShapeType, Solver::meta, "ElementShapeType");

		::Uml::SetClass(Solvers::meta, parent, "Solvers");

		::Uml::SetClass(Spherical::meta, parent, "Spherical");

		::Uml::SetClass(SurfaceTreatment::meta, parent, "SurfaceTreatment");
		::Uml::SetAttribute(SurfaceTreatment::meta_AdjoiningParts, SurfaceTreatment::meta, "AdjoiningParts");

		::Uml::SetClass(SurfaceTreatments::meta, parent, "SurfaceTreatments");

		::Uml::SetClass(Tolerance::meta, parent, "Tolerance");

		::Uml::SetClass(Translation::meta, parent, "Translation");
		::Uml::SetAttribute(Translation::meta_Units, Translation::meta, "Units");
		::Uml::SetAttribute(Translation::meta_x, Translation::meta, "x");
		::Uml::SetAttribute(Translation::meta_y, Translation::meta, "y");
		::Uml::SetAttribute(Translation::meta_z, Translation::meta, "z");

		::Uml::SetClass(UnassembledComponents::meta, parent, "UnassembledComponents");

		::Uml::SetClass(Units::meta, parent, "Units");
		::Uml::SetAttribute(Units::meta_Value, Units::meta, "Value");

	}

	void InitMetaLinks(const ::Uml::Diagram &parent) {
		// classes
		::Uml::SetChildRole(Analyses::meta_AnalysisType_children, Analyses::meta, AnalysisType::meta, "", "");
		::Uml::SetParentRole(Analyses::meta_Assembly_parent, Analyses::meta, Assembly::meta, "", "");

		::Uml::SetChildRole(AnalysisComponents::meta_Component_children, AnalysisComponents::meta, Component::meta, "", "");
		::Uml::SetParentRole(AnalysisComponents::meta_FEA_parent, AnalysisComponents::meta, FEA::meta, "", "");

		::Uml::SetChildRole(AnalysisConstraint::meta_ConstraintType_child, AnalysisConstraint::meta, ConstraintType::meta, "", "");
		::Uml::SetChildRole(AnalysisConstraint::meta_Geometry_child, AnalysisConstraint::meta, Geometry::meta, "", "");
		::Uml::SetParentRole(AnalysisConstraint::meta_AnalysisConstraints_parent, AnalysisConstraint::meta, AnalysisConstraints::meta, "", "");

		::Uml::SetChildRole(AnalysisConstraints::meta_AnalysisConstraint_children, AnalysisConstraints::meta, AnalysisConstraint::meta, "", "");
		::Uml::SetParentRole(AnalysisConstraints::meta_FEA_parent, AnalysisConstraints::meta, FEA::meta, "", "");

		::Uml::SetParentRole(AnalysisType::meta_Analyses_parent, AnalysisType::meta, Analyses::meta, "", "");

		::Uml::SetChildRole(Assemblies::meta_Assembly_children, Assemblies::meta, Assembly::meta, "", "");
		::Uml::SetChildRole(Assemblies::meta_Materials_children, Assemblies::meta, Materials::meta, "", "");
		::Uml::SetChildRole(Assemblies::meta_DataExchange_child, Assemblies::meta, DataExchange::meta, "", "");
		::Uml::SetChildRole(Assemblies::meta_UnassembledComponents_child, Assemblies::meta, UnassembledComponents::meta, "", "");

		::Uml::SetChildRole(Assembly::meta_CADComponent_child, Assembly::meta, CADComponent::meta, "", "");
		::Uml::SetChildRole(Assembly::meta_Analyses_child, Assembly::meta, Analyses::meta, "", "");
		::Uml::SetChildRole(Assembly::meta_Properties_child, Assembly::meta, Properties::meta, "", "");
		::Uml::SetChildRole(Assembly::meta_Computations_child, Assembly::meta, Computations::meta, "", "");
		::Uml::SetParentRole(Assembly::meta_Assemblies_parent, Assembly::meta, Assemblies::meta, "", "");

		::Uml::SetParentRole(AxialDisplacement::meta_Pin_parent, AxialDisplacement::meta, Pin::meta, "", "");

		::Uml::SetParentRole(AxialRotation::meta_Pin_parent, AxialRotation::meta, Pin::meta, "", "");

		::Uml::SetChildRole(CADComponent::meta_CADComponent_children, CADComponent::meta, CADComponent::meta, "", "");
		::Uml::SetChildRole(CADComponent::meta_Constraint_children, CADComponent::meta, Constraint::meta, "", "");
		::Uml::SetChildRole(CADComponent::meta_ParametricParameters_child, CADComponent::meta, ParametricParameters::meta, "", "");
		::Uml::SetChildRole(CADComponent::meta_KinematicConnections_child, CADComponent::meta, KinematicConnections::meta, "", "");
		::Uml::SetParentRole(CADComponent::meta_Assembly_parent, CADComponent::meta, Assembly::meta, "", "");
		::Uml::SetParentRole(CADComponent::meta_CADComponent_parent, CADComponent::meta, CADComponent::meta, "", "");
		::Uml::SetParentRole(CADComponent::meta_UnassembledComponents_parent, CADComponent::meta, UnassembledComponents::meta, "", "");

		::Uml::SetChildRole(CADParameter::meta_Units_child, CADParameter::meta, Units::meta, "", "");
		::Uml::SetParentRole(CADParameter::meta_ParametricParameters_parent, CADParameter::meta, ParametricParameters::meta, "", "");

		::Uml::SetChildRole(Component::meta_Metrics_child, Component::meta, Metrics::meta, "", "");
		::Uml::SetParentRole(Component::meta_AnalysisComponents_parent, Component::meta, AnalysisComponents::meta, "", "");

		::Uml::SetParentRole(ComputationType::meta_Computations_parent, ComputationType::meta, Computations::meta, "", "");

		::Uml::SetChildRole(Computations::meta_ComputationType_children, Computations::meta, ComputationType::meta, "", "");
		::Uml::SetParentRole(Computations::meta_Assembly_parent, Computations::meta, Assembly::meta, "", "");

		::Uml::SetParentRole(Condition::meta_Conditions_parent, Condition::meta, Conditions::meta, "", "");

		::Uml::SetChildRole(Conditions::meta_Condition_children, Conditions::meta, Condition::meta, "", "");
		::Uml::SetParentRole(Conditions::meta_FEA_parent, Conditions::meta, FEA::meta, "", "");

		::Uml::SetChildRole(Constraint::meta_Pair_children, Constraint::meta, Pair::meta, "", "");
		::Uml::SetParentRole(Constraint::meta_CADComponent_parent, Constraint::meta, CADComponent::meta, "", "");

		::Uml::SetParentRole(ConstraintFeature::meta_Pair_parent, ConstraintFeature::meta, Pair::meta, "", "");

		::Uml::SetChildRole(ConstraintOffset::meta_Units_child, ConstraintOffset::meta, Units::meta, "", "");
		::Uml::SetParentRole(ConstraintOffset::meta_Pair_parent, ConstraintOffset::meta, Pair::meta, "", "");

		::Uml::SetParentRole(ConstraintType::meta_AnalysisConstraint_parent, ConstraintType::meta, AnalysisConstraint::meta, "", "");

		::Uml::SetChildRole(DataExchange::meta_DataFormatBase_children, DataExchange::meta, DataFormatBase::meta, "", "");
		::Uml::SetParentRole(DataExchange::meta_Assemblies_parent, DataExchange::meta, Assemblies::meta, "", "");

		::Uml::SetParentRole(DataFormatBase::meta_DataExchange_parent, DataFormatBase::meta, DataExchange::meta, "", "");

		::Uml::SetChildRole(Displacement::meta_Translation_child, Displacement::meta, Translation::meta, "", "");
		::Uml::SetChildRole(Displacement::meta_Rotation_child, Displacement::meta, Rotation::meta, "", "");

		::Uml::SetChildRole(FEA::meta_AnalysisConstraints_child, FEA::meta, AnalysisConstraints::meta, "", "");
		::Uml::SetChildRole(FEA::meta_Loads_child, FEA::meta, Loads::meta, "", "");
		::Uml::SetChildRole(FEA::meta_PartInterfaces_child, FEA::meta, PartInterfaces::meta, "", "");
		::Uml::SetChildRole(FEA::meta_AnalysisComponents_child, FEA::meta, AnalysisComponents::meta, "", "");
		::Uml::SetChildRole(FEA::meta_Solvers_child, FEA::meta, Solvers::meta, "", "");
		::Uml::SetChildRole(FEA::meta_Conditions_child, FEA::meta, Conditions::meta, "", "");
		::Uml::SetChildRole(FEA::meta_SurfaceTreatments_children, FEA::meta, SurfaceTreatments::meta, "", "");

		::Uml::SetParentRole(Feature::meta_Features_parent, Feature::meta, Features::meta, "", "");

		::Uml::SetChildRole(Features::meta_Feature_children, Features::meta, Feature::meta, "", "");
		::Uml::SetParentRole(Features::meta_Geometry_parent, Features::meta, Geometry::meta, "", "");

		::Uml::SetParentRole(Force::meta_ForceMoment_parent, Force::meta, ForceMoment::meta, "", "");

		::Uml::SetChildRole(ForceMoment::meta_Force_child, ForceMoment::meta, Force::meta, "", "");
		::Uml::SetChildRole(ForceMoment::meta_Moment_child, ForceMoment::meta, Moment::meta, "", "");

		::Uml::SetChildRole(Geometry::meta_Features_children, Geometry::meta, Features::meta, "", "");
		::Uml::SetChildRole(Geometry::meta_SetOperation_children, Geometry::meta, SetOperation::meta, "", "");
		::Uml::SetParentRole(Geometry::meta_AnalysisConstraint_parent, Geometry::meta, AnalysisConstraint::meta, "", "");
		::Uml::SetParentRole(Geometry::meta_Load_parent, Geometry::meta, Load::meta, "", "");
		::Uml::SetParentRole(Geometry::meta_SurfaceTreatment_parent, Geometry::meta, SurfaceTreatment::meta, "", "");

		::Uml::SetChildRole(KinematicBase::meta_KinematicFeature_children, KinematicBase::meta, KinematicFeature::meta, "", "");
		::Uml::SetParentRole(KinematicBase::meta_KinematicConnections_parent, KinematicBase::meta, KinematicConnections::meta, "", "");

		::Uml::SetChildRole(KinematicConnections::meta_KinematicBase_children, KinematicConnections::meta, KinematicBase::meta, "", "");
		::Uml::SetParentRole(KinematicConnections::meta_CADComponent_parent, KinematicConnections::meta, CADComponent::meta, "", "");

		::Uml::SetParentRole(KinematicFeature::meta_KinematicBase_parent, KinematicFeature::meta, KinematicBase::meta, "", "");

		::Uml::SetChildRole(Load::meta_LoadType_child, Load::meta, LoadType::meta, "", "");
		::Uml::SetChildRole(Load::meta_Geometry_child, Load::meta, Geometry::meta, "", "");
		::Uml::SetParentRole(Load::meta_Loads_parent, Load::meta, Loads::meta, "", "");

		::Uml::SetParentRole(LoadType::meta_Load_parent, LoadType::meta, Load::meta, "", "");

		::Uml::SetChildRole(Loads::meta_Load_children, Loads::meta, Load::meta, "", "");
		::Uml::SetParentRole(Loads::meta_FEA_parent, Loads::meta, FEA::meta, "", "");

		::Uml::SetChildRole(Material::meta_MaterialProperty_children, Material::meta, MaterialProperty::meta, "", "");
		::Uml::SetParentRole(Material::meta_Materials_parent, Material::meta, Materials::meta, "", "");

		::Uml::SetParentRole(MaterialProperty::meta_Material_parent, MaterialProperty::meta, Material::meta, "", "");

		::Uml::SetChildRole(Materials::meta_Material_children, Materials::meta, Material::meta, "", "");
		::Uml::SetParentRole(Materials::meta_Assemblies_parent, Materials::meta, Assemblies::meta, "", "");

		::Uml::SetParentRole(Metric::meta_Metrics_parent, Metric::meta, Metrics::meta, "", "");

		::Uml::SetChildRole(Metrics::meta_Metric_children, Metrics::meta, Metric::meta, "", "");
		::Uml::SetParentRole(Metrics::meta_Component_parent, Metrics::meta, Component::meta, "", "");

		::Uml::SetParentRole(Moment::meta_ForceMoment_parent, Moment::meta, ForceMoment::meta, "", "");

		::Uml::SetChildRole(Pair::meta_ConstraintOffset_child, Pair::meta, ConstraintOffset::meta, "", "");
		::Uml::SetChildRole(Pair::meta_ConstraintFeature_children, Pair::meta, ConstraintFeature::meta, "", "");
		::Uml::SetParentRole(Pair::meta_Constraint_parent, Pair::meta, Constraint::meta, "", "");

		::Uml::SetChildRole(ParametricParameters::meta_CADParameter_children, ParametricParameters::meta, CADParameter::meta, "", "");
		::Uml::SetParentRole(ParametricParameters::meta_CADComponent_parent, ParametricParameters::meta, CADComponent::meta, "", "");

		::Uml::SetParentRole(PartInterface::meta_PartInterfaces_parent, PartInterface::meta, PartInterfaces::meta, "", "");

		::Uml::SetChildRole(PartInterfaces::meta_PartInterface_children, PartInterfaces::meta, PartInterface::meta, "", "");
		::Uml::SetParentRole(PartInterfaces::meta_FEA_parent, PartInterfaces::meta, FEA::meta, "", "");

		::Uml::SetChildRole(Pin::meta_AxialRotation_child, Pin::meta, AxialRotation::meta, "", "");
		::Uml::SetChildRole(Pin::meta_AxialDisplacement_child, Pin::meta, AxialDisplacement::meta, "", "");

		::Uml::SetChildRole(Properties::meta_Units_child, Properties::meta, Units::meta, "", "");
		::Uml::SetParentRole(Properties::meta_Assembly_parent, Properties::meta, Assembly::meta, "", "");

		::Uml::SetParentRole(Rotation::meta_Displacement_parent, Rotation::meta, Displacement::meta, "", "");

		::Uml::SetParentRole(SetOperation::meta_Geometry_parent, SetOperation::meta, Geometry::meta, "", "");

		::Uml::SetParentRole(Solver::meta_Solvers_parent, Solver::meta, Solvers::meta, "", "");

		::Uml::SetChildRole(Solvers::meta_Solver_children, Solvers::meta, Solver::meta, "", "");
		::Uml::SetParentRole(Solvers::meta_FEA_parent, Solvers::meta, FEA::meta, "", "");

		::Uml::SetChildRole(SurfaceTreatment::meta_Geometry_child, SurfaceTreatment::meta, Geometry::meta, "", "");
		::Uml::SetParentRole(SurfaceTreatment::meta_SurfaceTreatments_parent, SurfaceTreatment::meta, SurfaceTreatments::meta, "", "");

		::Uml::SetChildRole(SurfaceTreatments::meta_SurfaceTreatment_children, SurfaceTreatments::meta, SurfaceTreatment::meta, "", "");
		::Uml::SetParentRole(SurfaceTreatments::meta_FEA_parent, SurfaceTreatments::meta, FEA::meta, "", "");

		::Uml::SetParentRole(Translation::meta_Displacement_parent, Translation::meta, Displacement::meta, "", "");

		::Uml::SetChildRole(UnassembledComponents::meta_CADComponent_children, UnassembledComponents::meta, CADComponent::meta, "", "");
		::Uml::SetParentRole(UnassembledComponents::meta_Assemblies_parent, UnassembledComponents::meta, Assemblies::meta, "", "");

		::Uml::SetParentRole(Units::meta_Properties_parent, Units::meta, Properties::meta, "", "");
		::Uml::SetParentRole(Units::meta_CADParameter_parent, Units::meta, CADParameter::meta, "", "");
		::Uml::SetParentRole(Units::meta_ConstraintOffset_parent, Units::meta, ConstraintOffset::meta, "", "");

	}

	void _SetXsdStorage()
	{
		UdmDom::str_xsd_storage::StoreXsd("AssemblyInterface.xsd", AssemblyInterface_xsd::getString());
	}

	void Initialize()
	{
		static bool first = true;
		if (!first) return;
		first = false;
		::Uml::Initialize();

	
		UDM_ASSERT( meta == ::Udm::null );

		::UdmStatic::StaticDataNetwork * meta_dn = new ::UdmStatic::StaticDataNetwork(::Uml::diagram);
		meta_dn->CreateNew("AssemblyInterface.mem", "", ::Uml::Diagram::meta, ::Udm::CHANGES_LOST_DEFAULT);
		meta = ::Uml::Diagram::Cast(meta_dn->GetRootObject());

		::Uml::InitDiagramProps(meta, "AssemblyInterface", "1.2.0.0");


		CreateMeta();
		InitMeta();
		InitMetaLinks();

		_SetXsdStorage();

	}

	void Initialize(const ::Uml::Diagram &dgr)
	{
		
		if (meta == dgr) return;
		meta = dgr;

		InitMeta(dgr);
		InitMetaLinks(dgr);

		
		_SetXsdStorage();
	}


	 ::Udm::UdmDiagram diagram = { &meta, Initialize };
	static struct _regClass
	{
		_regClass()
		{
			::Udm::MetaDepository::StoreDiagram("AssemblyInterface", diagram);
		}
		~_regClass()
		{
			::Udm::MetaDepository::RemoveDiagram("AssemblyInterface");
		}
	} __regUnUsed;

}

