/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef MOBIES_ASSEMBLYINTERFACE_H
#define MOBIES_ASSEMBLYINTERFACE_H

// header file AssemblyInterface.h generated from diagram AssemblyInterface
// generated with Udm version 3.31 on Thu Mar 07 16:38:21 2013

#include <UdmBase.h>

#if !defined(UDM_VERSION_MAJOR) || !defined(UDM_VERSION_MINOR)
#    error "Udm headers too old, they do not define UDM_VERSION"
#elif UDM_VERSION_MAJOR < 3
#    error "Udm headers too old, minimum version required 3.31"
#elif UDM_VERSION_MAJOR == 3 && UDM_VERSION_MINOR < 31
#    error "Udm headers too old, minimum version required 3.31"
#endif

#include <Uml.h>


#ifdef min
#undef min
#endif

#ifdef max
#undef max
#endif

namespace AssemblyInterface {

	extern ::Uml::Diagram meta;
	class Assembly;
	class CADComponent;
	class Units;
	class Properties;
	class Constraint;
	class ConstraintFeature;
	class Pair;
	class CADParameter;
	class ConstraintOffset;
	class ParametricParameters;
	class Assemblies;
	class Analyses;
	class Material;
	class MaterialProperty;
	class Materials;
	class DataExchange;
	class DataFormatBase;
	class STEPFormat;
	class Computations;
	class UnassembledComponents;
	class AnalysisConstraints;
	class PartInterfaces;
	class FEA;
	class AnalysisType;
	class Solver;
	class AnalysisConstraint;
	class Loads;
	class AnalysisComponents;
	class Load;
	class PartInterface;
	class Component;
	class Solvers;
	class Interference;
	class Tolerance;
	class Metric;
	class Metrics;
	class Conditions;
	class Condition;
	class SurfaceTreatment;
	class SurfaceTreatments;
	class Features;
	class Feature;
	class Displacement;
	class Pin;
	class Ball;
	class ConstraintType;
	class LoadType;
	class ForceMoment;
	class Pressure;
	class Acceleration;
	class AxialRotation;
	class AxialDisplacement;
	class Translation;
	class Rotation;
	class Force;
	class Moment;
	class Geometry;
	class SetOperation;
	class KinematicBase;
	class KinematicConnections;
	class Revolute;
	class Spherical;
	class Prismatic;
	class KinematicFeature;
	class Fixed;
	class ComputationType;
	class BoundingBox;
	class CenterOfGravity;
	class PointCoordinates;
	class Mass;

	void Initialize();
	void Initialize(const ::Uml::Diagram &dgr);

	extern  ::Udm::UdmDiagram diagram;

	class Assembly : public ::Udm::Object {
	public:
		Assembly();
		Assembly(::Udm::ObjectImpl *impl);
		Assembly(const Assembly &master);

#ifdef UDM_RVALUE
		Assembly(Assembly &&master);

		static Assembly Cast(::Udm::Object &&a);
		Assembly& operator=(Assembly &&a);

#endif
		static Assembly Cast(const ::Udm::Object &a);
		static Assembly Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Assembly CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Assembly> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Assembly, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Assembly, Pred>(impl); };
		Assembly CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Assembly> Derived();
		template <class Pred> ::Udm::DerivedAttr< Assembly, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Assembly, Pred>(impl); };
		::Udm::ArchetypeAttr< Assembly> Archetype() const;
		::Udm::StringAttr ConfigurationID() const;
		::Udm::ChildAttr< ::AssemblyInterface::CADComponent> CADComponent_child() const;
		::Udm::ChildAttr< ::AssemblyInterface::Analyses> Analyses_child() const;
		::Udm::ChildAttr< ::AssemblyInterface::Properties> Properties_child() const;
		::Udm::ChildAttr< ::AssemblyInterface::Computations> Computations_child() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent> CADComponent_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent, Pred> CADComponent_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Properties> Properties_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Properties, Pred> Properties_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Properties, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Analyses> Analyses_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Analyses, Pred> Analyses_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Analyses, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Computations> Computations_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Computations, Pred> Computations_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Computations, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Assemblies> Assemblies_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Assemblies> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_ConfigurationID;
		static ::Uml::CompositionChildRole meta_CADComponent_child;
		static ::Uml::CompositionChildRole meta_Analyses_child;
		static ::Uml::CompositionChildRole meta_Properties_child;
		static ::Uml::CompositionChildRole meta_Computations_child;
		static ::Uml::CompositionParentRole meta_Assemblies_parent;

	};

	class CADComponent : public ::Udm::Object {
	public:
		CADComponent();
		CADComponent(::Udm::ObjectImpl *impl);
		CADComponent(const CADComponent &master);

#ifdef UDM_RVALUE
		CADComponent(CADComponent &&master);

		static CADComponent Cast(::Udm::Object &&a);
		CADComponent& operator=(CADComponent &&a);

#endif
		static CADComponent Cast(const ::Udm::Object &a);
		static CADComponent Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		CADComponent CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< CADComponent> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< CADComponent, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< CADComponent, Pred>(impl); };
		CADComponent CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< CADComponent> Derived();
		template <class Pred> ::Udm::DerivedAttr< CADComponent, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< CADComponent, Pred>(impl); };
		::Udm::ArchetypeAttr< CADComponent> Archetype() const;
		::Udm::StringAttr ComponentID() const;
		::Udm::StringAttr Name() const;
		::Udm::StringAttr Type() const;
		::Udm::StringAttr SpecialInstruction() const;
		::Udm::StringAttr MaterialID() const;
		::Udm::BooleanAttr Standalone() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent> CADComponent_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent, Pred> CADComponent_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent, Pred>(impl, meta_CADComponent_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Constraint> Constraint_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Constraint, Pred> Constraint_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Constraint, Pred>(impl, meta_Constraint_children); };
		::Udm::ChildAttr< ::AssemblyInterface::ParametricParameters> ParametricParameters_child() const;
		::Udm::ChildAttr< ::AssemblyInterface::KinematicConnections> KinematicConnections_child() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent> CADComponent_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent, Pred> CADComponent_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Constraint> Constraint_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Constraint, Pred> Constraint_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Constraint, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::ParametricParameters> ParametricParameters_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::ParametricParameters, Pred> ParametricParameters_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ParametricParameters, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::KinematicConnections> KinematicConnections_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::KinematicConnections, Pred> KinematicConnections_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::KinematicConnections, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Assembly> Assembly_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::CADComponent> CADComponent_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::UnassembledComponents> UnassembledComponents_parent() const;
		::Udm::ParentAttr< ::Udm::Object> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_ComponentID;
		static ::Uml::Attribute meta_Name;
		static ::Uml::Attribute meta_Type;
		static ::Uml::Attribute meta_SpecialInstruction;
		static ::Uml::Attribute meta_MaterialID;
		static ::Uml::Attribute meta_Standalone;
		static ::Uml::CompositionChildRole meta_CADComponent_children;
		static ::Uml::CompositionChildRole meta_Constraint_children;
		static ::Uml::CompositionChildRole meta_ParametricParameters_child;
		static ::Uml::CompositionChildRole meta_KinematicConnections_child;
		static ::Uml::CompositionParentRole meta_Assembly_parent;
		static ::Uml::CompositionParentRole meta_CADComponent_parent;
		static ::Uml::CompositionParentRole meta_UnassembledComponents_parent;

	};

	class Units : public ::Udm::Object {
	public:
		Units();
		Units(::Udm::ObjectImpl *impl);
		Units(const Units &master);

#ifdef UDM_RVALUE
		Units(Units &&master);

		static Units Cast(::Udm::Object &&a);
		Units& operator=(Units &&a);

#endif
		static Units Cast(const ::Udm::Object &a);
		static Units Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Units CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Units> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Units, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Units, Pred>(impl); };
		Units CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Units> Derived();
		template <class Pred> ::Udm::DerivedAttr< Units, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Units, Pred>(impl); };
		::Udm::ArchetypeAttr< Units> Archetype() const;
		::Udm::StringAttr Value() const;
		::Udm::ParentAttr< ::AssemblyInterface::Properties> Properties_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::CADParameter> CADParameter_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::ConstraintOffset> ConstraintOffset_parent() const;
		::Udm::ParentAttr< ::Udm::Object> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Value;
		static ::Uml::CompositionParentRole meta_Properties_parent;
		static ::Uml::CompositionParentRole meta_CADParameter_parent;
		static ::Uml::CompositionParentRole meta_ConstraintOffset_parent;

	};

	class Properties : public ::Udm::Object {
	public:
		Properties();
		Properties(::Udm::ObjectImpl *impl);
		Properties(const Properties &master);

#ifdef UDM_RVALUE
		Properties(Properties &&master);

		static Properties Cast(::Udm::Object &&a);
		Properties& operator=(Properties &&a);

#endif
		static Properties Cast(const ::Udm::Object &a);
		static Properties Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Properties CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Properties> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Properties, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Properties, Pred>(impl); };
		Properties CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Properties> Derived();
		template <class Pred> ::Udm::DerivedAttr< Properties, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Properties, Pred>(impl); };
		::Udm::ArchetypeAttr< Properties> Archetype() const;
		::Udm::ChildAttr< ::AssemblyInterface::Units> Units_child() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Units> Units_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Units, Pred> Units_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Units, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Assembly> Assembly_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Assembly> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Units_child;
		static ::Uml::CompositionParentRole meta_Assembly_parent;

	};

	class Constraint : public ::Udm::Object {
	public:
		Constraint();
		Constraint(::Udm::ObjectImpl *impl);
		Constraint(const Constraint &master);

#ifdef UDM_RVALUE
		Constraint(Constraint &&master);

		static Constraint Cast(::Udm::Object &&a);
		Constraint& operator=(Constraint &&a);

#endif
		static Constraint Cast(const ::Udm::Object &a);
		static Constraint Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Constraint CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Constraint> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Constraint, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Constraint, Pred>(impl); };
		Constraint CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Constraint> Derived();
		template <class Pred> ::Udm::DerivedAttr< Constraint, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Constraint, Pred>(impl); };
		::Udm::ArchetypeAttr< Constraint> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Pair> Pair_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Pair, Pred> Pair_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Pair, Pred>(impl, meta_Pair_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Pair> Pair_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Pair, Pred> Pair_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Pair, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::CADComponent> CADComponent_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::CADComponent> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Pair_children;
		static ::Uml::CompositionParentRole meta_CADComponent_parent;

	};

	class ConstraintFeature : public ::Udm::Object {
	public:
		ConstraintFeature();
		ConstraintFeature(::Udm::ObjectImpl *impl);
		ConstraintFeature(const ConstraintFeature &master);

#ifdef UDM_RVALUE
		ConstraintFeature(ConstraintFeature &&master);

		static ConstraintFeature Cast(::Udm::Object &&a);
		ConstraintFeature& operator=(ConstraintFeature &&a);

#endif
		static ConstraintFeature Cast(const ::Udm::Object &a);
		static ConstraintFeature Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		ConstraintFeature CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< ConstraintFeature> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< ConstraintFeature, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< ConstraintFeature, Pred>(impl); };
		ConstraintFeature CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< ConstraintFeature> Derived();
		template <class Pred> ::Udm::DerivedAttr< ConstraintFeature, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< ConstraintFeature, Pred>(impl); };
		::Udm::ArchetypeAttr< ConstraintFeature> Archetype() const;
		::Udm::StringAttr ComponentID() const;
		::Udm::StringAttr FeatureName() const;
		::Udm::StringAttr FeatureOrientationType() const;
		::Udm::ParentAttr< ::AssemblyInterface::Pair> Pair_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Pair> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_ComponentID;
		static ::Uml::Attribute meta_FeatureName;
		static ::Uml::Attribute meta_FeatureOrientationType;
		static ::Uml::CompositionParentRole meta_Pair_parent;

	};

	class Pair : public ::Udm::Object {
	public:
		Pair();
		Pair(::Udm::ObjectImpl *impl);
		Pair(const Pair &master);

#ifdef UDM_RVALUE
		Pair(Pair &&master);

		static Pair Cast(::Udm::Object &&a);
		Pair& operator=(Pair &&a);

#endif
		static Pair Cast(const ::Udm::Object &a);
		static Pair Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Pair CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Pair> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Pair, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Pair, Pred>(impl); };
		Pair CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Pair> Derived();
		template <class Pred> ::Udm::DerivedAttr< Pair, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Pair, Pred>(impl); };
		::Udm::ArchetypeAttr< Pair> Archetype() const;
		::Udm::StringAttr FeatureInterfaceType() const;
		::Udm::StringAttr FeatureGeometryType() const;
		::Udm::StringAttr FeatureAlignmentType() const;
		::Udm::ChildAttr< ::AssemblyInterface::ConstraintOffset> ConstraintOffset_child() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintFeature> ConstraintFeature_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintFeature, Pred> ConstraintFeature_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintFeature, Pred>(impl, meta_ConstraintFeature_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintFeature> ConstraintFeature_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintFeature, Pred> ConstraintFeature_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintFeature, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintOffset> ConstraintOffset_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintOffset, Pred> ConstraintOffset_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintOffset, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Constraint> Constraint_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Constraint> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_FeatureInterfaceType;
		static ::Uml::Attribute meta_FeatureGeometryType;
		static ::Uml::Attribute meta_FeatureAlignmentType;
		static ::Uml::CompositionChildRole meta_ConstraintOffset_child;
		static ::Uml::CompositionChildRole meta_ConstraintFeature_children;
		static ::Uml::CompositionParentRole meta_Constraint_parent;

	};

	class CADParameter : public ::Udm::Object {
	public:
		CADParameter();
		CADParameter(::Udm::ObjectImpl *impl);
		CADParameter(const CADParameter &master);

#ifdef UDM_RVALUE
		CADParameter(CADParameter &&master);

		static CADParameter Cast(::Udm::Object &&a);
		CADParameter& operator=(CADParameter &&a);

#endif
		static CADParameter Cast(const ::Udm::Object &a);
		static CADParameter Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		CADParameter CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< CADParameter> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< CADParameter, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< CADParameter, Pred>(impl); };
		CADParameter CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< CADParameter> Derived();
		template <class Pred> ::Udm::DerivedAttr< CADParameter, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< CADParameter, Pred>(impl); };
		::Udm::ArchetypeAttr< CADParameter> Archetype() const;
		::Udm::StringAttr Name() const;
		::Udm::StringAttr Type() const;
		::Udm::StringAttr Value() const;
		::Udm::ChildAttr< ::AssemblyInterface::Units> Units_child() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Units> Units_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Units, Pred> Units_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Units, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::ParametricParameters> ParametricParameters_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::ParametricParameters> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Name;
		static ::Uml::Attribute meta_Type;
		static ::Uml::Attribute meta_Value;
		static ::Uml::CompositionChildRole meta_Units_child;
		static ::Uml::CompositionParentRole meta_ParametricParameters_parent;

	};

	class ConstraintOffset : public ::Udm::Object {
	public:
		ConstraintOffset();
		ConstraintOffset(::Udm::ObjectImpl *impl);
		ConstraintOffset(const ConstraintOffset &master);

#ifdef UDM_RVALUE
		ConstraintOffset(ConstraintOffset &&master);

		static ConstraintOffset Cast(::Udm::Object &&a);
		ConstraintOffset& operator=(ConstraintOffset &&a);

#endif
		static ConstraintOffset Cast(const ::Udm::Object &a);
		static ConstraintOffset Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		ConstraintOffset CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< ConstraintOffset> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< ConstraintOffset, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< ConstraintOffset, Pred>(impl); };
		ConstraintOffset CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< ConstraintOffset> Derived();
		template <class Pred> ::Udm::DerivedAttr< ConstraintOffset, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< ConstraintOffset, Pred>(impl); };
		::Udm::ArchetypeAttr< ConstraintOffset> Archetype() const;
		::Udm::RealAttr Value() const;
		::Udm::StringAttr OffsetAlignmentType() const;
		::Udm::ChildAttr< ::AssemblyInterface::Units> Units_child() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Units> Units_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Units, Pred> Units_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Units, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Pair> Pair_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Pair> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Value;
		static ::Uml::Attribute meta_OffsetAlignmentType;
		static ::Uml::CompositionChildRole meta_Units_child;
		static ::Uml::CompositionParentRole meta_Pair_parent;

	};

	class ParametricParameters : public ::Udm::Object {
	public:
		ParametricParameters();
		ParametricParameters(::Udm::ObjectImpl *impl);
		ParametricParameters(const ParametricParameters &master);

#ifdef UDM_RVALUE
		ParametricParameters(ParametricParameters &&master);

		static ParametricParameters Cast(::Udm::Object &&a);
		ParametricParameters& operator=(ParametricParameters &&a);

#endif
		static ParametricParameters Cast(const ::Udm::Object &a);
		static ParametricParameters Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		ParametricParameters CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< ParametricParameters> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< ParametricParameters, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< ParametricParameters, Pred>(impl); };
		ParametricParameters CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< ParametricParameters> Derived();
		template <class Pred> ::Udm::DerivedAttr< ParametricParameters, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< ParametricParameters, Pred>(impl); };
		::Udm::ArchetypeAttr< ParametricParameters> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::CADParameter> CADParameter_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::CADParameter, Pred> CADParameter_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CADParameter, Pred>(impl, meta_CADParameter_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::CADParameter> CADParameter_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::CADParameter, Pred> CADParameter_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CADParameter, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::CADComponent> CADComponent_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::CADComponent> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_CADParameter_children;
		static ::Uml::CompositionParentRole meta_CADComponent_parent;

	};

	class Assemblies : public ::Udm::Object {
	public:
		Assemblies();
		Assemblies(::Udm::ObjectImpl *impl);
		Assemblies(const Assemblies &master);

#ifdef UDM_RVALUE
		Assemblies(Assemblies &&master);

		static Assemblies Cast(::Udm::Object &&a);
		Assemblies& operator=(Assemblies &&a);

#endif
		static Assemblies Cast(const ::Udm::Object &a);
		static Assemblies Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Assemblies CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Assemblies> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Assemblies, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Assemblies, Pred>(impl); };
		Assemblies CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Assemblies> Derived();
		template <class Pred> ::Udm::DerivedAttr< Assemblies, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Assemblies, Pred>(impl); };
		::Udm::ArchetypeAttr< Assemblies> Archetype() const;
		::Udm::StringAttr VersionInfo() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Assembly> Assembly_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Assembly, Pred> Assembly_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Assembly, Pred>(impl, meta_Assembly_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Materials> Materials_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Materials, Pred> Materials_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Materials, Pred>(impl, meta_Materials_children); };
		::Udm::ChildAttr< ::AssemblyInterface::DataExchange> DataExchange_child() const;
		::Udm::ChildAttr< ::AssemblyInterface::UnassembledComponents> UnassembledComponents_child() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Assembly> Assembly_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Assembly, Pred> Assembly_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Assembly, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Materials> Materials_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Materials, Pred> Materials_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Materials, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::DataExchange> DataExchange_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::DataExchange, Pred> DataExchange_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::DataExchange, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::UnassembledComponents> UnassembledComponents_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::UnassembledComponents, Pred> UnassembledComponents_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::UnassembledComponents, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::Udm::Object> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_VersionInfo;
		static ::Uml::CompositionChildRole meta_Assembly_children;
		static ::Uml::CompositionChildRole meta_Materials_children;
		static ::Uml::CompositionChildRole meta_DataExchange_child;
		static ::Uml::CompositionChildRole meta_UnassembledComponents_child;

	};

	class Analyses : public ::Udm::Object {
	public:
		Analyses();
		Analyses(::Udm::ObjectImpl *impl);
		Analyses(const Analyses &master);

#ifdef UDM_RVALUE
		Analyses(Analyses &&master);

		static Analyses Cast(::Udm::Object &&a);
		Analyses& operator=(Analyses &&a);

#endif
		static Analyses Cast(const ::Udm::Object &a);
		static Analyses Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Analyses CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Analyses> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Analyses, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Analyses, Pred>(impl); };
		Analyses CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Analyses> Derived();
		template <class Pred> ::Udm::DerivedAttr< Analyses, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Analyses, Pred>(impl); };
		::Udm::ArchetypeAttr< Analyses> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisType> AnalysisType_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisType, Pred> AnalysisType_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisType, Pred>(impl, meta_AnalysisType_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::FEA> FEA_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::FEA, Pred> FEA_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::FEA, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisType> AnalysisType_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisType, Pred> AnalysisType_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisType, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Interference> Interference_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Interference, Pred> Interference_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Interference, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Tolerance> Tolerance_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Tolerance, Pred> Tolerance_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Tolerance, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Assembly> Assembly_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Assembly> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_AnalysisType_children;
		static ::Uml::CompositionParentRole meta_Assembly_parent;

	};

	class Material : public ::Udm::Object {
	public:
		Material();
		Material(::Udm::ObjectImpl *impl);
		Material(const Material &master);

#ifdef UDM_RVALUE
		Material(Material &&master);

		static Material Cast(::Udm::Object &&a);
		Material& operator=(Material &&a);

#endif
		static Material Cast(const ::Udm::Object &a);
		static Material Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Material CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Material> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Material, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Material, Pred>(impl); };
		Material CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Material> Derived();
		template <class Pred> ::Udm::DerivedAttr< Material, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Material, Pred>(impl); };
		::Udm::ArchetypeAttr< Material> Archetype() const;
		::Udm::StringAttr MaterialName() const;
		::Udm::StringAttr MaterialID() const;
		::Udm::StringAttr MaterialType() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::MaterialProperty> MaterialProperty_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::MaterialProperty, Pred> MaterialProperty_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::MaterialProperty, Pred>(impl, meta_MaterialProperty_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::MaterialProperty> MaterialProperty_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::MaterialProperty, Pred> MaterialProperty_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::MaterialProperty, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Materials> Materials_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Materials> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_MaterialName;
		static ::Uml::Attribute meta_MaterialID;
		static ::Uml::Attribute meta_MaterialType;
		static ::Uml::CompositionChildRole meta_MaterialProperty_children;
		static ::Uml::CompositionParentRole meta_Materials_parent;

	};

	class MaterialProperty : public ::Udm::Object {
	public:
		MaterialProperty();
		MaterialProperty(::Udm::ObjectImpl *impl);
		MaterialProperty(const MaterialProperty &master);

#ifdef UDM_RVALUE
		MaterialProperty(MaterialProperty &&master);

		static MaterialProperty Cast(::Udm::Object &&a);
		MaterialProperty& operator=(MaterialProperty &&a);

#endif
		static MaterialProperty Cast(const ::Udm::Object &a);
		static MaterialProperty Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		MaterialProperty CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< MaterialProperty> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< MaterialProperty, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< MaterialProperty, Pred>(impl); };
		MaterialProperty CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< MaterialProperty> Derived();
		template <class Pred> ::Udm::DerivedAttr< MaterialProperty, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< MaterialProperty, Pred>(impl); };
		::Udm::ArchetypeAttr< MaterialProperty> Archetype() const;
		::Udm::StringAttr PropertyName() const;
		::Udm::RealAttr Value() const;
		::Udm::StringAttr Units() const;
		::Udm::ParentAttr< ::AssemblyInterface::Material> Material_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Material> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_PropertyName;
		static ::Uml::Attribute meta_Value;
		static ::Uml::Attribute meta_Units;
		static ::Uml::CompositionParentRole meta_Material_parent;

	};

	class Materials : public ::Udm::Object {
	public:
		Materials();
		Materials(::Udm::ObjectImpl *impl);
		Materials(const Materials &master);

#ifdef UDM_RVALUE
		Materials(Materials &&master);

		static Materials Cast(::Udm::Object &&a);
		Materials& operator=(Materials &&a);

#endif
		static Materials Cast(const ::Udm::Object &a);
		static Materials Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Materials CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Materials> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Materials, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Materials, Pred>(impl); };
		Materials CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Materials> Derived();
		template <class Pred> ::Udm::DerivedAttr< Materials, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Materials, Pred>(impl); };
		::Udm::ArchetypeAttr< Materials> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Material> Material_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Material, Pred> Material_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Material, Pred>(impl, meta_Material_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Material> Material_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Material, Pred> Material_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Material, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Assemblies> Assemblies_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Assemblies> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Material_children;
		static ::Uml::CompositionParentRole meta_Assemblies_parent;

	};

	class DataExchange : public ::Udm::Object {
	public:
		DataExchange();
		DataExchange(::Udm::ObjectImpl *impl);
		DataExchange(const DataExchange &master);

#ifdef UDM_RVALUE
		DataExchange(DataExchange &&master);

		static DataExchange Cast(::Udm::Object &&a);
		DataExchange& operator=(DataExchange &&a);

#endif
		static DataExchange Cast(const ::Udm::Object &a);
		static DataExchange Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		DataExchange CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< DataExchange> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< DataExchange, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< DataExchange, Pred>(impl); };
		DataExchange CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< DataExchange> Derived();
		template <class Pred> ::Udm::DerivedAttr< DataExchange, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< DataExchange, Pred>(impl); };
		::Udm::ArchetypeAttr< DataExchange> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::DataFormatBase> DataFormatBase_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::DataFormatBase, Pred> DataFormatBase_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::DataFormatBase, Pred>(impl, meta_DataFormatBase_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::DataFormatBase> DataFormatBase_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::DataFormatBase, Pred> DataFormatBase_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::DataFormatBase, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::STEPFormat> STEPFormat_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::STEPFormat, Pred> STEPFormat_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::STEPFormat, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Assemblies> Assemblies_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Assemblies> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_DataFormatBase_children;
		static ::Uml::CompositionParentRole meta_Assemblies_parent;

	};

	class DataFormatBase : public ::Udm::Object {
	public:
		DataFormatBase();
		DataFormatBase(::Udm::ObjectImpl *impl);
		DataFormatBase(const DataFormatBase &master);

#ifdef UDM_RVALUE
		DataFormatBase(DataFormatBase &&master);

		static DataFormatBase Cast(::Udm::Object &&a);
		DataFormatBase& operator=(DataFormatBase &&a);

#endif
		static DataFormatBase Cast(const ::Udm::Object &a);
		static DataFormatBase Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		DataFormatBase CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< DataFormatBase> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< DataFormatBase, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< DataFormatBase, Pred>(impl); };
		DataFormatBase CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< DataFormatBase> Derived();
		template <class Pred> ::Udm::DerivedAttr< DataFormatBase, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< DataFormatBase, Pred>(impl); };
		::Udm::ArchetypeAttr< DataFormatBase> Archetype() const;
		::Udm::ParentAttr< ::AssemblyInterface::DataExchange> DataExchange_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::DataExchange> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionParentRole meta_DataExchange_parent;

	};

	class STEPFormat :  public DataFormatBase {
	public:
		STEPFormat();
		STEPFormat(::Udm::ObjectImpl *impl);
		STEPFormat(const STEPFormat &master);

#ifdef UDM_RVALUE
		STEPFormat(STEPFormat &&master);

		static STEPFormat Cast(::Udm::Object &&a);
		STEPFormat& operator=(STEPFormat &&a);

#endif
		static STEPFormat Cast(const ::Udm::Object &a);
		static STEPFormat Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		STEPFormat CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< STEPFormat> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< STEPFormat, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< STEPFormat, Pred>(impl); };
		STEPFormat CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< STEPFormat> Derived();
		template <class Pred> ::Udm::DerivedAttr< STEPFormat, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< STEPFormat, Pred>(impl); };
		::Udm::ArchetypeAttr< STEPFormat> Archetype() const;
		::Udm::StringAttr Name() const;
		::Udm::ParentAttr< ::AssemblyInterface::DataExchange> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Name;

	};

	class Computations : public ::Udm::Object {
	public:
		Computations();
		Computations(::Udm::ObjectImpl *impl);
		Computations(const Computations &master);

#ifdef UDM_RVALUE
		Computations(Computations &&master);

		static Computations Cast(::Udm::Object &&a);
		Computations& operator=(Computations &&a);

#endif
		static Computations Cast(const ::Udm::Object &a);
		static Computations Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Computations CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Computations> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Computations, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Computations, Pred>(impl); };
		Computations CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Computations> Derived();
		template <class Pred> ::Udm::DerivedAttr< Computations, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Computations, Pred>(impl); };
		::Udm::ArchetypeAttr< Computations> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::ComputationType> ComputationType_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::ComputationType, Pred> ComputationType_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ComputationType, Pred>(impl, meta_ComputationType_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::ComputationType> ComputationType_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::ComputationType, Pred> ComputationType_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ComputationType, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::BoundingBox> BoundingBox_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::BoundingBox, Pred> BoundingBox_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::BoundingBox, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::CenterOfGravity> CenterOfGravity_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::CenterOfGravity, Pred> CenterOfGravity_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CenterOfGravity, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::PointCoordinates> PointCoordinates_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::PointCoordinates, Pred> PointCoordinates_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::PointCoordinates, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Mass> Mass_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Mass, Pred> Mass_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Mass, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Assembly> Assembly_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Assembly> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_ComputationType_children;
		static ::Uml::CompositionParentRole meta_Assembly_parent;

	};

	class UnassembledComponents : public ::Udm::Object {
	public:
		UnassembledComponents();
		UnassembledComponents(::Udm::ObjectImpl *impl);
		UnassembledComponents(const UnassembledComponents &master);

#ifdef UDM_RVALUE
		UnassembledComponents(UnassembledComponents &&master);

		static UnassembledComponents Cast(::Udm::Object &&a);
		UnassembledComponents& operator=(UnassembledComponents &&a);

#endif
		static UnassembledComponents Cast(const ::Udm::Object &a);
		static UnassembledComponents Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		UnassembledComponents CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< UnassembledComponents> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< UnassembledComponents, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< UnassembledComponents, Pred>(impl); };
		UnassembledComponents CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< UnassembledComponents> Derived();
		template <class Pred> ::Udm::DerivedAttr< UnassembledComponents, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< UnassembledComponents, Pred>(impl); };
		::Udm::ArchetypeAttr< UnassembledComponents> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent> CADComponent_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent, Pred> CADComponent_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent, Pred>(impl, meta_CADComponent_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent> CADComponent_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent, Pred> CADComponent_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::CADComponent, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Assemblies> Assemblies_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Assemblies> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_CADComponent_children;
		static ::Uml::CompositionParentRole meta_Assemblies_parent;

	};

	class AnalysisConstraints : public ::Udm::Object {
	public:
		AnalysisConstraints();
		AnalysisConstraints(::Udm::ObjectImpl *impl);
		AnalysisConstraints(const AnalysisConstraints &master);

#ifdef UDM_RVALUE
		AnalysisConstraints(AnalysisConstraints &&master);

		static AnalysisConstraints Cast(::Udm::Object &&a);
		AnalysisConstraints& operator=(AnalysisConstraints &&a);

#endif
		static AnalysisConstraints Cast(const ::Udm::Object &a);
		static AnalysisConstraints Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		AnalysisConstraints CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< AnalysisConstraints> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< AnalysisConstraints, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< AnalysisConstraints, Pred>(impl); };
		AnalysisConstraints CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< AnalysisConstraints> Derived();
		template <class Pred> ::Udm::DerivedAttr< AnalysisConstraints, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< AnalysisConstraints, Pred>(impl); };
		::Udm::ArchetypeAttr< AnalysisConstraints> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisConstraint> AnalysisConstraint_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisConstraint, Pred> AnalysisConstraint_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisConstraint, Pred>(impl, meta_AnalysisConstraint_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisConstraint> AnalysisConstraint_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisConstraint, Pred> AnalysisConstraint_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisConstraint, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::FEA> FEA_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::FEA> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_AnalysisConstraint_children;
		static ::Uml::CompositionParentRole meta_FEA_parent;

	};

	class PartInterfaces : public ::Udm::Object {
	public:
		PartInterfaces();
		PartInterfaces(::Udm::ObjectImpl *impl);
		PartInterfaces(const PartInterfaces &master);

#ifdef UDM_RVALUE
		PartInterfaces(PartInterfaces &&master);

		static PartInterfaces Cast(::Udm::Object &&a);
		PartInterfaces& operator=(PartInterfaces &&a);

#endif
		static PartInterfaces Cast(const ::Udm::Object &a);
		static PartInterfaces Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		PartInterfaces CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< PartInterfaces> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< PartInterfaces, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< PartInterfaces, Pred>(impl); };
		PartInterfaces CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< PartInterfaces> Derived();
		template <class Pred> ::Udm::DerivedAttr< PartInterfaces, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< PartInterfaces, Pred>(impl); };
		::Udm::ArchetypeAttr< PartInterfaces> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::PartInterface> PartInterface_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::PartInterface, Pred> PartInterface_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::PartInterface, Pred>(impl, meta_PartInterface_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::PartInterface> PartInterface_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::PartInterface, Pred> PartInterface_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::PartInterface, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::FEA> FEA_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::FEA> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_PartInterface_children;
		static ::Uml::CompositionParentRole meta_FEA_parent;

	};

	class AnalysisType : public ::Udm::Object {
	public:
		AnalysisType();
		AnalysisType(::Udm::ObjectImpl *impl);
		AnalysisType(const AnalysisType &master);

#ifdef UDM_RVALUE
		AnalysisType(AnalysisType &&master);

		static AnalysisType Cast(::Udm::Object &&a);
		AnalysisType& operator=(AnalysisType &&a);

#endif
		static AnalysisType Cast(const ::Udm::Object &a);
		static AnalysisType Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		AnalysisType CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< AnalysisType> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< AnalysisType, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< AnalysisType, Pred>(impl); };
		AnalysisType CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< AnalysisType> Derived();
		template <class Pred> ::Udm::DerivedAttr< AnalysisType, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< AnalysisType, Pred>(impl); };
		::Udm::ArchetypeAttr< AnalysisType> Archetype() const;
		::Udm::StringAttr AnalysisID() const;
		::Udm::ParentAttr< ::AssemblyInterface::Analyses> Analyses_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Analyses> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_AnalysisID;
		static ::Uml::CompositionParentRole meta_Analyses_parent;

	};

	class FEA :  public AnalysisType {
	public:
		FEA();
		FEA(::Udm::ObjectImpl *impl);
		FEA(const FEA &master);

#ifdef UDM_RVALUE
		FEA(FEA &&master);

		static FEA Cast(::Udm::Object &&a);
		FEA& operator=(FEA &&a);

#endif
		static FEA Cast(const ::Udm::Object &a);
		static FEA Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		FEA CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< FEA> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< FEA, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< FEA, Pred>(impl); };
		FEA CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< FEA> Derived();
		template <class Pred> ::Udm::DerivedAttr< FEA, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< FEA, Pred>(impl); };
		::Udm::ArchetypeAttr< FEA> Archetype() const;
		::Udm::StringAttr Type() const;
		::Udm::ChildAttr< ::AssemblyInterface::AnalysisConstraints> AnalysisConstraints_child() const;
		::Udm::ChildAttr< ::AssemblyInterface::Loads> Loads_child() const;
		::Udm::ChildAttr< ::AssemblyInterface::PartInterfaces> PartInterfaces_child() const;
		::Udm::ChildAttr< ::AssemblyInterface::AnalysisComponents> AnalysisComponents_child() const;
		::Udm::ChildAttr< ::AssemblyInterface::Solvers> Solvers_child() const;
		::Udm::ChildAttr< ::AssemblyInterface::Conditions> Conditions_child() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatments> SurfaceTreatments_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatments, Pred> SurfaceTreatments_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatments, Pred>(impl, meta_SurfaceTreatments_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisConstraints> AnalysisConstraints_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisConstraints, Pred> AnalysisConstraints_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisConstraints, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::PartInterfaces> PartInterfaces_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::PartInterfaces, Pred> PartInterfaces_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::PartInterfaces, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Loads> Loads_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Loads, Pred> Loads_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Loads, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisComponents> AnalysisComponents_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisComponents, Pred> AnalysisComponents_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AnalysisComponents, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Solvers> Solvers_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Solvers, Pred> Solvers_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Solvers, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Conditions> Conditions_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Conditions, Pred> Conditions_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Conditions, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatments> SurfaceTreatments_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatments, Pred> SurfaceTreatments_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatments, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Analyses> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Type;
		static ::Uml::CompositionChildRole meta_AnalysisConstraints_child;
		static ::Uml::CompositionChildRole meta_Loads_child;
		static ::Uml::CompositionChildRole meta_PartInterfaces_child;
		static ::Uml::CompositionChildRole meta_AnalysisComponents_child;
		static ::Uml::CompositionChildRole meta_Solvers_child;
		static ::Uml::CompositionChildRole meta_Conditions_child;
		static ::Uml::CompositionChildRole meta_SurfaceTreatments_children;

	};

	class Solver : public ::Udm::Object {
	public:
		Solver();
		Solver(::Udm::ObjectImpl *impl);
		Solver(const Solver &master);

#ifdef UDM_RVALUE
		Solver(Solver &&master);

		static Solver Cast(::Udm::Object &&a);
		Solver& operator=(Solver &&a);

#endif
		static Solver Cast(const ::Udm::Object &a);
		static Solver Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Solver CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Solver> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Solver, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Solver, Pred>(impl); };
		Solver CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Solver> Derived();
		template <class Pred> ::Udm::DerivedAttr< Solver, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Solver, Pred>(impl); };
		::Udm::ArchetypeAttr< Solver> Archetype() const;
		::Udm::StringAttr Type() const;
		::Udm::StringAttr MeshType() const;
		::Udm::StringAttr ShellElementType() const;
		::Udm::StringAttr ElementShapeType() const;
		::Udm::ParentAttr< ::AssemblyInterface::Solvers> Solvers_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Solvers> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Type;
		static ::Uml::Attribute meta_MeshType;
		static ::Uml::Attribute meta_ShellElementType;
		static ::Uml::Attribute meta_ElementShapeType;
		static ::Uml::CompositionParentRole meta_Solvers_parent;

	};

	class AnalysisConstraint : public ::Udm::Object {
	public:
		AnalysisConstraint();
		AnalysisConstraint(::Udm::ObjectImpl *impl);
		AnalysisConstraint(const AnalysisConstraint &master);

#ifdef UDM_RVALUE
		AnalysisConstraint(AnalysisConstraint &&master);

		static AnalysisConstraint Cast(::Udm::Object &&a);
		AnalysisConstraint& operator=(AnalysisConstraint &&a);

#endif
		static AnalysisConstraint Cast(const ::Udm::Object &a);
		static AnalysisConstraint Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		AnalysisConstraint CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< AnalysisConstraint> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< AnalysisConstraint, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< AnalysisConstraint, Pred>(impl); };
		AnalysisConstraint CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< AnalysisConstraint> Derived();
		template <class Pred> ::Udm::DerivedAttr< AnalysisConstraint, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< AnalysisConstraint, Pred>(impl); };
		::Udm::ArchetypeAttr< AnalysisConstraint> Archetype() const;
		::Udm::ChildAttr< ::AssemblyInterface::ConstraintType> ConstraintType_child() const;
		::Udm::ChildAttr< ::AssemblyInterface::Geometry> Geometry_child() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Displacement> Displacement_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Displacement, Pred> Displacement_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Displacement, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Pin> Pin_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Pin, Pred> Pin_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Pin, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Ball> Ball_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Ball, Pred> Ball_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Ball, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintType> ConstraintType_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintType, Pred> ConstraintType_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ConstraintType, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Geometry> Geometry_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Geometry, Pred> Geometry_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Geometry, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraints> AnalysisConstraints_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraints> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_ConstraintType_child;
		static ::Uml::CompositionChildRole meta_Geometry_child;
		static ::Uml::CompositionParentRole meta_AnalysisConstraints_parent;

	};

	class Loads : public ::Udm::Object {
	public:
		Loads();
		Loads(::Udm::ObjectImpl *impl);
		Loads(const Loads &master);

#ifdef UDM_RVALUE
		Loads(Loads &&master);

		static Loads Cast(::Udm::Object &&a);
		Loads& operator=(Loads &&a);

#endif
		static Loads Cast(const ::Udm::Object &a);
		static Loads Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Loads CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Loads> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Loads, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Loads, Pred>(impl); };
		Loads CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Loads> Derived();
		template <class Pred> ::Udm::DerivedAttr< Loads, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Loads, Pred>(impl); };
		::Udm::ArchetypeAttr< Loads> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Load> Load_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Load, Pred> Load_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Load, Pred>(impl, meta_Load_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Load> Load_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Load, Pred> Load_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Load, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::FEA> FEA_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::FEA> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Load_children;
		static ::Uml::CompositionParentRole meta_FEA_parent;

	};

	class AnalysisComponents : public ::Udm::Object {
	public:
		AnalysisComponents();
		AnalysisComponents(::Udm::ObjectImpl *impl);
		AnalysisComponents(const AnalysisComponents &master);

#ifdef UDM_RVALUE
		AnalysisComponents(AnalysisComponents &&master);

		static AnalysisComponents Cast(::Udm::Object &&a);
		AnalysisComponents& operator=(AnalysisComponents &&a);

#endif
		static AnalysisComponents Cast(const ::Udm::Object &a);
		static AnalysisComponents Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		AnalysisComponents CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< AnalysisComponents> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< AnalysisComponents, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< AnalysisComponents, Pred>(impl); };
		AnalysisComponents CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< AnalysisComponents> Derived();
		template <class Pred> ::Udm::DerivedAttr< AnalysisComponents, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< AnalysisComponents, Pred>(impl); };
		::Udm::ArchetypeAttr< AnalysisComponents> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Component> Component_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Component, Pred> Component_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Component, Pred>(impl, meta_Component_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Component> Component_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Component, Pred> Component_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Component, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::FEA> FEA_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::FEA> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Component_children;
		static ::Uml::CompositionParentRole meta_FEA_parent;

	};

	class Load : public ::Udm::Object {
	public:
		Load();
		Load(::Udm::ObjectImpl *impl);
		Load(const Load &master);

#ifdef UDM_RVALUE
		Load(Load &&master);

		static Load Cast(::Udm::Object &&a);
		Load& operator=(Load &&a);

#endif
		static Load Cast(const ::Udm::Object &a);
		static Load Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Load CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Load> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Load, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Load, Pred>(impl); };
		Load CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Load> Derived();
		template <class Pred> ::Udm::DerivedAttr< Load, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Load, Pred>(impl); };
		::Udm::ArchetypeAttr< Load> Archetype() const;
		::Udm::ChildAttr< ::AssemblyInterface::LoadType> LoadType_child() const;
		::Udm::ChildAttr< ::AssemblyInterface::Geometry> Geometry_child() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::LoadType> LoadType_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::LoadType, Pred> LoadType_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::LoadType, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::ForceMoment> ForceMoment_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::ForceMoment, Pred> ForceMoment_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::ForceMoment, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Pressure> Pressure_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Pressure, Pred> Pressure_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Pressure, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Acceleration> Acceleration_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Acceleration, Pred> Acceleration_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Acceleration, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Geometry> Geometry_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Geometry, Pred> Geometry_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Geometry, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Loads> Loads_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Loads> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_LoadType_child;
		static ::Uml::CompositionChildRole meta_Geometry_child;
		static ::Uml::CompositionParentRole meta_Loads_parent;

	};

	class PartInterface : public ::Udm::Object {
	public:
		PartInterface();
		PartInterface(::Udm::ObjectImpl *impl);
		PartInterface(const PartInterface &master);

#ifdef UDM_RVALUE
		PartInterface(PartInterface &&master);

		static PartInterface Cast(::Udm::Object &&a);
		PartInterface& operator=(PartInterface &&a);

#endif
		static PartInterface Cast(const ::Udm::Object &a);
		static PartInterface Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		PartInterface CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< PartInterface> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< PartInterface, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< PartInterface, Pred>(impl); };
		PartInterface CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< PartInterface> Derived();
		template <class Pred> ::Udm::DerivedAttr< PartInterface, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< PartInterface, Pred>(impl); };
		::Udm::ArchetypeAttr< PartInterface> Archetype() const;
		::Udm::StringAttr Type() const;
		::Udm::StringAttr ComponentID_1() const;
		::Udm::StringAttr ComponentID_2() const;
		::Udm::ParentAttr< ::AssemblyInterface::PartInterfaces> PartInterfaces_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::PartInterfaces> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Type;
		static ::Uml::Attribute meta_ComponentID_1;
		static ::Uml::Attribute meta_ComponentID_2;
		static ::Uml::CompositionParentRole meta_PartInterfaces_parent;

	};

	class Component : public ::Udm::Object {
	public:
		Component();
		Component(::Udm::ObjectImpl *impl);
		Component(const Component &master);

#ifdef UDM_RVALUE
		Component(Component &&master);

		static Component Cast(::Udm::Object &&a);
		Component& operator=(Component &&a);

#endif
		static Component Cast(const ::Udm::Object &a);
		static Component Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Component CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Component> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Component, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Component, Pred>(impl); };
		Component CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Component> Derived();
		template <class Pred> ::Udm::DerivedAttr< Component, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Component, Pred>(impl); };
		::Udm::ArchetypeAttr< Component> Archetype() const;
		::Udm::StringAttr ComponentID() const;
		::Udm::BooleanAttr InfiniteCycle() const;
		::Udm::ChildAttr< ::AssemblyInterface::Metrics> Metrics_child() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Metrics> Metrics_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Metrics, Pred> Metrics_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Metrics, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::AnalysisComponents> AnalysisComponents_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::AnalysisComponents> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_ComponentID;
		static ::Uml::Attribute meta_InfiniteCycle;
		static ::Uml::CompositionChildRole meta_Metrics_child;
		static ::Uml::CompositionParentRole meta_AnalysisComponents_parent;

	};

	class Solvers : public ::Udm::Object {
	public:
		Solvers();
		Solvers(::Udm::ObjectImpl *impl);
		Solvers(const Solvers &master);

#ifdef UDM_RVALUE
		Solvers(Solvers &&master);

		static Solvers Cast(::Udm::Object &&a);
		Solvers& operator=(Solvers &&a);

#endif
		static Solvers Cast(const ::Udm::Object &a);
		static Solvers Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Solvers CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Solvers> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Solvers, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Solvers, Pred>(impl); };
		Solvers CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Solvers> Derived();
		template <class Pred> ::Udm::DerivedAttr< Solvers, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Solvers, Pred>(impl); };
		::Udm::ArchetypeAttr< Solvers> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Solver> Solver_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Solver, Pred> Solver_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Solver, Pred>(impl, meta_Solver_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Solver> Solver_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Solver, Pred> Solver_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Solver, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::FEA> FEA_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::FEA> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Solver_children;
		static ::Uml::CompositionParentRole meta_FEA_parent;

	};

	class Interference :  public AnalysisType {
	public:
		Interference();
		Interference(::Udm::ObjectImpl *impl);
		Interference(const Interference &master);

#ifdef UDM_RVALUE
		Interference(Interference &&master);

		static Interference Cast(::Udm::Object &&a);
		Interference& operator=(Interference &&a);

#endif
		static Interference Cast(const ::Udm::Object &a);
		static Interference Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Interference CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Interference> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Interference, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Interference, Pred>(impl); };
		Interference CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Interference> Derived();
		template <class Pred> ::Udm::DerivedAttr< Interference, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Interference, Pred>(impl); };
		::Udm::ArchetypeAttr< Interference> Archetype() const;
		::Udm::ParentAttr< ::AssemblyInterface::Analyses> parent() const;

		static ::Uml::Class meta;

	};

	class Tolerance :  public AnalysisType {
	public:
		Tolerance();
		Tolerance(::Udm::ObjectImpl *impl);
		Tolerance(const Tolerance &master);

#ifdef UDM_RVALUE
		Tolerance(Tolerance &&master);

		static Tolerance Cast(::Udm::Object &&a);
		Tolerance& operator=(Tolerance &&a);

#endif
		static Tolerance Cast(const ::Udm::Object &a);
		static Tolerance Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Tolerance CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Tolerance> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Tolerance, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Tolerance, Pred>(impl); };
		Tolerance CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Tolerance> Derived();
		template <class Pred> ::Udm::DerivedAttr< Tolerance, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Tolerance, Pred>(impl); };
		::Udm::ArchetypeAttr< Tolerance> Archetype() const;
		::Udm::ParentAttr< ::AssemblyInterface::Analyses> parent() const;

		static ::Uml::Class meta;

	};

	class Metric : public ::Udm::Object {
	public:
		Metric();
		Metric(::Udm::ObjectImpl *impl);
		Metric(const Metric &master);

#ifdef UDM_RVALUE
		Metric(Metric &&master);

		static Metric Cast(::Udm::Object &&a);
		Metric& operator=(Metric &&a);

#endif
		static Metric Cast(const ::Udm::Object &a);
		static Metric Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Metric CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Metric> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Metric, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Metric, Pred>(impl); };
		Metric CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Metric> Derived();
		template <class Pred> ::Udm::DerivedAttr< Metric, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Metric, Pred>(impl); };
		::Udm::ArchetypeAttr< Metric> Archetype() const;
		::Udm::StringAttr Type() const;
		::Udm::StringAttr ID() const;
		::Udm::ParentAttr< ::AssemblyInterface::Metrics> Metrics_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Metrics> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Type;
		static ::Uml::Attribute meta_ID;
		static ::Uml::CompositionParentRole meta_Metrics_parent;

	};

	class Metrics : public ::Udm::Object {
	public:
		Metrics();
		Metrics(::Udm::ObjectImpl *impl);
		Metrics(const Metrics &master);

#ifdef UDM_RVALUE
		Metrics(Metrics &&master);

		static Metrics Cast(::Udm::Object &&a);
		Metrics& operator=(Metrics &&a);

#endif
		static Metrics Cast(const ::Udm::Object &a);
		static Metrics Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Metrics CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Metrics> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Metrics, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Metrics, Pred>(impl); };
		Metrics CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Metrics> Derived();
		template <class Pred> ::Udm::DerivedAttr< Metrics, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Metrics, Pred>(impl); };
		::Udm::ArchetypeAttr< Metrics> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Metric> Metric_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Metric, Pred> Metric_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Metric, Pred>(impl, meta_Metric_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Metric> Metric_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Metric, Pred> Metric_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Metric, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Component> Component_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Component> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Metric_children;
		static ::Uml::CompositionParentRole meta_Component_parent;

	};

	class Conditions : public ::Udm::Object {
	public:
		Conditions();
		Conditions(::Udm::ObjectImpl *impl);
		Conditions(const Conditions &master);

#ifdef UDM_RVALUE
		Conditions(Conditions &&master);

		static Conditions Cast(::Udm::Object &&a);
		Conditions& operator=(Conditions &&a);

#endif
		static Conditions Cast(const ::Udm::Object &a);
		static Conditions Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Conditions CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Conditions> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Conditions, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Conditions, Pred>(impl); };
		Conditions CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Conditions> Derived();
		template <class Pred> ::Udm::DerivedAttr< Conditions, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Conditions, Pred>(impl); };
		::Udm::ArchetypeAttr< Conditions> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Condition> Condition_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Condition, Pred> Condition_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Condition, Pred>(impl, meta_Condition_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Condition> Condition_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Condition, Pred> Condition_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Condition, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::FEA> FEA_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::FEA> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Condition_children;
		static ::Uml::CompositionParentRole meta_FEA_parent;

	};

	class Condition : public ::Udm::Object {
	public:
		Condition();
		Condition(::Udm::ObjectImpl *impl);
		Condition(const Condition &master);

#ifdef UDM_RVALUE
		Condition(Condition &&master);

		static Condition Cast(::Udm::Object &&a);
		Condition& operator=(Condition &&a);

#endif
		static Condition Cast(const ::Udm::Object &a);
		static Condition Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Condition CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Condition> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Condition, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Condition, Pred>(impl); };
		Condition CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Condition> Derived();
		template <class Pred> ::Udm::DerivedAttr< Condition, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Condition, Pred>(impl); };
		::Udm::ArchetypeAttr< Condition> Archetype() const;
		::Udm::StringAttr Name() const;
		::Udm::RealAttr Value() const;
		::Udm::StringAttr Units() const;
		::Udm::ParentAttr< ::AssemblyInterface::Conditions> Conditions_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Conditions> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Name;
		static ::Uml::Attribute meta_Value;
		static ::Uml::Attribute meta_Units;
		static ::Uml::CompositionParentRole meta_Conditions_parent;

	};

	class SurfaceTreatment : public ::Udm::Object {
	public:
		SurfaceTreatment();
		SurfaceTreatment(::Udm::ObjectImpl *impl);
		SurfaceTreatment(const SurfaceTreatment &master);

#ifdef UDM_RVALUE
		SurfaceTreatment(SurfaceTreatment &&master);

		static SurfaceTreatment Cast(::Udm::Object &&a);
		SurfaceTreatment& operator=(SurfaceTreatment &&a);

#endif
		static SurfaceTreatment Cast(const ::Udm::Object &a);
		static SurfaceTreatment Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		SurfaceTreatment CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< SurfaceTreatment> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< SurfaceTreatment, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< SurfaceTreatment, Pred>(impl); };
		SurfaceTreatment CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< SurfaceTreatment> Derived();
		template <class Pred> ::Udm::DerivedAttr< SurfaceTreatment, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< SurfaceTreatment, Pred>(impl); };
		::Udm::ArchetypeAttr< SurfaceTreatment> Archetype() const;
		::Udm::StringAttrArr AdjoiningParts() const;
		::Udm::ChildAttr< ::AssemblyInterface::Geometry> Geometry_child() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Geometry> Geometry_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Geometry, Pred> Geometry_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Geometry, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::SurfaceTreatments> SurfaceTreatments_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::SurfaceTreatments> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_AdjoiningParts;
		static ::Uml::CompositionChildRole meta_Geometry_child;
		static ::Uml::CompositionParentRole meta_SurfaceTreatments_parent;

	};

	class SurfaceTreatments : public ::Udm::Object {
	public:
		SurfaceTreatments();
		SurfaceTreatments(::Udm::ObjectImpl *impl);
		SurfaceTreatments(const SurfaceTreatments &master);

#ifdef UDM_RVALUE
		SurfaceTreatments(SurfaceTreatments &&master);

		static SurfaceTreatments Cast(::Udm::Object &&a);
		SurfaceTreatments& operator=(SurfaceTreatments &&a);

#endif
		static SurfaceTreatments Cast(const ::Udm::Object &a);
		static SurfaceTreatments Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		SurfaceTreatments CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< SurfaceTreatments> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< SurfaceTreatments, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< SurfaceTreatments, Pred>(impl); };
		SurfaceTreatments CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< SurfaceTreatments> Derived();
		template <class Pred> ::Udm::DerivedAttr< SurfaceTreatments, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< SurfaceTreatments, Pred>(impl); };
		::Udm::ArchetypeAttr< SurfaceTreatments> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatment> SurfaceTreatment_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatment, Pred> SurfaceTreatment_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatment, Pred>(impl, meta_SurfaceTreatment_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatment> SurfaceTreatment_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatment, Pred> SurfaceTreatment_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::SurfaceTreatment, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::FEA> FEA_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::FEA> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_SurfaceTreatment_children;
		static ::Uml::CompositionParentRole meta_FEA_parent;

	};

	class Features : public ::Udm::Object {
	public:
		Features();
		Features(::Udm::ObjectImpl *impl);
		Features(const Features &master);

#ifdef UDM_RVALUE
		Features(Features &&master);

		static Features Cast(::Udm::Object &&a);
		Features& operator=(Features &&a);

#endif
		static Features Cast(const ::Udm::Object &a);
		static Features Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Features CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Features> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Features, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Features, Pred>(impl); };
		Features CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Features> Derived();
		template <class Pred> ::Udm::DerivedAttr< Features, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Features, Pred>(impl); };
		::Udm::ArchetypeAttr< Features> Archetype() const;
		::Udm::StringAttr FeatureID() const;
		::Udm::StringAttr GeometryType() const;
		::Udm::StringAttr FeatureInterfaceType() const;
		::Udm::StringAttr FeatureGeometryType() const;
		::Udm::StringAttr PrimaryGeometryQualifier() const;
		::Udm::StringAttr SecondaryGeometryQualifier() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Feature> Feature_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Feature, Pred> Feature_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Feature, Pred>(impl, meta_Feature_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Feature> Feature_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Feature, Pred> Feature_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Feature, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Geometry> Geometry_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Geometry> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_FeatureID;
		static ::Uml::Attribute meta_GeometryType;
		static ::Uml::Attribute meta_FeatureInterfaceType;
		static ::Uml::Attribute meta_FeatureGeometryType;
		static ::Uml::Attribute meta_PrimaryGeometryQualifier;
		static ::Uml::Attribute meta_SecondaryGeometryQualifier;
		static ::Uml::CompositionChildRole meta_Feature_children;
		static ::Uml::CompositionParentRole meta_Geometry_parent;

	};

	class Feature : public ::Udm::Object {
	public:
		Feature();
		Feature(::Udm::ObjectImpl *impl);
		Feature(const Feature &master);

#ifdef UDM_RVALUE
		Feature(Feature &&master);

		static Feature Cast(::Udm::Object &&a);
		Feature& operator=(Feature &&a);

#endif
		static Feature Cast(const ::Udm::Object &a);
		static Feature Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Feature CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Feature> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Feature, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Feature, Pred>(impl); };
		Feature CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Feature> Derived();
		template <class Pred> ::Udm::DerivedAttr< Feature, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Feature, Pred>(impl); };
		::Udm::ArchetypeAttr< Feature> Archetype() const;
		::Udm::StringAttr Name() const;
		::Udm::StringAttr ComponentID() const;
		::Udm::ParentAttr< ::AssemblyInterface::Features> Features_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Features> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Name;
		static ::Uml::Attribute meta_ComponentID;
		static ::Uml::CompositionParentRole meta_Features_parent;

	};

	class ConstraintType : public ::Udm::Object {
	public:
		ConstraintType();
		ConstraintType(::Udm::ObjectImpl *impl);
		ConstraintType(const ConstraintType &master);

#ifdef UDM_RVALUE
		ConstraintType(ConstraintType &&master);

		static ConstraintType Cast(::Udm::Object &&a);
		ConstraintType& operator=(ConstraintType &&a);

#endif
		static ConstraintType Cast(const ::Udm::Object &a);
		static ConstraintType Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		ConstraintType CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< ConstraintType> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< ConstraintType, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< ConstraintType, Pred>(impl); };
		ConstraintType CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< ConstraintType> Derived();
		template <class Pred> ::Udm::DerivedAttr< ConstraintType, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< ConstraintType, Pred>(impl); };
		::Udm::ArchetypeAttr< ConstraintType> Archetype() const;
		::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint> AnalysisConstraint_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionParentRole meta_AnalysisConstraint_parent;

	};

	class Displacement :  public ConstraintType {
	public:
		Displacement();
		Displacement(::Udm::ObjectImpl *impl);
		Displacement(const Displacement &master);

#ifdef UDM_RVALUE
		Displacement(Displacement &&master);

		static Displacement Cast(::Udm::Object &&a);
		Displacement& operator=(Displacement &&a);

#endif
		static Displacement Cast(const ::Udm::Object &a);
		static Displacement Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Displacement CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Displacement> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Displacement, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Displacement, Pred>(impl); };
		Displacement CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Displacement> Derived();
		template <class Pred> ::Udm::DerivedAttr< Displacement, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Displacement, Pred>(impl); };
		::Udm::ArchetypeAttr< Displacement> Archetype() const;
		::Udm::ChildAttr< ::AssemblyInterface::Translation> Translation_child() const;
		::Udm::ChildAttr< ::AssemblyInterface::Rotation> Rotation_child() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Translation> Translation_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Translation, Pred> Translation_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Translation, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Rotation> Rotation_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Rotation, Pred> Rotation_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Rotation, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Translation_child;
		static ::Uml::CompositionChildRole meta_Rotation_child;

	};

	class Pin :  public ConstraintType {
	public:
		Pin();
		Pin(::Udm::ObjectImpl *impl);
		Pin(const Pin &master);

#ifdef UDM_RVALUE
		Pin(Pin &&master);

		static Pin Cast(::Udm::Object &&a);
		Pin& operator=(Pin &&a);

#endif
		static Pin Cast(const ::Udm::Object &a);
		static Pin Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Pin CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Pin> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Pin, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Pin, Pred>(impl); };
		Pin CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Pin> Derived();
		template <class Pred> ::Udm::DerivedAttr< Pin, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Pin, Pred>(impl); };
		::Udm::ArchetypeAttr< Pin> Archetype() const;
		::Udm::ChildAttr< ::AssemblyInterface::AxialRotation> AxialRotation_child() const;
		::Udm::ChildAttr< ::AssemblyInterface::AxialDisplacement> AxialDisplacement_child() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::AxialRotation> AxialRotation_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::AxialRotation, Pred> AxialRotation_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AxialRotation, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::AxialDisplacement> AxialDisplacement_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::AxialDisplacement, Pred> AxialDisplacement_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::AxialDisplacement, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_AxialRotation_child;
		static ::Uml::CompositionChildRole meta_AxialDisplacement_child;

	};

	class Ball :  public ConstraintType {
	public:
		Ball();
		Ball(::Udm::ObjectImpl *impl);
		Ball(const Ball &master);

#ifdef UDM_RVALUE
		Ball(Ball &&master);

		static Ball Cast(::Udm::Object &&a);
		Ball& operator=(Ball &&a);

#endif
		static Ball Cast(const ::Udm::Object &a);
		static Ball Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Ball CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Ball> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Ball, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Ball, Pred>(impl); };
		Ball CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Ball> Derived();
		template <class Pred> ::Udm::DerivedAttr< Ball, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Ball, Pred>(impl); };
		::Udm::ArchetypeAttr< Ball> Archetype() const;
		::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint> parent() const;

		static ::Uml::Class meta;

	};

	class LoadType : public ::Udm::Object {
	public:
		LoadType();
		LoadType(::Udm::ObjectImpl *impl);
		LoadType(const LoadType &master);

#ifdef UDM_RVALUE
		LoadType(LoadType &&master);

		static LoadType Cast(::Udm::Object &&a);
		LoadType& operator=(LoadType &&a);

#endif
		static LoadType Cast(const ::Udm::Object &a);
		static LoadType Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		LoadType CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< LoadType> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< LoadType, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< LoadType, Pred>(impl); };
		LoadType CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< LoadType> Derived();
		template <class Pred> ::Udm::DerivedAttr< LoadType, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< LoadType, Pred>(impl); };
		::Udm::ArchetypeAttr< LoadType> Archetype() const;
		::Udm::ParentAttr< ::AssemblyInterface::Load> Load_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Load> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionParentRole meta_Load_parent;

	};

	class ForceMoment :  public LoadType {
	public:
		ForceMoment();
		ForceMoment(::Udm::ObjectImpl *impl);
		ForceMoment(const ForceMoment &master);

#ifdef UDM_RVALUE
		ForceMoment(ForceMoment &&master);

		static ForceMoment Cast(::Udm::Object &&a);
		ForceMoment& operator=(ForceMoment &&a);

#endif
		static ForceMoment Cast(const ::Udm::Object &a);
		static ForceMoment Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		ForceMoment CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< ForceMoment> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< ForceMoment, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< ForceMoment, Pred>(impl); };
		ForceMoment CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< ForceMoment> Derived();
		template <class Pred> ::Udm::DerivedAttr< ForceMoment, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< ForceMoment, Pred>(impl); };
		::Udm::ArchetypeAttr< ForceMoment> Archetype() const;
		::Udm::ChildAttr< ::AssemblyInterface::Force> Force_child() const;
		::Udm::ChildAttr< ::AssemblyInterface::Moment> Moment_child() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Force> Force_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Force, Pred> Force_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Force, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Moment> Moment_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Moment, Pred> Moment_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Moment, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::Load> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Force_child;
		static ::Uml::CompositionChildRole meta_Moment_child;

	};

	class Pressure :  public LoadType {
	public:
		Pressure();
		Pressure(::Udm::ObjectImpl *impl);
		Pressure(const Pressure &master);

#ifdef UDM_RVALUE
		Pressure(Pressure &&master);

		static Pressure Cast(::Udm::Object &&a);
		Pressure& operator=(Pressure &&a);

#endif
		static Pressure Cast(const ::Udm::Object &a);
		static Pressure Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Pressure CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Pressure> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Pressure, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Pressure, Pred>(impl); };
		Pressure CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Pressure> Derived();
		template <class Pred> ::Udm::DerivedAttr< Pressure, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Pressure, Pred>(impl); };
		::Udm::ArchetypeAttr< Pressure> Archetype() const;
		::Udm::RealAttr Value() const;
		::Udm::StringAttr Units() const;
		::Udm::ParentAttr< ::AssemblyInterface::Load> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Value;
		static ::Uml::Attribute meta_Units;

	};

	class Acceleration :  public LoadType {
	public:
		Acceleration();
		Acceleration(::Udm::ObjectImpl *impl);
		Acceleration(const Acceleration &master);

#ifdef UDM_RVALUE
		Acceleration(Acceleration &&master);

		static Acceleration Cast(::Udm::Object &&a);
		Acceleration& operator=(Acceleration &&a);

#endif
		static Acceleration Cast(const ::Udm::Object &a);
		static Acceleration Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Acceleration CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Acceleration> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Acceleration, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Acceleration, Pred>(impl); };
		Acceleration CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Acceleration> Derived();
		template <class Pred> ::Udm::DerivedAttr< Acceleration, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Acceleration, Pred>(impl); };
		::Udm::ArchetypeAttr< Acceleration> Archetype() const;
		::Udm::StringAttr Units() const;
		::Udm::RealAttr x() const;
		::Udm::RealAttr y() const;
		::Udm::RealAttr z() const;
		::Udm::ParentAttr< ::AssemblyInterface::Load> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Units;
		static ::Uml::Attribute meta_x;
		static ::Uml::Attribute meta_y;
		static ::Uml::Attribute meta_z;

	};

	class AxialRotation : public ::Udm::Object {
	public:
		AxialRotation();
		AxialRotation(::Udm::ObjectImpl *impl);
		AxialRotation(const AxialRotation &master);

#ifdef UDM_RVALUE
		AxialRotation(AxialRotation &&master);

		static AxialRotation Cast(::Udm::Object &&a);
		AxialRotation& operator=(AxialRotation &&a);

#endif
		static AxialRotation Cast(const ::Udm::Object &a);
		static AxialRotation Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		AxialRotation CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< AxialRotation> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< AxialRotation, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< AxialRotation, Pred>(impl); };
		AxialRotation CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< AxialRotation> Derived();
		template <class Pred> ::Udm::DerivedAttr< AxialRotation, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< AxialRotation, Pred>(impl); };
		::Udm::ArchetypeAttr< AxialRotation> Archetype() const;
		::Udm::StringAttr Property() const;
		::Udm::ParentAttr< ::AssemblyInterface::Pin> Pin_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Pin> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Property;
		static ::Uml::CompositionParentRole meta_Pin_parent;

	};

	class AxialDisplacement : public ::Udm::Object {
	public:
		AxialDisplacement();
		AxialDisplacement(::Udm::ObjectImpl *impl);
		AxialDisplacement(const AxialDisplacement &master);

#ifdef UDM_RVALUE
		AxialDisplacement(AxialDisplacement &&master);

		static AxialDisplacement Cast(::Udm::Object &&a);
		AxialDisplacement& operator=(AxialDisplacement &&a);

#endif
		static AxialDisplacement Cast(const ::Udm::Object &a);
		static AxialDisplacement Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		AxialDisplacement CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< AxialDisplacement> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< AxialDisplacement, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< AxialDisplacement, Pred>(impl); };
		AxialDisplacement CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< AxialDisplacement> Derived();
		template <class Pred> ::Udm::DerivedAttr< AxialDisplacement, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< AxialDisplacement, Pred>(impl); };
		::Udm::ArchetypeAttr< AxialDisplacement> Archetype() const;
		::Udm::StringAttr Property() const;
		::Udm::ParentAttr< ::AssemblyInterface::Pin> Pin_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Pin> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Property;
		static ::Uml::CompositionParentRole meta_Pin_parent;

	};

	class Translation : public ::Udm::Object {
	public:
		Translation();
		Translation(::Udm::ObjectImpl *impl);
		Translation(const Translation &master);

#ifdef UDM_RVALUE
		Translation(Translation &&master);

		static Translation Cast(::Udm::Object &&a);
		Translation& operator=(Translation &&a);

#endif
		static Translation Cast(const ::Udm::Object &a);
		static Translation Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Translation CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Translation> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Translation, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Translation, Pred>(impl); };
		Translation CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Translation> Derived();
		template <class Pred> ::Udm::DerivedAttr< Translation, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Translation, Pred>(impl); };
		::Udm::ArchetypeAttr< Translation> Archetype() const;
		::Udm::StringAttr Units() const;
		::Udm::StringAttr x() const;
		::Udm::StringAttr y() const;
		::Udm::StringAttr z() const;
		::Udm::ParentAttr< ::AssemblyInterface::Displacement> Displacement_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Displacement> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Units;
		static ::Uml::Attribute meta_x;
		static ::Uml::Attribute meta_y;
		static ::Uml::Attribute meta_z;
		static ::Uml::CompositionParentRole meta_Displacement_parent;

	};

	class Rotation : public ::Udm::Object {
	public:
		Rotation();
		Rotation(::Udm::ObjectImpl *impl);
		Rotation(const Rotation &master);

#ifdef UDM_RVALUE
		Rotation(Rotation &&master);

		static Rotation Cast(::Udm::Object &&a);
		Rotation& operator=(Rotation &&a);

#endif
		static Rotation Cast(const ::Udm::Object &a);
		static Rotation Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Rotation CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Rotation> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Rotation, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Rotation, Pred>(impl); };
		Rotation CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Rotation> Derived();
		template <class Pred> ::Udm::DerivedAttr< Rotation, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Rotation, Pred>(impl); };
		::Udm::ArchetypeAttr< Rotation> Archetype() const;
		::Udm::StringAttr Units() const;
		::Udm::StringAttr x() const;
		::Udm::StringAttr y() const;
		::Udm::StringAttr z() const;
		::Udm::ParentAttr< ::AssemblyInterface::Displacement> Displacement_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Displacement> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Units;
		static ::Uml::Attribute meta_x;
		static ::Uml::Attribute meta_y;
		static ::Uml::Attribute meta_z;
		static ::Uml::CompositionParentRole meta_Displacement_parent;

	};

	class Force : public ::Udm::Object {
	public:
		Force();
		Force(::Udm::ObjectImpl *impl);
		Force(const Force &master);

#ifdef UDM_RVALUE
		Force(Force &&master);

		static Force Cast(::Udm::Object &&a);
		Force& operator=(Force &&a);

#endif
		static Force Cast(const ::Udm::Object &a);
		static Force Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Force CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Force> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Force, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Force, Pred>(impl); };
		Force CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Force> Derived();
		template <class Pred> ::Udm::DerivedAttr< Force, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Force, Pred>(impl); };
		::Udm::ArchetypeAttr< Force> Archetype() const;
		::Udm::StringAttr Units() const;
		::Udm::RealAttr x() const;
		::Udm::RealAttr y() const;
		::Udm::RealAttr z() const;
		::Udm::ParentAttr< ::AssemblyInterface::ForceMoment> ForceMoment_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::ForceMoment> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Units;
		static ::Uml::Attribute meta_x;
		static ::Uml::Attribute meta_y;
		static ::Uml::Attribute meta_z;
		static ::Uml::CompositionParentRole meta_ForceMoment_parent;

	};

	class Moment : public ::Udm::Object {
	public:
		Moment();
		Moment(::Udm::ObjectImpl *impl);
		Moment(const Moment &master);

#ifdef UDM_RVALUE
		Moment(Moment &&master);

		static Moment Cast(::Udm::Object &&a);
		Moment& operator=(Moment &&a);

#endif
		static Moment Cast(const ::Udm::Object &a);
		static Moment Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Moment CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Moment> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Moment, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Moment, Pred>(impl); };
		Moment CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Moment> Derived();
		template <class Pred> ::Udm::DerivedAttr< Moment, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Moment, Pred>(impl); };
		::Udm::ArchetypeAttr< Moment> Archetype() const;
		::Udm::StringAttr Units() const;
		::Udm::RealAttr x() const;
		::Udm::RealAttr y() const;
		::Udm::RealAttr z() const;
		::Udm::ParentAttr< ::AssemblyInterface::ForceMoment> ForceMoment_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::ForceMoment> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Units;
		static ::Uml::Attribute meta_x;
		static ::Uml::Attribute meta_y;
		static ::Uml::Attribute meta_z;
		static ::Uml::CompositionParentRole meta_ForceMoment_parent;

	};

	class Geometry : public ::Udm::Object {
	public:
		Geometry();
		Geometry(::Udm::ObjectImpl *impl);
		Geometry(const Geometry &master);

#ifdef UDM_RVALUE
		Geometry(Geometry &&master);

		static Geometry Cast(::Udm::Object &&a);
		Geometry& operator=(Geometry &&a);

#endif
		static Geometry Cast(const ::Udm::Object &a);
		static Geometry Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Geometry CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Geometry> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Geometry, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Geometry, Pred>(impl); };
		Geometry CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Geometry> Derived();
		template <class Pred> ::Udm::DerivedAttr< Geometry, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Geometry, Pred>(impl); };
		::Udm::ArchetypeAttr< Geometry> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::Features> Features_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Features, Pred> Features_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Features, Pred>(impl, meta_Features_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::SetOperation> SetOperation_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::SetOperation, Pred> SetOperation_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::SetOperation, Pred>(impl, meta_SetOperation_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Features> Features_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Features, Pred> Features_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Features, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::SetOperation> SetOperation_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::SetOperation, Pred> SetOperation_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::SetOperation, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::AnalysisConstraint> AnalysisConstraint_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Load> Load_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::SurfaceTreatment> SurfaceTreatment_parent() const;
		::Udm::ParentAttr< ::Udm::Object> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Features_children;
		static ::Uml::CompositionChildRole meta_SetOperation_children;
		static ::Uml::CompositionParentRole meta_AnalysisConstraint_parent;
		static ::Uml::CompositionParentRole meta_Load_parent;
		static ::Uml::CompositionParentRole meta_SurfaceTreatment_parent;

	};

	class SetOperation : public ::Udm::Object {
	public:
		SetOperation();
		SetOperation(::Udm::ObjectImpl *impl);
		SetOperation(const SetOperation &master);

#ifdef UDM_RVALUE
		SetOperation(SetOperation &&master);

		static SetOperation Cast(::Udm::Object &&a);
		SetOperation& operator=(SetOperation &&a);

#endif
		static SetOperation Cast(const ::Udm::Object &a);
		static SetOperation Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		SetOperation CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< SetOperation> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< SetOperation, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< SetOperation, Pred>(impl); };
		SetOperation CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< SetOperation> Derived();
		template <class Pred> ::Udm::DerivedAttr< SetOperation, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< SetOperation, Pred>(impl); };
		::Udm::ArchetypeAttr< SetOperation> Archetype() const;
		::Udm::StringAttr Type() const;
		::Udm::StringAttrArr FeatureID() const;
		::Udm::ParentAttr< ::AssemblyInterface::Geometry> Geometry_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Geometry> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Type;
		static ::Uml::Attribute meta_FeatureID;
		static ::Uml::CompositionParentRole meta_Geometry_parent;

	};

	class KinematicBase : public ::Udm::Object {
	public:
		KinematicBase();
		KinematicBase(::Udm::ObjectImpl *impl);
		KinematicBase(const KinematicBase &master);

#ifdef UDM_RVALUE
		KinematicBase(KinematicBase &&master);

		static KinematicBase Cast(::Udm::Object &&a);
		KinematicBase& operator=(KinematicBase &&a);

#endif
		static KinematicBase Cast(const ::Udm::Object &a);
		static KinematicBase Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		KinematicBase CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< KinematicBase> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< KinematicBase, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< KinematicBase, Pred>(impl); };
		KinematicBase CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< KinematicBase> Derived();
		template <class Pred> ::Udm::DerivedAttr< KinematicBase, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< KinematicBase, Pred>(impl); };
		::Udm::ArchetypeAttr< KinematicBase> Archetype() const;
		::Udm::StringAttr ConnectionID() const;
		::Udm::StringAttr ConnectedComponentID() const;
		::Udm::StringAttr FeatureInterfaceType() const;
		::Udm::RealAttr ERP() const;
		::Udm::RealAttr CFM() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::KinematicFeature> KinematicFeature_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::KinematicFeature, Pred> KinematicFeature_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::KinematicFeature, Pred>(impl, meta_KinematicFeature_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::KinematicFeature> KinematicFeature_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::KinematicFeature, Pred> KinematicFeature_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::KinematicFeature, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections> KinematicConnections_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_ConnectionID;
		static ::Uml::Attribute meta_ConnectedComponentID;
		static ::Uml::Attribute meta_FeatureInterfaceType;
		static ::Uml::Attribute meta_ERP;
		static ::Uml::Attribute meta_CFM;
		static ::Uml::CompositionChildRole meta_KinematicFeature_children;
		static ::Uml::CompositionParentRole meta_KinematicConnections_parent;

	};

	class KinematicConnections : public ::Udm::Object {
	public:
		KinematicConnections();
		KinematicConnections(::Udm::ObjectImpl *impl);
		KinematicConnections(const KinematicConnections &master);

#ifdef UDM_RVALUE
		KinematicConnections(KinematicConnections &&master);

		static KinematicConnections Cast(::Udm::Object &&a);
		KinematicConnections& operator=(KinematicConnections &&a);

#endif
		static KinematicConnections Cast(const ::Udm::Object &a);
		static KinematicConnections Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		KinematicConnections CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< KinematicConnections> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< KinematicConnections, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< KinematicConnections, Pred>(impl); };
		KinematicConnections CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< KinematicConnections> Derived();
		template <class Pred> ::Udm::DerivedAttr< KinematicConnections, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< KinematicConnections, Pred>(impl); };
		::Udm::ArchetypeAttr< KinematicConnections> Archetype() const;
		::Udm::ChildrenAttr< ::AssemblyInterface::KinematicBase> KinematicBase_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::KinematicBase, Pred> KinematicBase_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::KinematicBase, Pred>(impl, meta_KinematicBase_children); };
		::Udm::ChildrenAttr< ::AssemblyInterface::KinematicBase> KinematicBase_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::KinematicBase, Pred> KinematicBase_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::KinematicBase, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Revolute> Revolute_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Revolute, Pred> Revolute_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Revolute, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Spherical> Spherical_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Spherical, Pred> Spherical_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Spherical, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Prismatic> Prismatic_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Prismatic, Pred> Prismatic_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Prismatic, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::AssemblyInterface::Fixed> Fixed_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::AssemblyInterface::Fixed, Pred> Fixed_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::AssemblyInterface::Fixed, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::AssemblyInterface::CADComponent> CADComponent_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::CADComponent> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_KinematicBase_children;
		static ::Uml::CompositionParentRole meta_CADComponent_parent;

	};

	class Revolute :  public KinematicBase {
	public:
		Revolute();
		Revolute(::Udm::ObjectImpl *impl);
		Revolute(const Revolute &master);

#ifdef UDM_RVALUE
		Revolute(Revolute &&master);

		static Revolute Cast(::Udm::Object &&a);
		Revolute& operator=(Revolute &&a);

#endif
		static Revolute Cast(const ::Udm::Object &a);
		static Revolute Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Revolute CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Revolute> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Revolute, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Revolute, Pred>(impl); };
		Revolute CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Revolute> Derived();
		template <class Pred> ::Udm::DerivedAttr< Revolute, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Revolute, Pred>(impl); };
		::Udm::ArchetypeAttr< Revolute> Archetype() const;
		::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections> parent() const;

		static ::Uml::Class meta;

	};

	class Spherical :  public KinematicBase {
	public:
		Spherical();
		Spherical(::Udm::ObjectImpl *impl);
		Spherical(const Spherical &master);

#ifdef UDM_RVALUE
		Spherical(Spherical &&master);

		static Spherical Cast(::Udm::Object &&a);
		Spherical& operator=(Spherical &&a);

#endif
		static Spherical Cast(const ::Udm::Object &a);
		static Spherical Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Spherical CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Spherical> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Spherical, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Spherical, Pred>(impl); };
		Spherical CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Spherical> Derived();
		template <class Pred> ::Udm::DerivedAttr< Spherical, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Spherical, Pred>(impl); };
		::Udm::ArchetypeAttr< Spherical> Archetype() const;
		::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections> parent() const;

		static ::Uml::Class meta;

	};

	class Prismatic :  public KinematicBase {
	public:
		Prismatic();
		Prismatic(::Udm::ObjectImpl *impl);
		Prismatic(const Prismatic &master);

#ifdef UDM_RVALUE
		Prismatic(Prismatic &&master);

		static Prismatic Cast(::Udm::Object &&a);
		Prismatic& operator=(Prismatic &&a);

#endif
		static Prismatic Cast(const ::Udm::Object &a);
		static Prismatic Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Prismatic CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Prismatic> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Prismatic, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Prismatic, Pred>(impl); };
		Prismatic CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Prismatic> Derived();
		template <class Pred> ::Udm::DerivedAttr< Prismatic, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Prismatic, Pred>(impl); };
		::Udm::ArchetypeAttr< Prismatic> Archetype() const;
		::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections> parent() const;

		static ::Uml::Class meta;

	};

	class KinematicFeature : public ::Udm::Object {
	public:
		KinematicFeature();
		KinematicFeature(::Udm::ObjectImpl *impl);
		KinematicFeature(const KinematicFeature &master);

#ifdef UDM_RVALUE
		KinematicFeature(KinematicFeature &&master);

		static KinematicFeature Cast(::Udm::Object &&a);
		KinematicFeature& operator=(KinematicFeature &&a);

#endif
		static KinematicFeature Cast(const ::Udm::Object &a);
		static KinematicFeature Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		KinematicFeature CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< KinematicFeature> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< KinematicFeature, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< KinematicFeature, Pred>(impl); };
		KinematicFeature CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< KinematicFeature> Derived();
		template <class Pred> ::Udm::DerivedAttr< KinematicFeature, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< KinematicFeature, Pred>(impl); };
		::Udm::ArchetypeAttr< KinematicFeature> Archetype() const;
		::Udm::StringAttr DatumName() const;
		::Udm::StringAttr ComponentID() const;
		::Udm::StringAttr FeatureGeometryType() const;
		::Udm::ParentAttr< ::AssemblyInterface::KinematicBase> KinematicBase_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::KinematicBase> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_DatumName;
		static ::Uml::Attribute meta_ComponentID;
		static ::Uml::Attribute meta_FeatureGeometryType;
		static ::Uml::CompositionParentRole meta_KinematicBase_parent;

	};

	class Fixed :  public KinematicBase {
	public:
		Fixed();
		Fixed(::Udm::ObjectImpl *impl);
		Fixed(const Fixed &master);

#ifdef UDM_RVALUE
		Fixed(Fixed &&master);

		static Fixed Cast(::Udm::Object &&a);
		Fixed& operator=(Fixed &&a);

#endif
		static Fixed Cast(const ::Udm::Object &a);
		static Fixed Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Fixed CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Fixed> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Fixed, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Fixed, Pred>(impl); };
		Fixed CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Fixed> Derived();
		template <class Pred> ::Udm::DerivedAttr< Fixed, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Fixed, Pred>(impl); };
		::Udm::ArchetypeAttr< Fixed> Archetype() const;
		::Udm::ParentAttr< ::AssemblyInterface::KinematicConnections> parent() const;

		static ::Uml::Class meta;

	};

	class ComputationType : public ::Udm::Object {
	public:
		ComputationType();
		ComputationType(::Udm::ObjectImpl *impl);
		ComputationType(const ComputationType &master);

#ifdef UDM_RVALUE
		ComputationType(ComputationType &&master);

		static ComputationType Cast(::Udm::Object &&a);
		ComputationType& operator=(ComputationType &&a);

#endif
		static ComputationType Cast(const ::Udm::Object &a);
		static ComputationType Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		ComputationType CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< ComputationType> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< ComputationType, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< ComputationType, Pred>(impl); };
		ComputationType CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< ComputationType> Derived();
		template <class Pred> ::Udm::DerivedAttr< ComputationType, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< ComputationType, Pred>(impl); };
		::Udm::ArchetypeAttr< ComputationType> Archetype() const;
		::Udm::StringAttr ComponentID() const;
		::Udm::StringAttr RequestedValueType() const;
		::Udm::StringAttr MetricID() const;
		::Udm::ParentAttr< ::AssemblyInterface::Computations> Computations_parent() const;
		::Udm::ParentAttr< ::AssemblyInterface::Computations> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_ComponentID;
		static ::Uml::Attribute meta_RequestedValueType;
		static ::Uml::Attribute meta_MetricID;
		static ::Uml::CompositionParentRole meta_Computations_parent;

	};

	class BoundingBox :  public ComputationType {
	public:
		BoundingBox();
		BoundingBox(::Udm::ObjectImpl *impl);
		BoundingBox(const BoundingBox &master);

#ifdef UDM_RVALUE
		BoundingBox(BoundingBox &&master);

		static BoundingBox Cast(::Udm::Object &&a);
		BoundingBox& operator=(BoundingBox &&a);

#endif
		static BoundingBox Cast(const ::Udm::Object &a);
		static BoundingBox Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		BoundingBox CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< BoundingBox> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< BoundingBox, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< BoundingBox, Pred>(impl); };
		BoundingBox CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< BoundingBox> Derived();
		template <class Pred> ::Udm::DerivedAttr< BoundingBox, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< BoundingBox, Pred>(impl); };
		::Udm::ArchetypeAttr< BoundingBox> Archetype() const;
		::Udm::ParentAttr< ::AssemblyInterface::Computations> parent() const;

		static ::Uml::Class meta;

	};

	class CenterOfGravity :  public ComputationType {
	public:
		CenterOfGravity();
		CenterOfGravity(::Udm::ObjectImpl *impl);
		CenterOfGravity(const CenterOfGravity &master);

#ifdef UDM_RVALUE
		CenterOfGravity(CenterOfGravity &&master);

		static CenterOfGravity Cast(::Udm::Object &&a);
		CenterOfGravity& operator=(CenterOfGravity &&a);

#endif
		static CenterOfGravity Cast(const ::Udm::Object &a);
		static CenterOfGravity Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		CenterOfGravity CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< CenterOfGravity> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< CenterOfGravity, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< CenterOfGravity, Pred>(impl); };
		CenterOfGravity CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< CenterOfGravity> Derived();
		template <class Pred> ::Udm::DerivedAttr< CenterOfGravity, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< CenterOfGravity, Pred>(impl); };
		::Udm::ArchetypeAttr< CenterOfGravity> Archetype() const;
		::Udm::ParentAttr< ::AssemblyInterface::Computations> parent() const;

		static ::Uml::Class meta;

	};

	class PointCoordinates :  public ComputationType {
	public:
		PointCoordinates();
		PointCoordinates(::Udm::ObjectImpl *impl);
		PointCoordinates(const PointCoordinates &master);

#ifdef UDM_RVALUE
		PointCoordinates(PointCoordinates &&master);

		static PointCoordinates Cast(::Udm::Object &&a);
		PointCoordinates& operator=(PointCoordinates &&a);

#endif
		static PointCoordinates Cast(const ::Udm::Object &a);
		static PointCoordinates Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		PointCoordinates CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< PointCoordinates> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< PointCoordinates, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< PointCoordinates, Pred>(impl); };
		PointCoordinates CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< PointCoordinates> Derived();
		template <class Pred> ::Udm::DerivedAttr< PointCoordinates, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< PointCoordinates, Pred>(impl); };
		::Udm::ArchetypeAttr< PointCoordinates> Archetype() const;
		::Udm::StringAttr FeatureDatumName() const;
		::Udm::ParentAttr< ::AssemblyInterface::Computations> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_FeatureDatumName;

	};

	class Mass :  public ComputationType {
	public:
		Mass();
		Mass(::Udm::ObjectImpl *impl);
		Mass(const Mass &master);

#ifdef UDM_RVALUE
		Mass(Mass &&master);

		static Mass Cast(::Udm::Object &&a);
		Mass& operator=(Mass &&a);

#endif
		static Mass Cast(const ::Udm::Object &a);
		static Mass Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Mass CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Mass> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Mass, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Mass, Pred>(impl); };
		Mass CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Mass> Derived();
		template <class Pred> ::Udm::DerivedAttr< Mass, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Mass, Pred>(impl); };
		::Udm::ArchetypeAttr< Mass> Archetype() const;
		::Udm::ParentAttr< ::AssemblyInterface::Computations> parent() const;

		static ::Uml::Class meta;

	};

}

#endif // MOBIES_ASSEMBLYINTERFACE_H
