/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef AssemblyInterface_xsd_H
#define AssemblyInterface_xsd_H
#include <string>
#pragma warning( disable : 4010)

namespace AssemblyInterface_xsd
{
const std::string& getString()
{
	static std::string str;
	if (str.empty())
	{
		str +="<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
		str +="<?udm interface=\"AssemblyInterface\" version=\"1.2.0.0\"?>\n";
		str +="<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n";
		str +=" elementFormDefault=\"qualified\" \n";
		str +=">\n";
//		str +="<!-- generated on Thu Mar 07 16:38:21 2013 -->\n";
		str +="\n";
		str +="\n";
		str +="	<xsd:complexType name=\"AssemblyType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Analyses\" type=\"AnalysesType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"CADComponent\" type=\"CADComponentType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"Computations\" type=\"ComputationsType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"Properties\" type=\"PropertiesType\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"ConfigurationID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"CADComponentType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"CADComponent\" type=\"CADComponentType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Constraint\" type=\"ConstraintType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"KinematicConnections\" type=\"KinematicConnectionsType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"ParametricParameters\" type=\"ParametricParametersType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"ComponentID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Name\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Type\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"SpecialInstruction\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"MaterialID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Standalone\" type=\"xsd:boolean\" default=\"false\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"UnitsType\">\n";
		str +="		<xsd:attribute name=\"Value\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PropertiesType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Units\" type=\"UnitsType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ConstraintType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Pair\" type=\"PairType\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ConstraintFeatureType\">\n";
		str +="		<xsd:attribute name=\"ComponentID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"FeatureName\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"FeatureOrientationType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PairType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"ConstraintFeature\" type=\"ConstraintFeatureType\" minOccurs=\"2\" maxOccurs=\"2\"/>\n";
		str +="			<xsd:element name=\"ConstraintOffset\" type=\"ConstraintOffsetType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"FeatureInterfaceType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"FeatureGeometryType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"FeatureAlignmentType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"CADParameterType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Units\" type=\"UnitsType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Name\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Type\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Value\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ConstraintOffsetType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Units\" type=\"UnitsType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Value\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"OffsetAlignmentType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ParametricParametersType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"CADParameter\" type=\"CADParameterType\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"AssembliesType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Assembly\" type=\"AssemblyType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"DataExchange\" type=\"DataExchangeType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"Materials\" type=\"MaterialsType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"UnassembledComponents\" type=\"UnassembledComponentsType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"Assemblies\" type=\"AssembliesType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"VersionInfo\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_libname\" type=\"xsd:string\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"AnalysesType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"FEA\" type=\"FEAType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Interference\" type=\"InterferenceType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Tolerance\" type=\"ToleranceType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"MaterialType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"MaterialProperty\" type=\"MaterialPropertyType\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"MaterialName\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"MaterialID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"MaterialType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"MaterialPropertyType\">\n";
		str +="		<xsd:attribute name=\"PropertyName\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Value\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Units\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"MaterialsType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Material\" type=\"MaterialType\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"DataExchangeType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"STEPFormat\" type=\"STEPFormatType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"STEPFormatType\">\n";
		str +="		<xsd:attribute name=\"Name\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ComputationsType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"BoundingBox\" type=\"BoundingBoxType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"CenterOfGravity\" type=\"CenterOfGravityType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Mass\" type=\"MassType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"PointCoordinates\" type=\"PointCoordinatesType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"UnassembledComponentsType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"CADComponent\" type=\"CADComponentType\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"AnalysisConstraintsType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"AnalysisConstraint\" type=\"AnalysisConstraintType\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PartInterfacesType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"PartInterface\" type=\"PartInterfaceType\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"FEAType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"AnalysisComponents\" type=\"AnalysisComponentsType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"AnalysisConstraints\" type=\"AnalysisConstraintsType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"Conditions\" type=\"ConditionsType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"Loads\" type=\"LoadsType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"PartInterfaces\" type=\"PartInterfacesType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"Solvers\" type=\"SolversType\"/>\n";
		str +="			<xsd:element name=\"SurfaceTreatments\" type=\"SurfaceTreatmentsType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"Type\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"AnalysisID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"SolverType\">\n";
		str +="		<xsd:attribute name=\"Type\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"MeshType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ShellElementType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ElementShapeType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"AnalysisConstraintType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Ball\" type=\"BallType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"Displacement\" type=\"DisplacementType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"Geometry\" type=\"GeometryType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"Pin\" type=\"PinType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"LoadsType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Load\" type=\"LoadType\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"AnalysisComponentsType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Component\" type=\"ComponentType\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"LoadType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Acceleration\" type=\"AccelerationType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"ForceMoment\" type=\"ForceMomentType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"Geometry\" type=\"GeometryType\" minOccurs=\"0\"/>\n";
		str +="			<xsd:element name=\"Pressure\" type=\"PressureType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PartInterfaceType\">\n";
		str +="		<xsd:attribute name=\"Type\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ComponentID_1\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ComponentID_2\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ComponentType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Metrics\" type=\"MetricsType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"ComponentID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"InfiniteCycle\" type=\"xsd:boolean\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"SolversType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Solver\" type=\"SolverType\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"InterferenceType\">\n";
		str +="		<xsd:attribute name=\"AnalysisID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ToleranceType\">\n";
		str +="		<xsd:attribute name=\"AnalysisID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"MetricType\">\n";
		str +="		<xsd:attribute name=\"Type\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"MetricsType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Metric\" type=\"MetricType\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ConditionsType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Condition\" type=\"ConditionType\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ConditionType\">\n";
		str +="		<xsd:attribute name=\"Name\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Value\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Units\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"SurfaceTreatmentType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Geometry\" type=\"GeometryType\" minOccurs=\"0\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"AdjoiningParts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"SurfaceTreatmentsType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"SurfaceTreatment\" type=\"SurfaceTreatmentType\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"FeaturesType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Feature\" type=\"FeatureType\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"FeatureID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"GeometryType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"FeatureInterfaceType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"FeatureGeometryType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"PrimaryGeometryQualifier\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"SecondaryGeometryQualifier\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"FeatureType\">\n";
		str +="		<xsd:attribute name=\"Name\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ComponentID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"DisplacementType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Rotation\" type=\"RotationType\"/>\n";
		str +="			<xsd:element name=\"Translation\" type=\"TranslationType\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PinType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"AxialDisplacement\" type=\"AxialDisplacementType\"/>\n";
		str +="			<xsd:element name=\"AxialRotation\" type=\"AxialRotationType\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"BallType\">\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ForceMomentType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Force\" type=\"ForceType\"/>\n";
		str +="			<xsd:element name=\"Moment\" type=\"MomentType\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PressureType\">\n";
		str +="		<xsd:attribute name=\"Value\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"Units\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"AccelerationType\">\n";
		str +="		<xsd:attribute name=\"Units\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"x\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"y\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"z\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"AxialRotationType\">\n";
		str +="		<xsd:attribute name=\"Property\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"AxialDisplacementType\">\n";
		str +="		<xsd:attribute name=\"Property\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"TranslationType\">\n";
		str +="		<xsd:attribute name=\"Units\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"x\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"y\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"z\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"RotationType\">\n";
		str +="		<xsd:attribute name=\"Units\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"x\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"y\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"z\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"ForceType\">\n";
		str +="		<xsd:attribute name=\"Units\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"x\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"y\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"z\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"MomentType\">\n";
		str +="		<xsd:attribute name=\"Units\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"x\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"y\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"z\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"GeometryType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Features\" type=\"FeaturesType\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"SetOperation\" type=\"SetOperationType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"SetOperationType\">\n";
		str +="		<xsd:attribute name=\"Type\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"FeatureID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"KinematicConnectionsType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"Fixed\" type=\"FixedType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Prismatic\" type=\"PrismaticType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Revolute\" type=\"RevoluteType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="			<xsd:element name=\"Spherical\" type=\"SphericalType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"RevoluteType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"KinematicFeature\" type=\"KinematicFeatureType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"ConnectionID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ConnectedComponentID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"FeatureInterfaceType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ERP\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"CFM\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"SphericalType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"KinematicFeature\" type=\"KinematicFeatureType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"ConnectionID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ConnectedComponentID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"FeatureInterfaceType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ERP\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"CFM\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PrismaticType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"KinematicFeature\" type=\"KinematicFeatureType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"ConnectionID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ConnectedComponentID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"FeatureInterfaceType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ERP\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"CFM\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"KinematicFeatureType\">\n";
		str +="		<xsd:attribute name=\"DatumName\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ComponentID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"FeatureGeometryType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"FixedType\">\n";
		str +="		<xsd:sequence>\n";
		str +="			<xsd:element name=\"KinematicFeature\" type=\"KinematicFeatureType\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n";
		str +="		</xsd:sequence>\n";
		str +="		<xsd:attribute name=\"ConnectionID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ConnectedComponentID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"FeatureInterfaceType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"ERP\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"CFM\" type=\"xsd:double\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"BoundingBoxType\">\n";
		str +="		<xsd:attribute name=\"ComponentID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"RequestedValueType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"MetricID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"CenterOfGravityType\">\n";
		str +="		<xsd:attribute name=\"ComponentID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"RequestedValueType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"MetricID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"PointCoordinatesType\">\n";
		str +="		<xsd:attribute name=\"ComponentID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"RequestedValueType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"MetricID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"FeatureDatumName\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +="	<xsd:complexType name=\"MassType\">\n";
		str +="		<xsd:attribute name=\"ComponentID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"RequestedValueType\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"MetricID\" type=\"xsd:string\" use=\"required\"/>\n";
		str +="		<xsd:attribute name=\"_id\" type=\"xsd:ID\"/>\n";
		str +="		<xsd:attribute name=\"_archetype\" type=\"xsd:IDREF\"/>\n";
		str +="		<xsd:attribute name=\"_derived\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_instances\" type=\"xsd:IDREFS\"/>\n";
		str +="		<xsd:attribute name=\"_desynched_atts\" type=\"xsd:string\"/>\n";
		str +="		<xsd:attribute name=\"_real_archetype\" type=\"xsd:boolean\"/>\n";
		str +="		<xsd:attribute name=\"_subtype\" type=\"xsd:boolean\"/>\n";
		str +="	</xsd:complexType>\n";
		str +="\n";
		str +=" <xsd:element name=\"Assemblies\" type=\"AssembliesType\"/>\n";
		str +="\n";
		str +="</xsd:schema>\n";
		str +="\n";
	}
		return str;
}
} //namespace
#endif
