/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "CADEnvironmentSettings.h"
#include "CADSoftwareEnvirUtils.h"
#include <CommonUtilities.h>
#include <windows.h>
#include "WindowsFunctions.h"
#include <malloc.h>
//#include <stdio.h>
#include <iostream>
#include <vector>
//#include <list>
#include <tchar.h>
#include <algorithm>
#include <sstream>
#include <ISISConstants.h>

// #define BUFFER 8192

namespace isis
{		

	//////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	Description:	
	//		Based on the input arguments (i.e. in_argv), this function sets the PRO_COMM_MSG_EXE system 
	//		environment variable and retrieves the system settings.  See the function 
	//		SetupCreoEnvironmentVariables (above in this file) for more information about setting the evirmoment 
	//		variable and the source of the retrieved data.
	//
	//		If the data cannot be retrieved then isis::application_exception will be thrown.
	void SetCreoEnvirVariable_RetrieveSystemSettings( int   in_argc, 
													char *in_argv[],
													std::string		&out_CreoStartCommand,
													std::string		&out_ProeIsisExtensionsDir,
													std::string		&out_WorkingDir,
													std::string		&out_cADPartsLibDir,
													std::string		&out_XmlInputFile_PathAndFileName,  // may not contain path, if so reads from the same directory as the bat file location
													const std::string	&in_LogFile_PathAndFileName,	
													std::string		&out_TemplateFile_PathAndFileName,
													bool			&out_PromptBeforeExiting ) throw (isis::application_exception)
	{

		///////////////////////////////////////////////////////////////
		// Log: Use environment  variables or look values in registry
		//////////////////////////////////////////////////////////////
		char *envVariable_CREO_PARAMETRIC_USE_ENVIR_VARS;
		envVariable_CREO_PARAMETRIC_USE_ENVIR_VARS = getenv ("CREO_PARAMETRIC_USE_ENVIR_VARS");
		std::clog << std::endl;
		if ( envVariable_CREO_PARAMETRIC_USE_ENVIR_VARS == NULL )
			std::clog << std::endl << "Environment Variable CREO_PARAMETRIC_USE_ENVIR_VARS: Not Defined";
		else 
			std::clog << std::endl << "Environment Variable CREO_PARAMETRIC_USE_ENVIR_VARS: " << envVariable_CREO_PARAMETRIC_USE_ENVIR_VARS;

		int workingDirArg;
		int cADPartsLibDirArg = -1;
		int xmlFileArg;
		int logFileArg;
		int promptBeforeExitingArg;

		//New Case: %WORKING_DIR%   %PARTS_DIR%    %ASSEMBLY_XML_FILE%     %LOG_FILE%     %EXIT_PROMPT%

		workingDirArg = 1;
		cADPartsLibDirArg = 2;
		xmlFileArg = 3;
		logFileArg = 4;
		promptBeforeExitingArg = 5;

		//////////////////////////
		// Log Arguments
		//////////////////////////
		std::clog << std::endl << "arg 0, EXE:                     "  << in_argv[0];				// 0 EXE					e.g. C:\Program Files\Proe ISIS Extensions\bin\CADCreoParametricCreateAssembly.exe
		std::clog << std::endl << "arg 1, WORKING_DIR:             "  << in_argv[workingDirArg];	// 1 WORKING_DIR	
		std::clog << std::endl << "arg 2, PARTS_DIR:               "  << in_argv[cADPartsLibDirArg];// 2 PARTS_DIR	
		std::clog << std::endl << "arg 3, ASSEMBLY_XML_FILE:       "  << in_argv[xmlFileArg];		// 3 ASSEMBLY_XML_FILE	e.g. RLC_Assembly_5_CAD.xml
		std::clog << std::endl << "arg 4, LOG_FILE:                "  << in_argv[logFileArg];		// 4 LOG_FILE				e.g. RLC_Assembly_5_CAD.xml.log

		//////////////////////////
		// Prompt Before Exiting
		//////////////////////////
		out_PromptBeforeExiting = true;
		if ( in_argc == ( promptBeforeExitingArg + 1 )) 
		{
			std::clog << std::endl << "arg "<< promptBeforeExitingArg << ", PROMPT (before exiting): "  << in_argv[promptBeforeExitingArg];
			if ( strcmp("NO",  _strupr(in_argv[promptBeforeExitingArg]))  == 0  ) out_PromptBeforeExiting = false;
		}
		else
		{        
			std::clog << std::endl << "arg "<< promptBeforeExitingArg << ", PROMPT (before exiting): not passed, assume prompt before exiting";
		}

		/////////////////
		// Directories
		/////////////////
		out_ProeIsisExtensionsDir = getenv ("PROE_ISIS_EXTENSIONS");
		out_WorkingDir = in_argv[workingDirArg];  

		// Must get the complete path to the working directory.  This is necessary because when 
		// isis_ProDirectoryChange is called to change to a STEP directory, workingDir must be fully 
		// defined so that isis_ProDirectoryChange can be called to return to the original directory.
		if( ( out_WorkingDir.size() == 1 ) && out_WorkingDir[0] == '.') out_WorkingDir = isis_CADCommon::isis_GetCurrentDirectoryA();
		if ( cADPartsLibDirArg > 0 )
			out_cADPartsLibDir = in_argv[cADPartsLibDirArg];
		else
			out_cADPartsLibDir = "";
		
		out_XmlInputFile_PathAndFileName = in_argv[xmlFileArg];
		//out_LogFile_PathAndFileName = in_argv[logFileArg];

		if ( out_WorkingDir.size() >= PRO_PATH_SIZE )  // PRO_PATH_SIZE   260
		{
			std::stringstream errorString;
			errorString << "WORKING_DIR string too long.  Maximum allowed number of characters: "  << PRO_PATH_SIZE - 1 << " WORKING_DIR string: " << out_WorkingDir;
					throw isis::application_exception(errorString.str().c_str());
		}

		/////////////////////////////
		// Creo Start Command
		/////////////////////////////
		out_CreoStartCommand = ""; 
		isis::SetupCreoEnvironmentVariables(out_CreoStartCommand);
		out_TemplateFile_PathAndFileName =  out_ProeIsisExtensionsDir + "\\templates\\" + isis::TEMPLATE_MODEL_NAME_METRIC + isis::TEMPLATE_MODEL_NAME_METRIC_SUFFIX;	

		/////////////////////////////
		// Log Resulting Settings
		/////////////////////////////
		std::clog << std::endl << std::endl << "************** Begin Environment Variables and System Settings *****************";
		std::clog << std::endl << "ProeIsisExtensionsDir:         "	<< out_ProeIsisExtensionsDir; 
		std::clog << std::endl << "CreoStartCommand:              "	<< out_CreoStartCommand; 
		std::clog << std::endl << "PRO_COMM_MSG_EXE:              "	<<  getenv ("PRO_COMM_MSG_EXE"); 
		std::clog << std::endl << "WorkingDir:                    "	<< out_WorkingDir; 
		std::clog << std::endl << "XmlInputFile_PathAndFileName:  "	<< out_XmlInputFile_PathAndFileName; 
		std::clog << std::endl << "LogFile:                       "	<< in_LogFile_PathAndFileName; 
		std::clog << std::endl << "TemplateFile_PathAndFileName:  "	<< out_TemplateFile_PathAndFileName; 
		std::clog << std::endl << "************** End Environment Variables and System Settings *****************";

	}

} // end namespace isis