/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// cpp (meta datanetwork format) source file CADMetrics.cpp
// generated from diagram CADMetrics
// generated on Tue Dec 18 15:14:59 2012

#include "CADMetrics.h"
#include <UmlExt.h>
#include <UdmStatic.h>

#include <UdmDom.h>
#include "CADMetrics_xsd.h"
using namespace std;

namespace CADMetrics {

	Anomaly::Anomaly() {}
	Anomaly::Anomaly(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Anomaly::Anomaly(const Anomaly &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Anomaly::Anomaly(Anomaly &&master) : UDM_OBJECT(master) {};

	Anomaly Anomaly::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Anomaly& Anomaly::operator=(Anomaly &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Anomaly Anomaly::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Anomaly Anomaly::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Anomaly Anomaly::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Anomaly> Anomaly::Instances() { return ::Udm::InstantiatedAttr< Anomaly>(impl); }
	Anomaly Anomaly::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Anomaly> Anomaly::Derived() { return ::Udm::DerivedAttr< Anomaly>(impl); }
	::Udm::ArchetypeAttr< Anomaly> Anomaly::Archetype() const { return ::Udm::ArchetypeAttr< Anomaly>(impl); }
	::Udm::StringAttr Anomaly::MetricID() const { return ::Udm::StringAttr(impl, meta_MetricID); }
	::Udm::StringAttr Anomaly::Error() const { return ::Udm::StringAttr(impl, meta_Error); }
	::Udm::ParentAttr< ::CADMetrics::Anomalies> Anomaly::Anomalies_parent() const { return ::Udm::ParentAttr< ::CADMetrics::Anomalies>(impl, meta_Anomalies_parent); }
	::Udm::ParentAttr< ::CADMetrics::Anomalies> Anomaly::parent() const { return ::Udm::ParentAttr< ::CADMetrics::Anomalies>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Anomaly::meta;
	::Uml::Attribute Anomaly::meta_MetricID;
	::Uml::Attribute Anomaly::meta_Error;
	::Uml::CompositionParentRole Anomaly::meta_Anomalies_parent;

	Children::Children() {}
	Children::Children(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Children::Children(const Children &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Children::Children(Children &&master) : UDM_OBJECT(master) {};

	Children Children::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Children& Children::operator=(Children &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Children Children::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Children Children::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Children Children::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Children> Children::Instances() { return ::Udm::InstantiatedAttr< Children>(impl); }
	Children Children::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Children> Children::Derived() { return ::Udm::DerivedAttr< Children>(impl); }
	::Udm::ArchetypeAttr< Children> Children::Archetype() const { return ::Udm::ArchetypeAttr< Children>(impl); }
	::Udm::ChildrenAttr< ::CADMetrics::ChildMetric> Children::ChildMetric_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::ChildMetric>(impl, meta_ChildMetric_children); }
	::Udm::ChildrenAttr< ::CADMetrics::MetricsBase> Children::MetricsBase_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::MetricsBase>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::ChildMetric> Children::ChildMetric_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::ChildMetric>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> Children::MetricComponent_parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, meta_MetricComponent_parent); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> Children::parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Children::meta;
	::Uml::CompositionChildRole Children::meta_ChildMetric_children;
	::Uml::CompositionParentRole Children::meta_MetricComponent_parent;

	MetricComponents::MetricComponents() {}
	MetricComponents::MetricComponents(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	MetricComponents::MetricComponents(const MetricComponents &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	MetricComponents::MetricComponents(MetricComponents &&master) : UDM_OBJECT(master) {};

	MetricComponents MetricComponents::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	MetricComponents& MetricComponents::operator=(MetricComponents &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	MetricComponents MetricComponents::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	MetricComponents MetricComponents::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	MetricComponents MetricComponents::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< MetricComponents> MetricComponents::Instances() { return ::Udm::InstantiatedAttr< MetricComponents>(impl); }
	MetricComponents MetricComponents::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< MetricComponents> MetricComponents::Derived() { return ::Udm::DerivedAttr< MetricComponents>(impl); }
	::Udm::ArchetypeAttr< MetricComponents> MetricComponents::Archetype() const { return ::Udm::ArchetypeAttr< MetricComponents>(impl); }
	::Udm::ChildrenAttr< ::CADMetrics::MetricComponent> MetricComponents::MetricComponent_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::MetricComponent>(impl, meta_MetricComponent_children); }
	::Udm::ChildrenAttr< ::CADMetrics::MetricsBase> MetricComponents::MetricsBase_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::MetricsBase>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::MetricComponent> MetricComponents::MetricComponent_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::MetricComponent>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADMetrics::CADMetricRoot> MetricComponents::CADMetricRoot_parent() const { return ::Udm::ParentAttr< ::CADMetrics::CADMetricRoot>(impl, meta_CADMetricRoot_parent); }
	::Udm::ParentAttr< ::CADMetrics::CADMetricRoot> MetricComponents::parent() const { return ::Udm::ParentAttr< ::CADMetrics::CADMetricRoot>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class MetricComponents::meta;
	::Uml::CompositionChildRole MetricComponents::meta_MetricComponent_children;
	::Uml::CompositionParentRole MetricComponents::meta_CADMetricRoot_parent;

	CADMetricRoot::CADMetricRoot() {}
	CADMetricRoot::CADMetricRoot(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	CADMetricRoot::CADMetricRoot(const CADMetricRoot &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	CADMetricRoot::CADMetricRoot(CADMetricRoot &&master) : UDM_OBJECT(master) {};

	CADMetricRoot CADMetricRoot::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	CADMetricRoot& CADMetricRoot::operator=(CADMetricRoot &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	CADMetricRoot CADMetricRoot::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	CADMetricRoot CADMetricRoot::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	CADMetricRoot CADMetricRoot::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< CADMetricRoot> CADMetricRoot::Instances() { return ::Udm::InstantiatedAttr< CADMetricRoot>(impl); }
	CADMetricRoot CADMetricRoot::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< CADMetricRoot> CADMetricRoot::Derived() { return ::Udm::DerivedAttr< CADMetricRoot>(impl); }
	::Udm::ArchetypeAttr< CADMetricRoot> CADMetricRoot::Archetype() const { return ::Udm::ArchetypeAttr< CADMetricRoot>(impl); }
	::Udm::StringAttr CADMetricRoot::VersionInfo() const { return ::Udm::StringAttr(impl, meta_VersionInfo); }
	::Udm::ChildAttr< ::CADMetrics::Assemblies> CADMetricRoot::Assemblies_child() const { return ::Udm::ChildAttr< ::CADMetrics::Assemblies>(impl, meta_Assemblies_child); }
	::Udm::ChildAttr< ::CADMetrics::MetricComponents> CADMetricRoot::MetricComponents_child() const { return ::Udm::ChildAttr< ::CADMetrics::MetricComponents>(impl, meta_MetricComponents_child); }
	::Udm::ChildAttr< ::CADMetrics::Anomalies> CADMetricRoot::Anomalies_child() const { return ::Udm::ChildAttr< ::CADMetrics::Anomalies>(impl, meta_Anomalies_child); }
	::Udm::ChildrenAttr< ::CADMetrics::MetricComponents> CADMetricRoot::MetricComponents_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::MetricComponents>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::Assemblies> CADMetricRoot::Assemblies_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Assemblies>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::Anomalies> CADMetricRoot::Anomalies_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Anomalies>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::Udm::Object> CADMetricRoot::parent() const { return ::Udm::ParentAttr< ::Udm::Object>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class CADMetricRoot::meta;
	::Uml::Attribute CADMetricRoot::meta_VersionInfo;
	::Uml::CompositionChildRole CADMetricRoot::meta_Assemblies_child;
	::Uml::CompositionChildRole CADMetricRoot::meta_MetricComponents_child;
	::Uml::CompositionChildRole CADMetricRoot::meta_Anomalies_child;

	Assemblies::Assemblies() {}
	Assemblies::Assemblies(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Assemblies::Assemblies(const Assemblies &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Assemblies::Assemblies(Assemblies &&master) : UDM_OBJECT(master) {};

	Assemblies Assemblies::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Assemblies& Assemblies::operator=(Assemblies &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Assemblies Assemblies::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Assemblies Assemblies::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Assemblies Assemblies::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Assemblies> Assemblies::Instances() { return ::Udm::InstantiatedAttr< Assemblies>(impl); }
	Assemblies Assemblies::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Assemblies> Assemblies::Derived() { return ::Udm::DerivedAttr< Assemblies>(impl); }
	::Udm::ArchetypeAttr< Assemblies> Assemblies::Archetype() const { return ::Udm::ArchetypeAttr< Assemblies>(impl); }
	::Udm::ChildrenAttr< ::CADMetrics::Assembly> Assemblies::Assembly_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Assembly>(impl, meta_Assembly_children); }
	::Udm::ChildrenAttr< ::CADMetrics::Assembly> Assemblies::Assembly_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Assembly>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADMetrics::CADMetricRoot> Assemblies::CADMetricRoot_parent() const { return ::Udm::ParentAttr< ::CADMetrics::CADMetricRoot>(impl, meta_CADMetricRoot_parent); }
	::Udm::ParentAttr< ::CADMetrics::CADMetricRoot> Assemblies::parent() const { return ::Udm::ParentAttr< ::CADMetrics::CADMetricRoot>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Assemblies::meta;
	::Uml::CompositionChildRole Assemblies::meta_Assembly_children;
	::Uml::CompositionParentRole Assemblies::meta_CADMetricRoot_parent;

	CADComponent::CADComponent() {}
	CADComponent::CADComponent(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	CADComponent::CADComponent(const CADComponent &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	CADComponent::CADComponent(CADComponent &&master) : UDM_OBJECT(master) {};

	CADComponent CADComponent::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	CADComponent& CADComponent::operator=(CADComponent &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	CADComponent CADComponent::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	CADComponent CADComponent::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	CADComponent CADComponent::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< CADComponent> CADComponent::Instances() { return ::Udm::InstantiatedAttr< CADComponent>(impl); }
	CADComponent CADComponent::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< CADComponent> CADComponent::Derived() { return ::Udm::DerivedAttr< CADComponent>(impl); }
	::Udm::ArchetypeAttr< CADComponent> CADComponent::Archetype() const { return ::Udm::ArchetypeAttr< CADComponent>(impl); }
	::Udm::StringAttr CADComponent::ComponentID() const { return ::Udm::StringAttr(impl, meta_ComponentID); }
	::Udm::IntegerAttr CADComponent::MetricID() const { return ::Udm::IntegerAttr(impl, meta_MetricID); }
	::Udm::ChildrenAttr< ::CADMetrics::CADComponent> CADComponent::CADComponent_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::CADComponent>(impl, meta_CADComponent_children); }
	::Udm::ChildrenAttr< ::CADMetrics::CADComponent> CADComponent::CADComponent_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::CADComponent>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADMetrics::CADComponent> CADComponent::CADComponent_parent() const { return ::Udm::ParentAttr< ::CADMetrics::CADComponent>(impl, meta_CADComponent_parent); }
	::Udm::ParentAttr< ::CADMetrics::Assembly> CADComponent::Assembly_parent() const { return ::Udm::ParentAttr< ::CADMetrics::Assembly>(impl, meta_Assembly_parent); }
	::Udm::ParentAttr< ::Udm::Object> CADComponent::parent() const { return ::Udm::ParentAttr< ::Udm::Object>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class CADComponent::meta;
	::Uml::Attribute CADComponent::meta_ComponentID;
	::Uml::Attribute CADComponent::meta_MetricID;
	::Uml::CompositionChildRole CADComponent::meta_CADComponent_children;
	::Uml::CompositionParentRole CADComponent::meta_CADComponent_parent;
	::Uml::CompositionParentRole CADComponent::meta_Assembly_parent;

	Assembly::Assembly() {}
	Assembly::Assembly(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Assembly::Assembly(const Assembly &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Assembly::Assembly(Assembly &&master) : UDM_OBJECT(master) {};

	Assembly Assembly::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Assembly& Assembly::operator=(Assembly &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Assembly Assembly::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Assembly Assembly::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Assembly Assembly::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Assembly> Assembly::Instances() { return ::Udm::InstantiatedAttr< Assembly>(impl); }
	Assembly Assembly::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Assembly> Assembly::Derived() { return ::Udm::DerivedAttr< Assembly>(impl); }
	::Udm::ArchetypeAttr< Assembly> Assembly::Archetype() const { return ::Udm::ArchetypeAttr< Assembly>(impl); }
	::Udm::StringAttr Assembly::ConfigurationID() const { return ::Udm::StringAttr(impl, meta_ConfigurationID); }
	::Udm::ChildAttr< ::CADMetrics::CADComponent> Assembly::CADComponent_child() const { return ::Udm::ChildAttr< ::CADMetrics::CADComponent>(impl, meta_CADComponent_child); }
	::Udm::ChildrenAttr< ::CADMetrics::CADComponent> Assembly::CADComponent_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::CADComponent>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADMetrics::Assemblies> Assembly::Assemblies_parent() const { return ::Udm::ParentAttr< ::CADMetrics::Assemblies>(impl, meta_Assemblies_parent); }
	::Udm::ParentAttr< ::CADMetrics::Assemblies> Assembly::parent() const { return ::Udm::ParentAttr< ::CADMetrics::Assemblies>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Assembly::meta;
	::Uml::Attribute Assembly::meta_ConfigurationID;
	::Uml::CompositionChildRole Assembly::meta_CADComponent_child;
	::Uml::CompositionParentRole Assembly::meta_Assemblies_parent;

	Anomalies::Anomalies() {}
	Anomalies::Anomalies(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Anomalies::Anomalies(const Anomalies &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Anomalies::Anomalies(Anomalies &&master) : UDM_OBJECT(master) {};

	Anomalies Anomalies::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Anomalies& Anomalies::operator=(Anomalies &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Anomalies Anomalies::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Anomalies Anomalies::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Anomalies Anomalies::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Anomalies> Anomalies::Instances() { return ::Udm::InstantiatedAttr< Anomalies>(impl); }
	Anomalies Anomalies::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Anomalies> Anomalies::Derived() { return ::Udm::DerivedAttr< Anomalies>(impl); }
	::Udm::ArchetypeAttr< Anomalies> Anomalies::Archetype() const { return ::Udm::ArchetypeAttr< Anomalies>(impl); }
	::Udm::ChildrenAttr< ::CADMetrics::Anomaly> Anomalies::Anomaly_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Anomaly>(impl, meta_Anomaly_children); }
	::Udm::ChildrenAttr< ::CADMetrics::Anomaly> Anomalies::Anomaly_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Anomaly>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADMetrics::CADMetricRoot> Anomalies::CADMetricRoot_parent() const { return ::Udm::ParentAttr< ::CADMetrics::CADMetricRoot>(impl, meta_CADMetricRoot_parent); }
	::Udm::ParentAttr< ::CADMetrics::CADMetricRoot> Anomalies::parent() const { return ::Udm::ParentAttr< ::CADMetrics::CADMetricRoot>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Anomalies::meta;
	::Uml::CompositionChildRole Anomalies::meta_Anomaly_children;
	::Uml::CompositionParentRole Anomalies::meta_CADMetricRoot_parent;

	MetricsBase::MetricsBase() {}
	MetricsBase::MetricsBase(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	MetricsBase::MetricsBase(const MetricsBase &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	MetricsBase::MetricsBase(MetricsBase &&master) : UDM_OBJECT(master) {};

	MetricsBase MetricsBase::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	MetricsBase& MetricsBase::operator=(MetricsBase &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	MetricsBase MetricsBase::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	MetricsBase MetricsBase::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	MetricsBase MetricsBase::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< MetricsBase> MetricsBase::Instances() { return ::Udm::InstantiatedAttr< MetricsBase>(impl); }
	MetricsBase MetricsBase::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< MetricsBase> MetricsBase::Derived() { return ::Udm::DerivedAttr< MetricsBase>(impl); }
	::Udm::ArchetypeAttr< MetricsBase> MetricsBase::Archetype() const { return ::Udm::ArchetypeAttr< MetricsBase>(impl); }
	::Udm::IntegerAttr MetricsBase::MetricID() const { return ::Udm::IntegerAttr(impl, meta_MetricID); }
	::Udm::ParentAttr< ::Udm::Object> MetricsBase::parent() const { return ::Udm::ParentAttr< ::Udm::Object>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class MetricsBase::meta;
	::Uml::Attribute MetricsBase::meta_MetricID;

	Scalars::Scalars() {}
	Scalars::Scalars(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Scalars::Scalars(const Scalars &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Scalars::Scalars(Scalars &&master) : UDM_OBJECT(master) {};

	Scalars Scalars::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Scalars& Scalars::operator=(Scalars &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Scalars Scalars::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Scalars Scalars::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Scalars Scalars::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Scalars> Scalars::Instances() { return ::Udm::InstantiatedAttr< Scalars>(impl); }
	Scalars Scalars::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Scalars> Scalars::Derived() { return ::Udm::DerivedAttr< Scalars>(impl); }
	::Udm::ArchetypeAttr< Scalars> Scalars::Archetype() const { return ::Udm::ArchetypeAttr< Scalars>(impl); }
	::Udm::ChildrenAttr< ::CADMetrics::Scalar> Scalars::Scalar_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Scalar>(impl, meta_Scalar_children); }
	::Udm::ChildrenAttr< ::CADMetrics::Scalar> Scalars::Scalar_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Scalar>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> Scalars::MetricComponent_parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, meta_MetricComponent_parent); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> Scalars::parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Scalars::meta;
	::Uml::CompositionChildRole Scalars::meta_Scalar_children;
	::Uml::CompositionParentRole Scalars::meta_MetricComponent_parent;

	ChildMetric::ChildMetric() {}
	ChildMetric::ChildMetric(::Udm::ObjectImpl *impl) : MetricsBase(impl) {}
	ChildMetric::ChildMetric(const ChildMetric &master) : MetricsBase(master) {}

#ifdef UDM_RVALUE
	ChildMetric::ChildMetric(ChildMetric &&master) : MetricsBase(master) {};

	ChildMetric ChildMetric::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	ChildMetric& ChildMetric::operator=(ChildMetric &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	ChildMetric ChildMetric::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	ChildMetric ChildMetric::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	ChildMetric ChildMetric::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< ChildMetric> ChildMetric::Instances() { return ::Udm::InstantiatedAttr< ChildMetric>(impl); }
	ChildMetric ChildMetric::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< ChildMetric> ChildMetric::Derived() { return ::Udm::DerivedAttr< ChildMetric>(impl); }
	::Udm::ArchetypeAttr< ChildMetric> ChildMetric::Archetype() const { return ::Udm::ArchetypeAttr< ChildMetric>(impl); }
	::Udm::ChildAttr< ::CADMetrics::Translation> ChildMetric::Translation_child() const { return ::Udm::ChildAttr< ::CADMetrics::Translation>(impl, meta_Translation_child); }
	::Udm::ChildAttr< ::CADMetrics::RotationMatrix> ChildMetric::RotationMatrix_child() const { return ::Udm::ChildAttr< ::CADMetrics::RotationMatrix>(impl, meta_RotationMatrix_child); }
	::Udm::ChildrenAttr< ::CADMetrics::Matrix> ChildMetric::Matrix_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Matrix>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::RotationMatrix> ChildMetric::RotationMatrix_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::RotationMatrix>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::CoordinateBase> ChildMetric::CoordinateBase_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::CoordinateBase>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::Translation> ChildMetric::Translation_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Translation>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADMetrics::Children> ChildMetric::Children_parent() const { return ::Udm::ParentAttr< ::CADMetrics::Children>(impl, meta_Children_parent); }
	::Udm::ParentAttr< ::CADMetrics::Children> ChildMetric::parent() const { return ::Udm::ParentAttr< ::CADMetrics::Children>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class ChildMetric::meta;
	::Uml::CompositionChildRole ChildMetric::meta_Translation_child;
	::Uml::CompositionChildRole ChildMetric::meta_RotationMatrix_child;
	::Uml::CompositionParentRole ChildMetric::meta_Children_parent;

	MetricComponent::MetricComponent() {}
	MetricComponent::MetricComponent(::Udm::ObjectImpl *impl) : MetricsBase(impl) {}
	MetricComponent::MetricComponent(const MetricComponent &master) : MetricsBase(master) {}

#ifdef UDM_RVALUE
	MetricComponent::MetricComponent(MetricComponent &&master) : MetricsBase(master) {};

	MetricComponent MetricComponent::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	MetricComponent& MetricComponent::operator=(MetricComponent &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	MetricComponent MetricComponent::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	MetricComponent MetricComponent::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	MetricComponent MetricComponent::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< MetricComponent> MetricComponent::Instances() { return ::Udm::InstantiatedAttr< MetricComponent>(impl); }
	MetricComponent MetricComponent::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< MetricComponent> MetricComponent::Derived() { return ::Udm::DerivedAttr< MetricComponent>(impl); }
	::Udm::ArchetypeAttr< MetricComponent> MetricComponent::Archetype() const { return ::Udm::ArchetypeAttr< MetricComponent>(impl); }
	::Udm::StringAttr MetricComponent::Name() const { return ::Udm::StringAttr(impl, meta_Name); }
	::Udm::StringAttr MetricComponent::Type() const { return ::Udm::StringAttr(impl, meta_Type); }
	::Udm::StringAttr MetricComponent::CoordinateSystem() const { return ::Udm::StringAttr(impl, meta_CoordinateSystem); }
	::Udm::StringAttr MetricComponent::SpecialInstruction() const { return ::Udm::StringAttr(impl, meta_SpecialInstruction); }
	::Udm::ChildAttr< ::CADMetrics::PrincipleMomentsOfInertia> MetricComponent::PrincipleMomentsOfInertia_child() const { return ::Udm::ChildAttr< ::CADMetrics::PrincipleMomentsOfInertia>(impl, meta_PrincipleMomentsOfInertia_child); }
	::Udm::ChildAttr< ::CADMetrics::Scalars> MetricComponent::Scalars_child() const { return ::Udm::ChildAttr< ::CADMetrics::Scalars>(impl, meta_Scalars_child); }
	::Udm::ChildAttr< ::CADMetrics::CG> MetricComponent::CG_child() const { return ::Udm::ChildAttr< ::CADMetrics::CG>(impl, meta_CG_child); }
	::Udm::ChildAttr< ::CADMetrics::Units> MetricComponent::Units_child() const { return ::Udm::ChildAttr< ::CADMetrics::Units>(impl, meta_Units_child); }
	::Udm::ChildrenAttr< ::CADMetrics::InertiaTensor> MetricComponent::InertiaTensor_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::InertiaTensor>(impl, meta_InertiaTensor_children); }
	::Udm::ChildAttr< ::CADMetrics::Material> MetricComponent::Material_child() const { return ::Udm::ChildAttr< ::CADMetrics::Material>(impl, meta_Material_child); }
	::Udm::ChildAttr< ::CADMetrics::BoundingBox> MetricComponent::BoundingBox_child() const { return ::Udm::ChildAttr< ::CADMetrics::BoundingBox>(impl, meta_BoundingBox_child); }
	::Udm::ChildAttr< ::CADMetrics::Children> MetricComponent::Children_child() const { return ::Udm::ChildAttr< ::CADMetrics::Children>(impl, meta_Children_child); }
	::Udm::ChildrenAttr< ::CADMetrics::Children> MetricComponent::Children_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Children>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::Scalars> MetricComponent::Scalars_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Scalars>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::Units> MetricComponent::Units_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Units>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::Material> MetricComponent::Material_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Material>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::Matrix> MetricComponent::Matrix_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Matrix>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::InertiaTensor> MetricComponent::InertiaTensor_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::InertiaTensor>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::PrincipleMomentsOfInertia> MetricComponent::PrincipleMomentsOfInertia_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::PrincipleMomentsOfInertia>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::CoordinateBase> MetricComponent::CoordinateBase_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::CoordinateBase>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::CG> MetricComponent::CG_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::CG>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::BoundingBox> MetricComponent::BoundingBox_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::BoundingBox>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponents> MetricComponent::MetricComponents_parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponents>(impl, meta_MetricComponents_parent); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponents> MetricComponent::parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponents>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class MetricComponent::meta;
	::Uml::Attribute MetricComponent::meta_Name;
	::Uml::Attribute MetricComponent::meta_Type;
	::Uml::Attribute MetricComponent::meta_CoordinateSystem;
	::Uml::Attribute MetricComponent::meta_SpecialInstruction;
	::Uml::CompositionChildRole MetricComponent::meta_PrincipleMomentsOfInertia_child;
	::Uml::CompositionChildRole MetricComponent::meta_Scalars_child;
	::Uml::CompositionChildRole MetricComponent::meta_CG_child;
	::Uml::CompositionChildRole MetricComponent::meta_Units_child;
	::Uml::CompositionChildRole MetricComponent::meta_InertiaTensor_children;
	::Uml::CompositionChildRole MetricComponent::meta_Material_child;
	::Uml::CompositionChildRole MetricComponent::meta_BoundingBox_child;
	::Uml::CompositionChildRole MetricComponent::meta_Children_child;
	::Uml::CompositionParentRole MetricComponent::meta_MetricComponents_parent;

	Units::Units() {}
	Units::Units(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Units::Units(const Units &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Units::Units(Units &&master) : UDM_OBJECT(master) {};

	Units Units::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Units& Units::operator=(Units &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Units Units::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Units Units::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Units Units::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Units> Units::Instances() { return ::Udm::InstantiatedAttr< Units>(impl); }
	Units Units::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Units> Units::Derived() { return ::Udm::DerivedAttr< Units>(impl); }
	::Udm::ArchetypeAttr< Units> Units::Archetype() const { return ::Udm::ArchetypeAttr< Units>(impl); }
	::Udm::StringAttr Units::Distance() const { return ::Udm::StringAttr(impl, meta_Distance); }
	::Udm::StringAttr Units::Mass() const { return ::Udm::StringAttr(impl, meta_Mass); }
	::Udm::StringAttr Units::Force() const { return ::Udm::StringAttr(impl, meta_Force); }
	::Udm::StringAttr Units::Time() const { return ::Udm::StringAttr(impl, meta_Time); }
	::Udm::StringAttr Units::Temperature() const { return ::Udm::StringAttr(impl, meta_Temperature); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> Units::MetricComponent_parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, meta_MetricComponent_parent); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> Units::parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Units::meta;
	::Uml::Attribute Units::meta_Distance;
	::Uml::Attribute Units::meta_Mass;
	::Uml::Attribute Units::meta_Force;
	::Uml::Attribute Units::meta_Time;
	::Uml::Attribute Units::meta_Temperature;
	::Uml::CompositionParentRole Units::meta_MetricComponent_parent;

	Material::Material() {}
	Material::Material(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Material::Material(const Material &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Material::Material(Material &&master) : UDM_OBJECT(master) {};

	Material Material::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Material& Material::operator=(Material &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Material Material::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Material Material::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Material Material::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Material> Material::Instances() { return ::Udm::InstantiatedAttr< Material>(impl); }
	Material Material::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Material> Material::Derived() { return ::Udm::DerivedAttr< Material>(impl); }
	::Udm::ArchetypeAttr< Material> Material::Archetype() const { return ::Udm::ArchetypeAttr< Material>(impl); }
	::Udm::StringAttr Material::Type() const { return ::Udm::StringAttr(impl, meta_Type); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> Material::MetricComponent_parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, meta_MetricComponent_parent); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> Material::parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Material::meta;
	::Uml::Attribute Material::meta_Type;
	::Uml::CompositionParentRole Material::meta_MetricComponent_parent;

	Scalar::Scalar() {}
	Scalar::Scalar(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Scalar::Scalar(const Scalar &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Scalar::Scalar(Scalar &&master) : UDM_OBJECT(master) {};

	Scalar Scalar::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Scalar& Scalar::operator=(Scalar &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Scalar Scalar::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Scalar Scalar::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Scalar Scalar::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Scalar> Scalar::Instances() { return ::Udm::InstantiatedAttr< Scalar>(impl); }
	Scalar Scalar::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Scalar> Scalar::Derived() { return ::Udm::DerivedAttr< Scalar>(impl); }
	::Udm::ArchetypeAttr< Scalar> Scalar::Archetype() const { return ::Udm::ArchetypeAttr< Scalar>(impl); }
	::Udm::StringAttr Scalar::Name() const { return ::Udm::StringAttr(impl, meta_Name); }
	::Udm::RealAttr Scalar::Value() const { return ::Udm::RealAttr(impl, meta_Value); }
	::Udm::StringAttr Scalar::Unit() const { return ::Udm::StringAttr(impl, meta_Unit); }
	::Udm::ParentAttr< ::CADMetrics::Scalars> Scalar::Scalars_parent() const { return ::Udm::ParentAttr< ::CADMetrics::Scalars>(impl, meta_Scalars_parent); }
	::Udm::ParentAttr< ::CADMetrics::Scalars> Scalar::parent() const { return ::Udm::ParentAttr< ::CADMetrics::Scalars>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Scalar::meta;
	::Uml::Attribute Scalar::meta_Name;
	::Uml::Attribute Scalar::meta_Value;
	::Uml::Attribute Scalar::meta_Unit;
	::Uml::CompositionParentRole Scalar::meta_Scalars_parent;

	OutlinePoints::OutlinePoints() {}
	OutlinePoints::OutlinePoints(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	OutlinePoints::OutlinePoints(const OutlinePoints &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	OutlinePoints::OutlinePoints(OutlinePoints &&master) : UDM_OBJECT(master) {};

	OutlinePoints OutlinePoints::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	OutlinePoints& OutlinePoints::operator=(OutlinePoints &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	OutlinePoints OutlinePoints::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	OutlinePoints OutlinePoints::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	OutlinePoints OutlinePoints::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< OutlinePoints> OutlinePoints::Instances() { return ::Udm::InstantiatedAttr< OutlinePoints>(impl); }
	OutlinePoints OutlinePoints::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< OutlinePoints> OutlinePoints::Derived() { return ::Udm::DerivedAttr< OutlinePoints>(impl); }
	::Udm::ArchetypeAttr< OutlinePoints> OutlinePoints::Archetype() const { return ::Udm::ArchetypeAttr< OutlinePoints>(impl); }
	::Udm::ChildrenAttr< ::CADMetrics::Point> OutlinePoints::Point_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Point>(impl, meta_Point_children); }
	::Udm::ChildrenAttr< ::CADMetrics::CoordinateBase> OutlinePoints::CoordinateBase_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::CoordinateBase>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::Point> OutlinePoints::Point_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Point>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADMetrics::BoundingBox> OutlinePoints::BoundingBox_parent() const { return ::Udm::ParentAttr< ::CADMetrics::BoundingBox>(impl, meta_BoundingBox_parent); }
	::Udm::ParentAttr< ::CADMetrics::BoundingBox> OutlinePoints::parent() const { return ::Udm::ParentAttr< ::CADMetrics::BoundingBox>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class OutlinePoints::meta;
	::Uml::CompositionChildRole OutlinePoints::meta_Point_children;
	::Uml::CompositionParentRole OutlinePoints::meta_BoundingBox_parent;

	Column::Column() {}
	Column::Column(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Column::Column(const Column &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Column::Column(Column &&master) : UDM_OBJECT(master) {};

	Column Column::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Column& Column::operator=(Column &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Column Column::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Column Column::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Column Column::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Column> Column::Instances() { return ::Udm::InstantiatedAttr< Column>(impl); }
	Column Column::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Column> Column::Derived() { return ::Udm::DerivedAttr< Column>(impl); }
	::Udm::ArchetypeAttr< Column> Column::Archetype() const { return ::Udm::ArchetypeAttr< Column>(impl); }
	::Udm::RealAttr Column::Value() const { return ::Udm::RealAttr(impl, meta_Value); }
	::Udm::ParentAttr< ::CADMetrics::Row> Column::Row_parent() const { return ::Udm::ParentAttr< ::CADMetrics::Row>(impl, meta_Row_parent); }
	::Udm::ParentAttr< ::CADMetrics::Row> Column::parent() const { return ::Udm::ParentAttr< ::CADMetrics::Row>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Column::meta;
	::Uml::Attribute Column::meta_Value;
	::Uml::CompositionParentRole Column::meta_Row_parent;

	Row::Row() {}
	Row::Row(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Row::Row(const Row &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Row::Row(Row &&master) : UDM_OBJECT(master) {};

	Row Row::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Row& Row::operator=(Row &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Row Row::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Row Row::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Row Row::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Row> Row::Instances() { return ::Udm::InstantiatedAttr< Row>(impl); }
	Row Row::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Row> Row::Derived() { return ::Udm::DerivedAttr< Row>(impl); }
	::Udm::ArchetypeAttr< Row> Row::Archetype() const { return ::Udm::ArchetypeAttr< Row>(impl); }
	::Udm::ChildrenAttr< ::CADMetrics::Column> Row::Column_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Column>(impl, meta_Column_children); }
	::Udm::ChildrenAttr< ::CADMetrics::Column> Row::Column_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Column>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADMetrics::Rows> Row::Rows_parent() const { return ::Udm::ParentAttr< ::CADMetrics::Rows>(impl, meta_Rows_parent); }
	::Udm::ParentAttr< ::CADMetrics::Rows> Row::parent() const { return ::Udm::ParentAttr< ::CADMetrics::Rows>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Row::meta;
	::Uml::CompositionChildRole Row::meta_Column_children;
	::Uml::CompositionParentRole Row::meta_Rows_parent;

	Rows::Rows() {}
	Rows::Rows(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Rows::Rows(const Rows &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Rows::Rows(Rows &&master) : UDM_OBJECT(master) {};

	Rows Rows::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Rows& Rows::operator=(Rows &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Rows Rows::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Rows Rows::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Rows Rows::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Rows> Rows::Instances() { return ::Udm::InstantiatedAttr< Rows>(impl); }
	Rows Rows::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Rows> Rows::Derived() { return ::Udm::DerivedAttr< Rows>(impl); }
	::Udm::ArchetypeAttr< Rows> Rows::Archetype() const { return ::Udm::ArchetypeAttr< Rows>(impl); }
	::Udm::ChildrenAttr< ::CADMetrics::Row> Rows::Row_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Row>(impl, meta_Row_children); }
	::Udm::ChildrenAttr< ::CADMetrics::Row> Rows::Row_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Row>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADMetrics::Matrix> Rows::Matrix_parent() const { return ::Udm::ParentAttr< ::CADMetrics::Matrix>(impl, meta_Matrix_parent); }
	::Udm::ParentAttr< ::CADMetrics::Matrix> Rows::parent() const { return ::Udm::ParentAttr< ::CADMetrics::Matrix>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Rows::meta;
	::Uml::CompositionChildRole Rows::meta_Row_children;
	::Uml::CompositionParentRole Rows::meta_Matrix_parent;

	Matrix::Matrix() {}
	Matrix::Matrix(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Matrix::Matrix(const Matrix &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Matrix::Matrix(Matrix &&master) : UDM_OBJECT(master) {};

	Matrix Matrix::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Matrix& Matrix::operator=(Matrix &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Matrix Matrix::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Matrix Matrix::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Matrix Matrix::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Matrix> Matrix::Instances() { return ::Udm::InstantiatedAttr< Matrix>(impl); }
	Matrix Matrix::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Matrix> Matrix::Derived() { return ::Udm::DerivedAttr< Matrix>(impl); }
	::Udm::ArchetypeAttr< Matrix> Matrix::Archetype() const { return ::Udm::ArchetypeAttr< Matrix>(impl); }
	::Udm::ChildAttr< ::CADMetrics::Rows> Matrix::Rows_child() const { return ::Udm::ChildAttr< ::CADMetrics::Rows>(impl, meta_Rows_child); }
	::Udm::ChildrenAttr< ::CADMetrics::Rows> Matrix::Rows_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Rows>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::Udm::Object> Matrix::parent() const { return ::Udm::ParentAttr< ::Udm::Object>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Matrix::meta;
	::Uml::CompositionChildRole Matrix::meta_Rows_child;

	InertiaTensor::InertiaTensor() {}
	InertiaTensor::InertiaTensor(::Udm::ObjectImpl *impl) : Matrix(impl) {}
	InertiaTensor::InertiaTensor(const InertiaTensor &master) : Matrix(master) {}

#ifdef UDM_RVALUE
	InertiaTensor::InertiaTensor(InertiaTensor &&master) : Matrix(master) {};

	InertiaTensor InertiaTensor::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	InertiaTensor& InertiaTensor::operator=(InertiaTensor &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	InertiaTensor InertiaTensor::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	InertiaTensor InertiaTensor::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	InertiaTensor InertiaTensor::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< InertiaTensor> InertiaTensor::Instances() { return ::Udm::InstantiatedAttr< InertiaTensor>(impl); }
	InertiaTensor InertiaTensor::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< InertiaTensor> InertiaTensor::Derived() { return ::Udm::DerivedAttr< InertiaTensor>(impl); }
	::Udm::ArchetypeAttr< InertiaTensor> InertiaTensor::Archetype() const { return ::Udm::ArchetypeAttr< InertiaTensor>(impl); }
	::Udm::StringAttr InertiaTensor::At() const { return ::Udm::StringAttr(impl, meta_At); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> InertiaTensor::MetricComponent_parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, meta_MetricComponent_parent); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> InertiaTensor::parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class InertiaTensor::meta;
	::Uml::Attribute InertiaTensor::meta_At;
	::Uml::CompositionParentRole InertiaTensor::meta_MetricComponent_parent;

	PrincipleMomentsOfInertia::PrincipleMomentsOfInertia() {}
	PrincipleMomentsOfInertia::PrincipleMomentsOfInertia(::Udm::ObjectImpl *impl) : Matrix(impl) {}
	PrincipleMomentsOfInertia::PrincipleMomentsOfInertia(const PrincipleMomentsOfInertia &master) : Matrix(master) {}

#ifdef UDM_RVALUE
	PrincipleMomentsOfInertia::PrincipleMomentsOfInertia(PrincipleMomentsOfInertia &&master) : Matrix(master) {};

	PrincipleMomentsOfInertia PrincipleMomentsOfInertia::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	PrincipleMomentsOfInertia& PrincipleMomentsOfInertia::operator=(PrincipleMomentsOfInertia &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	PrincipleMomentsOfInertia PrincipleMomentsOfInertia::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	PrincipleMomentsOfInertia PrincipleMomentsOfInertia::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	PrincipleMomentsOfInertia PrincipleMomentsOfInertia::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< PrincipleMomentsOfInertia> PrincipleMomentsOfInertia::Instances() { return ::Udm::InstantiatedAttr< PrincipleMomentsOfInertia>(impl); }
	PrincipleMomentsOfInertia PrincipleMomentsOfInertia::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< PrincipleMomentsOfInertia> PrincipleMomentsOfInertia::Derived() { return ::Udm::DerivedAttr< PrincipleMomentsOfInertia>(impl); }
	::Udm::ArchetypeAttr< PrincipleMomentsOfInertia> PrincipleMomentsOfInertia::Archetype() const { return ::Udm::ArchetypeAttr< PrincipleMomentsOfInertia>(impl); }
	::Udm::ChildAttr< ::CADMetrics::RotationMatrix> PrincipleMomentsOfInertia::RotationMatrix_child() const { return ::Udm::ChildAttr< ::CADMetrics::RotationMatrix>(impl, meta_RotationMatrix_child); }
	::Udm::ChildrenAttr< ::CADMetrics::Matrix> PrincipleMomentsOfInertia::Matrix_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::Matrix>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADMetrics::RotationMatrix> PrincipleMomentsOfInertia::RotationMatrix_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::RotationMatrix>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> PrincipleMomentsOfInertia::MetricComponent_parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, meta_MetricComponent_parent); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> PrincipleMomentsOfInertia::parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class PrincipleMomentsOfInertia::meta;
	::Uml::CompositionChildRole PrincipleMomentsOfInertia::meta_RotationMatrix_child;
	::Uml::CompositionParentRole PrincipleMomentsOfInertia::meta_MetricComponent_parent;

	RotationMatrix::RotationMatrix() {}
	RotationMatrix::RotationMatrix(::Udm::ObjectImpl *impl) : Matrix(impl) {}
	RotationMatrix::RotationMatrix(const RotationMatrix &master) : Matrix(master) {}

#ifdef UDM_RVALUE
	RotationMatrix::RotationMatrix(RotationMatrix &&master) : Matrix(master) {};

	RotationMatrix RotationMatrix::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	RotationMatrix& RotationMatrix::operator=(RotationMatrix &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	RotationMatrix RotationMatrix::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	RotationMatrix RotationMatrix::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	RotationMatrix RotationMatrix::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< RotationMatrix> RotationMatrix::Instances() { return ::Udm::InstantiatedAttr< RotationMatrix>(impl); }
	RotationMatrix RotationMatrix::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< RotationMatrix> RotationMatrix::Derived() { return ::Udm::DerivedAttr< RotationMatrix>(impl); }
	::Udm::ArchetypeAttr< RotationMatrix> RotationMatrix::Archetype() const { return ::Udm::ArchetypeAttr< RotationMatrix>(impl); }
	::Udm::ParentAttr< ::CADMetrics::ChildMetric> RotationMatrix::ChildMetric_parent() const { return ::Udm::ParentAttr< ::CADMetrics::ChildMetric>(impl, meta_ChildMetric_parent); }
	::Udm::ParentAttr< ::CADMetrics::PrincipleMomentsOfInertia> RotationMatrix::PrincipleMomentsOfInertia_parent() const { return ::Udm::ParentAttr< ::CADMetrics::PrincipleMomentsOfInertia>(impl, meta_PrincipleMomentsOfInertia_parent); }
	::Udm::ParentAttr< ::Udm::Object> RotationMatrix::parent() const { return ::Udm::ParentAttr< ::Udm::Object>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class RotationMatrix::meta;
	::Uml::CompositionParentRole RotationMatrix::meta_ChildMetric_parent;
	::Uml::CompositionParentRole RotationMatrix::meta_PrincipleMomentsOfInertia_parent;

	CoordinateBase::CoordinateBase() {}
	CoordinateBase::CoordinateBase(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	CoordinateBase::CoordinateBase(const CoordinateBase &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	CoordinateBase::CoordinateBase(CoordinateBase &&master) : UDM_OBJECT(master) {};

	CoordinateBase CoordinateBase::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	CoordinateBase& CoordinateBase::operator=(CoordinateBase &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	CoordinateBase CoordinateBase::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	CoordinateBase CoordinateBase::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	CoordinateBase CoordinateBase::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< CoordinateBase> CoordinateBase::Instances() { return ::Udm::InstantiatedAttr< CoordinateBase>(impl); }
	CoordinateBase CoordinateBase::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< CoordinateBase> CoordinateBase::Derived() { return ::Udm::DerivedAttr< CoordinateBase>(impl); }
	::Udm::ArchetypeAttr< CoordinateBase> CoordinateBase::Archetype() const { return ::Udm::ArchetypeAttr< CoordinateBase>(impl); }
	::Udm::RealAttr CoordinateBase::X() const { return ::Udm::RealAttr(impl, meta_X); }
	::Udm::RealAttr CoordinateBase::Y() const { return ::Udm::RealAttr(impl, meta_Y); }
	::Udm::RealAttr CoordinateBase::Z() const { return ::Udm::RealAttr(impl, meta_Z); }
	::Udm::ParentAttr< ::Udm::Object> CoordinateBase::parent() const { return ::Udm::ParentAttr< ::Udm::Object>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class CoordinateBase::meta;
	::Uml::Attribute CoordinateBase::meta_X;
	::Uml::Attribute CoordinateBase::meta_Y;
	::Uml::Attribute CoordinateBase::meta_Z;

	CG::CG() {}
	CG::CG(::Udm::ObjectImpl *impl) : CoordinateBase(impl) {}
	CG::CG(const CG &master) : CoordinateBase(master) {}

#ifdef UDM_RVALUE
	CG::CG(CG &&master) : CoordinateBase(master) {};

	CG CG::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	CG& CG::operator=(CG &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	CG CG::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	CG CG::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	CG CG::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< CG> CG::Instances() { return ::Udm::InstantiatedAttr< CG>(impl); }
	CG CG::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< CG> CG::Derived() { return ::Udm::DerivedAttr< CG>(impl); }
	::Udm::ArchetypeAttr< CG> CG::Archetype() const { return ::Udm::ArchetypeAttr< CG>(impl); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> CG::MetricComponent_parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, meta_MetricComponent_parent); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> CG::parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class CG::meta;
	::Uml::CompositionParentRole CG::meta_MetricComponent_parent;

	Translation::Translation() {}
	Translation::Translation(::Udm::ObjectImpl *impl) : CoordinateBase(impl) {}
	Translation::Translation(const Translation &master) : CoordinateBase(master) {}

#ifdef UDM_RVALUE
	Translation::Translation(Translation &&master) : CoordinateBase(master) {};

	Translation Translation::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Translation& Translation::operator=(Translation &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Translation Translation::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Translation Translation::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Translation Translation::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Translation> Translation::Instances() { return ::Udm::InstantiatedAttr< Translation>(impl); }
	Translation Translation::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Translation> Translation::Derived() { return ::Udm::DerivedAttr< Translation>(impl); }
	::Udm::ArchetypeAttr< Translation> Translation::Archetype() const { return ::Udm::ArchetypeAttr< Translation>(impl); }
	::Udm::ParentAttr< ::CADMetrics::ChildMetric> Translation::ChildMetric_parent() const { return ::Udm::ParentAttr< ::CADMetrics::ChildMetric>(impl, meta_ChildMetric_parent); }
	::Udm::ParentAttr< ::CADMetrics::ChildMetric> Translation::parent() const { return ::Udm::ParentAttr< ::CADMetrics::ChildMetric>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Translation::meta;
	::Uml::CompositionParentRole Translation::meta_ChildMetric_parent;

	Point::Point() {}
	Point::Point(::Udm::ObjectImpl *impl) : CoordinateBase(impl) {}
	Point::Point(const Point &master) : CoordinateBase(master) {}

#ifdef UDM_RVALUE
	Point::Point(Point &&master) : CoordinateBase(master) {};

	Point Point::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Point& Point::operator=(Point &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Point Point::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Point Point::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Point Point::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Point> Point::Instances() { return ::Udm::InstantiatedAttr< Point>(impl); }
	Point Point::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Point> Point::Derived() { return ::Udm::DerivedAttr< Point>(impl); }
	::Udm::ArchetypeAttr< Point> Point::Archetype() const { return ::Udm::ArchetypeAttr< Point>(impl); }
	::Udm::ParentAttr< ::CADMetrics::OutlinePoints> Point::OutlinePoints_parent() const { return ::Udm::ParentAttr< ::CADMetrics::OutlinePoints>(impl, meta_OutlinePoints_parent); }
	::Udm::ParentAttr< ::CADMetrics::OutlinePoints> Point::parent() const { return ::Udm::ParentAttr< ::CADMetrics::OutlinePoints>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class Point::meta;
	::Uml::CompositionParentRole Point::meta_OutlinePoints_parent;

	BoundingBox::BoundingBox() {}
	BoundingBox::BoundingBox(::Udm::ObjectImpl *impl) : CoordinateBase(impl) {}
	BoundingBox::BoundingBox(const BoundingBox &master) : CoordinateBase(master) {}

#ifdef UDM_RVALUE
	BoundingBox::BoundingBox(BoundingBox &&master) : CoordinateBase(master) {};

	BoundingBox BoundingBox::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	BoundingBox& BoundingBox::operator=(BoundingBox &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	BoundingBox BoundingBox::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	BoundingBox BoundingBox::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	BoundingBox BoundingBox::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< BoundingBox> BoundingBox::Instances() { return ::Udm::InstantiatedAttr< BoundingBox>(impl); }
	BoundingBox BoundingBox::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< BoundingBox> BoundingBox::Derived() { return ::Udm::DerivedAttr< BoundingBox>(impl); }
	::Udm::ArchetypeAttr< BoundingBox> BoundingBox::Archetype() const { return ::Udm::ArchetypeAttr< BoundingBox>(impl); }
	::Udm::ChildAttr< ::CADMetrics::OutlinePoints> BoundingBox::OutlinePoints_child() const { return ::Udm::ChildAttr< ::CADMetrics::OutlinePoints>(impl, meta_OutlinePoints_child); }
	::Udm::ChildrenAttr< ::CADMetrics::OutlinePoints> BoundingBox::OutlinePoints_kind_children() const { return ::Udm::ChildrenAttr< ::CADMetrics::OutlinePoints>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> BoundingBox::MetricComponent_parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, meta_MetricComponent_parent); }
	::Udm::ParentAttr< ::CADMetrics::MetricComponent> BoundingBox::parent() const { return ::Udm::ParentAttr< ::CADMetrics::MetricComponent>(impl, ::Udm::NULLPARENTROLE); }

	::Uml::Class BoundingBox::meta;
	::Uml::CompositionChildRole BoundingBox::meta_OutlinePoints_child;
	::Uml::CompositionParentRole BoundingBox::meta_MetricComponent_parent;

	::Uml::Diagram meta;

	void CreateMeta() {
		// classes, with attributes, constraints and constraint definitions
		Anomalies::meta = ::Uml::Class::Create(meta);

		Anomaly::meta = ::Uml::Class::Create(meta);
		Anomaly::meta_MetricID = ::Uml::Attribute::Create(Anomaly::meta);
		Anomaly::meta_Error = ::Uml::Attribute::Create(Anomaly::meta);

		Assemblies::meta = ::Uml::Class::Create(meta);

		Assembly::meta = ::Uml::Class::Create(meta);
		Assembly::meta_ConfigurationID = ::Uml::Attribute::Create(Assembly::meta);

		BoundingBox::meta = ::Uml::Class::Create(meta);

		CADComponent::meta = ::Uml::Class::Create(meta);
		CADComponent::meta_ComponentID = ::Uml::Attribute::Create(CADComponent::meta);
		CADComponent::meta_MetricID = ::Uml::Attribute::Create(CADComponent::meta);

		CADMetricRoot::meta = ::Uml::Class::Create(meta);
		CADMetricRoot::meta_VersionInfo = ::Uml::Attribute::Create(CADMetricRoot::meta);

		CG::meta = ::Uml::Class::Create(meta);

		ChildMetric::meta = ::Uml::Class::Create(meta);

		Children::meta = ::Uml::Class::Create(meta);

		Column::meta = ::Uml::Class::Create(meta);
		Column::meta_Value = ::Uml::Attribute::Create(Column::meta);

		CoordinateBase::meta = ::Uml::Class::Create(meta);
		CoordinateBase::meta_X = ::Uml::Attribute::Create(CoordinateBase::meta);
		CoordinateBase::meta_Y = ::Uml::Attribute::Create(CoordinateBase::meta);
		CoordinateBase::meta_Z = ::Uml::Attribute::Create(CoordinateBase::meta);

		InertiaTensor::meta = ::Uml::Class::Create(meta);
		InertiaTensor::meta_At = ::Uml::Attribute::Create(InertiaTensor::meta);

		Material::meta = ::Uml::Class::Create(meta);
		Material::meta_Type = ::Uml::Attribute::Create(Material::meta);

		Matrix::meta = ::Uml::Class::Create(meta);

		MetricComponent::meta = ::Uml::Class::Create(meta);
		MetricComponent::meta_Name = ::Uml::Attribute::Create(MetricComponent::meta);
		MetricComponent::meta_Type = ::Uml::Attribute::Create(MetricComponent::meta);
		MetricComponent::meta_CoordinateSystem = ::Uml::Attribute::Create(MetricComponent::meta);
		MetricComponent::meta_SpecialInstruction = ::Uml::Attribute::Create(MetricComponent::meta);

		MetricComponents::meta = ::Uml::Class::Create(meta);

		MetricsBase::meta = ::Uml::Class::Create(meta);
		MetricsBase::meta_MetricID = ::Uml::Attribute::Create(MetricsBase::meta);

		OutlinePoints::meta = ::Uml::Class::Create(meta);

		Point::meta = ::Uml::Class::Create(meta);

		PrincipleMomentsOfInertia::meta = ::Uml::Class::Create(meta);

		RotationMatrix::meta = ::Uml::Class::Create(meta);

		Row::meta = ::Uml::Class::Create(meta);

		Rows::meta = ::Uml::Class::Create(meta);

		Scalar::meta = ::Uml::Class::Create(meta);
		Scalar::meta_Name = ::Uml::Attribute::Create(Scalar::meta);
		Scalar::meta_Value = ::Uml::Attribute::Create(Scalar::meta);
		Scalar::meta_Unit = ::Uml::Attribute::Create(Scalar::meta);

		Scalars::meta = ::Uml::Class::Create(meta);

		Translation::meta = ::Uml::Class::Create(meta);

		Units::meta = ::Uml::Class::Create(meta);
		Units::meta_Distance = ::Uml::Attribute::Create(Units::meta);
		Units::meta_Mass = ::Uml::Attribute::Create(Units::meta);
		Units::meta_Force = ::Uml::Attribute::Create(Units::meta);
		Units::meta_Time = ::Uml::Attribute::Create(Units::meta);
		Units::meta_Temperature = ::Uml::Attribute::Create(Units::meta);

	}

	void InitMeta() {
		// classes, with attributes, constraints and constraint definitions
		::Uml::InitClassProps(Anomalies::meta, "Anomalies", false, NULL, NULL);

		::Uml::InitClassProps(Anomaly::meta, "Anomaly", false, NULL, NULL);
		::Uml::InitAttributeProps(Anomaly::meta_MetricID, "MetricID", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Anomaly::meta_Error, "Error", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Assemblies::meta, "Assemblies", false, NULL, NULL);

		::Uml::InitClassProps(Assembly::meta, "Assembly", false, NULL, NULL);
		::Uml::InitAttributeProps(Assembly::meta_ConfigurationID, "ConfigurationID", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(BoundingBox::meta, "BoundingBox", false, NULL, NULL);

		::Uml::InitClassProps(CADComponent::meta, "CADComponent", false, NULL, NULL);
		::Uml::InitAttributeProps(CADComponent::meta_ComponentID, "ComponentID", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(CADComponent::meta_MetricID, "MetricID", "Integer", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(CADMetricRoot::meta, "CADMetricRoot", false, NULL, NULL);
		::Uml::InitAttributeProps(CADMetricRoot::meta_VersionInfo, "VersionInfo", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(CG::meta, "CG", false, NULL, NULL);

		::Uml::InitClassProps(ChildMetric::meta, "ChildMetric", false, NULL, NULL);

		::Uml::InitClassProps(Children::meta, "Children", false, NULL, NULL);

		::Uml::InitClassProps(Column::meta, "Column", false, NULL, NULL);
		::Uml::InitAttributeProps(Column::meta_Value, "Value", "Real", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(CoordinateBase::meta, "CoordinateBase", true, NULL, NULL);
		::Uml::InitAttributeProps(CoordinateBase::meta_X, "X", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(CoordinateBase::meta_Y, "Y", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(CoordinateBase::meta_Z, "Z", "Real", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(InertiaTensor::meta, "InertiaTensor", false, NULL, NULL);
		::Uml::InitAttributeProps(InertiaTensor::meta_At, "At", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Material::meta, "Material", false, NULL, NULL);
		::Uml::InitAttributeProps(Material::meta_Type, "Type", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Matrix::meta, "Matrix", true, NULL, NULL);

		::Uml::InitClassProps(MetricComponent::meta, "MetricComponent", false, NULL, NULL);
		::Uml::InitAttributeProps(MetricComponent::meta_Name, "Name", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(MetricComponent::meta_Type, "Type", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(MetricComponent::meta_CoordinateSystem, "CoordinateSystem", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(MetricComponent::meta_SpecialInstruction, "SpecialInstruction", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(MetricComponents::meta, "MetricComponents", false, NULL, NULL);

		::Uml::InitClassProps(MetricsBase::meta, "MetricsBase", true, NULL, NULL);
		::Uml::InitAttributeProps(MetricsBase::meta_MetricID, "MetricID", "Integer", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(OutlinePoints::meta, "OutlinePoints", false, NULL, NULL);

		::Uml::InitClassProps(Point::meta, "Point", false, NULL, NULL);

		::Uml::InitClassProps(PrincipleMomentsOfInertia::meta, "PrincipleMomentsOfInertia", false, NULL, NULL);

		::Uml::InitClassProps(RotationMatrix::meta, "RotationMatrix", false, NULL, NULL);

		::Uml::InitClassProps(Row::meta, "Row", false, NULL, NULL);

		::Uml::InitClassProps(Rows::meta, "Rows", false, NULL, NULL);

		::Uml::InitClassProps(Scalar::meta, "Scalar", false, NULL, NULL);
		::Uml::InitAttributeProps(Scalar::meta_Name, "Name", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Scalar::meta_Value, "Value", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Scalar::meta_Unit, "Unit", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Scalars::meta, "Scalars", false, NULL, NULL);

		::Uml::InitClassProps(Translation::meta, "Translation", false, NULL, NULL);

		::Uml::InitClassProps(Units::meta, "Units", false, NULL, NULL);
		::Uml::InitAttributeProps(Units::meta_Distance, "Distance", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Units::meta_Mass, "Mass", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Units::meta_Force, "Force", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Units::meta_Time, "Time", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Units::meta_Temperature, "Temperature", "String", false, false, 1, 1, false, "public", vector<string>());

		// compositions
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			ChildMetric::meta_Children_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(ChildMetric::meta_Children_parent, "Children_parent", true);
			Children::meta_ChildMetric_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Children::meta_ChildMetric_children, "ChildMetric", true, 0, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			MetricComponent::meta_MetricComponents_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(MetricComponent::meta_MetricComponents_parent, "MetricComponents_parent", true);
			MetricComponents::meta_MetricComponent_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(MetricComponents::meta_MetricComponent_children, "MetricComponent", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Assemblies::meta_CADMetricRoot_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Assemblies::meta_CADMetricRoot_parent, "CADMetricRoot_parent", true);
			CADMetricRoot::meta_Assemblies_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(CADMetricRoot::meta_Assemblies_child, "Assemblies", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			MetricComponents::meta_CADMetricRoot_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(MetricComponents::meta_CADMetricRoot_parent, "CADMetricRoot_parent", true);
			CADMetricRoot::meta_MetricComponents_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(CADMetricRoot::meta_MetricComponents_child, "MetricComponents", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Anomalies::meta_CADMetricRoot_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Anomalies::meta_CADMetricRoot_parent, "CADMetricRoot_parent", true);
			CADMetricRoot::meta_Anomalies_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(CADMetricRoot::meta_Anomalies_child, "Anomalies", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Assembly::meta_Assemblies_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Assembly::meta_Assemblies_parent, "Assemblies_parent", true);
			Assemblies::meta_Assembly_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Assemblies::meta_Assembly_children, "Assembly", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			CADComponent::meta_CADComponent_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(CADComponent::meta_CADComponent_parent, "CADComponent_parent", true);
			CADComponent::meta_CADComponent_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(CADComponent::meta_CADComponent_children, "CADComponent", true, 0, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			CADComponent::meta_Assembly_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(CADComponent::meta_Assembly_parent, "Assembly_parent", true);
			Assembly::meta_CADComponent_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Assembly::meta_CADComponent_child, "CADComponent", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Anomaly::meta_Anomalies_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Anomaly::meta_Anomalies_parent, "Anomalies_parent", true);
			Anomalies::meta_Anomaly_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Anomalies::meta_Anomaly_children, "Anomaly", true, 0, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Scalar::meta_Scalars_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Scalar::meta_Scalars_parent, "Scalars_parent", true);
			Scalars::meta_Scalar_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Scalars::meta_Scalar_children, "Scalar", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Translation::meta_ChildMetric_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Translation::meta_ChildMetric_parent, "ChildMetric_parent", true);
			ChildMetric::meta_Translation_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(ChildMetric::meta_Translation_child, "Translation", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			RotationMatrix::meta_ChildMetric_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(RotationMatrix::meta_ChildMetric_parent, "ChildMetric_parent", true);
			ChildMetric::meta_RotationMatrix_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(ChildMetric::meta_RotationMatrix_child, "RotationMatrix", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			PrincipleMomentsOfInertia::meta_MetricComponent_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(PrincipleMomentsOfInertia::meta_MetricComponent_parent, "MetricComponent_parent", true);
			MetricComponent::meta_PrincipleMomentsOfInertia_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(MetricComponent::meta_PrincipleMomentsOfInertia_child, "PrincipleMomentsOfInertia", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Scalars::meta_MetricComponent_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Scalars::meta_MetricComponent_parent, "MetricComponent_parent", true);
			MetricComponent::meta_Scalars_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(MetricComponent::meta_Scalars_child, "Scalars", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			CG::meta_MetricComponent_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(CG::meta_MetricComponent_parent, "MetricComponent_parent", true);
			MetricComponent::meta_CG_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(MetricComponent::meta_CG_child, "CG", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Units::meta_MetricComponent_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Units::meta_MetricComponent_parent, "MetricComponent_parent", true);
			MetricComponent::meta_Units_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(MetricComponent::meta_Units_child, "Units", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			InertiaTensor::meta_MetricComponent_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(InertiaTensor::meta_MetricComponent_parent, "MetricComponent_parent", true);
			MetricComponent::meta_InertiaTensor_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(MetricComponent::meta_InertiaTensor_children, "InertiaTensor", true, 0, 2);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Material::meta_MetricComponent_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Material::meta_MetricComponent_parent, "MetricComponent_parent", true);
			MetricComponent::meta_Material_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(MetricComponent::meta_Material_child, "Material", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			BoundingBox::meta_MetricComponent_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(BoundingBox::meta_MetricComponent_parent, "MetricComponent_parent", true);
			MetricComponent::meta_BoundingBox_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(MetricComponent::meta_BoundingBox_child, "BoundingBox", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Children::meta_MetricComponent_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Children::meta_MetricComponent_parent, "MetricComponent_parent", true);
			MetricComponent::meta_Children_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(MetricComponent::meta_Children_child, "Children", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Point::meta_OutlinePoints_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Point::meta_OutlinePoints_parent, "OutlinePoints_parent", true);
			OutlinePoints::meta_Point_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(OutlinePoints::meta_Point_children, "Point", true, 2, 2);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Column::meta_Row_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Column::meta_Row_parent, "Row_parent", true);
			Row::meta_Column_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Row::meta_Column_children, "Column", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Row::meta_Rows_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Row::meta_Rows_parent, "Rows_parent", true);
			Rows::meta_Row_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Rows::meta_Row_children, "Row", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Rows::meta_Matrix_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Rows::meta_Matrix_parent, "Matrix_parent", true);
			Matrix::meta_Rows_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Matrix::meta_Rows_child, "Rows", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			RotationMatrix::meta_PrincipleMomentsOfInertia_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(RotationMatrix::meta_PrincipleMomentsOfInertia_parent, "PrincipleMomentsOfInertia_parent", true);
			PrincipleMomentsOfInertia::meta_RotationMatrix_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(PrincipleMomentsOfInertia::meta_RotationMatrix_child, "RotationMatrix", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			OutlinePoints::meta_BoundingBox_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(OutlinePoints::meta_BoundingBox_parent, "BoundingBox_parent", true);
			BoundingBox::meta_OutlinePoints_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(BoundingBox::meta_OutlinePoints_child, "OutlinePoints", true, 1, 1);

		}

	}

	void InitMetaLinks() {
		Anomaly::meta_Anomalies_parent.target() = Anomalies::meta;
		CADMetricRoot::meta_Anomalies_child.target() = Anomalies::meta;

		Anomalies::meta_Anomaly_children.target() = Anomaly::meta;

		Assembly::meta_Assemblies_parent.target() = Assemblies::meta;
		CADMetricRoot::meta_Assemblies_child.target() = Assemblies::meta;

		CADComponent::meta_Assembly_parent.target() = Assembly::meta;
		Assemblies::meta_Assembly_children.target() = Assembly::meta;

		OutlinePoints::meta_BoundingBox_parent.target() = BoundingBox::meta;
		MetricComponent::meta_BoundingBox_child.target() = BoundingBox::meta;

		CADComponent::meta_CADComponent_parent.target() = CADComponent::meta;
		CADComponent::meta_CADComponent_children.target() = CADComponent::meta;
		Assembly::meta_CADComponent_child.target() = CADComponent::meta;

		Assemblies::meta_CADMetricRoot_parent.target() = CADMetricRoot::meta;
		MetricComponents::meta_CADMetricRoot_parent.target() = CADMetricRoot::meta;
		Anomalies::meta_CADMetricRoot_parent.target() = CADMetricRoot::meta;

		MetricComponent::meta_CG_child.target() = CG::meta;

		Translation::meta_ChildMetric_parent.target() = ChildMetric::meta;
		RotationMatrix::meta_ChildMetric_parent.target() = ChildMetric::meta;
		Children::meta_ChildMetric_children.target() = ChildMetric::meta;

		ChildMetric::meta_Children_parent.target() = Children::meta;
		MetricComponent::meta_Children_child.target() = Children::meta;

		Row::meta_Column_children.target() = Column::meta;

		CoordinateBase::meta.subTypes() += CG::meta;
		CoordinateBase::meta.subTypes() += Translation::meta;
		CoordinateBase::meta.subTypes() += Point::meta;
		CoordinateBase::meta.subTypes() += BoundingBox::meta;

		MetricComponent::meta_InertiaTensor_children.target() = InertiaTensor::meta;

		MetricComponent::meta_Material_child.target() = Material::meta;

		Rows::meta_Matrix_parent.target() = Matrix::meta;
		Matrix::meta.subTypes() += InertiaTensor::meta;
		Matrix::meta.subTypes() += PrincipleMomentsOfInertia::meta;
		Matrix::meta.subTypes() += RotationMatrix::meta;

		PrincipleMomentsOfInertia::meta_MetricComponent_parent.target() = MetricComponent::meta;
		Scalars::meta_MetricComponent_parent.target() = MetricComponent::meta;
		CG::meta_MetricComponent_parent.target() = MetricComponent::meta;
		Units::meta_MetricComponent_parent.target() = MetricComponent::meta;
		InertiaTensor::meta_MetricComponent_parent.target() = MetricComponent::meta;
		Material::meta_MetricComponent_parent.target() = MetricComponent::meta;
		BoundingBox::meta_MetricComponent_parent.target() = MetricComponent::meta;
		Children::meta_MetricComponent_parent.target() = MetricComponent::meta;
		MetricComponents::meta_MetricComponent_children.target() = MetricComponent::meta;

		MetricComponent::meta_MetricComponents_parent.target() = MetricComponents::meta;
		CADMetricRoot::meta_MetricComponents_child.target() = MetricComponents::meta;

		MetricsBase::meta.subTypes() += ChildMetric::meta;
		MetricsBase::meta.subTypes() += MetricComponent::meta;

		Point::meta_OutlinePoints_parent.target() = OutlinePoints::meta;
		BoundingBox::meta_OutlinePoints_child.target() = OutlinePoints::meta;

		OutlinePoints::meta_Point_children.target() = Point::meta;

		RotationMatrix::meta_PrincipleMomentsOfInertia_parent.target() = PrincipleMomentsOfInertia::meta;
		MetricComponent::meta_PrincipleMomentsOfInertia_child.target() = PrincipleMomentsOfInertia::meta;

		ChildMetric::meta_RotationMatrix_child.target() = RotationMatrix::meta;
		PrincipleMomentsOfInertia::meta_RotationMatrix_child.target() = RotationMatrix::meta;

		Column::meta_Row_parent.target() = Row::meta;
		Rows::meta_Row_children.target() = Row::meta;

		Row::meta_Rows_parent.target() = Rows::meta;
		Matrix::meta_Rows_child.target() = Rows::meta;

		Scalars::meta_Scalar_children.target() = Scalar::meta;

		Scalar::meta_Scalars_parent.target() = Scalars::meta;
		MetricComponent::meta_Scalars_child.target() = Scalars::meta;

		ChildMetric::meta_Translation_child.target() = Translation::meta;

		MetricComponent::meta_Units_child.target() = Units::meta;

	}

	void InitMeta(const ::Uml::Diagram &parent) {
		// classes, with attributes, constraints and constraint definitions
		::Uml::SetClass(Anomalies::meta, parent, "Anomalies");

		::Uml::SetClass(Anomaly::meta, parent, "Anomaly");
		::Uml::SetAttribute(Anomaly::meta_MetricID, Anomaly::meta, "MetricID");
		::Uml::SetAttribute(Anomaly::meta_Error, Anomaly::meta, "Error");

		::Uml::SetClass(Assemblies::meta, parent, "Assemblies");

		::Uml::SetClass(Assembly::meta, parent, "Assembly");
		::Uml::SetAttribute(Assembly::meta_ConfigurationID, Assembly::meta, "ConfigurationID");

		::Uml::SetClass(BoundingBox::meta, parent, "BoundingBox");

		::Uml::SetClass(CADComponent::meta, parent, "CADComponent");
		::Uml::SetAttribute(CADComponent::meta_ComponentID, CADComponent::meta, "ComponentID");
		::Uml::SetAttribute(CADComponent::meta_MetricID, CADComponent::meta, "MetricID");

		::Uml::SetClass(CADMetricRoot::meta, parent, "CADMetricRoot");
		::Uml::SetAttribute(CADMetricRoot::meta_VersionInfo, CADMetricRoot::meta, "VersionInfo");

		::Uml::SetClass(CG::meta, parent, "CG");

		::Uml::SetClass(ChildMetric::meta, parent, "ChildMetric");

		::Uml::SetClass(Children::meta, parent, "Children");

		::Uml::SetClass(Column::meta, parent, "Column");
		::Uml::SetAttribute(Column::meta_Value, Column::meta, "Value");

		::Uml::SetClass(CoordinateBase::meta, parent, "CoordinateBase");
		::Uml::SetAttribute(CoordinateBase::meta_X, CoordinateBase::meta, "X");
		::Uml::SetAttribute(CoordinateBase::meta_Y, CoordinateBase::meta, "Y");
		::Uml::SetAttribute(CoordinateBase::meta_Z, CoordinateBase::meta, "Z");

		::Uml::SetClass(InertiaTensor::meta, parent, "InertiaTensor");
		::Uml::SetAttribute(InertiaTensor::meta_At, InertiaTensor::meta, "At");

		::Uml::SetClass(Material::meta, parent, "Material");
		::Uml::SetAttribute(Material::meta_Type, Material::meta, "Type");

		::Uml::SetClass(Matrix::meta, parent, "Matrix");

		::Uml::SetClass(MetricComponent::meta, parent, "MetricComponent");
		::Uml::SetAttribute(MetricComponent::meta_Name, MetricComponent::meta, "Name");
		::Uml::SetAttribute(MetricComponent::meta_Type, MetricComponent::meta, "Type");
		::Uml::SetAttribute(MetricComponent::meta_CoordinateSystem, MetricComponent::meta, "CoordinateSystem");
		::Uml::SetAttribute(MetricComponent::meta_SpecialInstruction, MetricComponent::meta, "SpecialInstruction");

		::Uml::SetClass(MetricComponents::meta, parent, "MetricComponents");

		::Uml::SetClass(MetricsBase::meta, parent, "MetricsBase");
		::Uml::SetAttribute(MetricsBase::meta_MetricID, MetricsBase::meta, "MetricID");

		::Uml::SetClass(OutlinePoints::meta, parent, "OutlinePoints");

		::Uml::SetClass(Point::meta, parent, "Point");

		::Uml::SetClass(PrincipleMomentsOfInertia::meta, parent, "PrincipleMomentsOfInertia");

		::Uml::SetClass(RotationMatrix::meta, parent, "RotationMatrix");

		::Uml::SetClass(Row::meta, parent, "Row");

		::Uml::SetClass(Rows::meta, parent, "Rows");

		::Uml::SetClass(Scalar::meta, parent, "Scalar");
		::Uml::SetAttribute(Scalar::meta_Name, Scalar::meta, "Name");
		::Uml::SetAttribute(Scalar::meta_Value, Scalar::meta, "Value");
		::Uml::SetAttribute(Scalar::meta_Unit, Scalar::meta, "Unit");

		::Uml::SetClass(Scalars::meta, parent, "Scalars");

		::Uml::SetClass(Translation::meta, parent, "Translation");

		::Uml::SetClass(Units::meta, parent, "Units");
		::Uml::SetAttribute(Units::meta_Distance, Units::meta, "Distance");
		::Uml::SetAttribute(Units::meta_Mass, Units::meta, "Mass");
		::Uml::SetAttribute(Units::meta_Force, Units::meta, "Force");
		::Uml::SetAttribute(Units::meta_Time, Units::meta, "Time");
		::Uml::SetAttribute(Units::meta_Temperature, Units::meta, "Temperature");

	}

	void InitMetaLinks(const ::Uml::Diagram &parent) {
		// classes
		::Uml::SetChildRole(Anomalies::meta_Anomaly_children, Anomalies::meta, Anomaly::meta, "", "");
		::Uml::SetParentRole(Anomalies::meta_CADMetricRoot_parent, Anomalies::meta, CADMetricRoot::meta, "", "");

		::Uml::SetParentRole(Anomaly::meta_Anomalies_parent, Anomaly::meta, Anomalies::meta, "", "");

		::Uml::SetChildRole(Assemblies::meta_Assembly_children, Assemblies::meta, Assembly::meta, "", "");
		::Uml::SetParentRole(Assemblies::meta_CADMetricRoot_parent, Assemblies::meta, CADMetricRoot::meta, "", "");

		::Uml::SetChildRole(Assembly::meta_CADComponent_child, Assembly::meta, CADComponent::meta, "", "");
		::Uml::SetParentRole(Assembly::meta_Assemblies_parent, Assembly::meta, Assemblies::meta, "", "");

		::Uml::SetChildRole(BoundingBox::meta_OutlinePoints_child, BoundingBox::meta, OutlinePoints::meta, "", "");
		::Uml::SetParentRole(BoundingBox::meta_MetricComponent_parent, BoundingBox::meta, MetricComponent::meta, "", "");

		::Uml::SetChildRole(CADComponent::meta_CADComponent_children, CADComponent::meta, CADComponent::meta, "", "");
		::Uml::SetParentRole(CADComponent::meta_CADComponent_parent, CADComponent::meta, CADComponent::meta, "", "");
		::Uml::SetParentRole(CADComponent::meta_Assembly_parent, CADComponent::meta, Assembly::meta, "", "");

		::Uml::SetChildRole(CADMetricRoot::meta_Assemblies_child, CADMetricRoot::meta, Assemblies::meta, "", "");
		::Uml::SetChildRole(CADMetricRoot::meta_MetricComponents_child, CADMetricRoot::meta, MetricComponents::meta, "", "");
		::Uml::SetChildRole(CADMetricRoot::meta_Anomalies_child, CADMetricRoot::meta, Anomalies::meta, "", "");

		::Uml::SetParentRole(CG::meta_MetricComponent_parent, CG::meta, MetricComponent::meta, "", "");

		::Uml::SetChildRole(ChildMetric::meta_Translation_child, ChildMetric::meta, Translation::meta, "", "");
		::Uml::SetChildRole(ChildMetric::meta_RotationMatrix_child, ChildMetric::meta, RotationMatrix::meta, "", "");
		::Uml::SetParentRole(ChildMetric::meta_Children_parent, ChildMetric::meta, Children::meta, "", "");

		::Uml::SetChildRole(Children::meta_ChildMetric_children, Children::meta, ChildMetric::meta, "", "");
		::Uml::SetParentRole(Children::meta_MetricComponent_parent, Children::meta, MetricComponent::meta, "", "");

		::Uml::SetParentRole(Column::meta_Row_parent, Column::meta, Row::meta, "", "");

		::Uml::SetParentRole(InertiaTensor::meta_MetricComponent_parent, InertiaTensor::meta, MetricComponent::meta, "", "");

		::Uml::SetParentRole(Material::meta_MetricComponent_parent, Material::meta, MetricComponent::meta, "", "");

		::Uml::SetChildRole(Matrix::meta_Rows_child, Matrix::meta, Rows::meta, "", "");

		::Uml::SetChildRole(MetricComponent::meta_PrincipleMomentsOfInertia_child, MetricComponent::meta, PrincipleMomentsOfInertia::meta, "", "");
		::Uml::SetChildRole(MetricComponent::meta_Scalars_child, MetricComponent::meta, Scalars::meta, "", "");
		::Uml::SetChildRole(MetricComponent::meta_CG_child, MetricComponent::meta, CG::meta, "", "");
		::Uml::SetChildRole(MetricComponent::meta_Units_child, MetricComponent::meta, Units::meta, "", "");
		::Uml::SetChildRole(MetricComponent::meta_InertiaTensor_children, MetricComponent::meta, InertiaTensor::meta, "", "");
		::Uml::SetChildRole(MetricComponent::meta_Material_child, MetricComponent::meta, Material::meta, "", "");
		::Uml::SetChildRole(MetricComponent::meta_BoundingBox_child, MetricComponent::meta, BoundingBox::meta, "", "");
		::Uml::SetChildRole(MetricComponent::meta_Children_child, MetricComponent::meta, Children::meta, "", "");
		::Uml::SetParentRole(MetricComponent::meta_MetricComponents_parent, MetricComponent::meta, MetricComponents::meta, "", "");

		::Uml::SetChildRole(MetricComponents::meta_MetricComponent_children, MetricComponents::meta, MetricComponent::meta, "", "");
		::Uml::SetParentRole(MetricComponents::meta_CADMetricRoot_parent, MetricComponents::meta, CADMetricRoot::meta, "", "");

		::Uml::SetChildRole(OutlinePoints::meta_Point_children, OutlinePoints::meta, Point::meta, "", "");
		::Uml::SetParentRole(OutlinePoints::meta_BoundingBox_parent, OutlinePoints::meta, BoundingBox::meta, "", "");

		::Uml::SetParentRole(Point::meta_OutlinePoints_parent, Point::meta, OutlinePoints::meta, "", "");

		::Uml::SetChildRole(PrincipleMomentsOfInertia::meta_RotationMatrix_child, PrincipleMomentsOfInertia::meta, RotationMatrix::meta, "", "");
		::Uml::SetParentRole(PrincipleMomentsOfInertia::meta_MetricComponent_parent, PrincipleMomentsOfInertia::meta, MetricComponent::meta, "", "");

		::Uml::SetParentRole(RotationMatrix::meta_ChildMetric_parent, RotationMatrix::meta, ChildMetric::meta, "", "");
		::Uml::SetParentRole(RotationMatrix::meta_PrincipleMomentsOfInertia_parent, RotationMatrix::meta, PrincipleMomentsOfInertia::meta, "", "");

		::Uml::SetChildRole(Row::meta_Column_children, Row::meta, Column::meta, "", "");
		::Uml::SetParentRole(Row::meta_Rows_parent, Row::meta, Rows::meta, "", "");

		::Uml::SetChildRole(Rows::meta_Row_children, Rows::meta, Row::meta, "", "");
		::Uml::SetParentRole(Rows::meta_Matrix_parent, Rows::meta, Matrix::meta, "", "");

		::Uml::SetParentRole(Scalar::meta_Scalars_parent, Scalar::meta, Scalars::meta, "", "");

		::Uml::SetChildRole(Scalars::meta_Scalar_children, Scalars::meta, Scalar::meta, "", "");
		::Uml::SetParentRole(Scalars::meta_MetricComponent_parent, Scalars::meta, MetricComponent::meta, "", "");

		::Uml::SetParentRole(Translation::meta_ChildMetric_parent, Translation::meta, ChildMetric::meta, "", "");

		::Uml::SetParentRole(Units::meta_MetricComponent_parent, Units::meta, MetricComponent::meta, "", "");

	}

	void _SetXsdStorage()
	{
		UdmDom::str_xsd_storage::StoreXsd("CADMetrics.xsd", CADMetrics_xsd::getString());
	}

	void Initialize()
	{
		static bool first = true;
		if (!first) return;
		first = false;
		::Uml::Initialize();

	
		UDM_ASSERT( meta == ::Udm::null );

		::UdmStatic::StaticDataNetwork * meta_dn = new ::UdmStatic::StaticDataNetwork(::Uml::diagram);
		meta_dn->CreateNew("CADMetrics.mem", "", ::Uml::Diagram::meta, ::Udm::CHANGES_LOST_DEFAULT);
		meta = ::Uml::Diagram::Cast(meta_dn->GetRootObject());

		::Uml::InitDiagramProps(meta, "CADMetrics", "1.00");


		CreateMeta();
		InitMeta();
		InitMetaLinks();

		_SetXsdStorage();

	}

	void Initialize(const ::Uml::Diagram &dgr)
	{
		
		if (meta == dgr) return;
		meta = dgr;

		InitMeta(dgr);
		InitMetaLinks(dgr);

		
		_SetXsdStorage();
	}


	 ::Udm::UdmDiagram diagram = { &meta, Initialize };
	static struct _regClass
	{
		_regClass()
		{
			::Udm::MetaDepository::StoreDiagram("CADMetrics", diagram);
		}
		~_regClass()
		{
			::Udm::MetaDepository::RemoveDiagram("CADMetrics");
		}
	} __regUnUsed;

}

