/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef MOBIES_CADMETRICS_H
#define MOBIES_CADMETRICS_H

// header file CADMetrics.h generated from diagram CADMetrics
// generated with Udm version 3.31 on Tue Dec 18 15:14:59 2012

#include <UdmBase.h>

#if !defined(UDM_VERSION_MAJOR) || !defined(UDM_VERSION_MINOR)
#    error "Udm headers too old, they do not define UDM_VERSION"
#elif UDM_VERSION_MAJOR < 3
#    error "Udm headers too old, minimum version required 3.31"
#elif UDM_VERSION_MAJOR == 3 && UDM_VERSION_MINOR < 31
#    error "Udm headers too old, minimum version required 3.31"
#endif

#include <Uml.h>


#ifdef min
#undef min
#endif

#ifdef max
#undef max
#endif

namespace CADMetrics {

	extern ::Uml::Diagram meta;
	class Anomaly;
	class Children;
	class MetricComponents;
	class CADMetricRoot;
	class Assemblies;
	class CADComponent;
	class Assembly;
	class Anomalies;
	class MetricsBase;
	class Scalars;
	class ChildMetric;
	class MetricComponent;
	class Units;
	class Material;
	class Scalar;
	class OutlinePoints;
	class Column;
	class Row;
	class Rows;
	class Matrix;
	class InertiaTensor;
	class PrincipleMomentsOfInertia;
	class RotationMatrix;
	class CoordinateBase;
	class CG;
	class Translation;
	class Point;
	class BoundingBox;

	void Initialize();
	void Initialize(const ::Uml::Diagram &dgr);

	extern  ::Udm::UdmDiagram diagram;

	class Anomaly : public ::Udm::Object {
	public:
		Anomaly();
		Anomaly(::Udm::ObjectImpl *impl);
		Anomaly(const Anomaly &master);

#ifdef UDM_RVALUE
		Anomaly(Anomaly &&master);

		static Anomaly Cast(::Udm::Object &&a);
		Anomaly& operator=(Anomaly &&a);

#endif
		static Anomaly Cast(const ::Udm::Object &a);
		static Anomaly Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Anomaly CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Anomaly> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Anomaly, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Anomaly, Pred>(impl); };
		Anomaly CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Anomaly> Derived();
		template <class Pred> ::Udm::DerivedAttr< Anomaly, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Anomaly, Pred>(impl); };
		::Udm::ArchetypeAttr< Anomaly> Archetype() const;
		::Udm::StringAttr MetricID() const;
		::Udm::StringAttr Error() const;
		::Udm::ParentAttr< ::CADMetrics::Anomalies> Anomalies_parent() const;
		::Udm::ParentAttr< ::CADMetrics::Anomalies> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_MetricID;
		static ::Uml::Attribute meta_Error;
		static ::Uml::CompositionParentRole meta_Anomalies_parent;

	};

	class Children : public ::Udm::Object {
	public:
		Children();
		Children(::Udm::ObjectImpl *impl);
		Children(const Children &master);

#ifdef UDM_RVALUE
		Children(Children &&master);

		static Children Cast(::Udm::Object &&a);
		Children& operator=(Children &&a);

#endif
		static Children Cast(const ::Udm::Object &a);
		static Children Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Children CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Children> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Children, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Children, Pred>(impl); };
		Children CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Children> Derived();
		template <class Pred> ::Udm::DerivedAttr< Children, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Children, Pred>(impl); };
		::Udm::ArchetypeAttr< Children> Archetype() const;
		::Udm::ChildrenAttr< ::CADMetrics::ChildMetric> ChildMetric_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::ChildMetric, Pred> ChildMetric_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::ChildMetric, Pred>(impl, meta_ChildMetric_children); };
		::Udm::ChildrenAttr< ::CADMetrics::MetricsBase> MetricsBase_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::MetricsBase, Pred> MetricsBase_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::MetricsBase, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::ChildMetric> ChildMetric_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::ChildMetric, Pred> ChildMetric_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::ChildMetric, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> MetricComponent_parent() const;
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_ChildMetric_children;
		static ::Uml::CompositionParentRole meta_MetricComponent_parent;

	};

	class MetricComponents : public ::Udm::Object {
	public:
		MetricComponents();
		MetricComponents(::Udm::ObjectImpl *impl);
		MetricComponents(const MetricComponents &master);

#ifdef UDM_RVALUE
		MetricComponents(MetricComponents &&master);

		static MetricComponents Cast(::Udm::Object &&a);
		MetricComponents& operator=(MetricComponents &&a);

#endif
		static MetricComponents Cast(const ::Udm::Object &a);
		static MetricComponents Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		MetricComponents CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< MetricComponents> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< MetricComponents, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< MetricComponents, Pred>(impl); };
		MetricComponents CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< MetricComponents> Derived();
		template <class Pred> ::Udm::DerivedAttr< MetricComponents, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< MetricComponents, Pred>(impl); };
		::Udm::ArchetypeAttr< MetricComponents> Archetype() const;
		::Udm::ChildrenAttr< ::CADMetrics::MetricComponent> MetricComponent_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::MetricComponent, Pred> MetricComponent_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::MetricComponent, Pred>(impl, meta_MetricComponent_children); };
		::Udm::ChildrenAttr< ::CADMetrics::MetricsBase> MetricsBase_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::MetricsBase, Pred> MetricsBase_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::MetricsBase, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::MetricComponent> MetricComponent_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::MetricComponent, Pred> MetricComponent_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::MetricComponent, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADMetrics::CADMetricRoot> CADMetricRoot_parent() const;
		::Udm::ParentAttr< ::CADMetrics::CADMetricRoot> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_MetricComponent_children;
		static ::Uml::CompositionParentRole meta_CADMetricRoot_parent;

	};

	class CADMetricRoot : public ::Udm::Object {
	public:
		CADMetricRoot();
		CADMetricRoot(::Udm::ObjectImpl *impl);
		CADMetricRoot(const CADMetricRoot &master);

#ifdef UDM_RVALUE
		CADMetricRoot(CADMetricRoot &&master);

		static CADMetricRoot Cast(::Udm::Object &&a);
		CADMetricRoot& operator=(CADMetricRoot &&a);

#endif
		static CADMetricRoot Cast(const ::Udm::Object &a);
		static CADMetricRoot Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		CADMetricRoot CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< CADMetricRoot> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< CADMetricRoot, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< CADMetricRoot, Pred>(impl); };
		CADMetricRoot CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< CADMetricRoot> Derived();
		template <class Pred> ::Udm::DerivedAttr< CADMetricRoot, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< CADMetricRoot, Pred>(impl); };
		::Udm::ArchetypeAttr< CADMetricRoot> Archetype() const;
		::Udm::StringAttr VersionInfo() const;
		::Udm::ChildAttr< ::CADMetrics::Assemblies> Assemblies_child() const;
		::Udm::ChildAttr< ::CADMetrics::MetricComponents> MetricComponents_child() const;
		::Udm::ChildAttr< ::CADMetrics::Anomalies> Anomalies_child() const;
		::Udm::ChildrenAttr< ::CADMetrics::MetricComponents> MetricComponents_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::MetricComponents, Pred> MetricComponents_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::MetricComponents, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::Assemblies> Assemblies_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Assemblies, Pred> Assemblies_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Assemblies, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::Anomalies> Anomalies_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Anomalies, Pred> Anomalies_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Anomalies, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::Udm::Object> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_VersionInfo;
		static ::Uml::CompositionChildRole meta_Assemblies_child;
		static ::Uml::CompositionChildRole meta_MetricComponents_child;
		static ::Uml::CompositionChildRole meta_Anomalies_child;

	};

	class Assemblies : public ::Udm::Object {
	public:
		Assemblies();
		Assemblies(::Udm::ObjectImpl *impl);
		Assemblies(const Assemblies &master);

#ifdef UDM_RVALUE
		Assemblies(Assemblies &&master);

		static Assemblies Cast(::Udm::Object &&a);
		Assemblies& operator=(Assemblies &&a);

#endif
		static Assemblies Cast(const ::Udm::Object &a);
		static Assemblies Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Assemblies CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Assemblies> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Assemblies, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Assemblies, Pred>(impl); };
		Assemblies CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Assemblies> Derived();
		template <class Pred> ::Udm::DerivedAttr< Assemblies, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Assemblies, Pred>(impl); };
		::Udm::ArchetypeAttr< Assemblies> Archetype() const;
		::Udm::ChildrenAttr< ::CADMetrics::Assembly> Assembly_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Assembly, Pred> Assembly_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Assembly, Pred>(impl, meta_Assembly_children); };
		::Udm::ChildrenAttr< ::CADMetrics::Assembly> Assembly_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Assembly, Pred> Assembly_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Assembly, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADMetrics::CADMetricRoot> CADMetricRoot_parent() const;
		::Udm::ParentAttr< ::CADMetrics::CADMetricRoot> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Assembly_children;
		static ::Uml::CompositionParentRole meta_CADMetricRoot_parent;

	};

	class CADComponent : public ::Udm::Object {
	public:
		CADComponent();
		CADComponent(::Udm::ObjectImpl *impl);
		CADComponent(const CADComponent &master);

#ifdef UDM_RVALUE
		CADComponent(CADComponent &&master);

		static CADComponent Cast(::Udm::Object &&a);
		CADComponent& operator=(CADComponent &&a);

#endif
		static CADComponent Cast(const ::Udm::Object &a);
		static CADComponent Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		CADComponent CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< CADComponent> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< CADComponent, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< CADComponent, Pred>(impl); };
		CADComponent CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< CADComponent> Derived();
		template <class Pred> ::Udm::DerivedAttr< CADComponent, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< CADComponent, Pred>(impl); };
		::Udm::ArchetypeAttr< CADComponent> Archetype() const;
		::Udm::StringAttr ComponentID() const;
		::Udm::IntegerAttr MetricID() const;
		::Udm::ChildrenAttr< ::CADMetrics::CADComponent> CADComponent_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::CADComponent, Pred> CADComponent_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::CADComponent, Pred>(impl, meta_CADComponent_children); };
		::Udm::ChildrenAttr< ::CADMetrics::CADComponent> CADComponent_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::CADComponent, Pred> CADComponent_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::CADComponent, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADMetrics::CADComponent> CADComponent_parent() const;
		::Udm::ParentAttr< ::CADMetrics::Assembly> Assembly_parent() const;
		::Udm::ParentAttr< ::Udm::Object> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_ComponentID;
		static ::Uml::Attribute meta_MetricID;
		static ::Uml::CompositionChildRole meta_CADComponent_children;
		static ::Uml::CompositionParentRole meta_CADComponent_parent;
		static ::Uml::CompositionParentRole meta_Assembly_parent;

	};

	class Assembly : public ::Udm::Object {
	public:
		Assembly();
		Assembly(::Udm::ObjectImpl *impl);
		Assembly(const Assembly &master);

#ifdef UDM_RVALUE
		Assembly(Assembly &&master);

		static Assembly Cast(::Udm::Object &&a);
		Assembly& operator=(Assembly &&a);

#endif
		static Assembly Cast(const ::Udm::Object &a);
		static Assembly Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Assembly CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Assembly> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Assembly, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Assembly, Pred>(impl); };
		Assembly CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Assembly> Derived();
		template <class Pred> ::Udm::DerivedAttr< Assembly, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Assembly, Pred>(impl); };
		::Udm::ArchetypeAttr< Assembly> Archetype() const;
		::Udm::StringAttr ConfigurationID() const;
		::Udm::ChildAttr< ::CADMetrics::CADComponent> CADComponent_child() const;
		::Udm::ChildrenAttr< ::CADMetrics::CADComponent> CADComponent_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::CADComponent, Pred> CADComponent_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::CADComponent, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADMetrics::Assemblies> Assemblies_parent() const;
		::Udm::ParentAttr< ::CADMetrics::Assemblies> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_ConfigurationID;
		static ::Uml::CompositionChildRole meta_CADComponent_child;
		static ::Uml::CompositionParentRole meta_Assemblies_parent;

	};

	class Anomalies : public ::Udm::Object {
	public:
		Anomalies();
		Anomalies(::Udm::ObjectImpl *impl);
		Anomalies(const Anomalies &master);

#ifdef UDM_RVALUE
		Anomalies(Anomalies &&master);

		static Anomalies Cast(::Udm::Object &&a);
		Anomalies& operator=(Anomalies &&a);

#endif
		static Anomalies Cast(const ::Udm::Object &a);
		static Anomalies Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Anomalies CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Anomalies> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Anomalies, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Anomalies, Pred>(impl); };
		Anomalies CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Anomalies> Derived();
		template <class Pred> ::Udm::DerivedAttr< Anomalies, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Anomalies, Pred>(impl); };
		::Udm::ArchetypeAttr< Anomalies> Archetype() const;
		::Udm::ChildrenAttr< ::CADMetrics::Anomaly> Anomaly_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Anomaly, Pred> Anomaly_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Anomaly, Pred>(impl, meta_Anomaly_children); };
		::Udm::ChildrenAttr< ::CADMetrics::Anomaly> Anomaly_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Anomaly, Pred> Anomaly_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Anomaly, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADMetrics::CADMetricRoot> CADMetricRoot_parent() const;
		::Udm::ParentAttr< ::CADMetrics::CADMetricRoot> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Anomaly_children;
		static ::Uml::CompositionParentRole meta_CADMetricRoot_parent;

	};

	class MetricsBase : public ::Udm::Object {
	public:
		MetricsBase();
		MetricsBase(::Udm::ObjectImpl *impl);
		MetricsBase(const MetricsBase &master);

#ifdef UDM_RVALUE
		MetricsBase(MetricsBase &&master);

		static MetricsBase Cast(::Udm::Object &&a);
		MetricsBase& operator=(MetricsBase &&a);

#endif
		static MetricsBase Cast(const ::Udm::Object &a);
		static MetricsBase Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		MetricsBase CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< MetricsBase> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< MetricsBase, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< MetricsBase, Pred>(impl); };
		MetricsBase CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< MetricsBase> Derived();
		template <class Pred> ::Udm::DerivedAttr< MetricsBase, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< MetricsBase, Pred>(impl); };
		::Udm::ArchetypeAttr< MetricsBase> Archetype() const;
		::Udm::IntegerAttr MetricID() const;
		::Udm::ParentAttr< ::Udm::Object> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_MetricID;

	};

	class Scalars : public ::Udm::Object {
	public:
		Scalars();
		Scalars(::Udm::ObjectImpl *impl);
		Scalars(const Scalars &master);

#ifdef UDM_RVALUE
		Scalars(Scalars &&master);

		static Scalars Cast(::Udm::Object &&a);
		Scalars& operator=(Scalars &&a);

#endif
		static Scalars Cast(const ::Udm::Object &a);
		static Scalars Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Scalars CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Scalars> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Scalars, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Scalars, Pred>(impl); };
		Scalars CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Scalars> Derived();
		template <class Pred> ::Udm::DerivedAttr< Scalars, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Scalars, Pred>(impl); };
		::Udm::ArchetypeAttr< Scalars> Archetype() const;
		::Udm::ChildrenAttr< ::CADMetrics::Scalar> Scalar_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Scalar, Pred> Scalar_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Scalar, Pred>(impl, meta_Scalar_children); };
		::Udm::ChildrenAttr< ::CADMetrics::Scalar> Scalar_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Scalar, Pred> Scalar_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Scalar, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> MetricComponent_parent() const;
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Scalar_children;
		static ::Uml::CompositionParentRole meta_MetricComponent_parent;

	};

	class ChildMetric :  public MetricsBase {
	public:
		ChildMetric();
		ChildMetric(::Udm::ObjectImpl *impl);
		ChildMetric(const ChildMetric &master);

#ifdef UDM_RVALUE
		ChildMetric(ChildMetric &&master);

		static ChildMetric Cast(::Udm::Object &&a);
		ChildMetric& operator=(ChildMetric &&a);

#endif
		static ChildMetric Cast(const ::Udm::Object &a);
		static ChildMetric Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		ChildMetric CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< ChildMetric> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< ChildMetric, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< ChildMetric, Pred>(impl); };
		ChildMetric CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< ChildMetric> Derived();
		template <class Pred> ::Udm::DerivedAttr< ChildMetric, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< ChildMetric, Pred>(impl); };
		::Udm::ArchetypeAttr< ChildMetric> Archetype() const;
		::Udm::ChildAttr< ::CADMetrics::Translation> Translation_child() const;
		::Udm::ChildAttr< ::CADMetrics::RotationMatrix> RotationMatrix_child() const;
		::Udm::ChildrenAttr< ::CADMetrics::Matrix> Matrix_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Matrix, Pred> Matrix_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Matrix, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::RotationMatrix> RotationMatrix_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::RotationMatrix, Pred> RotationMatrix_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::RotationMatrix, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::CoordinateBase> CoordinateBase_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::CoordinateBase, Pred> CoordinateBase_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::CoordinateBase, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::Translation> Translation_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Translation, Pred> Translation_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Translation, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADMetrics::Children> Children_parent() const;
		::Udm::ParentAttr< ::CADMetrics::Children> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Translation_child;
		static ::Uml::CompositionChildRole meta_RotationMatrix_child;
		static ::Uml::CompositionParentRole meta_Children_parent;

	};

	class MetricComponent :  public MetricsBase {
	public:
		MetricComponent();
		MetricComponent(::Udm::ObjectImpl *impl);
		MetricComponent(const MetricComponent &master);

#ifdef UDM_RVALUE
		MetricComponent(MetricComponent &&master);

		static MetricComponent Cast(::Udm::Object &&a);
		MetricComponent& operator=(MetricComponent &&a);

#endif
		static MetricComponent Cast(const ::Udm::Object &a);
		static MetricComponent Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		MetricComponent CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< MetricComponent> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< MetricComponent, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< MetricComponent, Pred>(impl); };
		MetricComponent CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< MetricComponent> Derived();
		template <class Pred> ::Udm::DerivedAttr< MetricComponent, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< MetricComponent, Pred>(impl); };
		::Udm::ArchetypeAttr< MetricComponent> Archetype() const;
		::Udm::StringAttr Name() const;
		::Udm::StringAttr Type() const;
		::Udm::StringAttr CoordinateSystem() const;
		::Udm::StringAttr SpecialInstruction() const;
		::Udm::ChildAttr< ::CADMetrics::PrincipleMomentsOfInertia> PrincipleMomentsOfInertia_child() const;
		::Udm::ChildAttr< ::CADMetrics::Scalars> Scalars_child() const;
		::Udm::ChildAttr< ::CADMetrics::CG> CG_child() const;
		::Udm::ChildAttr< ::CADMetrics::Units> Units_child() const;
		::Udm::ChildrenAttr< ::CADMetrics::InertiaTensor> InertiaTensor_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::InertiaTensor, Pred> InertiaTensor_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::InertiaTensor, Pred>(impl, meta_InertiaTensor_children); };
		::Udm::ChildAttr< ::CADMetrics::Material> Material_child() const;
		::Udm::ChildAttr< ::CADMetrics::BoundingBox> BoundingBox_child() const;
		::Udm::ChildAttr< ::CADMetrics::Children> Children_child() const;
		::Udm::ChildrenAttr< ::CADMetrics::Children> Children_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Children, Pred> Children_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Children, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::Scalars> Scalars_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Scalars, Pred> Scalars_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Scalars, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::Units> Units_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Units, Pred> Units_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Units, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::Material> Material_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Material, Pred> Material_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Material, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::Matrix> Matrix_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Matrix, Pred> Matrix_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Matrix, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::InertiaTensor> InertiaTensor_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::InertiaTensor, Pred> InertiaTensor_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::InertiaTensor, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::PrincipleMomentsOfInertia> PrincipleMomentsOfInertia_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::PrincipleMomentsOfInertia, Pred> PrincipleMomentsOfInertia_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::PrincipleMomentsOfInertia, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::CoordinateBase> CoordinateBase_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::CoordinateBase, Pred> CoordinateBase_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::CoordinateBase, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::CG> CG_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::CG, Pred> CG_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::CG, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::BoundingBox> BoundingBox_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::BoundingBox, Pred> BoundingBox_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::BoundingBox, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADMetrics::MetricComponents> MetricComponents_parent() const;
		::Udm::ParentAttr< ::CADMetrics::MetricComponents> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Name;
		static ::Uml::Attribute meta_Type;
		static ::Uml::Attribute meta_CoordinateSystem;
		static ::Uml::Attribute meta_SpecialInstruction;
		static ::Uml::CompositionChildRole meta_PrincipleMomentsOfInertia_child;
		static ::Uml::CompositionChildRole meta_Scalars_child;
		static ::Uml::CompositionChildRole meta_CG_child;
		static ::Uml::CompositionChildRole meta_Units_child;
		static ::Uml::CompositionChildRole meta_InertiaTensor_children;
		static ::Uml::CompositionChildRole meta_Material_child;
		static ::Uml::CompositionChildRole meta_BoundingBox_child;
		static ::Uml::CompositionChildRole meta_Children_child;
		static ::Uml::CompositionParentRole meta_MetricComponents_parent;

	};

	class Units : public ::Udm::Object {
	public:
		Units();
		Units(::Udm::ObjectImpl *impl);
		Units(const Units &master);

#ifdef UDM_RVALUE
		Units(Units &&master);

		static Units Cast(::Udm::Object &&a);
		Units& operator=(Units &&a);

#endif
		static Units Cast(const ::Udm::Object &a);
		static Units Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Units CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Units> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Units, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Units, Pred>(impl); };
		Units CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Units> Derived();
		template <class Pred> ::Udm::DerivedAttr< Units, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Units, Pred>(impl); };
		::Udm::ArchetypeAttr< Units> Archetype() const;
		::Udm::StringAttr Distance() const;
		::Udm::StringAttr Mass() const;
		::Udm::StringAttr Force() const;
		::Udm::StringAttr Time() const;
		::Udm::StringAttr Temperature() const;
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> MetricComponent_parent() const;
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Distance;
		static ::Uml::Attribute meta_Mass;
		static ::Uml::Attribute meta_Force;
		static ::Uml::Attribute meta_Time;
		static ::Uml::Attribute meta_Temperature;
		static ::Uml::CompositionParentRole meta_MetricComponent_parent;

	};

	class Material : public ::Udm::Object {
	public:
		Material();
		Material(::Udm::ObjectImpl *impl);
		Material(const Material &master);

#ifdef UDM_RVALUE
		Material(Material &&master);

		static Material Cast(::Udm::Object &&a);
		Material& operator=(Material &&a);

#endif
		static Material Cast(const ::Udm::Object &a);
		static Material Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Material CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Material> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Material, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Material, Pred>(impl); };
		Material CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Material> Derived();
		template <class Pred> ::Udm::DerivedAttr< Material, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Material, Pred>(impl); };
		::Udm::ArchetypeAttr< Material> Archetype() const;
		::Udm::StringAttr Type() const;
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> MetricComponent_parent() const;
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Type;
		static ::Uml::CompositionParentRole meta_MetricComponent_parent;

	};

	class Scalar : public ::Udm::Object {
	public:
		Scalar();
		Scalar(::Udm::ObjectImpl *impl);
		Scalar(const Scalar &master);

#ifdef UDM_RVALUE
		Scalar(Scalar &&master);

		static Scalar Cast(::Udm::Object &&a);
		Scalar& operator=(Scalar &&a);

#endif
		static Scalar Cast(const ::Udm::Object &a);
		static Scalar Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Scalar CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Scalar> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Scalar, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Scalar, Pred>(impl); };
		Scalar CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Scalar> Derived();
		template <class Pred> ::Udm::DerivedAttr< Scalar, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Scalar, Pred>(impl); };
		::Udm::ArchetypeAttr< Scalar> Archetype() const;
		::Udm::StringAttr Name() const;
		::Udm::RealAttr Value() const;
		::Udm::StringAttr Unit() const;
		::Udm::ParentAttr< ::CADMetrics::Scalars> Scalars_parent() const;
		::Udm::ParentAttr< ::CADMetrics::Scalars> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Name;
		static ::Uml::Attribute meta_Value;
		static ::Uml::Attribute meta_Unit;
		static ::Uml::CompositionParentRole meta_Scalars_parent;

	};

	class OutlinePoints : public ::Udm::Object {
	public:
		OutlinePoints();
		OutlinePoints(::Udm::ObjectImpl *impl);
		OutlinePoints(const OutlinePoints &master);

#ifdef UDM_RVALUE
		OutlinePoints(OutlinePoints &&master);

		static OutlinePoints Cast(::Udm::Object &&a);
		OutlinePoints& operator=(OutlinePoints &&a);

#endif
		static OutlinePoints Cast(const ::Udm::Object &a);
		static OutlinePoints Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		OutlinePoints CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< OutlinePoints> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< OutlinePoints, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< OutlinePoints, Pred>(impl); };
		OutlinePoints CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< OutlinePoints> Derived();
		template <class Pred> ::Udm::DerivedAttr< OutlinePoints, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< OutlinePoints, Pred>(impl); };
		::Udm::ArchetypeAttr< OutlinePoints> Archetype() const;
		::Udm::ChildrenAttr< ::CADMetrics::Point> Point_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Point, Pred> Point_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Point, Pred>(impl, meta_Point_children); };
		::Udm::ChildrenAttr< ::CADMetrics::CoordinateBase> CoordinateBase_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::CoordinateBase, Pred> CoordinateBase_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::CoordinateBase, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::Point> Point_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Point, Pred> Point_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Point, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADMetrics::BoundingBox> BoundingBox_parent() const;
		::Udm::ParentAttr< ::CADMetrics::BoundingBox> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Point_children;
		static ::Uml::CompositionParentRole meta_BoundingBox_parent;

	};

	class Column : public ::Udm::Object {
	public:
		Column();
		Column(::Udm::ObjectImpl *impl);
		Column(const Column &master);

#ifdef UDM_RVALUE
		Column(Column &&master);

		static Column Cast(::Udm::Object &&a);
		Column& operator=(Column &&a);

#endif
		static Column Cast(const ::Udm::Object &a);
		static Column Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Column CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Column> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Column, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Column, Pred>(impl); };
		Column CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Column> Derived();
		template <class Pred> ::Udm::DerivedAttr< Column, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Column, Pred>(impl); };
		::Udm::ArchetypeAttr< Column> Archetype() const;
		::Udm::RealAttr Value() const;
		::Udm::ParentAttr< ::CADMetrics::Row> Row_parent() const;
		::Udm::ParentAttr< ::CADMetrics::Row> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Value;
		static ::Uml::CompositionParentRole meta_Row_parent;

	};

	class Row : public ::Udm::Object {
	public:
		Row();
		Row(::Udm::ObjectImpl *impl);
		Row(const Row &master);

#ifdef UDM_RVALUE
		Row(Row &&master);

		static Row Cast(::Udm::Object &&a);
		Row& operator=(Row &&a);

#endif
		static Row Cast(const ::Udm::Object &a);
		static Row Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Row CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Row> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Row, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Row, Pred>(impl); };
		Row CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Row> Derived();
		template <class Pred> ::Udm::DerivedAttr< Row, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Row, Pred>(impl); };
		::Udm::ArchetypeAttr< Row> Archetype() const;
		::Udm::ChildrenAttr< ::CADMetrics::Column> Column_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Column, Pred> Column_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Column, Pred>(impl, meta_Column_children); };
		::Udm::ChildrenAttr< ::CADMetrics::Column> Column_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Column, Pred> Column_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Column, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADMetrics::Rows> Rows_parent() const;
		::Udm::ParentAttr< ::CADMetrics::Rows> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Column_children;
		static ::Uml::CompositionParentRole meta_Rows_parent;

	};

	class Rows : public ::Udm::Object {
	public:
		Rows();
		Rows(::Udm::ObjectImpl *impl);
		Rows(const Rows &master);

#ifdef UDM_RVALUE
		Rows(Rows &&master);

		static Rows Cast(::Udm::Object &&a);
		Rows& operator=(Rows &&a);

#endif
		static Rows Cast(const ::Udm::Object &a);
		static Rows Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Rows CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Rows> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Rows, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Rows, Pred>(impl); };
		Rows CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Rows> Derived();
		template <class Pred> ::Udm::DerivedAttr< Rows, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Rows, Pred>(impl); };
		::Udm::ArchetypeAttr< Rows> Archetype() const;
		::Udm::ChildrenAttr< ::CADMetrics::Row> Row_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Row, Pred> Row_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Row, Pred>(impl, meta_Row_children); };
		::Udm::ChildrenAttr< ::CADMetrics::Row> Row_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Row, Pred> Row_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Row, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADMetrics::Matrix> Matrix_parent() const;
		::Udm::ParentAttr< ::CADMetrics::Matrix> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Row_children;
		static ::Uml::CompositionParentRole meta_Matrix_parent;

	};

	class Matrix : public ::Udm::Object {
	public:
		Matrix();
		Matrix(::Udm::ObjectImpl *impl);
		Matrix(const Matrix &master);

#ifdef UDM_RVALUE
		Matrix(Matrix &&master);

		static Matrix Cast(::Udm::Object &&a);
		Matrix& operator=(Matrix &&a);

#endif
		static Matrix Cast(const ::Udm::Object &a);
		static Matrix Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Matrix CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Matrix> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Matrix, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Matrix, Pred>(impl); };
		Matrix CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Matrix> Derived();
		template <class Pred> ::Udm::DerivedAttr< Matrix, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Matrix, Pred>(impl); };
		::Udm::ArchetypeAttr< Matrix> Archetype() const;
		::Udm::ChildAttr< ::CADMetrics::Rows> Rows_child() const;
		::Udm::ChildrenAttr< ::CADMetrics::Rows> Rows_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Rows, Pred> Rows_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Rows, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::Udm::Object> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Rows_child;

	};

	class InertiaTensor :  public Matrix {
	public:
		InertiaTensor();
		InertiaTensor(::Udm::ObjectImpl *impl);
		InertiaTensor(const InertiaTensor &master);

#ifdef UDM_RVALUE
		InertiaTensor(InertiaTensor &&master);

		static InertiaTensor Cast(::Udm::Object &&a);
		InertiaTensor& operator=(InertiaTensor &&a);

#endif
		static InertiaTensor Cast(const ::Udm::Object &a);
		static InertiaTensor Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		InertiaTensor CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< InertiaTensor> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< InertiaTensor, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< InertiaTensor, Pred>(impl); };
		InertiaTensor CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< InertiaTensor> Derived();
		template <class Pred> ::Udm::DerivedAttr< InertiaTensor, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< InertiaTensor, Pred>(impl); };
		::Udm::ArchetypeAttr< InertiaTensor> Archetype() const;
		::Udm::StringAttr At() const;
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> MetricComponent_parent() const;
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_At;
		static ::Uml::CompositionParentRole meta_MetricComponent_parent;

	};

	class PrincipleMomentsOfInertia :  public Matrix {
	public:
		PrincipleMomentsOfInertia();
		PrincipleMomentsOfInertia(::Udm::ObjectImpl *impl);
		PrincipleMomentsOfInertia(const PrincipleMomentsOfInertia &master);

#ifdef UDM_RVALUE
		PrincipleMomentsOfInertia(PrincipleMomentsOfInertia &&master);

		static PrincipleMomentsOfInertia Cast(::Udm::Object &&a);
		PrincipleMomentsOfInertia& operator=(PrincipleMomentsOfInertia &&a);

#endif
		static PrincipleMomentsOfInertia Cast(const ::Udm::Object &a);
		static PrincipleMomentsOfInertia Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		PrincipleMomentsOfInertia CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< PrincipleMomentsOfInertia> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< PrincipleMomentsOfInertia, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< PrincipleMomentsOfInertia, Pred>(impl); };
		PrincipleMomentsOfInertia CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< PrincipleMomentsOfInertia> Derived();
		template <class Pred> ::Udm::DerivedAttr< PrincipleMomentsOfInertia, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< PrincipleMomentsOfInertia, Pred>(impl); };
		::Udm::ArchetypeAttr< PrincipleMomentsOfInertia> Archetype() const;
		::Udm::ChildAttr< ::CADMetrics::RotationMatrix> RotationMatrix_child() const;
		::Udm::ChildrenAttr< ::CADMetrics::Matrix> Matrix_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::Matrix, Pred> Matrix_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::Matrix, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADMetrics::RotationMatrix> RotationMatrix_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::RotationMatrix, Pred> RotationMatrix_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::RotationMatrix, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> MetricComponent_parent() const;
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_RotationMatrix_child;
		static ::Uml::CompositionParentRole meta_MetricComponent_parent;

	};

	class RotationMatrix :  public Matrix {
	public:
		RotationMatrix();
		RotationMatrix(::Udm::ObjectImpl *impl);
		RotationMatrix(const RotationMatrix &master);

#ifdef UDM_RVALUE
		RotationMatrix(RotationMatrix &&master);

		static RotationMatrix Cast(::Udm::Object &&a);
		RotationMatrix& operator=(RotationMatrix &&a);

#endif
		static RotationMatrix Cast(const ::Udm::Object &a);
		static RotationMatrix Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		RotationMatrix CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< RotationMatrix> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< RotationMatrix, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< RotationMatrix, Pred>(impl); };
		RotationMatrix CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< RotationMatrix> Derived();
		template <class Pred> ::Udm::DerivedAttr< RotationMatrix, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< RotationMatrix, Pred>(impl); };
		::Udm::ArchetypeAttr< RotationMatrix> Archetype() const;
		::Udm::ParentAttr< ::CADMetrics::ChildMetric> ChildMetric_parent() const;
		::Udm::ParentAttr< ::CADMetrics::PrincipleMomentsOfInertia> PrincipleMomentsOfInertia_parent() const;
		::Udm::ParentAttr< ::Udm::Object> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionParentRole meta_ChildMetric_parent;
		static ::Uml::CompositionParentRole meta_PrincipleMomentsOfInertia_parent;

	};

	class CoordinateBase : public ::Udm::Object {
	public:
		CoordinateBase();
		CoordinateBase(::Udm::ObjectImpl *impl);
		CoordinateBase(const CoordinateBase &master);

#ifdef UDM_RVALUE
		CoordinateBase(CoordinateBase &&master);

		static CoordinateBase Cast(::Udm::Object &&a);
		CoordinateBase& operator=(CoordinateBase &&a);

#endif
		static CoordinateBase Cast(const ::Udm::Object &a);
		static CoordinateBase Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		CoordinateBase CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< CoordinateBase> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< CoordinateBase, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< CoordinateBase, Pred>(impl); };
		CoordinateBase CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< CoordinateBase> Derived();
		template <class Pred> ::Udm::DerivedAttr< CoordinateBase, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< CoordinateBase, Pred>(impl); };
		::Udm::ArchetypeAttr< CoordinateBase> Archetype() const;
		::Udm::RealAttr X() const;
		::Udm::RealAttr Y() const;
		::Udm::RealAttr Z() const;
		::Udm::ParentAttr< ::Udm::Object> parent() const;

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_X;
		static ::Uml::Attribute meta_Y;
		static ::Uml::Attribute meta_Z;

	};

	class CG :  public CoordinateBase {
	public:
		CG();
		CG(::Udm::ObjectImpl *impl);
		CG(const CG &master);

#ifdef UDM_RVALUE
		CG(CG &&master);

		static CG Cast(::Udm::Object &&a);
		CG& operator=(CG &&a);

#endif
		static CG Cast(const ::Udm::Object &a);
		static CG Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		CG CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< CG> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< CG, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< CG, Pred>(impl); };
		CG CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< CG> Derived();
		template <class Pred> ::Udm::DerivedAttr< CG, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< CG, Pred>(impl); };
		::Udm::ArchetypeAttr< CG> Archetype() const;
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> MetricComponent_parent() const;
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionParentRole meta_MetricComponent_parent;

	};

	class Translation :  public CoordinateBase {
	public:
		Translation();
		Translation(::Udm::ObjectImpl *impl);
		Translation(const Translation &master);

#ifdef UDM_RVALUE
		Translation(Translation &&master);

		static Translation Cast(::Udm::Object &&a);
		Translation& operator=(Translation &&a);

#endif
		static Translation Cast(const ::Udm::Object &a);
		static Translation Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Translation CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Translation> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Translation, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Translation, Pred>(impl); };
		Translation CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Translation> Derived();
		template <class Pred> ::Udm::DerivedAttr< Translation, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Translation, Pred>(impl); };
		::Udm::ArchetypeAttr< Translation> Archetype() const;
		::Udm::ParentAttr< ::CADMetrics::ChildMetric> ChildMetric_parent() const;
		::Udm::ParentAttr< ::CADMetrics::ChildMetric> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionParentRole meta_ChildMetric_parent;

	};

	class Point :  public CoordinateBase {
	public:
		Point();
		Point(::Udm::ObjectImpl *impl);
		Point(const Point &master);

#ifdef UDM_RVALUE
		Point(Point &&master);

		static Point Cast(::Udm::Object &&a);
		Point& operator=(Point &&a);

#endif
		static Point Cast(const ::Udm::Object &a);
		static Point Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Point CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Point> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Point, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Point, Pred>(impl); };
		Point CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Point> Derived();
		template <class Pred> ::Udm::DerivedAttr< Point, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Point, Pred>(impl); };
		::Udm::ArchetypeAttr< Point> Archetype() const;
		::Udm::ParentAttr< ::CADMetrics::OutlinePoints> OutlinePoints_parent() const;
		::Udm::ParentAttr< ::CADMetrics::OutlinePoints> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionParentRole meta_OutlinePoints_parent;

	};

	class BoundingBox :  public CoordinateBase {
	public:
		BoundingBox();
		BoundingBox(::Udm::ObjectImpl *impl);
		BoundingBox(const BoundingBox &master);

#ifdef UDM_RVALUE
		BoundingBox(BoundingBox &&master);

		static BoundingBox Cast(::Udm::Object &&a);
		BoundingBox& operator=(BoundingBox &&a);

#endif
		static BoundingBox Cast(const ::Udm::Object &a);
		static BoundingBox Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		BoundingBox CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< BoundingBox> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< BoundingBox, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< BoundingBox, Pred>(impl); };
		BoundingBox CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< BoundingBox> Derived();
		template <class Pred> ::Udm::DerivedAttr< BoundingBox, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< BoundingBox, Pred>(impl); };
		::Udm::ArchetypeAttr< BoundingBox> Archetype() const;
		::Udm::ChildAttr< ::CADMetrics::OutlinePoints> OutlinePoints_child() const;
		::Udm::ChildrenAttr< ::CADMetrics::OutlinePoints> OutlinePoints_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADMetrics::OutlinePoints, Pred> OutlinePoints_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADMetrics::OutlinePoints, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> MetricComponent_parent() const;
		::Udm::ParentAttr< ::CADMetrics::MetricComponent> parent() const;

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_OutlinePoints_child;
		static ::Uml::CompositionParentRole meta_MetricComponent_parent;

	};

}

#endif // MOBIES_CADMETRICS_H
