// Copyright (C) 2005-2010 Code Synthesis Tools CC
//
// This program was generated by CodeSynthesis XSD, an XML Schema
// to C++ data binding compiler, in the Proprietary License mode.
// You should have received a proprietary license from Code Synthesis
// Tools CC prior to generating this code. See the license text for
// conditions.
//

#ifndef CADMETRICS_HXX
#define CADMETRICS_HXX

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/config.hxx>

#if (XSD_INT_VERSION != 3030000L)
#error XSD runtime version mismatch
#endif

#include <xsd/cxx/pre.hxx>

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>

#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

#include <xsd/cxx/tree/parsing.hxx>
#include <xsd/cxx/tree/parsing/byte.hxx>
#include <xsd/cxx/tree/parsing/unsigned-byte.hxx>
#include <xsd/cxx/tree/parsing/short.hxx>
#include <xsd/cxx/tree/parsing/unsigned-short.hxx>
#include <xsd/cxx/tree/parsing/int.hxx>
#include <xsd/cxx/tree/parsing/unsigned-int.hxx>
#include <xsd/cxx/tree/parsing/long.hxx>
#include <xsd/cxx/tree/parsing/unsigned-long.hxx>
#include <xsd/cxx/tree/parsing/boolean.hxx>
#include <xsd/cxx/tree/parsing/float.hxx>
#include <xsd/cxx/tree/parsing/double.hxx>
#include <xsd/cxx/tree/parsing/decimal.hxx>

#include <xsd/cxx/xml/dom/serialization-header.hxx>
#include <xsd/cxx/tree/serialization.hxx>
#include <xsd/cxx/tree/serialization/byte.hxx>
#include <xsd/cxx/tree/serialization/unsigned-byte.hxx>
#include <xsd/cxx/tree/serialization/short.hxx>
#include <xsd/cxx/tree/serialization/unsigned-short.hxx>
#include <xsd/cxx/tree/serialization/int.hxx>
#include <xsd/cxx/tree/serialization/unsigned-int.hxx>
#include <xsd/cxx/tree/serialization/long.hxx>
#include <xsd/cxx/tree/serialization/unsigned-long.hxx>
#include <xsd/cxx/tree/serialization/boolean.hxx>
#include <xsd/cxx/tree/serialization/float.hxx>
#include <xsd/cxx/tree/serialization/double.hxx>
#include <xsd/cxx/tree/serialization/decimal.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type< type > simple_type;
  typedef ::xsd::cxx::tree::type container;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef long long non_positive_integer;
  typedef unsigned long long non_negative_integer;
  typedef unsigned long long positive_integer;
  typedef long long negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken > nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< char, ncname, type > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::time_zone time_zone;
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::gday< char, simple_type > gday;
  typedef ::xsd::cxx::tree::gmonth< char, simple_type > gmonth;
  typedef ::xsd::cxx::tree::gmonth_day< char, simple_type > gmonth_day;
  typedef ::xsd::cxx::tree::gyear< char, simple_type > gyear;
  typedef ::xsd::cxx::tree::gyear_month< char, simple_type > gyear_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  // Namespace information and list stream. Used in
  // serialization functions.
  //
  typedef ::xsd::cxx::xml::dom::namespace_info< char > namespace_info;
  typedef ::xsd::cxx::xml::dom::namespace_infomap< char > namespace_infomap;
  typedef ::xsd::cxx::tree::list_stream< char > list_stream;
  typedef ::xsd::cxx::tree::as_double< double_ > as_double;
  typedef ::xsd::cxx::tree::as_decimal< decimal > as_decimal;
  typedef ::xsd::cxx::tree::facet facet;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // Parsing/serialization diagnostics.
  //
  typedef ::xsd::cxx::tree::severity severity;
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::diagnostics< char > diagnostics;

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::bounds< char > bounds;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::serialization< char > serialization;

  // Error handler callback interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;

  // DOM interaction.
  //
  namespace dom
  {
    // Automatic pointer for DOMDocument.
    //
    using ::xsd::cxx::xml::dom::auto_ptr;

#ifndef XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
    // DOM user data key for back pointers to tree nodes.
    //
    const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;
#endif
  }
}

// Forward declarations.
//
namespace CADMetrics
{
  class TranslationType;
  class CGType;
  class RotationMatrixType;
  class PrincipleMomentsOfInertiaType;
  class InertiaTensorType;
  class MetricComponentType;
  class ChildMetricType;
  class RowsType;
  class RowType;
  class ColumnType;
  class MaterialType;
  class UnitsType;
  class ScalarsType;
  class ChildrenType;
  class ScalarType;
  class CADComponentType;
  class AssemblyType;
  class MetricComponentsType;
  class AssembliesType;
  class CADMetricRootType;
}


#include <memory>    // std::auto_ptr
#include <limits>    // std::numeric_limits
#include <algorithm> // std::binary_search

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

#include <xsd/cxx/xml/dom/parsing-header.hxx>

namespace CADMetrics
{
  class TranslationType: public ::xml_schema::type
  {
    public:
    // Y
    // 
    typedef ::xml_schema::double_ Y_type;
    typedef ::xsd::cxx::tree::traits< Y_type, char, ::xsd::cxx::tree::schema_type::double_ > Y_traits;

    const Y_type&
    Y () const;

    Y_type&
    Y ();

    void
    Y (const Y_type& x);

    // X
    // 
    typedef ::xml_schema::double_ X_type;
    typedef ::xsd::cxx::tree::traits< X_type, char, ::xsd::cxx::tree::schema_type::double_ > X_traits;

    const X_type&
    X () const;

    X_type&
    X ();

    void
    X (const X_type& x);

    // Z
    // 
    typedef ::xml_schema::double_ Z_type;
    typedef ::xsd::cxx::tree::traits< Z_type, char, ::xsd::cxx::tree::schema_type::double_ > Z_traits;

    const Z_type&
    Z () const;

    Z_type&
    Z ();

    void
    Z (const Z_type& x);

    // Constructors.
    //
    TranslationType (const Y_type&,
                     const X_type&,
                     const Z_type&);

    TranslationType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    TranslationType (const TranslationType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual TranslationType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~TranslationType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< Y_type > Y_;
    ::xsd::cxx::tree::one< X_type > X_;
    ::xsd::cxx::tree::one< Z_type > Z_;
  };

  class CGType: public ::xml_schema::type
  {
    public:
    // Y
    // 
    typedef ::xml_schema::double_ Y_type;
    typedef ::xsd::cxx::tree::traits< Y_type, char, ::xsd::cxx::tree::schema_type::double_ > Y_traits;

    const Y_type&
    Y () const;

    Y_type&
    Y ();

    void
    Y (const Y_type& x);

    // X
    // 
    typedef ::xml_schema::double_ X_type;
    typedef ::xsd::cxx::tree::traits< X_type, char, ::xsd::cxx::tree::schema_type::double_ > X_traits;

    const X_type&
    X () const;

    X_type&
    X ();

    void
    X (const X_type& x);

    // Z
    // 
    typedef ::xml_schema::double_ Z_type;
    typedef ::xsd::cxx::tree::traits< Z_type, char, ::xsd::cxx::tree::schema_type::double_ > Z_traits;

    const Z_type&
    Z () const;

    Z_type&
    Z ();

    void
    Z (const Z_type& x);

    // Constructors.
    //
    CGType (const Y_type&,
            const X_type&,
            const Z_type&);

    CGType (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0);

    CGType (const CGType& x,
            ::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0);

    virtual CGType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~CGType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< Y_type > Y_;
    ::xsd::cxx::tree::one< X_type > X_;
    ::xsd::cxx::tree::one< Z_type > Z_;
  };

  class RotationMatrixType: public ::xml_schema::type
  {
    public:
    // Rows
    // 
    typedef ::CADMetrics::RowsType Rows_type;
    typedef ::xsd::cxx::tree::traits< Rows_type, char > Rows_traits;

    const Rows_type&
    Rows () const;

    Rows_type&
    Rows ();

    void
    Rows (const Rows_type& x);

    void
    Rows (::std::auto_ptr< Rows_type > p);

    // Constructors.
    //
    RotationMatrixType (const Rows_type&);

    RotationMatrixType (::std::auto_ptr< Rows_type >&);

    RotationMatrixType (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    RotationMatrixType (const RotationMatrixType& x,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    virtual RotationMatrixType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~RotationMatrixType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< Rows_type > Rows_;
  };

  class PrincipleMomentsOfInertiaType: public ::xml_schema::type
  {
    public:
    // RotationMatrix
    // 
    typedef ::CADMetrics::RotationMatrixType RotationMatrix_type;
    typedef ::xsd::cxx::tree::traits< RotationMatrix_type, char > RotationMatrix_traits;

    const RotationMatrix_type&
    RotationMatrix () const;

    RotationMatrix_type&
    RotationMatrix ();

    void
    RotationMatrix (const RotationMatrix_type& x);

    void
    RotationMatrix (::std::auto_ptr< RotationMatrix_type > p);

    // Rows
    // 
    typedef ::CADMetrics::RowsType Rows_type;
    typedef ::xsd::cxx::tree::traits< Rows_type, char > Rows_traits;

    const Rows_type&
    Rows () const;

    Rows_type&
    Rows ();

    void
    Rows (const Rows_type& x);

    void
    Rows (::std::auto_ptr< Rows_type > p);

    // Constructors.
    //
    PrincipleMomentsOfInertiaType (const RotationMatrix_type&,
                                   const Rows_type&);

    PrincipleMomentsOfInertiaType (::std::auto_ptr< RotationMatrix_type >&,
                                   ::std::auto_ptr< Rows_type >&);

    PrincipleMomentsOfInertiaType (const ::xercesc::DOMElement& e,
                                   ::xml_schema::flags f = 0,
                                   ::xml_schema::container* c = 0);

    PrincipleMomentsOfInertiaType (const PrincipleMomentsOfInertiaType& x,
                                   ::xml_schema::flags f = 0,
                                   ::xml_schema::container* c = 0);

    virtual PrincipleMomentsOfInertiaType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~PrincipleMomentsOfInertiaType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< RotationMatrix_type > RotationMatrix_;
    ::xsd::cxx::tree::one< Rows_type > Rows_;
  };

  class InertiaTensorType: public ::xml_schema::type
  {
    public:
    // Rows
    // 
    typedef ::CADMetrics::RowsType Rows_type;
    typedef ::xsd::cxx::tree::traits< Rows_type, char > Rows_traits;

    const Rows_type&
    Rows () const;

    Rows_type&
    Rows ();

    void
    Rows (const Rows_type& x);

    void
    Rows (::std::auto_ptr< Rows_type > p);

    // Constructors.
    //
    InertiaTensorType (const Rows_type&);

    InertiaTensorType (::std::auto_ptr< Rows_type >&);

    InertiaTensorType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    InertiaTensorType (const InertiaTensorType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual InertiaTensorType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~InertiaTensorType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< Rows_type > Rows_;
  };

  class MetricComponentType: public ::xml_schema::type
  {
    public:
    // CG
    // 
    typedef ::CADMetrics::CGType CG_type;
    typedef ::xsd::cxx::tree::traits< CG_type, char > CG_traits;

    const CG_type&
    CG () const;

    CG_type&
    CG ();

    void
    CG (const CG_type& x);

    void
    CG (::std::auto_ptr< CG_type > p);

    // Children
    // 
    typedef ::CADMetrics::ChildrenType Children_type;
    typedef ::xsd::cxx::tree::optional< Children_type > Children_optional;
    typedef ::xsd::cxx::tree::traits< Children_type, char > Children_traits;

    const Children_optional&
    Children () const;

    Children_optional&
    Children ();

    void
    Children (const Children_type& x);

    void
    Children (const Children_optional& x);

    void
    Children (::std::auto_ptr< Children_type > p);

    // InertiaTensor
    // 
    typedef ::CADMetrics::InertiaTensorType InertiaTensor_type;
    typedef ::xsd::cxx::tree::traits< InertiaTensor_type, char > InertiaTensor_traits;

    const InertiaTensor_type&
    InertiaTensor () const;

    InertiaTensor_type&
    InertiaTensor ();

    void
    InertiaTensor (const InertiaTensor_type& x);

    void
    InertiaTensor (::std::auto_ptr< InertiaTensor_type > p);

    // Material
    // 
    typedef ::CADMetrics::MaterialType Material_type;
    typedef ::xsd::cxx::tree::optional< Material_type > Material_optional;
    typedef ::xsd::cxx::tree::traits< Material_type, char > Material_traits;

    const Material_optional&
    Material () const;

    Material_optional&
    Material ();

    void
    Material (const Material_type& x);

    void
    Material (const Material_optional& x);

    void
    Material (::std::auto_ptr< Material_type > p);

    // PrincipleMomentsOfInertia
    // 
    typedef ::CADMetrics::PrincipleMomentsOfInertiaType PrincipleMomentsOfInertia_type;
    typedef ::xsd::cxx::tree::traits< PrincipleMomentsOfInertia_type, char > PrincipleMomentsOfInertia_traits;

    const PrincipleMomentsOfInertia_type&
    PrincipleMomentsOfInertia () const;

    PrincipleMomentsOfInertia_type&
    PrincipleMomentsOfInertia ();

    void
    PrincipleMomentsOfInertia (const PrincipleMomentsOfInertia_type& x);

    void
    PrincipleMomentsOfInertia (::std::auto_ptr< PrincipleMomentsOfInertia_type > p);

    // Scalars
    // 
    typedef ::CADMetrics::ScalarsType Scalars_type;
    typedef ::xsd::cxx::tree::traits< Scalars_type, char > Scalars_traits;

    const Scalars_type&
    Scalars () const;

    Scalars_type&
    Scalars ();

    void
    Scalars (const Scalars_type& x);

    void
    Scalars (::std::auto_ptr< Scalars_type > p);

    // Units
    // 
    typedef ::CADMetrics::UnitsType Units_type;
    typedef ::xsd::cxx::tree::traits< Units_type, char > Units_traits;

    const Units_type&
    Units () const;

    Units_type&
    Units ();

    void
    Units (const Units_type& x);

    void
    Units (::std::auto_ptr< Units_type > p);

    // Type
    // 
    typedef ::xml_schema::string Type_type;
    typedef ::xsd::cxx::tree::traits< Type_type, char > Type_traits;

    const Type_type&
    Type () const;

    Type_type&
    Type ();

    void
    Type (const Type_type& x);

    void
    Type (::std::auto_ptr< Type_type > p);

    // Name
    // 
    typedef ::xml_schema::string Name_type;
    typedef ::xsd::cxx::tree::traits< Name_type, char > Name_traits;

    const Name_type&
    Name () const;

    Name_type&
    Name ();

    void
    Name (const Name_type& x);

    void
    Name (::std::auto_ptr< Name_type > p);

    // CoordinateSystem
    // 
    typedef ::xml_schema::string CoordinateSystem_type;
    typedef ::xsd::cxx::tree::traits< CoordinateSystem_type, char > CoordinateSystem_traits;

    const CoordinateSystem_type&
    CoordinateSystem () const;

    CoordinateSystem_type&
    CoordinateSystem ();

    void
    CoordinateSystem (const CoordinateSystem_type& x);

    void
    CoordinateSystem (::std::auto_ptr< CoordinateSystem_type > p);

    // SpecialInstruction
    // 
    typedef ::xml_schema::string SpecialInstruction_type;
    typedef ::xsd::cxx::tree::traits< SpecialInstruction_type, char > SpecialInstruction_traits;

    const SpecialInstruction_type&
    SpecialInstruction () const;

    SpecialInstruction_type&
    SpecialInstruction ();

    void
    SpecialInstruction (const SpecialInstruction_type& x);

    void
    SpecialInstruction (::std::auto_ptr< SpecialInstruction_type > p);

    // MetricID
    // 
    typedef ::xml_schema::long_ MetricID_type;
    typedef ::xsd::cxx::tree::traits< MetricID_type, char > MetricID_traits;

    const MetricID_type&
    MetricID () const;

    MetricID_type&
    MetricID ();

    void
    MetricID (const MetricID_type& x);

    // Constructors.
    //
    MetricComponentType (const CG_type&,
                         const InertiaTensor_type&,
                         const PrincipleMomentsOfInertia_type&,
                         const Scalars_type&,
                         const Units_type&,
                         const Type_type&,
                         const Name_type&,
                         const CoordinateSystem_type&,
                         const SpecialInstruction_type&,
                         const MetricID_type&);

    MetricComponentType (::std::auto_ptr< CG_type >&,
                         ::std::auto_ptr< InertiaTensor_type >&,
                         ::std::auto_ptr< PrincipleMomentsOfInertia_type >&,
                         ::std::auto_ptr< Scalars_type >&,
                         ::std::auto_ptr< Units_type >&,
                         const Type_type&,
                         const Name_type&,
                         const CoordinateSystem_type&,
                         const SpecialInstruction_type&,
                         const MetricID_type&);

    MetricComponentType (const ::xercesc::DOMElement& e,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    MetricComponentType (const MetricComponentType& x,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    virtual MetricComponentType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~MetricComponentType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< CG_type > CG_;
    Children_optional Children_;
    ::xsd::cxx::tree::one< InertiaTensor_type > InertiaTensor_;
    Material_optional Material_;
    ::xsd::cxx::tree::one< PrincipleMomentsOfInertia_type > PrincipleMomentsOfInertia_;
    ::xsd::cxx::tree::one< Scalars_type > Scalars_;
    ::xsd::cxx::tree::one< Units_type > Units_;
    ::xsd::cxx::tree::one< Type_type > Type_;
    ::xsd::cxx::tree::one< Name_type > Name_;
    ::xsd::cxx::tree::one< CoordinateSystem_type > CoordinateSystem_;
    ::xsd::cxx::tree::one< SpecialInstruction_type > SpecialInstruction_;
    ::xsd::cxx::tree::one< MetricID_type > MetricID_;
  };

  class ChildMetricType: public ::xml_schema::type
  {
    public:
    // RotationMatrix
    // 
    typedef ::CADMetrics::RotationMatrixType RotationMatrix_type;
    typedef ::xsd::cxx::tree::traits< RotationMatrix_type, char > RotationMatrix_traits;

    const RotationMatrix_type&
    RotationMatrix () const;

    RotationMatrix_type&
    RotationMatrix ();

    void
    RotationMatrix (const RotationMatrix_type& x);

    void
    RotationMatrix (::std::auto_ptr< RotationMatrix_type > p);

    // Translation
    // 
    typedef ::CADMetrics::TranslationType Translation_type;
    typedef ::xsd::cxx::tree::traits< Translation_type, char > Translation_traits;

    const Translation_type&
    Translation () const;

    Translation_type&
    Translation ();

    void
    Translation (const Translation_type& x);

    void
    Translation (::std::auto_ptr< Translation_type > p);

    // MetricID
    // 
    typedef ::xml_schema::long_ MetricID_type;
    typedef ::xsd::cxx::tree::traits< MetricID_type, char > MetricID_traits;

    const MetricID_type&
    MetricID () const;

    MetricID_type&
    MetricID ();

    void
    MetricID (const MetricID_type& x);

    // Constructors.
    //
    ChildMetricType (const RotationMatrix_type&,
                     const Translation_type&,
                     const MetricID_type&);

    ChildMetricType (::std::auto_ptr< RotationMatrix_type >&,
                     ::std::auto_ptr< Translation_type >&,
                     const MetricID_type&);

    ChildMetricType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    ChildMetricType (const ChildMetricType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual ChildMetricType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~ChildMetricType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< RotationMatrix_type > RotationMatrix_;
    ::xsd::cxx::tree::one< Translation_type > Translation_;
    ::xsd::cxx::tree::one< MetricID_type > MetricID_;
  };

  class RowsType: public ::xml_schema::type
  {
    public:
    // Row
    // 
    typedef ::CADMetrics::RowType Row_type;
    typedef ::xsd::cxx::tree::sequence< Row_type > Row_sequence;
    typedef Row_sequence::iterator Row_iterator;
    typedef Row_sequence::const_iterator Row_const_iterator;
    typedef ::xsd::cxx::tree::traits< Row_type, char > Row_traits;

    const Row_sequence&
    Row () const;

    Row_sequence&
    Row ();

    void
    Row (const Row_sequence& s);

    // Constructors.
    //
    RowsType ();

    RowsType (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    RowsType (const RowsType& x,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    virtual RowsType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~RowsType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    Row_sequence Row_;
  };

  class RowType: public ::xml_schema::type
  {
    public:
    // Column
    // 
    typedef ::CADMetrics::ColumnType Column_type;
    typedef ::xsd::cxx::tree::sequence< Column_type > Column_sequence;
    typedef Column_sequence::iterator Column_iterator;
    typedef Column_sequence::const_iterator Column_const_iterator;
    typedef ::xsd::cxx::tree::traits< Column_type, char > Column_traits;

    const Column_sequence&
    Column () const;

    Column_sequence&
    Column ();

    void
    Column (const Column_sequence& s);

    // Constructors.
    //
    RowType ();

    RowType (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    RowType (const RowType& x,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    virtual RowType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~RowType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    Column_sequence Column_;
  };

  class ColumnType: public ::xml_schema::type
  {
    public:
    // Value
    // 
    typedef ::xml_schema::double_ Value_type;
    typedef ::xsd::cxx::tree::traits< Value_type, char, ::xsd::cxx::tree::schema_type::double_ > Value_traits;

    const Value_type&
    Value () const;

    Value_type&
    Value ();

    void
    Value (const Value_type& x);

    // Constructors.
    //
    ColumnType (const Value_type&);

    ColumnType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    ColumnType (const ColumnType& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual ColumnType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~ColumnType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< Value_type > Value_;
  };

  class MaterialType: public ::xml_schema::type
  {
    public:
    // Type
    // 
    typedef ::xml_schema::string Type_type;
    typedef ::xsd::cxx::tree::traits< Type_type, char > Type_traits;

    const Type_type&
    Type () const;

    Type_type&
    Type ();

    void
    Type (const Type_type& x);

    void
    Type (::std::auto_ptr< Type_type > p);

    // Constructors.
    //
    MaterialType (const Type_type&);

    MaterialType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    MaterialType (const MaterialType& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual MaterialType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~MaterialType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< Type_type > Type_;
  };

  class UnitsType: public ::xml_schema::type
  {
    public:
    // Mass
    // 
    typedef ::xml_schema::string Mass_type;
    typedef ::xsd::cxx::tree::traits< Mass_type, char > Mass_traits;

    const Mass_type&
    Mass () const;

    Mass_type&
    Mass ();

    void
    Mass (const Mass_type& x);

    void
    Mass (::std::auto_ptr< Mass_type > p);

    // Distance
    // 
    typedef ::xml_schema::string Distance_type;
    typedef ::xsd::cxx::tree::traits< Distance_type, char > Distance_traits;

    const Distance_type&
    Distance () const;

    Distance_type&
    Distance ();

    void
    Distance (const Distance_type& x);

    void
    Distance (::std::auto_ptr< Distance_type > p);

    // Force
    // 
    typedef ::xml_schema::string Force_type;
    typedef ::xsd::cxx::tree::traits< Force_type, char > Force_traits;

    const Force_type&
    Force () const;

    Force_type&
    Force ();

    void
    Force (const Force_type& x);

    void
    Force (::std::auto_ptr< Force_type > p);

    // Time
    // 
    typedef ::xml_schema::string Time_type;
    typedef ::xsd::cxx::tree::traits< Time_type, char > Time_traits;

    const Time_type&
    Time () const;

    Time_type&
    Time ();

    void
    Time (const Time_type& x);

    void
    Time (::std::auto_ptr< Time_type > p);

    // Temperature
    // 
    typedef ::xml_schema::string Temperature_type;
    typedef ::xsd::cxx::tree::traits< Temperature_type, char > Temperature_traits;

    const Temperature_type&
    Temperature () const;

    Temperature_type&
    Temperature ();

    void
    Temperature (const Temperature_type& x);

    void
    Temperature (::std::auto_ptr< Temperature_type > p);

    // Constructors.
    //
    UnitsType (const Mass_type&,
               const Distance_type&,
               const Force_type&,
               const Time_type&,
               const Temperature_type&);

    UnitsType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    UnitsType (const UnitsType& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual UnitsType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~UnitsType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< Mass_type > Mass_;
    ::xsd::cxx::tree::one< Distance_type > Distance_;
    ::xsd::cxx::tree::one< Force_type > Force_;
    ::xsd::cxx::tree::one< Time_type > Time_;
    ::xsd::cxx::tree::one< Temperature_type > Temperature_;
  };

  class ScalarsType: public ::xml_schema::type
  {
    public:
    // Scalar
    // 
    typedef ::CADMetrics::ScalarType Scalar_type;
    typedef ::xsd::cxx::tree::sequence< Scalar_type > Scalar_sequence;
    typedef Scalar_sequence::iterator Scalar_iterator;
    typedef Scalar_sequence::const_iterator Scalar_const_iterator;
    typedef ::xsd::cxx::tree::traits< Scalar_type, char > Scalar_traits;

    const Scalar_sequence&
    Scalar () const;

    Scalar_sequence&
    Scalar ();

    void
    Scalar (const Scalar_sequence& s);

    // Constructors.
    //
    ScalarsType ();

    ScalarsType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    ScalarsType (const ScalarsType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual ScalarsType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~ScalarsType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    Scalar_sequence Scalar_;
  };

  class ChildrenType: public ::xml_schema::type
  {
    public:
    // ChildMetric
    // 
    typedef ::CADMetrics::ChildMetricType ChildMetric_type;
    typedef ::xsd::cxx::tree::sequence< ChildMetric_type > ChildMetric_sequence;
    typedef ChildMetric_sequence::iterator ChildMetric_iterator;
    typedef ChildMetric_sequence::const_iterator ChildMetric_const_iterator;
    typedef ::xsd::cxx::tree::traits< ChildMetric_type, char > ChildMetric_traits;

    const ChildMetric_sequence&
    ChildMetric () const;

    ChildMetric_sequence&
    ChildMetric ();

    void
    ChildMetric (const ChildMetric_sequence& s);

    // Constructors.
    //
    ChildrenType ();

    ChildrenType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    ChildrenType (const ChildrenType& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual ChildrenType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~ChildrenType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ChildMetric_sequence ChildMetric_;
  };

  class ScalarType: public ::xml_schema::type
  {
    public:
    // Value
    // 
    typedef ::xml_schema::double_ Value_type;
    typedef ::xsd::cxx::tree::traits< Value_type, char, ::xsd::cxx::tree::schema_type::double_ > Value_traits;

    const Value_type&
    Value () const;

    Value_type&
    Value ();

    void
    Value (const Value_type& x);

    // Name
    // 
    typedef ::xml_schema::string Name_type;
    typedef ::xsd::cxx::tree::traits< Name_type, char > Name_traits;

    const Name_type&
    Name () const;

    Name_type&
    Name ();

    void
    Name (const Name_type& x);

    void
    Name (::std::auto_ptr< Name_type > p);

    // Unit
    // 
    typedef ::xml_schema::string Unit_type;
    typedef ::xsd::cxx::tree::traits< Unit_type, char > Unit_traits;

    const Unit_type&
    Unit () const;

    Unit_type&
    Unit ();

    void
    Unit (const Unit_type& x);

    void
    Unit (::std::auto_ptr< Unit_type > p);

    // Constructors.
    //
    ScalarType (const Value_type&,
                const Name_type&,
                const Unit_type&);

    ScalarType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    ScalarType (const ScalarType& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual ScalarType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~ScalarType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< Value_type > Value_;
    ::xsd::cxx::tree::one< Name_type > Name_;
    ::xsd::cxx::tree::one< Unit_type > Unit_;
  };

  class CADComponentType: public ::xml_schema::type
  {
    public:
    // CADComponent
    // 
    typedef ::CADMetrics::CADComponentType CADComponent_type;
    typedef ::xsd::cxx::tree::sequence< CADComponent_type > CADComponent_sequence;
    typedef CADComponent_sequence::iterator CADComponent_iterator;
    typedef CADComponent_sequence::const_iterator CADComponent_const_iterator;
    typedef ::xsd::cxx::tree::traits< CADComponent_type, char > CADComponent_traits;

    const CADComponent_sequence&
    CADComponent () const;

    CADComponent_sequence&
    CADComponent ();

    void
    CADComponent (const CADComponent_sequence& s);

    // MetricID
    // 
    typedef ::xml_schema::long_ MetricID_type;
    typedef ::xsd::cxx::tree::traits< MetricID_type, char > MetricID_traits;

    const MetricID_type&
    MetricID () const;

    MetricID_type&
    MetricID ();

    void
    MetricID (const MetricID_type& x);

    // ComponentID
    // 
    typedef ::xml_schema::string ComponentID_type;
    typedef ::xsd::cxx::tree::traits< ComponentID_type, char > ComponentID_traits;

    const ComponentID_type&
    ComponentID () const;

    ComponentID_type&
    ComponentID ();

    void
    ComponentID (const ComponentID_type& x);

    void
    ComponentID (::std::auto_ptr< ComponentID_type > p);

    // Constructors.
    //
    CADComponentType (const MetricID_type&,
                      const ComponentID_type&);

    CADComponentType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    CADComponentType (const CADComponentType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual CADComponentType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~CADComponentType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    CADComponent_sequence CADComponent_;
    ::xsd::cxx::tree::one< MetricID_type > MetricID_;
    ::xsd::cxx::tree::one< ComponentID_type > ComponentID_;
  };

  class AssemblyType: public ::xml_schema::type
  {
    public:
    // CADComponent
    // 
    typedef ::CADMetrics::CADComponentType CADComponent_type;
    typedef ::xsd::cxx::tree::traits< CADComponent_type, char > CADComponent_traits;

    const CADComponent_type&
    CADComponent () const;

    CADComponent_type&
    CADComponent ();

    void
    CADComponent (const CADComponent_type& x);

    void
    CADComponent (::std::auto_ptr< CADComponent_type > p);

    // ConfigurationID
    // 
    typedef ::xml_schema::long_ ConfigurationID_type;
    typedef ::xsd::cxx::tree::traits< ConfigurationID_type, char > ConfigurationID_traits;

    const ConfigurationID_type&
    ConfigurationID () const;

    ConfigurationID_type&
    ConfigurationID ();

    void
    ConfigurationID (const ConfigurationID_type& x);

    // Constructors.
    //
    AssemblyType (const CADComponent_type&,
                  const ConfigurationID_type&);

    AssemblyType (::std::auto_ptr< CADComponent_type >&,
                  const ConfigurationID_type&);

    AssemblyType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    AssemblyType (const AssemblyType& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual AssemblyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~AssemblyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< CADComponent_type > CADComponent_;
    ::xsd::cxx::tree::one< ConfigurationID_type > ConfigurationID_;
  };

  class MetricComponentsType: public ::xml_schema::type
  {
    public:
    // MetricComponent
    // 
    typedef ::CADMetrics::MetricComponentType MetricComponent_type;
    typedef ::xsd::cxx::tree::sequence< MetricComponent_type > MetricComponent_sequence;
    typedef MetricComponent_sequence::iterator MetricComponent_iterator;
    typedef MetricComponent_sequence::const_iterator MetricComponent_const_iterator;
    typedef ::xsd::cxx::tree::traits< MetricComponent_type, char > MetricComponent_traits;

    const MetricComponent_sequence&
    MetricComponent () const;

    MetricComponent_sequence&
    MetricComponent ();

    void
    MetricComponent (const MetricComponent_sequence& s);

    // Constructors.
    //
    MetricComponentsType ();

    MetricComponentsType (const ::xercesc::DOMElement& e,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    MetricComponentsType (const MetricComponentsType& x,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    virtual MetricComponentsType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~MetricComponentsType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    MetricComponent_sequence MetricComponent_;
  };

  class AssembliesType: public ::xml_schema::type
  {
    public:
    // Assembly
    // 
    typedef ::CADMetrics::AssemblyType Assembly_type;
    typedef ::xsd::cxx::tree::sequence< Assembly_type > Assembly_sequence;
    typedef Assembly_sequence::iterator Assembly_iterator;
    typedef Assembly_sequence::const_iterator Assembly_const_iterator;
    typedef ::xsd::cxx::tree::traits< Assembly_type, char > Assembly_traits;

    const Assembly_sequence&
    Assembly () const;

    Assembly_sequence&
    Assembly ();

    void
    Assembly (const Assembly_sequence& s);

    // Constructors.
    //
    AssembliesType ();

    AssembliesType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    AssembliesType (const AssembliesType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual AssembliesType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~AssembliesType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    Assembly_sequence Assembly_;
  };

  class CADMetricRootType: public ::xml_schema::type
  {
    public:
    // Assemblies
    // 
    typedef ::CADMetrics::AssembliesType Assemblies_type;
    typedef ::xsd::cxx::tree::traits< Assemblies_type, char > Assemblies_traits;

    const Assemblies_type&
    Assemblies () const;

    Assemblies_type&
    Assemblies ();

    void
    Assemblies (const Assemblies_type& x);

    void
    Assemblies (::std::auto_ptr< Assemblies_type > p);

    // MetricComponents
    // 
    typedef ::CADMetrics::MetricComponentsType MetricComponents_type;
    typedef ::xsd::cxx::tree::traits< MetricComponents_type, char > MetricComponents_traits;

    const MetricComponents_type&
    MetricComponents () const;

    MetricComponents_type&
    MetricComponents ();

    void
    MetricComponents (const MetricComponents_type& x);

    void
    MetricComponents (::std::auto_ptr< MetricComponents_type > p);

    // VersionInfo
    // 
    typedef ::xml_schema::string VersionInfo_type;
    typedef ::xsd::cxx::tree::traits< VersionInfo_type, char > VersionInfo_traits;

    const VersionInfo_type&
    VersionInfo () const;

    VersionInfo_type&
    VersionInfo ();

    void
    VersionInfo (const VersionInfo_type& x);

    void
    VersionInfo (::std::auto_ptr< VersionInfo_type > p);

    // Constructors.
    //
    CADMetricRootType (const Assemblies_type&,
                       const MetricComponents_type&,
                       const VersionInfo_type&);

    CADMetricRootType (::std::auto_ptr< Assemblies_type >&,
                       ::std::auto_ptr< MetricComponents_type >&,
                       const VersionInfo_type&);

    CADMetricRootType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    CADMetricRootType (const CADMetricRootType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual CADMetricRootType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual 
    ~CADMetricRootType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< Assemblies_type > Assemblies_;
    ::xsd::cxx::tree::one< MetricComponents_type > MetricComponents_;
    ::xsd::cxx::tree::one< VersionInfo_type > VersionInfo_;
  };
}

#include <iosfwd>

#include <xercesc/sax/InputSource.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace CADMetrics
{
  // Parse a URI or a local file.
  //

  ::std::auto_ptr< ::CADMetrics::CADMetricRootType >
  CADMetricRoot (const ::std::string& uri,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::CADMetrics::CADMetricRootType >
  CADMetricRoot (const ::std::string& uri,
                 ::xml_schema::error_handler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::CADMetrics::CADMetricRootType >
  CADMetricRoot (const ::std::string& uri,
                 ::xercesc::DOMErrorHandler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::auto_ptr< ::CADMetrics::CADMetricRootType >
  CADMetricRoot (::std::istream& is,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::CADMetrics::CADMetricRootType >
  CADMetricRoot (::std::istream& is,
                 ::xml_schema::error_handler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::CADMetrics::CADMetricRootType >
  CADMetricRoot (::std::istream& is,
                 ::xercesc::DOMErrorHandler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::CADMetrics::CADMetricRootType >
  CADMetricRoot (::std::istream& is,
                 const ::std::string& id,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::CADMetrics::CADMetricRootType >
  CADMetricRoot (::std::istream& is,
                 const ::std::string& id,
                 ::xml_schema::error_handler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::CADMetrics::CADMetricRootType >
  CADMetricRoot (::std::istream& is,
                 const ::std::string& id,
                 ::xercesc::DOMErrorHandler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::auto_ptr< ::CADMetrics::CADMetricRootType >
  CADMetricRoot (::xercesc::InputSource& is,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::CADMetrics::CADMetricRootType >
  CADMetricRoot (::xercesc::InputSource& is,
                 ::xml_schema::error_handler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::CADMetrics::CADMetricRootType >
  CADMetricRoot (::xercesc::InputSource& is,
                 ::xercesc::DOMErrorHandler& eh,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::auto_ptr< ::CADMetrics::CADMetricRootType >
  CADMetricRoot (const ::xercesc::DOMDocument& d,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::CADMetrics::CADMetricRootType >
  CADMetricRoot (::xml_schema::dom::auto_ptr< ::xercesc::DOMDocument >& d,
                 ::xml_schema::flags f = 0,
                 const ::xml_schema::properties& p = ::xml_schema::properties ());
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/framework/XMLFormatter.hpp>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

namespace CADMetrics
{
  void
  operator<< (::xercesc::DOMElement&, const TranslationType&);

  void
  operator<< (::xercesc::DOMElement&, const CGType&);

  void
  operator<< (::xercesc::DOMElement&, const RotationMatrixType&);

  void
  operator<< (::xercesc::DOMElement&, const PrincipleMomentsOfInertiaType&);

  void
  operator<< (::xercesc::DOMElement&, const InertiaTensorType&);

  void
  operator<< (::xercesc::DOMElement&, const MetricComponentType&);

  void
  operator<< (::xercesc::DOMElement&, const ChildMetricType&);

  void
  operator<< (::xercesc::DOMElement&, const RowsType&);

  void
  operator<< (::xercesc::DOMElement&, const RowType&);

  void
  operator<< (::xercesc::DOMElement&, const ColumnType&);

  void
  operator<< (::xercesc::DOMElement&, const MaterialType&);

  void
  operator<< (::xercesc::DOMElement&, const UnitsType&);

  void
  operator<< (::xercesc::DOMElement&, const ScalarsType&);

  void
  operator<< (::xercesc::DOMElement&, const ChildrenType&);

  void
  operator<< (::xercesc::DOMElement&, const ScalarType&);

  void
  operator<< (::xercesc::DOMElement&, const CADComponentType&);

  void
  operator<< (::xercesc::DOMElement&, const AssemblyType&);

  void
  operator<< (::xercesc::DOMElement&, const MetricComponentsType&);

  void
  operator<< (::xercesc::DOMElement&, const AssembliesType&);

  void
  operator<< (::xercesc::DOMElement&, const CADMetricRootType&);

  // Serialize to std::ostream.
  //

  void
  CADMetricRoot (::std::ostream& os,
                 const ::CADMetrics::CADMetricRootType& x, 
                 const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                 const ::std::string& e = "UTF-8",
                 ::xml_schema::flags f = 0);

  void
  CADMetricRoot (::std::ostream& os,
                 const ::CADMetrics::CADMetricRootType& x, 
                 ::xml_schema::error_handler& eh,
                 const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                 const ::std::string& e = "UTF-8",
                 ::xml_schema::flags f = 0);

  void
  CADMetricRoot (::std::ostream& os,
                 const ::CADMetrics::CADMetricRootType& x, 
                 ::xercesc::DOMErrorHandler& eh,
                 const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                 const ::std::string& e = "UTF-8",
                 ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  CADMetricRoot (::xercesc::XMLFormatTarget& ft,
                 const ::CADMetrics::CADMetricRootType& x, 
                 const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                 const ::std::string& e = "UTF-8",
                 ::xml_schema::flags f = 0);

  void
  CADMetricRoot (::xercesc::XMLFormatTarget& ft,
                 const ::CADMetrics::CADMetricRootType& x, 
                 ::xml_schema::error_handler& eh,
                 const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                 const ::std::string& e = "UTF-8",
                 ::xml_schema::flags f = 0);

  void
  CADMetricRoot (::xercesc::XMLFormatTarget& ft,
                 const ::CADMetrics::CADMetricRootType& x, 
                 ::xercesc::DOMErrorHandler& eh,
                 const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                 const ::std::string& e = "UTF-8",
                 ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  CADMetricRoot (::xercesc::DOMDocument& d,
                 const ::CADMetrics::CADMetricRootType& x,
                 ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::auto_ptr< ::xercesc::DOMDocument >
  CADMetricRoot (const ::CADMetrics::CADMetricRootType& x, 
                 const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                 ::xml_schema::flags f = 0);
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // CADMETRICS_HXX
