/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// cpp (meta datanetwork format) source file CADPostProcessingParameters.cpp
// generated from diagram CADPostProcessingParameters
// generated on Wed Aug 22 10:48:14 2012

#include "CADPostProcessingParameters.h"
#include <UmlExt.h>
#include <UdmStatic.h>

#include <UdmDom.h>
#include "CADPostProcessingParameters_xsd.h"
using namespace std;

namespace CADPostProcessingParameters {

	Material::Material() {}
	Material::Material(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Material::Material(const Material &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Material::Material(Material &&master) : UDM_OBJECT(master) {};

	Material Material::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Material& Material::operator=(Material &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Material Material::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Material Material::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Material Material::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Material> Material::Instances() { return ::Udm::InstantiatedAttr< Material>(impl); }
	Material Material::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Material> Material::Derived() { return ::Udm::DerivedAttr< Material>(impl); }
	::Udm::ArchetypeAttr< Material> Material::Archetype() const { return ::Udm::ArchetypeAttr< Material>(impl); }
	::Udm::RealAttr Material::Mises() const { return ::Udm::RealAttr(impl, meta_Mises); }
	::Udm::RealAttr Material::Bearing() const { return ::Udm::RealAttr(impl, meta_Bearing); }
	::Udm::RealAttr Material::Shear() const { return ::Udm::RealAttr(impl, meta_Shear); }
	::Udm::StringAttr Material::Units() const { return ::Udm::StringAttr(impl, meta_Units); }
	::Udm::ParentAttr< ::CADPostProcessingParameters::Component> Material::Component_parent() const { return ::Udm::ParentAttr< ::CADPostProcessingParameters::Component>(impl, meta_Component_parent); }
	::Udm::ParentAttr< ::CADPostProcessingParameters::Component> Material::parent() const { return ::Udm::ParentAttr< ::CADPostProcessingParameters::Component>(impl, ::Udm::NULLPARENTROLE); }
	void Material::Accept(Visitor &v) { v.Visit_Material(*this); }

	::Uml::Class Material::meta;
	::Uml::Attribute Material::meta_Mises;
	::Uml::Attribute Material::meta_Bearing;
	::Uml::Attribute Material::meta_Shear;
	::Uml::Attribute Material::meta_Units;
	::Uml::CompositionParentRole Material::meta_Component_parent;

	Components::Components() {}
	Components::Components(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Components::Components(const Components &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Components::Components(Components &&master) : UDM_OBJECT(master) {};

	Components Components::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Components& Components::operator=(Components &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Components Components::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Components Components::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Components Components::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Components> Components::Instances() { return ::Udm::InstantiatedAttr< Components>(impl); }
	Components Components::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Components> Components::Derived() { return ::Udm::DerivedAttr< Components>(impl); }
	::Udm::ArchetypeAttr< Components> Components::Archetype() const { return ::Udm::ArchetypeAttr< Components>(impl); }
	::Udm::StringAttr Components::ConfigurationID() const { return ::Udm::StringAttr(impl, meta_ConfigurationID); }
	::Udm::ChildrenAttr< ::CADPostProcessingParameters::Component> Components::Component_children() const { return ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Component>(impl, meta_Component_children); }
	::Udm::ChildrenAttr< ::CADPostProcessingParameters::Component> Components::Component_kind_children() const { return ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Component>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::Udm::Object> Components::parent() const { return ::Udm::ParentAttr< ::Udm::Object>(impl, ::Udm::NULLPARENTROLE); }
	void Components::Accept(Visitor &v) { v.Visit_Components(*this); }

	::Uml::Class Components::meta;
	::Uml::Attribute Components::meta_ConfigurationID;
	::Uml::CompositionChildRole Components::meta_Component_children;

	Metric::Metric() {}
	Metric::Metric(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Metric::Metric(const Metric &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Metric::Metric(Metric &&master) : UDM_OBJECT(master) {};

	Metric Metric::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Metric& Metric::operator=(Metric &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Metric Metric::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Metric Metric::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Metric Metric::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Metric> Metric::Instances() { return ::Udm::InstantiatedAttr< Metric>(impl); }
	Metric Metric::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Metric> Metric::Derived() { return ::Udm::DerivedAttr< Metric>(impl); }
	::Udm::ArchetypeAttr< Metric> Metric::Archetype() const { return ::Udm::ArchetypeAttr< Metric>(impl); }
	::Udm::StringAttr Metric::MetricID() const { return ::Udm::StringAttr(impl, meta_MetricID); }
	::Udm::StringAttr Metric::Type() const { return ::Udm::StringAttr(impl, meta_Type); }
	::Udm::RealAttrArr Metric::ArrayValue() const { return ::Udm::RealAttrArr(impl, meta_ArrayValue); }
	::Udm::StringAttr Metric::Units() const { return ::Udm::StringAttr(impl, meta_Units); }
	::Udm::ParentAttr< ::CADPostProcessingParameters::Metrics> Metric::Metrics_parent() const { return ::Udm::ParentAttr< ::CADPostProcessingParameters::Metrics>(impl, meta_Metrics_parent); }
	::Udm::ParentAttr< ::CADPostProcessingParameters::Metrics> Metric::parent() const { return ::Udm::ParentAttr< ::CADPostProcessingParameters::Metrics>(impl, ::Udm::NULLPARENTROLE); }
	void Metric::Accept(Visitor &v) { v.Visit_Metric(*this); }

	::Uml::Class Metric::meta;
	::Uml::Attribute Metric::meta_MetricID;
	::Uml::Attribute Metric::meta_Type;
	::Uml::Attribute Metric::meta_ArrayValue;
	::Uml::Attribute Metric::meta_Units;
	::Uml::CompositionParentRole Metric::meta_Metrics_parent;

	Component::Component() {}
	Component::Component(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Component::Component(const Component &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Component::Component(Component &&master) : UDM_OBJECT(master) {};

	Component Component::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Component& Component::operator=(Component &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Component Component::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Component Component::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Component Component::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Component> Component::Instances() { return ::Udm::InstantiatedAttr< Component>(impl); }
	Component Component::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Component> Component::Derived() { return ::Udm::DerivedAttr< Component>(impl); }
	::Udm::ArchetypeAttr< Component> Component::Archetype() const { return ::Udm::ArchetypeAttr< Component>(impl); }
	::Udm::StringAttr Component::ComponentID() const { return ::Udm::StringAttr(impl, meta_ComponentID); }
	::Udm::StringAttr Component::FEAElementID() const { return ::Udm::StringAttr(impl, meta_FEAElementID); }
	::Udm::ChildAttr< ::CADPostProcessingParameters::Metrics> Component::Metrics_child() const { return ::Udm::ChildAttr< ::CADPostProcessingParameters::Metrics>(impl, meta_Metrics_child); }
	::Udm::ChildAttr< ::CADPostProcessingParameters::Material> Component::Material_child() const { return ::Udm::ChildAttr< ::CADPostProcessingParameters::Material>(impl, meta_Material_child); }
	::Udm::ChildrenAttr< ::CADPostProcessingParameters::Material> Component::Material_kind_children() const { return ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Material>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ChildrenAttr< ::CADPostProcessingParameters::Metrics> Component::Metrics_kind_children() const { return ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Metrics>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADPostProcessingParameters::Components> Component::Components_parent() const { return ::Udm::ParentAttr< ::CADPostProcessingParameters::Components>(impl, meta_Components_parent); }
	::Udm::ParentAttr< ::CADPostProcessingParameters::Components> Component::parent() const { return ::Udm::ParentAttr< ::CADPostProcessingParameters::Components>(impl, ::Udm::NULLPARENTROLE); }
	void Component::Accept(Visitor &v) { v.Visit_Component(*this); }

	::Uml::Class Component::meta;
	::Uml::Attribute Component::meta_ComponentID;
	::Uml::Attribute Component::meta_FEAElementID;
	::Uml::CompositionChildRole Component::meta_Metrics_child;
	::Uml::CompositionChildRole Component::meta_Material_child;
	::Uml::CompositionParentRole Component::meta_Components_parent;

	Metrics::Metrics() {}
	Metrics::Metrics(::Udm::ObjectImpl *impl) : UDM_OBJECT(impl) {}
	Metrics::Metrics(const Metrics &master) : UDM_OBJECT(master) {}

#ifdef UDM_RVALUE
	Metrics::Metrics(Metrics &&master) : UDM_OBJECT(master) {};

	Metrics Metrics::Cast(::Udm::Object &&a) { return __Cast(std::move(a), meta); };
	Metrics& Metrics::operator=(Metrics &&a) { ::Udm::Object::operator =(std::move(a)); return *this; };

#endif
	Metrics Metrics::Cast(const ::Udm::Object &a) { return __Cast(a, meta); }
	Metrics Metrics::Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role); }
	Metrics Metrics::CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl); }
	::Udm::InstantiatedAttr< Metrics> Metrics::Instances() { return ::Udm::InstantiatedAttr< Metrics>(impl); }
	Metrics Metrics::CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role) { return __Create(meta, parent, role, impl, true); }
	::Udm::DerivedAttr< Metrics> Metrics::Derived() { return ::Udm::DerivedAttr< Metrics>(impl); }
	::Udm::ArchetypeAttr< Metrics> Metrics::Archetype() const { return ::Udm::ArchetypeAttr< Metrics>(impl); }
	::Udm::ChildrenAttr< ::CADPostProcessingParameters::Metric> Metrics::Metric_children() const { return ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Metric>(impl, meta_Metric_children); }
	::Udm::ChildrenAttr< ::CADPostProcessingParameters::Metric> Metrics::Metric_kind_children() const { return ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Metric>(impl, ::Udm::NULLCHILDROLE); }
	::Udm::ParentAttr< ::CADPostProcessingParameters::Component> Metrics::Component_parent() const { return ::Udm::ParentAttr< ::CADPostProcessingParameters::Component>(impl, meta_Component_parent); }
	::Udm::ParentAttr< ::CADPostProcessingParameters::Component> Metrics::parent() const { return ::Udm::ParentAttr< ::CADPostProcessingParameters::Component>(impl, ::Udm::NULLPARENTROLE); }
	void Metrics::Accept(Visitor &v) { v.Visit_Metrics(*this); }

	::Uml::Class Metrics::meta;
	::Uml::CompositionChildRole Metrics::meta_Metric_children;
	::Uml::CompositionParentRole Metrics::meta_Component_parent;

	::Uml::Diagram meta;

	void CreateMeta() {
		// classes, with attributes, constraints and constraint definitions
		Component::meta = ::Uml::Class::Create(meta);
		Component::meta_ComponentID = ::Uml::Attribute::Create(Component::meta);
		Component::meta_FEAElementID = ::Uml::Attribute::Create(Component::meta);

		Components::meta = ::Uml::Class::Create(meta);
		Components::meta_ConfigurationID = ::Uml::Attribute::Create(Components::meta);

		Material::meta = ::Uml::Class::Create(meta);
		Material::meta_Mises = ::Uml::Attribute::Create(Material::meta);
		Material::meta_Bearing = ::Uml::Attribute::Create(Material::meta);
		Material::meta_Shear = ::Uml::Attribute::Create(Material::meta);
		Material::meta_Units = ::Uml::Attribute::Create(Material::meta);

		Metric::meta = ::Uml::Class::Create(meta);
		Metric::meta_MetricID = ::Uml::Attribute::Create(Metric::meta);
		Metric::meta_Type = ::Uml::Attribute::Create(Metric::meta);
		Metric::meta_ArrayValue = ::Uml::Attribute::Create(Metric::meta);
		Metric::meta_Units = ::Uml::Attribute::Create(Metric::meta);

		Metrics::meta = ::Uml::Class::Create(meta);

	}

	void InitMeta() {
		// classes, with attributes, constraints and constraint definitions
		::Uml::InitClassProps(Component::meta, "Component", false, NULL, NULL);
		::Uml::InitAttributeProps(Component::meta_ComponentID, "ComponentID", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Component::meta_FEAElementID, "FEAElementID", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Components::meta, "Components", false, NULL, NULL);
		::Uml::InitAttributeProps(Components::meta_ConfigurationID, "ConfigurationID", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Material::meta, "Material", false, NULL, NULL);
		::Uml::InitAttributeProps(Material::meta_Mises, "Mises", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Material::meta_Bearing, "Bearing", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Material::meta_Shear, "Shear", "Real", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Material::meta_Units, "Units", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Metric::meta, "Metric", false, NULL, NULL);
		::Uml::InitAttributeProps(Metric::meta_MetricID, "MetricID", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Metric::meta_Type, "Type", "String", false, false, 1, 1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Metric::meta_ArrayValue, "ArrayValue", "Real", false, false, 0, -1, false, "public", vector<string>());
		::Uml::InitAttributeProps(Metric::meta_Units, "Units", "String", false, false, 1, 1, false, "public", vector<string>());

		::Uml::InitClassProps(Metrics::meta, "Metrics", false, NULL, NULL);

		// compositions
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Component::meta_Components_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Component::meta_Components_parent, "Components_parent", true);
			Components::meta_Component_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Components::meta_Component_children, "Component", true, 1, -1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Metrics::meta_Component_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Metrics::meta_Component_parent, "Component_parent", true);
			Component::meta_Metrics_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Component::meta_Metrics_child, "Metrics", true, 0, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Material::meta_Component_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Material::meta_Component_parent, "Component_parent", true);
			Component::meta_Material_child = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Component::meta_Material_child, "Material", true, 1, 1);

		}
		{
			::Uml::Composition comp = ::Uml::Composition::Create(meta);
			::Uml::InitCompositionProps(comp, "Composition", false);
			Metric::meta_Metrics_parent = ::Uml::CompositionParentRole::Create(comp);
			::Uml::InitCompositionParentRoleProps(Metric::meta_Metrics_parent, "Metrics_parent", true);
			Metrics::meta_Metric_children = ::Uml::CompositionChildRole::Create(comp);
			::Uml::InitCompositionChildRoleProps(Metrics::meta_Metric_children, "Metric", true, 1, -1);

		}

	}

	void InitMetaLinks() {
		Metrics::meta_Component_parent.target() = Component::meta;
		Material::meta_Component_parent.target() = Component::meta;
		Components::meta_Component_children.target() = Component::meta;

		Component::meta_Components_parent.target() = Components::meta;

		Component::meta_Material_child.target() = Material::meta;

		Metrics::meta_Metric_children.target() = Metric::meta;

		Metric::meta_Metrics_parent.target() = Metrics::meta;
		Component::meta_Metrics_child.target() = Metrics::meta;

	}

	void InitMeta(const ::Uml::Diagram &parent) {
		// classes, with attributes, constraints and constraint definitions
		::Uml::SetClass(Component::meta, parent, "Component");
		::Uml::SetAttribute(Component::meta_ComponentID, Component::meta, "ComponentID");
		::Uml::SetAttribute(Component::meta_FEAElementID, Component::meta, "FEAElementID");

		::Uml::SetClass(Components::meta, parent, "Components");
		::Uml::SetAttribute(Components::meta_ConfigurationID, Components::meta, "ConfigurationID");

		::Uml::SetClass(Material::meta, parent, "Material");
		::Uml::SetAttribute(Material::meta_Mises, Material::meta, "Mises");
		::Uml::SetAttribute(Material::meta_Bearing, Material::meta, "Bearing");
		::Uml::SetAttribute(Material::meta_Shear, Material::meta, "Shear");
		::Uml::SetAttribute(Material::meta_Units, Material::meta, "Units");

		::Uml::SetClass(Metric::meta, parent, "Metric");
		::Uml::SetAttribute(Metric::meta_MetricID, Metric::meta, "MetricID");
		::Uml::SetAttribute(Metric::meta_Type, Metric::meta, "Type");
		::Uml::SetAttribute(Metric::meta_ArrayValue, Metric::meta, "ArrayValue");
		::Uml::SetAttribute(Metric::meta_Units, Metric::meta, "Units");

		::Uml::SetClass(Metrics::meta, parent, "Metrics");

	}

	void InitMetaLinks(const ::Uml::Diagram &parent) {
		// classes
		::Uml::SetChildRole(Component::meta_Metrics_child, Component::meta, Metrics::meta, "", "");
		::Uml::SetChildRole(Component::meta_Material_child, Component::meta, Material::meta, "", "");
		::Uml::SetParentRole(Component::meta_Components_parent, Component::meta, Components::meta, "", "");

		::Uml::SetChildRole(Components::meta_Component_children, Components::meta, Component::meta, "", "");

		::Uml::SetParentRole(Material::meta_Component_parent, Material::meta, Component::meta, "", "");

		::Uml::SetParentRole(Metric::meta_Metrics_parent, Metric::meta, Metrics::meta, "", "");

		::Uml::SetChildRole(Metrics::meta_Metric_children, Metrics::meta, Metric::meta, "", "");
		::Uml::SetParentRole(Metrics::meta_Component_parent, Metrics::meta, Component::meta, "", "");

	}

	Visitor::~Visitor() {}

	void Visitor::Visit_Material(const Material &) {}
	void Visitor::Visit_Components(const Components &) {}
	void Visitor::Visit_Metric(const Metric &) {}
	void Visitor::Visit_Component(const Component &) {}
	void Visitor::Visit_Metrics(const Metrics &) {}
	void Visitor::Visit_Object(const ::Udm::Object &) {}

	void _SetXsdStorage()
	{
		UdmDom::str_xsd_storage::StoreXsd("CADPostProcessingParameters.xsd", CADPostProcessingParameters_xsd::getString());
	}

	void Initialize()
	{
		static bool first = true;
		if (!first) return;
		first = false;
		::Uml::Initialize();

	
		UDM_ASSERT( meta == ::Udm::null );

		::UdmStatic::StaticDataNetwork * meta_dn = new ::UdmStatic::StaticDataNetwork(::Uml::diagram);
		meta_dn->CreateNew("CADPostProcessingParameters.mem", "", ::Uml::Diagram::meta, ::Udm::CHANGES_LOST_DEFAULT);
		meta = ::Uml::Diagram::Cast(meta_dn->GetRootObject());

		::Uml::InitDiagramProps(meta, "CADPostProcessingParameters", "1.00");


		CreateMeta();
		InitMeta();
		InitMetaLinks();

		_SetXsdStorage();

	}

	void Initialize(const ::Uml::Diagram &dgr)
	{
		
		if (meta == dgr) return;
		meta = dgr;

		InitMeta(dgr);
		InitMetaLinks(dgr);

		
		_SetXsdStorage();
	}


	 ::Udm::UdmDiagram diagram = { &meta, Initialize };
	static struct _regClass
	{
		_regClass()
		{
			::Udm::MetaDepository::StoreDiagram("CADPostProcessingParameters", diagram);
		}
		~_regClass()
		{
			::Udm::MetaDepository::RemoveDiagram("CADPostProcessingParameters");
		}
	} __regUnUsed;

}

