/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef MOBIES_CADPOSTPROCESSINGPARAMETERS_H
#define MOBIES_CADPOSTPROCESSINGPARAMETERS_H

// header file CADPostProcessingParameters.h generated from diagram CADPostProcessingParameters
// generated with Udm version 3.31 on Wed Aug 22 10:48:14 2012

#include <UdmBase.h>

#if !defined(UDM_VERSION_MAJOR) || !defined(UDM_VERSION_MINOR)
#    error "Udm headers too old, they do not define UDM_VERSION"
#elif UDM_VERSION_MAJOR < 3
#    error "Udm headers too old, minimum version required 3.31"
#elif UDM_VERSION_MAJOR == 3 && UDM_VERSION_MINOR < 31
#    error "Udm headers too old, minimum version required 3.31"
#endif

#include <Uml.h>


#ifdef min
#undef min
#endif

#ifdef max
#undef max
#endif

namespace CADPostProcessingParameters {

	extern ::Uml::Diagram meta;
	class Material;
	class Components;
	class Metric;
	class Component;
	class Metrics;

	class Visitor : public ::Udm::BaseVisitor {
	public:
		virtual ~Visitor();

		virtual void Visit_Material(const Material &);
		virtual void Visit_Components(const Components &);
		virtual void Visit_Metric(const Metric &);
		virtual void Visit_Component(const Component &);
		virtual void Visit_Metrics(const Metrics &);
		virtual void Visit_Object(const ::Udm::Object &);

	};

	void Initialize();
	void Initialize(const ::Uml::Diagram &dgr);

	extern  ::Udm::UdmDiagram diagram;

	class Material : public ::Udm::Object {
	public:
		Material();
		Material(::Udm::ObjectImpl *impl);
		Material(const Material &master);

#ifdef UDM_RVALUE
		Material(Material &&master);

		static Material Cast(::Udm::Object &&a);
		Material& operator=(Material &&a);

#endif
		static Material Cast(const ::Udm::Object &a);
		static Material Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Material CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Material> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Material, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Material, Pred>(impl); };
		Material CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Material> Derived();
		template <class Pred> ::Udm::DerivedAttr< Material, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Material, Pred>(impl); };
		::Udm::ArchetypeAttr< Material> Archetype() const;
		::Udm::RealAttr Mises() const;
		::Udm::RealAttr Bearing() const;
		::Udm::RealAttr Shear() const;
		::Udm::StringAttr Units() const;
		::Udm::ParentAttr< ::CADPostProcessingParameters::Component> Component_parent() const;
		::Udm::ParentAttr< ::CADPostProcessingParameters::Component> parent() const;
		void Accept(Visitor &v);

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_Mises;
		static ::Uml::Attribute meta_Bearing;
		static ::Uml::Attribute meta_Shear;
		static ::Uml::Attribute meta_Units;
		static ::Uml::CompositionParentRole meta_Component_parent;

	};

	class Components : public ::Udm::Object {
	public:
		Components();
		Components(::Udm::ObjectImpl *impl);
		Components(const Components &master);

#ifdef UDM_RVALUE
		Components(Components &&master);

		static Components Cast(::Udm::Object &&a);
		Components& operator=(Components &&a);

#endif
		static Components Cast(const ::Udm::Object &a);
		static Components Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Components CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Components> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Components, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Components, Pred>(impl); };
		Components CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Components> Derived();
		template <class Pred> ::Udm::DerivedAttr< Components, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Components, Pred>(impl); };
		::Udm::ArchetypeAttr< Components> Archetype() const;
		::Udm::StringAttr ConfigurationID() const;
		::Udm::ChildrenAttr< ::CADPostProcessingParameters::Component> Component_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Component, Pred> Component_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Component, Pred>(impl, meta_Component_children); };
		::Udm::ChildrenAttr< ::CADPostProcessingParameters::Component> Component_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Component, Pred> Component_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Component, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::Udm::Object> parent() const;
		void Accept(Visitor &v);

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_ConfigurationID;
		static ::Uml::CompositionChildRole meta_Component_children;

	};

	class Metric : public ::Udm::Object {
	public:
		Metric();
		Metric(::Udm::ObjectImpl *impl);
		Metric(const Metric &master);

#ifdef UDM_RVALUE
		Metric(Metric &&master);

		static Metric Cast(::Udm::Object &&a);
		Metric& operator=(Metric &&a);

#endif
		static Metric Cast(const ::Udm::Object &a);
		static Metric Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Metric CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Metric> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Metric, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Metric, Pred>(impl); };
		Metric CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Metric> Derived();
		template <class Pred> ::Udm::DerivedAttr< Metric, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Metric, Pred>(impl); };
		::Udm::ArchetypeAttr< Metric> Archetype() const;
		::Udm::StringAttr MetricID() const;
		::Udm::StringAttr Type() const;
		::Udm::RealAttrArr ArrayValue() const;
		::Udm::StringAttr Units() const;
		::Udm::ParentAttr< ::CADPostProcessingParameters::Metrics> Metrics_parent() const;
		::Udm::ParentAttr< ::CADPostProcessingParameters::Metrics> parent() const;
		void Accept(Visitor &v);

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_MetricID;
		static ::Uml::Attribute meta_Type;
		static ::Uml::Attribute meta_ArrayValue;
		static ::Uml::Attribute meta_Units;
		static ::Uml::CompositionParentRole meta_Metrics_parent;

	};

	class Component : public ::Udm::Object {
	public:
		Component();
		Component(::Udm::ObjectImpl *impl);
		Component(const Component &master);

#ifdef UDM_RVALUE
		Component(Component &&master);

		static Component Cast(::Udm::Object &&a);
		Component& operator=(Component &&a);

#endif
		static Component Cast(const ::Udm::Object &a);
		static Component Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Component CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Component> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Component, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Component, Pred>(impl); };
		Component CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Component> Derived();
		template <class Pred> ::Udm::DerivedAttr< Component, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Component, Pred>(impl); };
		::Udm::ArchetypeAttr< Component> Archetype() const;
		::Udm::StringAttr ComponentID() const;
		::Udm::StringAttr FEAElementID() const;
		::Udm::ChildAttr< ::CADPostProcessingParameters::Metrics> Metrics_child() const;
		::Udm::ChildAttr< ::CADPostProcessingParameters::Material> Material_child() const;
		::Udm::ChildrenAttr< ::CADPostProcessingParameters::Material> Material_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Material, Pred> Material_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Material, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ChildrenAttr< ::CADPostProcessingParameters::Metrics> Metrics_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Metrics, Pred> Metrics_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Metrics, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADPostProcessingParameters::Components> Components_parent() const;
		::Udm::ParentAttr< ::CADPostProcessingParameters::Components> parent() const;
		void Accept(Visitor &v);

		static ::Uml::Class meta;
		static ::Uml::Attribute meta_ComponentID;
		static ::Uml::Attribute meta_FEAElementID;
		static ::Uml::CompositionChildRole meta_Metrics_child;
		static ::Uml::CompositionChildRole meta_Material_child;
		static ::Uml::CompositionParentRole meta_Components_parent;

	};

	class Metrics : public ::Udm::Object {
	public:
		Metrics();
		Metrics(::Udm::ObjectImpl *impl);
		Metrics(const Metrics &master);

#ifdef UDM_RVALUE
		Metrics(Metrics &&master);

		static Metrics Cast(::Udm::Object &&a);
		Metrics& operator=(Metrics &&a);

#endif
		static Metrics Cast(const ::Udm::Object &a);
		static Metrics Create(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		Metrics CreateInstance(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::InstantiatedAttr< Metrics> Instances();
		template <class Pred> ::Udm::InstantiatedAttr< Metrics, Pred> Instances_sorted(const Pred &) { return ::Udm::InstantiatedAttr< Metrics, Pred>(impl); };
		Metrics CreateDerived(const ::Udm::Object &parent, const ::Uml::CompositionChildRole &role = ::Udm::NULLCHILDROLE);
		::Udm::DerivedAttr< Metrics> Derived();
		template <class Pred> ::Udm::DerivedAttr< Metrics, Pred> Derived_sorted(const Pred &) { return ::Udm::DerivedAttr< Metrics, Pred>(impl); };
		::Udm::ArchetypeAttr< Metrics> Archetype() const;
		::Udm::ChildrenAttr< ::CADPostProcessingParameters::Metric> Metric_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Metric, Pred> Metric_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Metric, Pred>(impl, meta_Metric_children); };
		::Udm::ChildrenAttr< ::CADPostProcessingParameters::Metric> Metric_kind_children() const;
		template <class Pred> ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Metric, Pred> Metric_kind_children_sorted(const Pred &) const { return ::Udm::ChildrenAttr< ::CADPostProcessingParameters::Metric, Pred>(impl, ::Udm::NULLCHILDROLE); };
		::Udm::ParentAttr< ::CADPostProcessingParameters::Component> Component_parent() const;
		::Udm::ParentAttr< ::CADPostProcessingParameters::Component> parent() const;
		void Accept(Visitor &v);

		static ::Uml::Class meta;
		static ::Uml::CompositionChildRole meta_Metric_children;
		static ::Uml::CompositionParentRole meta_Component_parent;

	};

}

#endif // MOBIES_CADPOSTPROCESSINGPARAMETERS_H
