/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include <CommonStructures.h>

namespace isis
{
	std::ostream& operator<<(std::ostream& output, const CADComponentData& in_AssembledInfo)
	{
		output << std::endl << std::endl << 
			"CADComponent:" << std::endl <<
			"   ComponentID:             " << in_AssembledInfo.componentID.c_str() << std::endl <<
			"   Name:                    " << in_AssembledInfo.name.c_str() << std::endl <<
			"   Type:                    " << isis::ProMdlType_string(in_AssembledInfo.modelType) <<  std::endl <<
			"   MaterialID:              " << in_AssembledInfo.materialID <<  std::endl <<
			"   SpecialInstruction:      " << isis::SpecialInstruction_string(in_AssembledInfo.specialInstruction) <<  std::endl <<
			"   modelHandle:             " << in_AssembledInfo.modelHandle <<  std::endl <<
			"   assembledFeature.id:     " << in_AssembledInfo.assembledFeature.id <<  std::endl <<
			"   assembledFeature.type:   " << in_AssembledInfo.assembledFeature.type <<  std::endl <<
			"   assembledFeature.owner:  " << in_AssembledInfo.assembledFeature.owner <<  std::endl <<

			"   constraints:";

			output << std::endl <<
				"      applyAllConstraints:     "  << Bool_string(in_AssembledInfo.constraintDef.applyAllConstraints) <<  std::endl <<
				"      applySingleConstaintID:  "  << in_AssembledInfo.constraintDef.applySingleConstaintID;

			//output << std::endl << "in_AssembledInfo.constraintDef.constraints.capacity() %%%  " << in_AssembledInfo.constraintDef.constraints.capacity();
			
			
			for ( std::vector<ConstraintData>::const_iterator i(in_AssembledInfo.constraintDef.constraints.begin());
				  i != in_AssembledInfo.constraintDef.constraints.end();
				  ++i )
			{
				for (	std::vector<ConstraintPair>::const_iterator j(i->constraintPairs.begin());
						j != i->constraintPairs.end();
						++j )
				{
					output << std::endl <<	"      constraintFeatures:";
					for (	std::vector<ConstraintFeature>::const_iterator k(j->constraintFeatures.begin());
							k != j->constraintFeatures.end();
							++k )
					{
						output << std::endl <<
						"         componentID:             " <<  k->componentID  << std::endl <<
						"         featureName:             " <<  k->featureName  << std::endl <<
						"         featureOrientationType:  " <<  ProDatumside_string( k->featureOrientationType );

					}
				}

			}
			output << std::endl << "   parametricParameters:";

			if ( in_AssembledInfo.parametricParametersPresent )
			{
				for ( std::list<CADParameter>::const_iterator i( in_AssembledInfo.parametricParameters.begin());
					  i != in_AssembledInfo.parametricParameters.end();
					  ++i )
				{
					output << std::endl << "      name:    " << i->name;
					output << std::endl << "      name:    " << CADParameterType_string(i->type);
					output << std::endl << "      value:   " << i->value;
				}
			}

			output << std::endl <<
			"   componentPaths list:";
			for ( list<int>::const_iterator i = in_AssembledInfo.componentPaths.begin();
			  i != in_AssembledInfo.componentPaths.end(); ++i )
			{
				output << std::endl << "      Feature ID: " << *i;
			}

			output << std::endl << "   children set:";
			for ( list<std::string>::const_iterator i = in_AssembledInfo.children.begin();
			  i != in_AssembledInfo.children.end(); ++i )
			{
				output << std::endl << "      ComponentID: " << *i;
			}

			output << std::endl << "   dependsOn set:";
			for ( set<std::string>::const_iterator i = in_AssembledInfo.dependsOn.begin();
			  i != in_AssembledInfo.dependsOn.end(); ++i )
			{
				output << std::endl << "      ComponentID: " << *i;
			}

			if ( in_AssembledInfo.analysisTempMaterialDefined )
			{
				output << std::endl << "   Material Definition:";
				output << std::endl << "      Name:                  " << in_AssembledInfo.analysisTempMaterialDefinition.name;
				output << std::endl << "      Poisson's Ratio:       " << in_AssembledInfo.analysisTempMaterialDefinition.poissonsRatio;
				output << std::endl << "      Token Poisson's Ratio: " << in_AssembledInfo.analysisTempMaterialDefinition.tokenPoissonsRatio;
			}
			else
			{
				output << std::endl << "   Material Definition: Not retrieved from Creo Model.  Only retrieved for analysis runs.";
			}

		return output;
	};


////////////////////////////////////////////////////////////////////////////////////////
//std::string AmalgamateModelNameWithSuffix ( const std::string &in_Name, const std::string &in_Type )
std::string AmalgamateModelNameWithSuffix ( const std::string &in_Name, ProMdlType in_pro_model_type )
{
	std::string ModelNameWithSuffix;

	//wchar_t  PartName[PRO_FAMILY_NAME_SIZE];
	//wchar_t  PartName[ISIS_CHAR_BUFFER_LENGTH];

	//ProMdlType pro_model_type = isis::ProMdlType_enum( in_Type);

	if ( in_pro_model_type == PRO_MDL_ASSEMBLY)
		ModelNameWithSuffix = in_Name + ".asm";
	else
		ModelNameWithSuffix = in_Name + ".prt";

	return ModelNameWithSuffix;
}
}